/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.oracle;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.connector.jdbc.extension.impl.AliasModifier;
import com.metamatrix.connector.jdbc.extension.impl.BasicSQLTranslator;
import com.metamatrix.connector.jdbc.oracle.ConcatFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.DayWeekQuarterFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.ExtractFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.FormatFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.HourFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.LeftOrRightFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.LocateFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.Log10FunctionModifier;
import com.metamatrix.connector.jdbc.oracle.MonthOrDayNameFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.OracleConvertModifier;
import com.metamatrix.connector.jdbc.oracle.OracleSQLConversionVisitor;
import com.metamatrix.connector.jdbc.oracle.ParseFunctionModifier;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.ICriteria;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IFrom;
import com.metamatrix.data.language.IGroup;
import com.metamatrix.data.language.IInlineView;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.ILimit;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.ISelect;
import com.metamatrix.data.language.ISelectSymbol;
import com.metamatrix.data.language.IUnion;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import com.metamatrix.data.visitor.util.CollectorVisitor;
import com.metamatrix.data.visitor.util.SQLStringVisitor;
import com.metamatrix.dqp.internal.datamgr.language.LanguageFactoryImpl;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class OracleSQLTranslator
extends BasicSQLTranslator {
    protected static final String ROWNUM = "ROWNUM";
    protected static final String ROWNUM_ALIAS = "MM_ROWNUM";
    protected static final String INLINE_VIEW_ALIAS = "MM_VIEW_FOR_LIMIT";
    protected static final String ROOT_EXPRESSION_NAME = "EXPR";
    private Map functionModifiers;
    private Properties connectorProperties;
    private ILanguageFactory languageFactory;

    public void initialize(ConnectorEnvironment env, RuntimeMetadata metadata) throws ConnectorException {
        super.initialize(env, metadata);
        ConnectorEnvironment connEnv = this.getConnectorEnvironment();
        this.connectorProperties = connEnv.getProperties();
        this.languageFactory = connEnv.getLanguageFactory();
        this.initializeFunctionModifiers();
    }

    public ICommand modifyCommand(ICommand command, ExecutionContext context) throws ConnectorException {
        command = super.modifyCommand(command, context);
        Collection subCommands = CollectorVisitor.collectObjects(IInlineView.class, (ILanguageObject)command);
        for (IInlineView inlineView : subCommands) {
            inlineView.setQuery((IQuery)this.modifyCommand((ICommand)inlineView.getQuery(), context));
        }
        if (command instanceof IUnion) {
            IUnion union = (IUnion)command;
            Iterator i = union.getUnionQueries().iterator();
            while (i.hasNext()) {
                this.modifySingleCommand((ICommand)i.next(), context);
            }
        }
        return this.modifySingleCommand(command, context);
    }

    protected ICommand modifySingleCommand(ICommand command, ExecutionContext context) {
        ICompareCriteria criteria;
        IElement eleRowNum;
        if (!(command instanceof IQuery)) {
            return command;
        }
        IQuery query = (IQuery)command;
        if (query.getLimit() == null) {
            return command;
        }
        ILimit limit = query.getLimit();
        query.setLimit(null);
        ArrayList<ICompareCriteria> lstCriteria = new ArrayList<ICompareCriteria>();
        IGroup group = LanguageFactoryImpl.INSTANCE.createGroup(INLINE_VIEW_ALIAS, null, null);
        if (limit.getRowOffset() > 0) {
            eleRowNum = LanguageFactoryImpl.INSTANCE.createElement(ROWNUM_ALIAS, group, null, DataTypeManager.DefaultDataClasses.INTEGER);
            ILiteral litOffset = LanguageFactoryImpl.INSTANCE.createLiteral((Object)new Integer(limit.getRowOffset()), DataTypeManager.DefaultDataClasses.INTEGER);
            criteria = LanguageFactoryImpl.INSTANCE.createCompareCriteria(4, (IExpression)eleRowNum, (IExpression)litOffset);
            lstCriteria.add(criteria);
        }
        if (limit.getRowLimit() > 0) {
            eleRowNum = LanguageFactoryImpl.INSTANCE.createElement(ROWNUM_ALIAS, group, null, DataTypeManager.DefaultDataClasses.INTEGER);
            ILiteral litLimit = LanguageFactoryImpl.INSTANCE.createLiteral((Object)new Integer(limit.getRowOffset() + limit.getRowLimit()), DataTypeManager.DefaultDataClasses.INTEGER);
            criteria = LanguageFactoryImpl.INSTANCE.createCompareCriteria(3, (IExpression)eleRowNum, (IExpression)litLimit);
            lstCriteria.add(criteria);
        }
        if (lstCriteria.isEmpty()) {
            return command;
        }
        Object criteria2 = null;
        criteria2 = lstCriteria.size() == 1 ? (ICriteria)lstCriteria.get(0) : LanguageFactoryImpl.INSTANCE.createCompoundCriteria(0, lstCriteria);
        IQuery intermediate = this.createLimitQuery(query, null);
        IQuery result = this.createLimitQuery(intermediate, (ICriteria)criteria2);
        IElement eleRowNum2 = LanguageFactoryImpl.INSTANCE.createElement(ROWNUM, null, null, DataTypeManager.DefaultDataClasses.INTEGER);
        ISelectSymbol newSelectSymbol = LanguageFactoryImpl.INSTANCE.createSelectSymbol(ROWNUM_ALIAS, (IExpression)eleRowNum2);
        newSelectSymbol.setAlias(true);
        intermediate.getSelect().getSelectSymbols().add(newSelectSymbol);
        return result;
    }

    private IQuery createLimitQuery(IQuery query, ICriteria criteria) {
        IInlineView view = LanguageFactoryImpl.INSTANCE.createInlineView(query, INLINE_VIEW_ALIAS);
        IFrom from = LanguageFactoryImpl.INSTANCE.createFrom(Arrays.asList(view));
        HashSet<String> names = new HashSet<String>();
        List symbols = query.getSelect().getSelectSymbols();
        for (int i = 0; i < symbols.size(); ++i) {
            ISelectSymbol symbol = (ISelectSymbol)symbols.get(i);
            String name = null;
            boolean isExpression = false;
            if (!symbol.hasAlias() && symbol.getExpression() instanceof IElement || symbol.hasAlias()) {
                name = SQLStringVisitor.getElementShortName((String)symbol.getOutputName()).toUpperCase();
            } else {
                isExpression = true;
                name = ROOT_EXPRESSION_NAME;
            }
            String rootName = name;
            int j = 0;
            while (names.contains(name)) {
                name = rootName + j++;
            }
            if (!name.equals(rootName) || isExpression) {
                symbol.setAlias(true);
                symbol.setOutputName(name);
            }
            names.add(name);
        }
        ArrayList<ISelectSymbol> lstSelect = new ArrayList<ISelectSymbol>();
        for (ISelectSymbol symbol : query.getSelect().getSelectSymbols()) {
            String outputName = symbol.hasAlias() ? symbol.getOutputName() : symbol.getExpression().toString();
            IElement expression = LanguageFactoryImpl.INSTANCE.createElement(outputName, (IGroup)view, null, symbol.getExpression().getType());
            ISelectSymbol newSymbol = LanguageFactoryImpl.INSTANCE.createSelectSymbol(outputName, (IExpression)expression);
            lstSelect.add(newSymbol);
        }
        ISelect select = LanguageFactoryImpl.INSTANCE.createSelect(false, lstSelect);
        IQuery result = LanguageFactoryImpl.INSTANCE.createQuery(select, from, criteria, null, null, null);
        return result;
    }

    private void initializeFunctionModifiers() {
        this.functionModifiers = new HashMap();
        this.functionModifiers.putAll(super.getFunctionModifiers());
        this.functionModifiers.put("char", new AliasModifier("chr"));
        this.functionModifiers.put("lcase", new AliasModifier("lower"));
        this.functionModifiers.put("ucase", new AliasModifier("upper"));
        this.functionModifiers.put("ifnull", new AliasModifier("nvl"));
        this.functionModifiers.put("log", new AliasModifier("ln"));
        this.functionModifiers.put("ceiling", new AliasModifier("ceil"));
        this.functionModifiers.put("log10", new Log10FunctionModifier(this.languageFactory));
        this.functionModifiers.put("convert", new OracleConvertModifier(this.languageFactory, this.getRuntimeMetadata(), this.getConnectorEnvironment().getLogger()));
        this.functionModifiers.put("cast", new OracleConvertModifier(this.languageFactory, this.getRuntimeMetadata(), this.getConnectorEnvironment().getLogger()));
        this.functionModifiers.put("hour", new HourFunctionModifier(this.languageFactory));
        this.functionModifiers.put("month", new ExtractFunctionModifier("MONTH"));
        this.functionModifiers.put("year", new ExtractFunctionModifier("YEAR"));
        this.functionModifiers.put("day", new ExtractFunctionModifier("DAY"));
        this.functionModifiers.put("minute", new DayWeekQuarterFunctionModifier(this.languageFactory, "MI"));
        this.functionModifiers.put("second", new DayWeekQuarterFunctionModifier(this.languageFactory, "SS"));
        this.functionModifiers.put("monthname", new MonthOrDayNameFunctionModifier(this.languageFactory, "Month"));
        this.functionModifiers.put("dayname", new MonthOrDayNameFunctionModifier(this.languageFactory, "Day"));
        this.functionModifiers.put("week", new DayWeekQuarterFunctionModifier(this.languageFactory, "WW"));
        this.functionModifiers.put("quarter", new DayWeekQuarterFunctionModifier(this.languageFactory, "Q"));
        this.functionModifiers.put("dayofweek", new DayWeekQuarterFunctionModifier(this.languageFactory, "D"));
        this.functionModifiers.put("dayofmonth", new DayWeekQuarterFunctionModifier(this.languageFactory, "DD"));
        this.functionModifiers.put("dayofyear", new DayWeekQuarterFunctionModifier(this.languageFactory, "DDD"));
        this.functionModifiers.put("formatdate", new FormatFunctionModifier(this.languageFactory));
        this.functionModifiers.put("formattime", new FormatFunctionModifier(this.languageFactory));
        this.functionModifiers.put("formattimestamp", new FormatFunctionModifier(this.languageFactory));
        this.functionModifiers.put("parsedate", new ParseFunctionModifier(this.languageFactory, Date.class));
        this.functionModifiers.put("parsetime", new ParseFunctionModifier(this.languageFactory, Time.class));
        this.functionModifiers.put("parsetimestamp", new ParseFunctionModifier(this.languageFactory, Timestamp.class));
        this.functionModifiers.put("locate", new LocateFunctionModifier(this.languageFactory));
        this.functionModifiers.put("substring", new AliasModifier("substr"));
        this.functionModifiers.put("left", new LeftOrRightFunctionModifier(this.languageFactory, "left"));
        this.functionModifiers.put("right", new LeftOrRightFunctionModifier(this.languageFactory, "right"));
        this.functionModifiers.put("concat", new ConcatFunctionModifier(this.languageFactory));
        this.functionModifiers.put("||", new ConcatFunctionModifier(this.languageFactory));
    }

    public SQLConversionVisitor getTranslationVisitor() {
        OracleSQLConversionVisitor visitor = new OracleSQLConversionVisitor();
        visitor.setRuntimeMetadata(this.getRuntimeMetadata());
        visitor.setFunctionModifiers(this.functionModifiers);
        visitor.setProperties(this.connectorProperties);
        visitor.setLanguageFactory(this.languageFactory);
        visitor.setDatabaseTimeZone(this.getDatabaseTimeZone());
        return visitor;
    }

    public Map getFunctionModifiers() {
        return this.functionModifiers;
    }
}

