/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.relational.impl;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.log.Logger;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.Stopwatch;
import com.metamatrix.metamodels.core.Annotation;
import com.metamatrix.metamodels.core.AnnotationContainer;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.relational.BaseTable;
import com.metamatrix.metamodels.relational.Catalog;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.ColumnSet;
import com.metamatrix.metamodels.relational.DirectionKind;
import com.metamatrix.metamodels.relational.ForeignKey;
import com.metamatrix.metamodels.relational.Index;
import com.metamatrix.metamodels.relational.MultiplicityKind;
import com.metamatrix.metamodels.relational.NullableType;
import com.metamatrix.metamodels.relational.PrimaryKey;
import com.metamatrix.metamodels.relational.Procedure;
import com.metamatrix.metamodels.relational.ProcedureParameter;
import com.metamatrix.metamodels.relational.ProcedureResult;
import com.metamatrix.metamodels.relational.RelationalEntity;
import com.metamatrix.metamodels.relational.RelationalFactory;
import com.metamatrix.metamodels.relational.RelationalPackage;
import com.metamatrix.metamodels.relational.Schema;
import com.metamatrix.metamodels.relational.SearchabilityType;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.metamodels.relational.UniqueConstraint;
import com.metamatrix.metamodels.relational.UniqueKey;
import com.metamatrix.metamodels.relational.aspects.validation.rules.RelationalStringNameRule;
import com.metamatrix.metamodels.relational.util.RelationalTypeMapping;
import com.metamatrix.modeler.compare.DifferenceDescriptor;
import com.metamatrix.modeler.compare.DifferenceProcessor;
import com.metamatrix.modeler.compare.DifferenceReport;
import com.metamatrix.modeler.compare.MergeProcessor;
import com.metamatrix.modeler.compare.ModelerComparePlugin;
import com.metamatrix.modeler.compare.PropertyDifference;
import com.metamatrix.modeler.compare.util.CompareUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.ModelerCoreRuntimeException;
import com.metamatrix.modeler.core.TransactionRunnable;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.util.ModelResourceContainerFactory;
import com.metamatrix.modeler.core.validation.rules.StringNameValidator;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.ModelEditorImpl;
import com.metamatrix.modeler.internal.core.container.ContainerImpl;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.jdbc.relational.ContextImpl;
import com.metamatrix.modeler.internal.jdbc.relational.ModelerJdbcRelationalConstants;
import com.metamatrix.modeler.jdbc.CaseConversion;
import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.JdbcImportSettings;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.SourceNames;
import com.metamatrix.modeler.jdbc.data.Request;
import com.metamatrix.modeler.jdbc.data.Results;
import com.metamatrix.modeler.jdbc.metadata.JdbcDatabase;
import com.metamatrix.modeler.jdbc.metadata.JdbcNode;
import com.metamatrix.modeler.jdbc.metadata.JdbcProcedure;
import com.metamatrix.modeler.jdbc.metadata.JdbcTable;
import com.metamatrix.modeler.jdbc.metadata.JdbcTableType;
import com.metamatrix.modeler.jdbc.metadata.impl.GetColumnsRequest;
import com.metamatrix.modeler.jdbc.metadata.impl.GetExportedForeignKeysRequest;
import com.metamatrix.modeler.jdbc.metadata.impl.GetImportedForeignKeysRequest;
import com.metamatrix.modeler.jdbc.metadata.impl.GetIndexesRequest;
import com.metamatrix.modeler.jdbc.metadata.impl.GetPrimaryKeyRequest;
import com.metamatrix.modeler.jdbc.metadata.impl.GetProcedureParametersRequest;
import com.metamatrix.modeler.jdbc.relational.JdbcRelationalPlugin;
import com.metamatrix.modeler.jdbc.relational.RelationalModelProcessor;
import com.metamatrix.modeler.jdbc.relational.impl.Context;
import com.metamatrix.modeler.jdbc.relational.impl.JdbcModelStructure;
import com.metamatrix.modeler.jdbc.relational.impl.ObjectMatcher;
import com.metamatrix.modeler.jdbc.relational.impl.RelationalModelProcessorImpl;
import com.metamatrix.modeler.jdbc.relational.impl.UserCancelledException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mapping.Mapping;

public class RelationalModelProcessorImpl
implements ModelerJdbcRelationalConstants,
RelationalModelProcessor {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(RelationalModelProcessorImpl.class);
    private static final String IMPORT_DESCRIPTION = RelationalModelProcessorImpl.getString("importDescription");
    public static final int IMPORT_WITH_NO_PROBLEMS = 3001;
    public static final int IMPORT_WITH_WARNINGS = 3002;
    public static final int IMPORT_WITH_ERRORS = 3003;
    public static final int IMPORT_WITH_WARNINGS_AND_ERRORS = 3004;
    public static final int IMPORT_WITH_NO_WARNINGS_AND_ERRORS = 3005;
    public static final int ERROR_PROCESSING_NODE = 3006;
    private static final int UNITS_PHASE_0 = 10;
    private static final int UNITS_PHASE_1 = 1000;
    private static final int UNITS_PHASE_2 = 1000;
    private static final int UNITS_PHASE_3 = 10000;
    private static final int UNITS_PHASE_4 = 10;
    private static final int UNITS_PHASE_5 = 10000;
    private static final int UNITS_PHASE_6 = 1000;
    private static final int UNITS_PHASE_7 = 1000;
    private final RelationalFactory factory;
    private boolean verbose = false;
    private RelationalTypeMapping typeMapping;
    private DatatypeManager datatypeManager;
    private StringNameValidator nameValidator;
    private DifferenceProcessor diffProc;
    private DifferenceReport drDifferenceReport;
    private boolean moveRatherThanCopyAdds;
    private boolean debugTimingEnabled = false;

    private static String getString(String id) {
        return Util.getString(I18N_PREFIX + id);
    }

    public RelationalModelProcessorImpl() {
        this(RelationalFactory.eINSTANCE, null);
    }

    public RelationalModelProcessorImpl(RelationalFactory factory) {
        this(factory, null);
    }

    public RelationalModelProcessorImpl(RelationalFactory factory, RelationalTypeMapping mapping) {
        ArgCheck.isNotNull((Object)factory);
        this.factory = factory;
        this.typeMapping = mapping;
        this.nameValidator = new StringNameValidator();
    }

    private void stopLogIncrementAndRestart(Stopwatch watch, String message) {
        if (this.debugTimingEnabled) {
            watch.stopLogIncrementAndRestart(message);
        }
    }

    public final IStatus execute(Resource modelResource, JdbcDatabase jdbcDatabase, JdbcImportSettings settings, IProgressMonitor monitor) {
        return this.execute(modelResource, null, jdbcDatabase, settings, monitor);
    }

    public final IStatus execute(Resource modelResource, Container container, JdbcDatabase jdbcDatabase, JdbcImportSettings settings, IProgressMonitor monitor) {
        Stopwatch totalWatch = new Stopwatch();
        totalWatch.start();
        Stopwatch sWatch = new Stopwatch();
        sWatch.start();
        ModelContents modelContents = modelResource instanceof EmfResource ? ((EmfResource)modelResource).getModelContents() : new ModelContents(modelResource);
        this.stopLogIncrementAndRestart(sWatch, " RelationalModelProcessor:  Got/Created Model Contents - Delta ");
        PluginUtil logger = JdbcRelationalPlugin.Util;
        ContextImpl context = new ContextImpl(modelResource, modelContents, jdbcDatabase, settings, monitor, (Logger)logger);
        this.stopLogIncrementAndRestart(sWatch, " RelationalModelProcessor:  Created ContextImpl - Delta ");
        URI uri = modelResource.getURI();
        WorkingArea workingArea = new WorkingArea(this, uri, jdbcDatabase, settings, monitor, (Logger)logger);
        this.stopLogIncrementAndRestart(sWatch, " RelationalModelProcessor:  Created Working Area - Delta ");
        IStatus iStatus = this.executeWithinTransaction((Context)context, workingArea, container);
        this.stopLogIncrementAndRestart(sWatch, " RelationalModelProcessor:  Executing ContextImpl - Delta ");
        this.stopLogIncrementAndRestart(totalWatch, " RelationalModelProcessor:  Execute() Total - Delta ");
        return iStatus;
    }

    public final IStatus execute(ModelResource modelResource, JdbcDatabase jdbcDatabase, JdbcImportSettings settings, IProgressMonitor monitor) throws ModelWorkspaceException {
        Stopwatch totalWatch = new Stopwatch();
        totalWatch.start();
        Stopwatch sWatch = new Stopwatch();
        sWatch.start();
        Resource emfResource = modelResource.getEmfResource();
        ModelContents modelContents = ModelContents.getModelContents((ModelResource)modelResource);
        this.stopLogIncrementAndRestart(sWatch, " RelationalModelProcessor:  Got/Created Model Contents - Delta ");
        PluginUtil logger = JdbcRelationalPlugin.Util;
        ContextImpl context = new ContextImpl(emfResource, modelContents, jdbcDatabase, settings, monitor, (Logger)logger);
        this.stopLogIncrementAndRestart(sWatch, " RelationalModelProcessor:  Created ContextImpl - Delta ");
        URI uri = modelResource.getEmfResource().getURI();
        WorkingArea workingArea = new WorkingArea(this, uri, jdbcDatabase, settings, monitor, (Logger)logger);
        this.stopLogIncrementAndRestart(sWatch, " RelationalModelProcessor:  Created Working Area - Delta ");
        IStatus iStatus = this.executeWithinTransaction((Context)context, workingArea);
        this.stopLogIncrementAndRestart(sWatch, " RelationalModelProcessor:  Executing ContextImpl - Delta ");
        this.stopLogIncrementAndRestart(totalWatch, " RelationalModelProcessor:  Execute() Total - Delta ");
        return iStatus;
    }

    protected IStatus executeWithinTransaction(Context context, WorkingArea workingArea) {
        return this.executeWithinTransaction(context, workingArea, null);
    }

    protected IStatus executeWithinTransaction(Context context, WorkingArea workingArea, Container container) {
        Status problem;
        String msg;
        boolean code;
        LinkedList<Status> problems = new LinkedList<Status>();
        try {
            1 op = new /* Unavailable Anonymous Inner Class!! */;
            ModelerCore.getModelEditor().executeAsTransaction((TransactionRunnable)op, container, IMPORT_DESCRIPTION, true, (Object)this);
        }
        catch (ModelerCoreRuntimeException e) {
            if (!(e.getChild() instanceof UserCancelledException)) {
                code = false;
                msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Problem_while_importing");
                problem = new Status(4, JdbcRelationalPlugin.PLUGIN_ID, 0, msg, (Throwable)e);
                problems.add(problem);
            }
        }
        catch (ModelerCoreException err) {
            code = false;
            msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Problem_while_importing");
            problem = new Status(4, JdbcRelationalPlugin.PLUGIN_ID, 0, msg, (Throwable)err);
            problems.add(problem);
        }
        String PLUGINID = JdbcRelationalPlugin.PLUGIN_ID;
        IStatus resultStatus = null;
        if (problems.isEmpty()) {
            msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Import_into_relational_model_completed");
            Status status = new Status(0, PLUGINID, 3001, msg, null);
            resultStatus = status;
        } else if (problems.size() == 1) {
            resultStatus = (IStatus)problems.get(0);
        } else {
            int numErrors = 0;
            int numWarnings = 0;
            for (IStatus iStatus : problems) {
                if (iStatus.getSeverity() == 2) {
                    ++numWarnings;
                    continue;
                }
                if (iStatus.getSeverity() != 4) continue;
                ++numErrors;
            }
            IStatus[] iStatusArray = problems.toArray(new IStatus[problems.size()]);
            if (numWarnings != 0 && numErrors == 0) {
                Object[] params = new Object[]{new Integer(numWarnings)};
                String msg2 = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Completed_import_with_warnings", params);
                resultStatus = new MultiStatus(PLUGINID, 3002, iStatusArray, msg2, null);
            } else if (numWarnings == 0 && numErrors != 0) {
                Object[] params = new Object[]{new Integer(numErrors)};
                String msg3 = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Import_resulted_in_errors", params);
                resultStatus = new MultiStatus(PLUGINID, 3003, iStatusArray, msg3, null);
            } else if (numWarnings != 0 && numErrors != 0) {
                Object[] params = new Object[]{new Integer(numWarnings), new Integer(numErrors)};
                String msg4 = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Import_resulted_in_warnings_and_errors", params);
                resultStatus = new MultiStatus(PLUGINID, 3004, iStatusArray, msg4, null);
            } else {
                String msg5 = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Completed_import_with_no_warnings_or_errors");
                resultStatus = new MultiStatus(PLUGINID, 3005, iStatusArray, msg5, null);
            }
        }
        return resultStatus;
    }

    public DifferenceReport generateDifferenceReport(ModelResource modelResource, JdbcDatabase jdbcDatabase, JdbcImportSettings settings, IProgressMonitor monitor) throws ModelWorkspaceException {
        LinkedList<Status> problems = new LinkedList<Status>();
        Resource emfResource = modelResource.getEmfResource();
        ModelContents modelContents = ModelContents.getModelContents((ModelResource)modelResource);
        PluginUtil logger = JdbcRelationalPlugin.Util;
        ContextImpl context = new ContextImpl(emfResource, modelContents, jdbcDatabase, settings, monitor, (Logger)logger);
        URI uri = modelResource.getEmfResource().getURI();
        WorkingArea workingArea = new WorkingArea(this, uri, jdbcDatabase, settings, monitor, (Logger)logger);
        try {
            this.createDifferenceReport((Context)context, workingArea, problems);
        }
        catch (ModelerCoreException err) {
            boolean code = false;
            String msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Problem_while_importing");
            Status problem = new Status(4, JdbcRelationalPlugin.PLUGIN_ID, 0, msg, (Throwable)err);
            problems.add(problem);
        }
        return this.getDifferenceReport();
    }

    private DifferenceReport createDifferenceReport(Context context, WorkingArea workingArea, List problems) throws ModelerCoreException {
        try {
            2 op = new /* Unavailable Anonymous Inner Class!! */;
            ModelerCore.getModelEditor().executeAsTransaction((TransactionRunnable)op, IMPORT_DESCRIPTION, true, (Object)this);
        }
        catch (ModelerCoreRuntimeException e) {
            if (!(e.getChild() instanceof UserCancelledException)) {
                boolean code = false;
                String msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Problem_while_importing");
                Status problem = new Status(4, JdbcRelationalPlugin.PLUGIN_ID, 0, msg, (Throwable)e);
                problems.add(problem);
            }
        }
        catch (ModelerCoreException err) {
            boolean code = false;
            String msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Problem_while_importing");
            Status problem = new Status(4, JdbcRelationalPlugin.PLUGIN_ID, 0, msg, (Throwable)err);
            problems.add(problem);
        }
        return this.drDifferenceReport;
    }

    public DifferenceReport getDifferenceReport() {
        return this.drDifferenceReport;
    }

    private DifferenceProcessor getDifferenceProcessor() {
        return this.diffProc;
    }

    protected void performMerge(Context context, WorkingArea workingArea, List problems) throws ModelerCoreException {
        if (this.getDifferenceProcessor() == null) {
            Resource startingResource = context.getResource();
            Resource endingResource = workingArea.getResource();
            IProgressMonitor monitor = context.getProgressMonitor();
            this.diffProc = ModelerComparePlugin.createDifferenceProcessor((Resource)startingResource, (Resource)endingResource);
            IStatus diffStatus = this.diffProc.execute(monitor);
            problems.add(diffStatus);
            if (diffStatus.getSeverity() != 4) {
                DifferenceReport differences = this.diffProc.getDifferenceReport();
                this.preProcessDifferenceReport(differences, context, workingArea, problems);
            }
        } else {
            this.diffProc = this.getDifferenceProcessor();
        }
        IProgressMonitor monitor = context.getProgressMonitor();
        EObject[] externalReferences = this.getDatatypeManager().getAllDatatypes();
        ModelEditorImpl.setContainer((ContainerImpl)((ContainerImpl)context.getResource().getResourceSet()));
        MergeProcessor mergeProc = ModelerComparePlugin.createMergeProcessor((DifferenceProcessor)this.diffProc, (EObject[])externalReferences, (boolean)this.moveRatherThanCopyAdds);
        IStatus mergeStatus = mergeProc.execute(monitor);
        problems.add(mergeStatus);
    }

    public void setMoveRatherThanCopyAdds(boolean moveRatherThanCopyAdds) {
        this.moveRatherThanCopyAdds = moveRatherThanCopyAdds;
    }

    protected void preProcessDifferenceReport(DifferenceReport differences, Context context, WorkingArea workingArea, List problems) throws ModelerCoreException {
        CompareUtil.skipDeletesOfStandardContainers((DifferenceReport)differences);
        CompareUtil.skipDeletesOfModelImports((DifferenceReport)differences);
        this.skipDeletesOfJdbcSource(differences);
        this.skipChanges(differences);
    }

    protected void skipChanges(DifferenceReport differences) {
        Mapping rootMapping = differences.getMapping();
        this.skipChanges(rootMapping);
    }

    protected void skipChanges(Mapping mapping) {
        DifferenceDescriptor descriptor = CompareUtil.getDifferenceDescriptor((Mapping)mapping);
        boolean recursive = true;
        if (descriptor != null) {
            if (descriptor.isChanged()) {
                EList inputs = mapping.getInputs();
                if (inputs.size() == 1) {
                    this.skipChanges(descriptor, (EObject)inputs.get(0));
                }
                recursive = false;
            } else if (descriptor.isAddition()) {
                recursive = false;
            } else if (descriptor.isDeletion()) {
                recursive = false;
            }
        }
        if (recursive) {
            EList nestedMappings = mapping.getNested();
            for (Mapping nestedMapping : nestedMappings) {
                this.skipChanges(nestedMapping);
            }
        }
    }

    protected void skipChanges(DifferenceDescriptor changeDescriptor, EObject inputObject) {
        if (inputObject instanceof Column) {
            EList propertyDiffs = changeDescriptor.getPropertyDifferences();
            for (PropertyDifference propDiff : propertyDiffs) {
                EStructuralFeature columnFeature = propDiff.getAffectedFeature();
                int columnFeatureId = columnFeature.getFeatureID();
                switch (columnFeatureId) {
                    case 8: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 19: 
                    case 21: {
                        propDiff.setSkip(true);
                        break;
                    }
                    case 17: 
                    case 18: {
                        propDiff.setSkip(true);
                    }
                }
            }
        }
    }

    protected void skipDeletesOfJdbcSource(DifferenceReport differences) {
        Mapping rootMapping = differences.getMapping();
        EList nestedMappings = rootMapping.getNested();
        for (Mapping nestedMapping : nestedMappings) {
            if (!CompareUtil.hasInstanceof((Mapping)nestedMapping, JdbcSource.class)) continue;
            DifferenceDescriptor desc = CompareUtil.getDifferenceDescriptor((Mapping)nestedMapping);
            desc.setSkip(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performExecute(Context context, List problems) {
        Object[] taskNameParams = new Object[]{context.getJdbcDatabase().getName()};
        String taskName = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Progress_main_task_name", taskNameParams);
        int numUnits = 24020;
        IProgressMonitor monitor = context.getProgressMonitor();
        monitor.beginTask(null, 24020);
        monitor.setTaskName(taskName);
        try {
            int unitsPerModelObject;
            if (monitor.isCanceled()) {
                throw new UserCancelledException();
            }
            monitor.worked(10);
            if (this.isVerboseLogging()) {
                String msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Analyzing_structure_of_database");
                context.getLogger().log(1, msg);
            }
            JdbcModelStructure modelStructure = JdbcModelStructure.build((Context)context);
            if (this.isVerboseLogging()) {
                StringBuffer sb = new StringBuffer();
                modelStructure.print(sb);
                String msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Completed_analysis._The_following_structure_to_be_put_into_model");
                context.getLogger().log(1, msg + sb.toString());
            }
            monitor.worked(1000);
            HashMap nodesToModelObjects = new HashMap();
            ObjectMatcher matcher = new ObjectMatcher(nodesToModelObjects);
            List rootModelObjects = context.getModelContents().getEObjects();
            List rootNodes = modelStructure.getChildren(null);
            if (rootNodes == null) {
                rootNodes = Collections.EMPTY_LIST;
            }
            this.matchChildren(null, rootNodes, rootModelObjects, modelStructure, matcher, monitor);
            monitor.worked(1000);
            int totalNumTablesAndProcedures = modelStructure.getTotalTablesAndProceduresCount();
            if (this.typeMapping == null) {
                String msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.NoDatatypeManager");
                Status status = new Status(2, JdbcRelationalPlugin.PLUGIN_ID, 0, msg, null);
                problems.add(status);
            }
            if (this.getDatatypeManager() == null) {
                try {
                    DatatypeManager mgr = ModelerCore.getWorkspaceDatatypeManager();
                    this.setDatatypeManager(mgr);
                }
                catch (ModelerCoreRuntimeException e) {
                    String msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Unable_to_find_the_builtin_Datatype_Manager");
                    Status status = new Status(2, JdbcRelationalPlugin.PLUGIN_ID, 0, msg, null);
                    problems.add(status);
                }
            }
            ArrayList newTableObjects = new ArrayList();
            int n = unitsPerModelObject = totalNumTablesAndProcedures != 0 ? 10000 / totalNumTablesAndProcedures : 0;
            if (matcher.getUnmatchedJdbcNodes().size() == 0) {
                monitor.worked(10000);
            }
            int counter = 0;
            Iterator iter = matcher.getUnmatchedJdbcNodes().iterator();
            while (iter.hasNext()) {
                RelationalEntity newModelObject;
                boolean countWork;
                if (monitor.isCanceled()) {
                    throw new UserCancelledException();
                }
                JdbcNode unmatchedNode = (JdbcNode)iter.next();
                boolean bl = countWork = unmatchedNode instanceof JdbcTable || unmatchedNode instanceof JdbcProcedure;
                if (countWork) {
                    ++counter;
                }
                JdbcNode parentNode = modelStructure.getParent(unmatchedNode);
                RelationalEntity parent = null;
                if (parentNode != null) {
                    parent = (RelationalEntity)nodesToModelObjects.get(parentNode);
                    Assertion.isNotNull((Object)parent);
                }
                if ((newModelObject = this.createNewObject(unmatchedNode, parent, modelStructure, nodesToModelObjects, context, totalNumTablesAndProcedures, unitsPerModelObject, counter, monitor, problems, newTableObjects)) == null || parentNode != null) continue;
                context.getResource().getContents().add((Object)newModelObject);
            }
            if (context.getJdbcDatabase().getIncludes().includeForeignKeys()) {
                int numTables = newTableObjects.size();
                if (numTables != 0) {
                    int unitsPerForeignKey = 10000 / numTables;
                    int count = 1;
                    Integer totalCount = new Integer(numTables);
                    for (JdbcTable tableNode : newTableObjects) {
                        if (monitor.isCanceled()) {
                            throw new UserCancelledException();
                        }
                        RelationalEntity entity = (RelationalEntity)nodesToModelObjects.get(tableNode);
                        Object[] tabParams = new Object[]{tableNode.getName(), totalCount, new Integer(count)};
                        String subtaskMsg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Creating_foreign_keys", tabParams);
                        monitor.subTask(subtaskMsg);
                        if (entity instanceof BaseTable) {
                            this.createForeignKey(tableNode, (Table)((BaseTable)entity), context, nodesToModelObjects, problems);
                        }
                        ++count;
                        monitor.worked(unitsPerForeignKey);
                    }
                }
            } else {
                monitor.worked(10000);
            }
            if (monitor.isCanceled()) {
                throw new UserCancelledException();
            }
            monitor.worked(1000);
            if (monitor.isCanceled()) {
                throw new UserCancelledException();
            }
            this.processModelInformation(context, problems);
            monitor.worked(1000);
        }
        catch (JdbcException e) {
            Status status = new Status(4, JdbcRelationalPlugin.PLUGIN_ID, 0, null, (Throwable)e);
            problems.add(status);
        }
        catch (UserCancelledException e) {
            String msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.User_cancelled_operation");
            Status status = new Status(2, JdbcRelationalPlugin.PLUGIN_ID, 0, msg, null);
            problems.add(status);
            throw e;
        }
        catch (Throwable e) {
            Object[] params = new Object[]{context.getJdbcDatabase().getName()};
            String msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Unexpected_exception", params);
            Status status = new Status(4, JdbcRelationalPlugin.PLUGIN_ID, 0, msg, e);
            problems.add(status);
        }
        finally {
            monitor.done();
        }
    }

    protected void processModelInformation(Context context, List problems) {
        ModelContents contents = context.getModelContents();
        ModelAnnotation model = contents.getModelAnnotation();
        this.updateModelAnnotation(model);
    }

    protected RelationalEntity createNewObject(JdbcNode node, RelationalEntity parent, JdbcModelStructure modelStructure, Map nodesToModelObjects, Context context, int totalNum, int unitsPerModelObject, int index, IProgressMonitor monitor, List problems, List newTableObjects) throws JdbcException {
        Assertion.isNotNull((Object)node);
        Assertion.isNotNull((Object)modelStructure);
        Assertion.isNotNull((Object)context);
        ModelContents contents = context.getModelContents();
        int nodeType = node.getType();
        String nodeName = node.getName();
        if (monitor.isCanceled()) {
            throw new UserCancelledException();
        }
        if (nodeName == null || nodeName.trim().length() == 0) {
            String typeName = node.getTypeName();
            Object[] params = new Object[]{typeName};
            String msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Skipping_{0}_with_no_name", params);
            Status status = new Status(2, JdbcRelationalPlugin.PLUGIN_ID, 0, msg, null);
            problems.add(status);
        }
        Catalog obj = null;
        switch (nodeType) {
            case 102: {
                Catalog cat = this.factory.createCatalog();
                this.setNameAndNameInSource((RelationalEntity)cat, nodeName, node, context);
                Object[] catParams = new Object[]{nodeName, new Integer(totalNum), new Integer(index)};
                String subtaskMsg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Creating_catalog", catParams);
                monitor.subTask(subtaskMsg);
                obj = cat;
                monitor.worked(unitsPerModelObject);
                break;
            }
            case 103: {
                Schema schema = this.factory.createSchema();
                Object[] schemaParams = new Object[]{nodeName, new Integer(totalNum), new Integer(index)};
                String subtaskMsg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Creating_schema", schemaParams);
                monitor.subTask(subtaskMsg);
                if (parent instanceof Catalog) {
                    schema.setCatalog((Catalog)parent);
                }
                this.setNameAndNameInSource((RelationalEntity)schema, nodeName, node, context);
                obj = schema;
                monitor.worked(unitsPerModelObject);
                break;
            }
            case 104: {
                EClass eclass;
                JdbcTable tableNode = (JdbcTable)node;
                String tableType = tableNode.getTypeName();
                String eclassName = JdbcRelationalPlugin.getJdbcNodeToRelationalMapping().getRelationalClassForJdbcTableType(tableType);
                RelationalPackage pkg = RelationalPackage.eINSTANCE;
                if (pkg == null) {
                    Assertion.isNotNull((Object)pkg, (String)JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.RelationalPackageNotFound"));
                }
                if ((eclass = (EClass)pkg.getEClassifier(eclassName)) == null) {
                    eclass = pkg.getBaseTable();
                }
                Object[] subtaskParams = new Object[]{eclass.getName(), nodeName, new Integer(totalNum), new Integer(index)};
                String subtaskMsg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Creating_table_or_view", subtaskParams);
                monitor.subTask(subtaskMsg);
                Table table = (Table)this.factory.create(eclass);
                if (parent instanceof Catalog) {
                    table.setCatalog((Catalog)parent);
                } else if (parent instanceof Schema) {
                    table.setSchema((Schema)parent);
                } else {
                    context.getResource().getContents().add((Object)table);
                }
                this.setNameAndNameInSource((RelationalEntity)table, nodeName, node, context);
                String desc = tableNode.getRemarks();
                if (desc != null && desc.trim().length() != 0) {
                    Annotation annotation = ModelResourceContainerFactory.createNewAnnotation((EObject)table, (AnnotationContainer)contents.getAnnotationContainer(true));
                    annotation.setDescription(desc);
                }
                this.createColumns(tableNode, table, context, problems);
                this.createPrimaryKey(tableNode, table, context, problems);
                if (context.getJdbcDatabase().getIncludes().includeIndexes()) {
                    this.createIndexes(tableNode, table, context, problems);
                }
                newTableObjects.add(node);
                obj = table;
                monitor.worked(unitsPerModelObject);
                break;
            }
            case 106: {
                JdbcProcedure procNode = (JdbcProcedure)node;
                Procedure proc = this.factory.createProcedure();
                Object[] procParams = new Object[]{nodeName, new Integer(totalNum), new Integer(index)};
                String subtaskMsg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Creating_procedure", procParams);
                monitor.subTask(subtaskMsg);
                if (parent instanceof Catalog) {
                    proc.setCatalog((Catalog)parent);
                } else if (parent instanceof Schema) {
                    proc.setSchema((Schema)parent);
                } else {
                    context.getResource().getContents().add((Object)proc);
                }
                this.setNameAndNameInSource((RelationalEntity)proc, nodeName, node, context);
                obj = proc;
                this.createParameters(procNode, proc, context, problems);
                monitor.worked(unitsPerModelObject);
            }
        }
        nodesToModelObjects.put(node, obj);
        List children = modelStructure.getChildren(node);
        int counter = 0;
        if (children != null && children.size() != 0) {
            for (JdbcNode child : children) {
                this.createNewObject(child, (RelationalEntity)obj, modelStructure, nodesToModelObjects, context, totalNum, unitsPerModelObject, index + ++counter, monitor, problems, newTableObjects);
            }
        }
        return obj;
    }

    protected void createColumns(JdbcTable tableNode, Table table, Context context, List problems) throws JdbcException {
        Assertion.isNotNull((Object)context);
        ModelContents contents = context.getModelContents();
        try {
            Request request = tableNode.getRequest(GetColumnsRequest.NAME, false);
            Results results = request.getResults();
            Object[] rows = results.getRows();
            int numRows = results.getRowCount();
            for (int i = 0; i < numRows; ++i) {
                Object row = rows[i];
                String name = results.getString(row, 3);
                int type = results.getInt(row, 4);
                String typeName = results.getString(row, 5);
                int columnSize = results.getInt(row, 6);
                int numDecDigits = results.getInt(row, 8);
                int numPrecRadix = results.getInt(row, 9);
                int nullable = results.getInt(row, 10);
                String remarks = results.getString(row, 11);
                String defaultValue = results.getString(row, 12);
                int charOctetLen = results.getInt(row, 15);
                Column column = this.factory.createColumn();
                column.setOwner((ColumnSet)table);
                this.setColumnInfo(column, tableNode, context, problems, name, type, typeName, columnSize, numDecDigits, numPrecRadix, nullable, defaultValue, charOctetLen);
                if (remarks == null || remarks.trim().length() == 0) continue;
                Annotation annotation = ModelResourceContainerFactory.createNewAnnotation((EObject)column, (AnnotationContainer)contents.getAnnotationContainer(true));
                annotation.setDescription(remarks);
            }
        }
        catch (JdbcException e) {
            String msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Error_obtaining_column_info") + e.getLocalizedMessage();
            Status status = new Status(4, JdbcRelationalPlugin.PLUGIN_ID, 0, msg, (Throwable)e);
            problems.add(status);
        }
    }

    protected void setColumnInfo(Column column, JdbcTable tableNode, Context context, List problems, String name, int type, String typeName, int columnSize, int numDecDigits, int numPrecRadix, int nullable, String defaultValue, int charOctetLen) {
        this.setNameAndNameInSource((RelationalEntity)column, name, (JdbcNode)tableNode, context);
        column.setFixedLength(this.isFixedLength(type, typeName));
        column.setNativeType(typeName);
        EObject datatype = this.findType(type, typeName, columnSize, columnSize, numDecDigits, problems);
        if (datatype != null) {
            column.setType(datatype);
        }
        SearchabilityType searchability = this.typeMapping != null && datatype != null ? this.typeMapping.getSearchabilityType(datatype) : SearchabilityType.UNSEARCHABLE_LITERAL;
        column.setSearchability(searchability);
        if (searchability.getValue() == 1) {
            column.setCaseSensitive(false);
            column.setPrecision(columnSize);
            column.setLength(0);
        } else if (searchability.getValue() == 0) {
            column.setLength(columnSize);
            column.setPrecision(0);
            column.setCaseSensitive(true);
        } else {
            column.setCaseSensitive(false);
            column.setPrecision(0);
            column.setLength(columnSize);
        }
        if (type == 1) {
            column.setLength(columnSize);
            column.setPrecision(0);
        }
        column.setScale(numDecDigits);
        switch (nullable) {
            case 0: {
                column.setNullable(NullableType.NO_NULLS_LITERAL);
                break;
            }
            case 1: {
                column.setNullable(NullableType.NULLABLE_LITERAL);
                break;
            }
            default: {
                column.setNullable(NullableType.NULLABLE_UNKNOWN_LITERAL);
            }
        }
        if (defaultValue != null) {
            if (type == -7) {
                column.setNullable(NullableType.NULLABLE_LITERAL);
                char[] charArray = defaultValue.toCharArray();
                if (charArray.length == 1) {
                    char charIntVal = charArray[0];
                    if (charIntVal == '\u0000') {
                        column.setDefaultValue(Boolean.FALSE.toString());
                    } else if (charIntVal == '\u0001') {
                        column.setDefaultValue(Boolean.TRUE.toString());
                    }
                } else if (defaultValue.trim().equals("(0)")) {
                    column.setDefaultValue(Boolean.FALSE.toString());
                } else if (defaultValue.trim().equals("(1)")) {
                    column.setDefaultValue(Boolean.TRUE.toString());
                }
            } else {
                column.setDefaultValue(defaultValue);
            }
        }
        column.setSelectable(true);
        column.setUpdateable(true);
        if (numPrecRadix != 0) {
            column.setRadix(numPrecRadix);
        }
    }

    protected boolean isFixedLength(int type, String typeName) {
        return type != -4 && type != -1 && type != -3 && type != 12 && type != 2003 && type != 2004 && type != 2005;
    }

    protected EObject findType(int jdbcType, String typeName, int length, int precision, int scale, List problems) {
        EObject result = null;
        if (precision != 0 && (jdbcType == 2 || jdbcType == 3)) {
            result = this.findType(precision, scale, problems);
        }
        if (result != null) {
            return result;
        }
        if (jdbcType == 1 || jdbcType == 12 || jdbcType == -1 || "NCHAR".equals(typeName)) {
            result = this.findType("VARCHAR", problems);
        }
        if (result != null) {
            return result;
        }
        if (jdbcType != 1111 && (result = this.findType(jdbcType, problems)) != null) {
            return result;
        }
        result = this.findType(typeName, problems);
        return result;
    }

    protected EObject findType(int precision, int scale, List problems) {
        int numDigits;
        EObject result = null;
        result = scale <= 0 ? ((numDigits = precision - scale) <= 4 ? this.findBuiltinType("short", problems) : (numDigits <= 9 ? this.findBuiltinType("int", problems) : (numDigits <= 18 ? this.findBuiltinType("long", problems) : this.findBuiltinType("biginteger", problems)))) : this.findBuiltinType("bigdecimal", problems);
        return result;
    }

    protected EObject findType(int jdbcType, List problems) {
        if (this.typeMapping != null) {
            try {
                return this.typeMapping.getDatatype(jdbcType);
            }
            catch (ModelerCoreException e) {
                Object[] params = new Object[]{new Integer(jdbcType)};
                String msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Error_while_computing_datatype", params);
                Status status = new Status(4, JdbcRelationalPlugin.PLUGIN_ID, 0, msg, (Throwable)e);
                problems.add(status);
            }
        }
        return null;
    }

    protected EObject findType(String jdbcTypeName, List problems) {
        if (jdbcTypeName != null && this.typeMapping != null) {
            try {
                return this.typeMapping.getDatatype(jdbcTypeName);
            }
            catch (ModelerCoreException e) {
                Object[] params = new Object[]{jdbcTypeName};
                String msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Error_while_computing_datatype", params);
                Status status = new Status(4, JdbcRelationalPlugin.PLUGIN_ID, 0, msg, (Throwable)e);
                problems.add(status);
            }
        }
        return null;
    }

    protected EObject findBuiltinType(String typeName, List problems) {
        if (typeName != null && this.getDatatypeManager() != null) {
            try {
                EObject obj = this.getDatatypeManager().getBuiltInDatatype(typeName);
                if (obj != null) {
                    return obj;
                }
            }
            catch (ModelerCoreException e) {
                Object[] params = new Object[]{typeName};
                String msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Error_while_computing_datatype", params);
                Status status = new Status(4, JdbcRelationalPlugin.PLUGIN_ID, 0, msg, (Throwable)e);
                problems.add(status);
            }
        }
        return null;
    }

    protected void createPrimaryKey(JdbcTable tableNode, Table table, Context context, List problems) throws JdbcException {
        if (!(table instanceof BaseTable)) {
            return;
        }
        boolean includeUniqueIndexes = context.getJdbcImportSettings().isIncludeUniqueIndexes();
        boolean includeForeignKeys = context.getJdbcImportSettings().isIncludeForeignKeys();
        if (!includeUniqueIndexes && !includeForeignKeys) {
            return;
        }
        try {
            Column column;
            Request request = tableNode.getRequest(GetPrimaryKeyRequest.NAME, false);
            Results results = request.getResults();
            Object[] rows = results.getRows();
            int numRows = results.getRowCount();
            if (numRows == 0) {
                return;
            }
            Map columnsByName = this.createColumnMapKeyedByNames(table);
            String pkName = null;
            Column[] columns = new Column[numRows];
            for (int i = 0; i < numRows; ++i) {
                Object row = rows[i];
                String columnName = results.getString(row, 3);
                pkName = results.getString(row, 5);
                column = (Column)columnsByName.get(columnName = tableNode.getUnqualifiedName(columnName));
                if (column == null) continue;
                short seqIndex = results.getShort(row, 4);
                columns[seqIndex - 1] = column;
            }
            PrimaryKey primaryKey = this.factory.createPrimaryKey();
            primaryKey.setTable((BaseTable)table);
            if (pkName != null) {
                this.setNameAndNameInSource((RelationalEntity)primaryKey, pkName, (JdbcNode)tableNode, context);
            }
            EList keyColumns = primaryKey.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                column = columns[i];
                if (column == null) continue;
                keyColumns.add(column);
            }
        }
        catch (JdbcException e) {
            String msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Error_while_obtaining_primary_key_info") + e.getLocalizedMessage();
            Status status = new Status(4, JdbcRelationalPlugin.PLUGIN_ID, 0, msg, (Throwable)e);
            problems.add(status);
        }
    }

    protected boolean checkExportedForeignKeysIfNoImportedForeignKeysFound() {
        return true;
    }

    protected Request getForeignKeyRequest(JdbcTable tableNode, String name, boolean includeMetadata) throws JdbcException {
        return tableNode.getRequest(GetImportedForeignKeysRequest.NAME, false);
    }

    protected void createForeignKey(JdbcTable tableNode, Table table, Context context, Map nodesToModelObjects, List problems) throws JdbcException {
        if (!(table instanceof BaseTable)) {
            return;
        }
        try {
            Request request = this.getForeignKeyRequest(tableNode, GetImportedForeignKeysRequest.NAME, false);
            Results results = request.getResults();
            Object[] rows = results.getRows();
            int numRows = results.getRowCount();
            if (numRows == 0 && this.checkExportedForeignKeysIfNoImportedForeignKeysFound()) {
                request = tableNode.getRequest(GetExportedForeignKeysRequest.NAME, false);
                results = request.getResults();
                rows = results.getRows();
                numRows = results.getRowCount();
                if (numRows == 0) {
                    return;
                }
                return;
            }
            Map columnsByName = this.createColumnMapKeyedByNames(table);
            ArrayList<Column> currentColumnsForKey = null;
            HashMap<String, ArrayList<Column>> columnsByFK = new HashMap<String, ArrayList<Column>>();
            ArrayList<String> currentColumnNamesForPk = null;
            HashMap<String, ArrayList<String>> columnNamesForPks = new HashMap<String, ArrayList<String>>();
            HashMap<String, ForeignKeySpec> fkSpecs = new HashMap<String, ForeignKeySpec>();
            ArrayList<Column> previousColForKeyList = null;
            boolean initDone = false;
            for (int i = 0; i < numRows; ++i) {
                Object row = rows[i];
                short seqIndex = results.getShort(row, 8);
                String fkColumnName = results.getString(row, 7);
                String pkColumnName = results.getString(row, 3);
                fkColumnName = tableNode.getUnqualifiedName(fkColumnName);
                pkColumnName = tableNode.getUnqualifiedName(pkColumnName);
                Column column = (Column)columnsByName.get(fkColumnName);
                String fkName = results.getString(row, 11);
                currentColumnsForKey = (ArrayList<Column>)columnsByFK.get(fkName);
                currentColumnNamesForPk = (ArrayList<String>)columnNamesForPks.get(fkName);
                if (currentColumnsForKey == null || currentColumnsForKey != null && currentColumnsForKey != previousColForKeyList) {
                    initDone = false;
                    previousColForKeyList = currentColumnsForKey;
                }
                if (column == null) continue;
                if (!(seqIndex != 1 && seqIndex != 0 || initDone)) {
                    currentColumnsForKey = new ArrayList<Column>();
                    currentColumnNamesForPk = new ArrayList<String>();
                    ForeignKeySpec fkSpec = new ForeignKeySpec();
                    fkSpec.fkName = fkName;
                    fkSpec.pkName = results.getString(row, 12);
                    fkSpec.pkTable = results.getString(row, 2);
                    fkSpec.pkSchema = results.getString(row, 1);
                    fkSpec.pkCatalog = results.getString(row, 0);
                    fkSpecs.put(fkName, fkSpec);
                    columnsByFK.put(fkName, currentColumnsForKey);
                    columnNamesForPks.put(fkName, currentColumnNamesForPk);
                    initDone = true;
                }
                currentColumnsForKey.add(column);
                currentColumnNamesForPk.add(pkColumnName);
            }
            Iterator fkSpecIter = columnsByFK.keySet().iterator();
            Iterator columnsForKeyIter = columnsByFK.values().iterator();
            Iterator columnNamesForPkIter = columnNamesForPks.values().iterator();
            while (columnsForKeyIter.hasNext()) {
                List columnsForKey = (List)columnsForKeyIter.next();
                List columnNamesForPk = (List)columnNamesForPkIter.next();
                ForeignKeySpec fkSpec = (ForeignKeySpec)fkSpecs.get(fkSpecIter.next());
                ForeignKey fk = this.factory.createForeignKey();
                fk.setTable((BaseTable)table);
                this.setNameAndNameInSource((RelationalEntity)fk, fkSpec.fkName, (JdbcNode)tableNode, context);
                fk.getColumns().addAll((Collection)columnsForKey);
                fk.setPrimaryKeyMultiplicity(MultiplicityKind.UNSPECIFIED_LITERAL);
                fk.setForeignKeyMultiplicity(MultiplicityKind.UNSPECIFIED_LITERAL);
                UniqueKey ukey = this.findUniqueKey(tableNode.getJdbcDatabase(), nodesToModelObjects, fkSpec.pkCatalog, fkSpec.pkSchema, fkSpec.pkTable, columnNamesForPk);
                if (ukey == null) continue;
                fk.setUniqueKey(ukey);
            }
        }
        catch (JdbcException e) {
            String msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Error_while_obtaining_primary_key_info") + e.getLocalizedMessage();
            Status status = new Status(4, JdbcRelationalPlugin.PLUGIN_ID, 0, msg, (Throwable)e);
            problems.add(status);
        }
    }

    protected UniqueKey findUniqueKey(JdbcDatabase dbNode, Map nodesToModelObjects, String catalogName, String schemaName, String tableName, List columnNames) {
        JdbcNode tableTypeContainer;
        Path path = new Path("/");
        if (catalogName != null && catalogName.trim().length() != 0) {
            boolean supportsCatalogs = true;
            try {
                supportsCatalogs = dbNode.getCapabilities().supportsCatalogs();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (supportsCatalogs) {
                path = path.append(catalogName);
            }
        }
        if (schemaName != null && schemaName.trim().length() != 0) {
            boolean supportsSchemas = true;
            try {
                supportsSchemas = dbNode.getCapabilities().supportsSchemas();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (supportsSchemas) {
                path = path.append(schemaName);
            }
        }
        if ((tableTypeContainer = dbNode.findJdbcNode((IPath)path)) == null) {
            tableTypeContainer = dbNode;
        }
        if (tableTypeContainer != null) {
            JdbcNode[] children = null;
            try {
                children = tableTypeContainer.getChildren();
            }
            catch (JdbcException e) {
                JdbcRelationalPlugin.Util.log((Throwable)e);
                return null;
            }
            for (int i = 0; i < children.length; ++i) {
                JdbcNode tableWithKey;
                JdbcNode child = children[i];
                if (!(child instanceof JdbcTableType) || (tableWithKey = child.findChild(tableName)) == null || !(tableWithKey instanceof JdbcTable)) continue;
                JdbcTable tableNode = (JdbcTable)tableWithKey;
                RelationalEntity table = (RelationalEntity)nodesToModelObjects.get(tableWithKey);
                if (table == null || !(table instanceof BaseTable)) continue;
                BaseTable baseTable = (BaseTable)table;
                PrimaryKey pk = baseTable.getPrimaryKey();
                if (this.isUniqueyMatch((UniqueKey)pk, columnNames, tableNode)) {
                    return pk;
                }
                for (UniqueConstraint constraint : ((BaseTable)table).getUniqueConstraints()) {
                    if (!this.isUniqueyMatch((UniqueKey)constraint, columnNames, tableNode)) continue;
                    return constraint;
                }
            }
        }
        return null;
    }

    protected Map createColumnMapKeyedByNames(Table table) {
        HashMap<String, Column> columnsByName = new HashMap<String, Column>();
        for (Column column : table.getColumns()) {
            String columnName = column.getNameInSource();
            if (columnName == null || columnName.trim().length() == 0) {
                columnName = column.getName();
            }
            columnsByName.put(columnName, column);
        }
        return columnsByName;
    }

    protected List createIndexes(JdbcTable tableNode, Table table, Context context, List problems) throws JdbcException {
        LinkedList<Index> indexes = null;
        try {
            Request request = tableNode.getRequest(GetIndexesRequest.NAME, false);
            Results results = request.getResults();
            Object[] rows = results.getRows();
            int numRows = results.getRowCount();
            if (numRows == 0) {
                return Collections.EMPTY_LIST;
            }
            indexes = new LinkedList<Index>();
            Map columnsByName = this.createColumnMapKeyedByNames(table);
            ArrayList<IndexSpec> indexSpecs = new ArrayList<IndexSpec>();
            ArrayList<Column> currentColumnsForIndex = null;
            for (int i = 0; i < numRows; ++i) {
                Object row = rows[i];
                short type = results.getShort(row, 6);
                if (type == 0) {
                    int cardinality = results.getInt(row, 10);
                    this.updateCardinality(table, cardinality);
                    continue;
                }
                short position = results.getShort(row, 7);
                String columnName = results.getString(row, 8);
                columnName = tableNode.getUnqualifiedName(columnName);
                Column column = (Column)columnsByName.get(columnName);
                if (position == 1) {
                    currentColumnsForIndex = new ArrayList<Column>();
                    IndexSpec spec = new IndexSpec();
                    spec.indexName = results.getString(row, 5);
                    spec.indexQualifier = results.getString(row, 4);
                    spec.nonUnique = results.getBoolean(row, 0);
                    spec.pages = results.getInt(row, 11);
                    spec.cardinality = results.getInt(row, 10);
                    spec.filterCondition = results.getString(row, 12);
                    spec.type = type;
                    spec.columns = currentColumnsForIndex;
                    indexSpecs.add(spec);
                }
                if (column == null) continue;
                currentColumnsForIndex.add(column);
            }
            for (IndexSpec indexSpec : indexSpecs) {
                this.modifyIndexName(indexSpec);
                Index index = this.findIndex(table, indexSpec, tableNode, context, true);
                if (index == null) continue;
                this.updateCardinality(table, indexSpec.cardinality);
                indexes.add(index);
            }
        }
        catch (JdbcException e) {
            String msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Error_while_obtaining_primary_key_info") + e.getLocalizedMessage();
            Status status = new Status(4, JdbcRelationalPlugin.PLUGIN_ID, 0, msg, (Throwable)e);
            problems.add(status);
        }
        return indexes;
    }

    protected void modifyIndexName(IndexSpec indexSpec) {
    }

    protected void updateCardinality(Table table, int cardinality) {
        if (table.getCardinality() == 0 && cardinality > 0) {
            table.setCardinality(cardinality);
        }
    }

    protected Index findIndex(Table table, IndexSpec spec, JdbcTable tableNode, Context context, boolean createIfRequired) {
        EObject tableOwner = table.eContainer();
        if (tableOwner != null) {
            EList existingIndexes = null;
            if (tableOwner instanceof Catalog) {
                existingIndexes = ((Catalog)tableOwner).getIndexes();
            } else if (tableOwner instanceof Schema) {
                existingIndexes = ((Schema)tableOwner).getIndexes();
            }
            for (Index index : existingIndexes) {
                boolean isMatch = this.isMatchingIndex(index, spec);
                if (!isMatch) continue;
                this.setNameAndNameInSource((RelationalEntity)index, spec.indexName, (JdbcNode)tableNode, context);
                return index;
            }
        } else {
            Resource resource = table.eResource();
            if (resource != null) {
                for (Object rootObj : resource.getContents()) {
                    Index index;
                    if (!(rootObj instanceof Index) || !this.isMatchingIndex(index = (Index)rootObj, spec)) continue;
                    this.setNameAndNameInSource((RelationalEntity)index, spec.indexName, (JdbcNode)tableNode, context);
                    return index;
                }
            }
        }
        if (table instanceof BaseTable) {
            String objectName = this.convertName(spec.indexName, context);
            PrimaryKey pk = ((BaseTable)table).getPrimaryKey();
            if (pk != null && objectName.equals(pk.getName())) {
                return null;
            }
        }
        Index index = this.factory.createIndex();
        if (tableOwner != null) {
            if (tableOwner instanceof Catalog) {
                index.setCatalog((Catalog)tableOwner);
            } else if (tableOwner instanceof Schema) {
                index.setSchema((Schema)tableOwner);
            }
        } else {
            Resource resource = table.eResource();
            Assertion.isNotNull((Object)resource);
            resource.getContents().add((Object)index);
        }
        this.setNameAndNameInSource((RelationalEntity)index, spec.indexName, (JdbcNode)tableNode, context);
        index.setUnique(!spec.nonUnique);
        index.getColumns().addAll((Collection)spec.columns);
        index.setFilterCondition(spec.filterCondition);
        return index;
    }

    protected boolean isMatchingIndex(Index index, IndexSpec spec) {
        if (index.isUnique() && spec.nonUnique) {
            return false;
        }
        EList indexColumns = index.getColumns();
        List specColumns = spec.columns;
        if (indexColumns.size() != specColumns.size()) {
            return false;
        }
        return indexColumns.containsAll(specColumns) && specColumns.containsAll((Collection<?>)indexColumns);
    }

    private boolean isUniqueyMatch(UniqueKey ukey, List columnNames, JdbcTable tableNode) {
        if (ukey == null) {
            return false;
        }
        EList ukeyColumns = ukey.getColumns();
        if (ukeyColumns.size() != columnNames.size()) {
            return false;
        }
        Iterator iter = ukeyColumns.iterator();
        Iterator nameIter = columnNames.iterator();
        while (iter.hasNext()) {
            Column ukColumn = (Column)iter.next();
            String columnName = (String)nameIter.next();
            String ukColumnName = ukColumn.getNameInSource();
            if (ukColumnName == null || ukColumnName.trim().length() == 0) {
                ukColumnName = ukColumn.getName();
            }
            if (ukColumnName.equals(columnName)) continue;
            return false;
        }
        return true;
    }

    protected void createParameters(JdbcProcedure procNode, Procedure proc, Context context, List problems) throws JdbcException {
        Assertion.isNotNull((Object)context);
        ModelContents contents = context.getModelContents();
        try {
            Request request = procNode.getRequest(GetProcedureParametersRequest.NAME, false);
            Results results = request.getResults();
            Object[] rows = results.getRows();
            int numRows = results.getRowCount();
            if (numRows == 0) {
                return;
            }
            ProcedureResult procResult = null;
            int numParamsWithNullName = 0;
            for (int i = 0; i < numRows; ++i) {
                boolean includeColumn;
                Object row = rows[i];
                String name = results.getString(row, 3);
                short columnType = results.getShort(row, 4);
                short type = results.getShort(row, 5);
                String typeName = results.getString(row, 6);
                int precision = results.getInt(row, 7);
                int length = results.getInt(row, 8);
                int scale = results.getInt(row, 9);
                int radix = results.getInt(row, 10);
                short nullable = results.getShort(row, 11);
                String remarks = results.getString(row, 12);
                boolean resultSetColumn = this.isProcedureResultColumn(columnType, type, typeName);
                if (!resultSetColumn) {
                    ProcedureParameter param = this.factory.createProcedureParameter();
                    param.setProcedure(proc);
                    if (name == null) {
                        name = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.DefaultNameForProcParamWithNoName", ++numParamsWithNullName);
                    }
                    this.setNameAndNameInSource((RelationalEntity)param, name, (JdbcNode)procNode, context);
                    param.setNativeType(typeName);
                    EObject datatype = this.findType(type, typeName, length, precision, scale, problems);
                    if (datatype != null) {
                        param.setType(datatype);
                    }
                    param.setLength(length);
                    param.setPrecision(precision);
                    param.setScale(scale);
                    param.setRadix(radix);
                    switch (nullable) {
                        case 0: {
                            param.setNullable(NullableType.NO_NULLS_LITERAL);
                            break;
                        }
                        case 1: {
                            param.setNullable(NullableType.NULLABLE_LITERAL);
                            break;
                        }
                        default: {
                            param.setNullable(NullableType.NULLABLE_UNKNOWN_LITERAL);
                        }
                    }
                    switch (columnType) {
                        case 1: {
                            param.setDirection(DirectionKind.IN_LITERAL);
                            break;
                        }
                        case 4: {
                            param.setDirection(DirectionKind.OUT_LITERAL);
                            break;
                        }
                        case 2: {
                            param.setDirection(DirectionKind.INOUT_LITERAL);
                            break;
                        }
                        case 5: {
                            param.setDirection(DirectionKind.RETURN_LITERAL);
                            break;
                        }
                        case 3: {
                            param.setDirection(DirectionKind.RETURN_LITERAL);
                            break;
                        }
                        default: {
                            param.setDirection(DirectionKind.UNKNOWN_LITERAL);
                        }
                    }
                    if (remarks == null || remarks.trim().length() == 0) continue;
                    Annotation annotation = ModelResourceContainerFactory.createNewAnnotation((EObject)param, (AnnotationContainer)contents.getAnnotationContainer(true));
                    annotation.setDescription(remarks);
                    continue;
                }
                if (procResult == null) {
                    procResult = this.factory.createProcedureResult();
                    procResult.setProcedure(proc);
                    String resultSetName = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.ResultSetName");
                    this.setNameAndNameInSource((RelationalEntity)procResult, resultSetName, (JdbcNode)procNode, context);
                }
                if (!(includeColumn = this.includeColumnInProcedureResult(columnType, type, typeName))) {
                    this.setNameAndNameInSource((RelationalEntity)procResult, name, (JdbcNode)procNode, context);
                    if (remarks == null || remarks.trim().length() == 0) continue;
                    Annotation annotation = ModelResourceContainerFactory.createNewAnnotation((EObject)procResult, (AnnotationContainer)contents.getAnnotationContainer(true));
                    annotation.setDescription(remarks);
                    continue;
                }
                Column param = this.factory.createColumn();
                param.setOwner((ColumnSet)procResult);
                this.setNameAndNameInSource((RelationalEntity)param, name, (JdbcNode)procNode, context);
                param.setNativeType(typeName);
                EObject datatype = this.findType(type, typeName, length, precision, scale, problems);
                if (datatype != null) {
                    param.setType(datatype);
                }
                param.setLength(length);
                param.setPrecision(precision);
                param.setScale(scale);
                param.setRadix(radix);
                switch (nullable) {
                    case 0: {
                        param.setNullable(NullableType.NO_NULLS_LITERAL);
                        break;
                    }
                    case 1: {
                        param.setNullable(NullableType.NULLABLE_LITERAL);
                        break;
                    }
                    default: {
                        param.setNullable(NullableType.NULLABLE_UNKNOWN_LITERAL);
                    }
                }
                if (remarks == null || remarks.trim().length() == 0) continue;
                Annotation annotation = ModelResourceContainerFactory.createNewAnnotation((EObject)param, (AnnotationContainer)contents.getAnnotationContainer(true));
                annotation.setDescription(remarks);
            }
        }
        catch (JdbcException e) {
            String msg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Error_while_obtaining_primary_key_info") + e.getLocalizedMessage();
            Status status = new Status(4, JdbcRelationalPlugin.PLUGIN_ID, 0, msg, (Throwable)e);
            problems.add(status);
        }
    }

    protected boolean isProcedureResultColumn(short columnType, short type, String typeName) {
        return columnType == 3;
    }

    protected boolean includeColumnInProcedureResult(short columnType, short type, String typeName) {
        return true;
    }

    protected void matchChildren(JdbcNode parentOfNodes, List jdbcNodes, List modelObjs, JdbcModelStructure structure, ObjectMatcher matcher, IProgressMonitor monitor) {
        ArgCheck.isNotNull((Object)jdbcNodes);
        ArgCheck.isNotNull((Object)modelObjs);
        ArgCheck.isNotNull((Object)structure);
        ArgCheck.isNotNull((Object)matcher);
        if (parentOfNodes == null) {
            String subtaskMsg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Finding_existing_root_model_objects");
            monitor.subTask(subtaskMsg);
        } else {
            Object[] params = new Object[]{parentOfNodes.getName()};
            String subtaskMsg = JdbcRelationalPlugin.Util.getString("RelationalModelProcessorImpl.Finding_existing_model_objects", params);
            monitor.subTask(subtaskMsg);
        }
        LinkedList relationalModelObjs = new LinkedList(modelObjs);
        Iterator modelObjIter = relationalModelObjs.iterator();
        while (modelObjIter.hasNext()) {
            Object modelObject = modelObjIter.next();
            if (modelObject instanceof RelationalEntity) continue;
            modelObjIter.remove();
        }
        matcher.findBestMatches(jdbcNodes, relationalModelObjs);
        Iterator iter = jdbcNodes.iterator();
        while (iter.hasNext()) {
            List childrenOfChild;
            if (monitor.isCanceled()) {
                throw new UserCancelledException();
            }
            JdbcNode child = (JdbcNode)iter.next();
            RelationalEntity match = (RelationalEntity)matcher.getDestination().get(child);
            if (match == null || (childrenOfChild = structure.getChildren(child)) == null) continue;
            EList childrenOfMatch = match.eContents();
            this.matchChildren(child, childrenOfChild, (List)childrenOfMatch, structure, matcher, monitor);
        }
    }

    public boolean isVerboseLogging() {
        return this.verbose;
    }

    public void setVerboseLogging(boolean b) {
        this.verbose = b;
    }

    public RelationalFactory getFactory() {
        return this.factory;
    }

    protected void setNameAndNameInSource(RelationalEntity entity, String name, JdbcNode node, Context context) {
        String theName = name;
        if (theName == null || theName.trim().length() == 0) {
            theName = this.createReplacementName(entity, context);
        }
        String convertedName = this.convertName(theName, context);
        RelationalStringNameRule rule = new RelationalStringNameRule(0);
        List siblings = rule.getSiblingsForUniquenessCheck((EObject)entity);
        HashSet<String> siblingNames = new HashSet<String>();
        for (RelationalEntity sibling : siblings) {
            String siblingName;
            if (sibling == entity || (siblingName = sibling.getName()) == null) continue;
            siblingNames.add(siblingName);
        }
        String uniqueName = this.nameValidator.createValidUniqueName(convertedName, siblingNames);
        boolean forceSetNameInSource = false;
        if (uniqueName == null) {
            entity.setName(convertedName);
        } else {
            entity.setName(uniqueName);
            forceSetNameInSource = true;
        }
        String nameInSource = this.computeNameInSource(entity, name, node, context, forceSetNameInSource);
        if (nameInSource != null) {
            entity.setNameInSource(nameInSource);
        }
    }

    protected String convertName(String originalName, Context context) {
        String name = originalName;
        if (originalName != null) {
            JdbcImportSettings settings = context.getJdbcImportSettings();
            CaseConversion caseConversion = settings.getConvertCaseInModel();
            switch (caseConversion.getValue()) {
                case 2: {
                    return name.toLowerCase();
                }
                case 1: {
                    return name.toUpperCase();
                }
            }
        }
        return name;
    }

    protected String createReplacementName(RelationalEntity entity, Context context) {
        return "New" + entity.eClass().getName();
    }

    protected String computeNameInSource(RelationalEntity object, String name, JdbcNode node, Context context, boolean forced) {
        boolean childOfNode;
        if (name == null) {
            return null;
        }
        JdbcImportSettings settings = context.getJdbcImportSettings();
        SourceNames sourceNames = settings.getGenerateSourceNamesInModel();
        int value = sourceNames.getValue();
        if (value == 0) {
            return null;
        }
        EObject parent = object.eContainer();
        boolean bl = childOfNode = parent != null && (parent instanceof Table || parent instanceof Index || parent instanceof Procedure);
        if (forced) {
            if (childOfNode) {
                return node.getUnqualifiedName(name);
            }
            return node.getUnqualifiedName();
        }
        if (value == 2) {
            if (childOfNode) {
                return node.getUnqualifiedName(name);
            }
            return node.getFullyQualifiedName();
        }
        if (value == 1) {
            if (childOfNode) {
                return node.getUnqualifiedName(name);
            }
            return node.getUnqualifiedName();
        }
        return null;
    }

    public RelationalTypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(RelationalTypeMapping mapping) {
        this.typeMapping = mapping;
    }

    public void setDatatypeManager(DatatypeManager manager) {
        this.datatypeManager = manager;
    }

    protected DatatypeManager getDatatypeManager() {
        return this.datatypeManager;
    }

    protected void updateModelAnnotation(ModelAnnotation modelAnnotation) {
        modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
        modelAnnotation.setSupportsOuterJoin(true);
    }

    public boolean getDebugLogTiming() {
        return this.debugTimingEnabled;
    }

    public void setDebugLogTiming(boolean logTiming) {
        this.debugTimingEnabled = logTiming;
    }

    static /* synthetic */ void access$000(RelationalModelProcessorImpl x0, Stopwatch x1, String x2) {
        x0.stopLogIncrementAndRestart(x1, x2);
    }

    static /* synthetic */ DifferenceProcessor access$102(RelationalModelProcessorImpl x0, DifferenceProcessor x1) {
        x0.diffProc = x1;
        return x0.diffProc;
    }

    static /* synthetic */ DifferenceProcessor access$100(RelationalModelProcessorImpl x0) {
        return x0.diffProc;
    }

    static /* synthetic */ DifferenceReport access$202(RelationalModelProcessorImpl x0, DifferenceReport x1) {
        x0.drDifferenceReport = x1;
        return x0.drDifferenceReport;
    }

    static /* synthetic */ DifferenceReport access$200(RelationalModelProcessorImpl x0) {
        return x0.drDifferenceReport;
    }

    class ForeignKeySpec {
        public String fkName;
        public String pkName;
        public String pkCatalog;
        public String pkSchema;
        public String pkTable;

        ForeignKeySpec() {
        }
    }

    public class IndexSpec {
        public String indexName;
        public String indexQualifier;
        public String filterCondition;
        public int cardinality;
        public int pages;
        public int type;
        public boolean nonUnique;
        public List columns;
    }
}

