/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.soap;

import com.metamatrix.connector.xml.SOAPConnectorState;
import com.metamatrix.connector.xml.base.CriteriaDesc;
import com.metamatrix.connector.xml.base.DocumentBuilder;
import com.metamatrix.connector.xml.base.Response;
import com.metamatrix.connector.xml.base.XMLDocument;
import com.metamatrix.connector.xml.jms.JMSSOAPConnectorState;
import com.metamatrix.data.exception.ConnectorException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.message.SOAPHeaderElement;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class SOAPDocBuilder {
    public static final String encodingStyle = "encoding-style";
    public static final String encodingStyleUrl = "http://schemas.xmlsoap.org/soap/encoding/";
    public static final String xsiLabel = "xsi";
    public static final String xsiNS = "http://www.w3.org/1999/XMLSchema-instance";
    public static final String xsdLabel = "xsd";
    public static final String xsLabel = "xs";
    public static final String xsNS = "http://www.w3.org/2001/XMLSchema";
    public static final String xsdNS = "http://www.w3.org/1999/XMLSchema";
    public static final String soapNSLabel = "SOAP-ENV";
    public static final String soapNS = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String soapEnvelope = "Envelope";
    public static final String soapBody = "Body";
    public static final String soapHeader = "Header";
    public static final String DUMMY_NS_PREFIX = "mm-dummy";
    public static final String DUMMY_NS_NAME = "http://www.metamatrix.com/dummy";
    public static final String wsSecNS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final String wsSecLabel = "wsse";
    public static final String wsSecUtilNS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    public static final String wsSecUtilLabel = "wsu";
    public static final Namespace soapNSObj = Namespace.getNamespace((String)"SOAP-ENV", (String)"http://schemas.xmlsoap.org/soap/envelope/");
    public static final Namespace xsiNSObj = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/1999/XMLSchema-instance");
    public static final Namespace xsdNSObj = Namespace.getNamespace((String)"xsd", (String)"http://www.w3.org/1999/XMLSchema");
    public static final Namespace xsNSObj = Namespace.getNamespace((String)"xs", (String)"http://www.w3.org/2001/XMLSchema");
    public static final Namespace wsSecNSObj = Namespace.getNamespace((String)"wsse", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
    public static final Namespace wsSecUtilNSObj = Namespace.getNamespace((String)"wsu", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");

    public String createSOAPRequest(JMSSOAPConnectorState state, List queryList, String namespacePrefixes, String inputParmsXPath) throws ConnectorException {
        Element body = new Element(soapBody, soapNSObj);
        Element envelope = new Element(soapEnvelope, soapNSObj);
        envelope.addNamespaceDeclaration(xsiNSObj);
        envelope.addNamespaceDeclaration(xsdNSObj);
        envelope.addNamespaceDeclaration(xsNSObj);
        if (state.isUseWSSec()) {
            envelope.addNamespaceDeclaration(wsSecNSObj);
            envelope.addNamespaceDeclaration(wsSecUtilNSObj);
        }
        Element header = new Element(soapHeader, soapNSObj);
        ArrayList headerParams = new ArrayList();
        ArrayList bodyParams = new ArrayList();
        this.sortParams(queryList, headerParams, bodyParams);
        if (headerParams.size() > 0) {
            Document headerDoc = this.createSOAPHeaderDoc(headerParams, (SOAPConnectorState)state, namespacePrefixes);
            Element headerRoot = headerDoc.getRootElement();
            Element headerHolder = (Element)headerRoot.getChild(soapHeader).detach();
            List headerChilds = headerHolder.getChildren();
            Object[] children = headerChilds.toArray();
            for (int i = 0; i < children.length; ++i) {
                Element child = (Element)children[i];
                child.detach();
                header.addContent((Content)child);
            }
        }
        envelope.addContent((Content)header);
        Document doc = this.createXMLRequestDoc(bodyParams, (SOAPConnectorState)state, namespacePrefixes, inputParmsXPath);
        Element docRoot = doc.getRootElement();
        docRoot = (Element)docRoot.detach();
        List addNamespaces = docRoot.getAdditionalNamespaces();
        Iterator nsIter = addNamespaces.iterator();
        while (nsIter.hasNext()) {
            Namespace ns = (Namespace)nsIter.next();
            if (ns.getPrefix().equals(xsiNSObj.getPrefix()) && ns.getURI().equals(xsiNSObj.getURI()) || ns.getPrefix().equals(xsdNSObj.getPrefix()) || !ns.getURI().equals(xsdNSObj.getURI())) continue;
            envelope.addNamespaceDeclaration((Namespace)nsIter.next());
        }
        if (docRoot.getNamespaceURI().equals(DUMMY_NS_NAME)) {
            List children = docRoot.getChildren();
            Object[] childarray = children.toArray();
            for (int j = 0; j < childarray.length; ++j) {
                Element elem = (Element)childarray[j];
                elem.detach();
                body.addContent((Content)elem);
            }
            docRoot = body;
        } else {
            body.addContent((Content)docRoot);
        }
        if (state.isEncoded()) {
            Attribute encStyle = new Attribute(encodingStyle, encodingStyleUrl, xsiNSObj);
            docRoot.setAttribute(encStyle);
        }
        if (state.isUseBasicAuth()) {
            SOAPDocBuilder.addSoapBasicAuth(header, state.getAuthUser(), state.getAuthPassword());
        } else if (state.isUseWSSec()) {
            SOAPDocBuilder.addWSSecurityUserToken(header, state.getAuthUser(), state.getAuthPassword());
        }
        envelope.addContent((Content)body);
        doc.setRootElement(envelope);
        String xmlDoc = DocumentBuilder.outputDocToString((Document)doc);
        return xmlDoc;
    }

    private void sortParams(List allParams, List headerParams, List bodyParams) throws ConnectorException {
        for (CriteriaDesc desc : allParams) {
            if (desc.getInputXpath().startsWith("SOAP-ENV:Header")) {
                headerParams.add(desc);
                continue;
            }
            bodyParams.add(desc);
        }
    }

    public static void addSoapBasicAuth(Element header, String user, String password) {
        String soapBasicAuth = "BasicAuth";
        String authLabel = "auth";
        String authNS = "http://soap-authentication.org/2001/10/";
        String attrMustUnderstand = "mustUnderstand";
        String nameLabel = "Name";
        String passwordLabel = "Password";
        Namespace authNSObj = Namespace.getNamespace((String)"auth", (String)"http://soap-authentication.org/2001/10/");
        Element basicAuth = new Element("BasicAuth", authNSObj);
        Attribute mustUnderstand = new Attribute("mustUnderstand", "1", soapNSObj);
        basicAuth.setAttribute(mustUnderstand);
        header.addContent((Content)basicAuth);
        Element name = new Element("Name");
        name.addContent(user);
        basicAuth.addContent((Content)name);
        Element pwd = new Element("Password");
        pwd.addContent(password);
        basicAuth.addContent((Content)pwd);
    }

    public static void addWSSecurityUserToken(Element header, String user, String password) {
        String securityLabel = "Security";
        String attrMustUnderstand = "mustUnderstand";
        String usernameTokenLabel = "UsernameToken";
        String attrId = "Id";
        String usernameLabel = "Username";
        String passwordLabel = "Password";
        String attrPassType = "Type";
        String passwordTextType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
        String nonceLabel = "Nonce";
        String createdLabel = "Created";
        Element security = new Element("Security", wsSecLabel, wsSecNS);
        header.addContent((Content)security);
        Attribute mustUnderstand = new Attribute("mustUnderstand", "1", soapNSObj);
        security.setAttribute(mustUnderstand);
        Element usernameToken = new Element("UsernameToken", wsSecLabel, wsSecNS);
        security.addContent((Content)usernameToken);
        Attribute id = new Attribute("Id", "mm-soap", wsSecUtilNSObj);
        usernameToken.setAttribute(id);
        Element usernameElem = new Element("Username", wsSecLabel, wsSecNS);
        usernameElem.setText(user);
        usernameToken.addContent((Content)usernameElem);
        Element passwordElem = new Element("Password", wsSecLabel, wsSecNS);
        Attribute passTypeAttr = new Attribute("Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        passwordElem.setAttribute(passTypeAttr);
        passwordElem.setText(password);
        usernameToken.addContent((Content)passwordElem);
        String nonce = String.valueOf(Calendar.getInstance().getTimeInMillis()) + user;
        Element nonceElem = new Element("Nonce", wsSecLabel, wsSecNS);
        nonceElem.addContent(String.valueOf(nonce.hashCode()));
        usernameToken.addContent((Content)nonceElem);
        Element createdElem = new Element("Created", wsSecUtilLabel, wsSecUtilNS);
        createdElem.addContent(String.valueOf(Calendar.getInstance().getTimeInMillis()));
        usernameToken.addContent((Content)createdElem);
    }

    private Document createSOAPHeaderDoc(List params, SOAPConnectorState state, String namespacePrefixes) throws ConnectorException {
        DocumentBuilder builder = new DocumentBuilder();
        builder.setUseTypeAttributes(state.isEncoded());
        return builder.buildDocument(params, "SOAP-ENV:Header", namespacePrefixes);
    }

    public Document createXMLRequestDoc(List params, SOAPConnectorState state, String namespacePrefixes, String inputParmsXPath) throws ConnectorException {
        DocumentBuilder builder = new DocumentBuilder();
        builder.setUseTypeAttributes(state.isEncoded());
        String slash = "/";
        String dotSlash = "./";
        if (inputParmsXPath.equals("./") || inputParmsXPath.equals("/") || inputParmsXPath.equals("")) {
            inputParmsXPath = "mm-dummy:dummy";
            namespacePrefixes = namespacePrefixes + " xmlns:" + DUMMY_NS_PREFIX + "=\"" + DUMMY_NS_NAME + "\"";
        }
        return builder.buildDocument(params, inputParmsXPath, namespacePrefixes);
    }

    public static void removeEnvelope(SOAPConnectorState state, Response response) throws ConnectorException {
        XMLDocument xmlDoc = response.getDocuments()[0];
        SOAPDocBuilder.removeEnvelope(state, xmlDoc);
    }

    public static void removeEnvelope(SOAPConnectorState state, XMLDocument xmlDoc) throws ConnectorException {
        Object contextRoot = xmlDoc.getContextRoot();
        if (contextRoot instanceof Document) {
            Document doc = (Document)contextRoot;
            Element env = doc.getRootElement();
            Element bod = env.getChild(soapBody, soapNSObj);
            if (bod != null) {
                if (state.isExceptionOnFault()) {
                    Element soapFault = null;
                    soapFault = bod.getChild("fault", soapNSObj);
                    if (soapFault != null) {
                        SOAPDocBuilder.handleSoapFault(soapFault, state);
                    } else {
                        soapFault = bod.getChild("Fault", soapNSObj);
                        if (soapFault != null) {
                            SOAPDocBuilder.handleSoapFault(soapFault, state);
                        }
                    }
                }
                xmlDoc.setContextRoot((Object)bod);
            } else {
                xmlDoc.setContextRoot((Object)env);
            }
        }
    }

    private static void handleSoapFault(Element soapFault, SOAPConnectorState state) throws ConnectorException {
        String strMessage = soapFault.getChildTextTrim("faultstring");
        Element detailElement = soapFault.getChild("detail");
        if (null != detailElement) {
            Content detail = detailElement.detach();
            Document detailDoc = new Document((Element)detail);
            String strDetail = DocumentBuilder.outputDocToString((Document)detailDoc);
            state.getLogger().logError(strMessage + " : \n" + strDetail);
        } else {
            state.getLogger().logError(strMessage);
        }
        throw new ConnectorException(strMessage);
    }

    public List createSOAPHeaders(SOAPConnectorState state, ArrayList headerParams, String namespacePrefixes, String inputParmsXPath) throws ConnectorException {
        ArrayList<SOAPHeaderElement> result = new ArrayList<SOAPHeaderElement>();
        Document headerDoc = null;
        if (headerParams.size() > 0) {
            headerDoc = this.createSOAPHeaderDoc(headerParams, state, namespacePrefixes);
            Element headerRoot = headerDoc.getRootElement();
            Element headerHolder = (Element)headerRoot.getChild(soapHeader).detach();
            List headerChilds = headerHolder.getChildren();
            Object[] children = headerChilds.toArray();
            for (int i = 0; i < children.length; ++i) {
                Element child = (Element)children[i];
                child.detach();
                QName qname = new QName(child.getNamespaceURI(), child.getName());
                SOAPHeaderElement headerElement = new SOAPHeaderElement(qname, (Object)child.getValue());
                List attributes = child.getAttributes();
                for (Attribute attribute : attributes) {
                    headerElement.setAttribute(attribute.getName(), attribute.getValue());
                }
                result.add(headerElement);
            }
        }
        return result;
    }
}

