/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.metadata.runtime;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.index.IEntryResult;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.index.EntryResult;
import com.metamatrix.internal.core.index.WordEntry;
import com.metamatrix.metamodels.core.Annotation;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.index.IndexingContext;
import com.metamatrix.modeler.core.metadata.runtime.AnnotationRecord;
import com.metamatrix.modeler.core.metadata.runtime.ColumnRecord;
import com.metamatrix.modeler.core.metadata.runtime.ColumnSetRecord;
import com.metamatrix.modeler.core.metadata.runtime.DatatypeRecord;
import com.metamatrix.modeler.core.metadata.runtime.FileRecord;
import com.metamatrix.modeler.core.metadata.runtime.ForeignKeyRecord;
import com.metamatrix.modeler.core.metadata.runtime.MetadataRecord;
import com.metamatrix.modeler.core.metadata.runtime.ModelRecord;
import com.metamatrix.modeler.core.metadata.runtime.ProcedureParameterRecord;
import com.metamatrix.modeler.core.metadata.runtime.ProcedureRecord;
import com.metamatrix.modeler.core.metadata.runtime.PropertyRecord;
import com.metamatrix.modeler.core.metadata.runtime.TableRecord;
import com.metamatrix.modeler.core.metadata.runtime.TransformationRecord;
import com.metamatrix.modeler.core.metadata.runtime.UniqueKeyRecord;
import com.metamatrix.modeler.core.metadata.runtime.VdbRecord;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAnnotationAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnSetAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlDatatypeAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlForeignKeyAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlModelAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTableAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTransformationAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTransformationInfo;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlUniqueKeyAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlVdbAspect;
import com.metamatrix.modeler.internal.core.ModelEditorImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.AbstractMetadataRecord;
import com.metamatrix.modeler.internal.core.metadata.runtime.AnnotationRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.ColumnRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.ColumnSetRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.DatatypeRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.FileRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.ForeignKeyRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.ModelRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.ProcedureParameterRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.ProcedureRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.PropertyRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.TableRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.TransformationRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.UniqueKeyRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.VdbRecordImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class RuntimeAdapter {
    public static final int INDEX_RECORD_BLOCK_SIZE = 8160;
    public static int NONVERSIONED_RECORD_INDEX_VERSION = 0;
    public static int DELIMITER_INDEX_VERSION = 1;
    public static int TABLE_MATERIALIZATION_INDEX_VERSION = 2;
    public static int COLUMN_NATIVE_TYPE_INDEX_VERSION = 3;
    public static int COLUMN_INPUT_PARAMETER_FLAG_INDEX_VERSION = 4;
    public static int ANNOTATION_TAGS_INDEX_VERSION = 5;
    public static int TRANSFORMATION_UUID_INDEX_VERSION = 6;
    public static int COLUMN_NULL_DISTINCT_INDEX_VERSION = 7;
    public static int PRIMITIVE_TYPE_ID_INDEX_VERSION = 8;
    public static int PROCEDURE_UPDATE_COUNT_VERSION;
    public static int CURRENT_INDEX_VERSION;
    private static HashMap metaClassUriMap;

    public static Collection getMetadataRecord(IEntryResult[] queryResult, Container container) {
        ArrayList<MetadataRecord> records = new ArrayList<MetadataRecord>(queryResult.length);
        for (int i = 0; i < queryResult.length; ++i) {
            MetadataRecord record = RuntimeAdapter.getMetadataRecord(queryResult[i], container);
            if (record == null) continue;
            records.add(record);
        }
        return records;
    }

    private static MetadataRecord getMetadataRecord(char[] record) {
        if (record == null || record.length == 0) {
            return null;
        }
        switch (record[0]) {
            case 'A': {
                return RuntimeAdapter.createModelRecord(record);
            }
            case 'B': {
                return RuntimeAdapter.createTableRecord(record);
            }
            case 'D': {
                return null;
            }
            case 'E': {
                return RuntimeAdapter.createProcedureRecord(record);
            }
            case 'F': {
                return RuntimeAdapter.createProcedureParameterRecord(record);
            }
            case 'G': {
                return RuntimeAdapter.createColumnRecord(record);
            }
            case 'C': 
            case 'H': 
            case 'L': {
                return RuntimeAdapter.createColumnSetRecord(record);
            }
            case 'I': 
            case 'K': {
                return RuntimeAdapter.createUniqueKeyRecord(record);
            }
            case 'J': {
                return RuntimeAdapter.createForeignKeyRecord(record);
            }
            case 'M': {
                return RuntimeAdapter.createDatatypeRecord(record);
            }
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': {
                return RuntimeAdapter.createTransformationRecord(record);
            }
            case 'V': {
                return RuntimeAdapter.createVdbRecord(record);
            }
            case 'W': {
                return RuntimeAdapter.createAnnotationRecord(record);
            }
            case 'X': {
                return RuntimeAdapter.createPropertyRecord(record);
            }
            case 'Z': {
                return RuntimeAdapter.createFileRecord(record);
            }
        }
        throw new IllegalArgumentException(ModelerCore.Util.getString("RuntimeAdapter.Invalid_record_type_for_creating_MetadataRecord__1") + record[0]);
    }

    public static MetadataRecord getMetadataRecord(IEntryResult queryResult) {
        return RuntimeAdapter.getMetadataRecord(queryResult, null);
    }

    public static MetadataRecord getMetadataRecord(IEntryResult queryResult, Container container) {
        MetadataRecord record = RuntimeAdapter.getMetadataRecord(queryResult.getWord());
        if (record instanceof AbstractMetadataRecord) {
            ((AbstractMetadataRecord)record).setContainer(container);
        }
        return record;
    }

    public static void addIndexWord(Object eObject, IndexingContext context, String modelPath, Collection wordEntries) {
        RuntimeAdapter.addIndexWord(eObject, context, modelPath, wordEntries, true);
    }

    public static void addFileIndexWord(String filePath, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(50);
        sb.append('Z');
        sb.append('\u00a0');
        sb.append(filePath);
        sb.append('\u00a0');
        WordEntry wordEntry = new WordEntry(sb.toString().toCharArray());
        wordEntries.add(wordEntry);
    }

    public static void addIndexWord(Object eObject, IndexingContext context, String modelPath, Collection wordEntries, boolean addAllWords) {
        ArgCheck.isInstanceOf(EObject.class, (Object)eObject);
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)((EObject)eObject));
        if (sqlAspect == null || !sqlAspect.isQueryable((EObject)eObject)) {
            return;
        }
        if (sqlAspect.isRecordType('G')) {
            RuntimeAdapter.addColumnWord((SqlColumnAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
        }
        if (sqlAspect.isRecordType('B')) {
            RuntimeAdapter.addTableWord((SqlTableAspect)sqlAspect, (EObject)eObject, context, modelPath, wordEntries);
        }
        if (sqlAspect.isRecordType('M')) {
            RuntimeAdapter.addDatatypeWord((SqlDatatypeAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
        }
        if (sqlAspect.isRecordType('E')) {
            RuntimeAdapter.addCallableWord((SqlProcedureAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
        }
        if (sqlAspect.isRecordType('F')) {
            RuntimeAdapter.addCallableParameterWord((SqlProcedureParameterAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
        }
        if (sqlAspect.isRecordType('A')) {
            RuntimeAdapter.addModelWord((SqlModelAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
        }
        if (addAllWords) {
            if (sqlAspect.isRecordType('I') || sqlAspect.isRecordType('K')) {
                RuntimeAdapter.addUniqueKeyWord((SqlUniqueKeyAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
            }
            if (sqlAspect.isRecordType('L') || sqlAspect.isRecordType('H') || sqlAspect.isRecordType('C')) {
                RuntimeAdapter.addColumnSetWord((SqlColumnSetAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
            }
            if (sqlAspect.isRecordType('J')) {
                RuntimeAdapter.addForeignKeyWord((SqlForeignKeyAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
            }
            if (sqlAspect.isRecordType('P') || sqlAspect.isRecordType('Q') || sqlAspect.isRecordType('R') || sqlAspect.isRecordType('S') || sqlAspect.isRecordType('T') || sqlAspect.isRecordType('U')) {
                RuntimeAdapter.addTransformationWords((SqlTransformationAspect)sqlAspect, (EObject)eObject, context, modelPath, wordEntries);
            }
            if (sqlAspect.isRecordType('V')) {
                RuntimeAdapter.addVdbWord((SqlVdbAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
            }
            if (sqlAspect.isRecordType('W')) {
                RuntimeAdapter.addAnnotationWord((SqlAnnotationAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
            }
            RuntimeAdapter.addPropertyWord(sqlAspect, (EObject)eObject, modelPath, wordEntries);
        }
    }

    public static void addModelWord(SqlModelAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String parentObjectID = null;
        String fullName = aspect.getName(eObject);
        RuntimeAdapter.addModelWord(objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, aspect.getMaxSetSize(eObject), aspect.getModelType(eObject), aspect.isVisible(eObject), aspect.supportsDistinct(eObject), aspect.supportsJoin(eObject), aspect.supportsOrderBy(eObject), aspect.supportsOuterJoin(eObject), aspect.supportsWhereAll(eObject), aspect.getPrimaryMetamodelUri(eObject), modelPath, wordEntries);
    }

    static void addModelWord(String objectID, String fullName, String nameInSource, String parentObjectID, int maxSetSize, int modelType, boolean isVisible, boolean supportsDistinct, boolean supportsJoin, boolean supportsOrderBy, boolean supportsOuterJoin, boolean supportsWhereAll, String primaryMetamodelUri, String modelPath, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader('A', objectID, fullName, nameInSource, parentObjectID, sb);
        sb.append(maxSetSize);
        sb.append('\u00a0');
        sb.append(modelType);
        sb.append('\u00a0');
        sb.append(primaryMetamodelUri);
        sb.append('\u00a0');
        RuntimeAdapter.appendBoolean(isVisible, sb);
        RuntimeAdapter.appendBoolean(supportsDistinct, sb);
        RuntimeAdapter.appendBoolean(supportsJoin, sb);
        RuntimeAdapter.appendBoolean(supportsOrderBy, sb);
        RuntimeAdapter.appendBoolean(supportsOuterJoin, sb);
        RuntimeAdapter.appendBoolean(supportsWhereAll, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, fullName, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addVdbWord(SqlVdbAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String parentObjectID = null;
        String fullName = aspect.getFullName(eObject);
        String name = aspect.getName(eObject);
        RuntimeAdapter.addVdbWord(objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, aspect.getVersion(eObject), aspect.getIdentifier(eObject), aspect.getDescription(eObject), aspect.getProducerName(eObject), aspect.getProducerVersion(eObject), aspect.getProvider(eObject), aspect.getTimeLastChanged(eObject), aspect.getTimeLastProduced(eObject), aspect.getModelIDs(eObject), modelPath, name, wordEntries);
    }

    static void addVdbWord(String objectID, String fullName, String nameInSource, String parentObjectID, String version, String identifier, String description, String producerName, String producerVersion, String provider, String timeLastChanged, String timeLastProduced, List modelIDs, String modelPath, String name, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader('V', objectID, fullName, nameInSource, parentObjectID, sb);
        RuntimeAdapter.appendObject(version, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(identifier, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(producerName, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(producerVersion, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(provider, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(timeLastChanged, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(timeLastProduced, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendIDs(modelIDs, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(description, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addTransformationWords(SqlTransformationAspect aspect, EObject eObject, IndexingContext context, String modelPath, Collection wordEntries) {
        EObject virtualTable = (EObject)aspect.getTransformedObject(eObject);
        if (virtualTable == null) {
            return;
        }
        if (context != null) {
            if (context.hasTransformation(virtualTable)) {
                return;
            }
            context.addTargetTransform(virtualTable, eObject);
        }
        String upperName = aspect.getFullName(eObject).toUpperCase();
        String transformedObjectID = RuntimeAdapter.getObjectIdString(virtualTable);
        String transformationObjectID = RuntimeAdapter.getObjectIdString(eObject);
        String name = aspect.getName(eObject);
        String[] types = aspect.getTransformationTypes(eObject);
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                SqlTransformationInfo transInfo;
                if (types[i].equals("Insert") && !aspect.isInsertAllowed(eObject) || types[i].equals("Update") && !aspect.isUpdateAllowed(eObject) || types[i].equals("Delete") && !aspect.isDeleteAllowed(eObject) || (transInfo = aspect.getTransformationInfo(eObject, context, types[i])) == null) continue;
                String sqlTransform = transInfo.getSqlTransform();
                List bindingNames = transInfo.getBindings();
                List schemaPaths = transInfo.getSchemaPaths();
                RuntimeAdapter.addTransformationWord(upperName, types[i], transformationObjectID, transformedObjectID, sqlTransform, bindingNames, schemaPaths, modelPath, name, wordEntries);
            }
        }
    }

    static void addTransformationWord(String upperName, String tranformType, String transformationObjectID, String transformedObjectID, String transformation, List bindings, List schemaPaths, String modelPath, String name, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        if (tranformType.equals("Select")) {
            sb.append('P');
        } else if (tranformType.equals("Insert")) {
            sb.append('Q');
        } else if (tranformType.equals("Update")) {
            sb.append('R');
        } else if (tranformType.equals("Delete")) {
            sb.append('S');
        } else if (tranformType.equals("Procedure")) {
            sb.append('T');
        } else if (tranformType.equals("Mapping")) {
            sb.append('U');
        }
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(upperName, sb);
        sb.append('\u00a0');
        sb.append(transformedObjectID);
        sb.append('\u00a0');
        sb.append(transformationObjectID);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(transformation, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendStrings(bindings, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendStrings(schemaPaths, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(transformedObjectID, sb, wordEntries);
    }

    public static void addCallableWord(SqlProcedureAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String parentObjectID = null;
        String fullName = aspect.getFullName(eObject);
        String name = aspect.getName(eObject);
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader('E', objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, sb);
        RuntimeAdapter.appendBoolean(aspect.isFunction(eObject), sb);
        RuntimeAdapter.appendBoolean(aspect.isVirtual(eObject), sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendIDs(aspect.getParameters(eObject), sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendID(aspect.getResult(eObject), sb);
        sb.append('\u00a0');
        sb.append(aspect.getUpdateCount(eObject));
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addCallableParameterWord(SqlProcedureParameterAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String parentObjectID = RuntimeAdapter.getObjectIdString(aspect.getParentObjectID(eObject));
        String fullName = aspect.getFullName(eObject);
        String name = aspect.getName(eObject);
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader('F', objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, sb);
        RuntimeAdapter.appendObject(aspect.getDefaultValue(eObject), sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(aspect.getRuntimeType(eObject), sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(aspect.getDatatypeObjectID(eObject), sb);
        sb.append('\u00a0');
        sb.append(aspect.getLength(eObject));
        sb.append('\u00a0');
        sb.append(aspect.getRadix(eObject));
        sb.append('\u00a0');
        sb.append(aspect.getScale(eObject));
        sb.append('\u00a0');
        sb.append(aspect.getNullType(eObject));
        sb.append('\u00a0');
        sb.append(aspect.getPrecision(eObject));
        sb.append('\u00a0');
        sb.append(aspect.getPosition(eObject));
        sb.append('\u00a0');
        sb.append(aspect.getType(eObject));
        sb.append('\u00a0');
        RuntimeAdapter.appendBoolean(aspect.isOptional(eObject), sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addTableWord(SqlTableAspect aspect, EObject eObject, IndexingContext context, String modelPath, Collection wordEntries) {
        Collection tables;
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String name = aspect.getName(eObject);
        String parentObjectID = null;
        String fullName = aspect.getFullName(eObject);
        String primaryKeyID = RuntimeAdapter.getObjectIdString(aspect.getPrimaryKey(eObject));
        String materializedTableID = null;
        String materializedStageTableID = null;
        boolean isMaterialized = aspect.isMaterialized(eObject);
        if (isMaterialized && context != null && (tables = context.getMaterializedTables(eObject)) != null) {
            Iterator iter = tables.iterator();
            EObject matTable1 = (EObject)iter.next();
            EObject matTable2 = null;
            if (iter.hasNext()) {
                matTable2 = (EObject)iter.next();
            }
            if (matTable1 != null && matTable2 != null) {
                String matTable1Name = aspect.getNameInSource(matTable1);
                String matTable2Name = aspect.getNameInSource(matTable2);
                if (matTable1Name != null && matTable2Name != null) {
                    int matTable2Len;
                    int matTable1Len = matTable1Name.length();
                    if (matTable1Len > (matTable2Len = matTable2Name.length())) {
                        materializedStageTableID = aspect.getObjectID(matTable1).toString();
                        materializedTableID = aspect.getObjectID(matTable2).toString();
                    } else {
                        materializedStageTableID = aspect.getObjectID(matTable2).toString();
                        materializedTableID = aspect.getObjectID(matTable1).toString();
                    }
                }
            }
        }
        RuntimeAdapter.addTableWord(objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, aspect.getCardinality(eObject), aspect.getTableType(eObject), aspect.isVirtual(eObject), aspect.isSystem(eObject), isMaterialized, aspect.supportsUpdate(eObject), primaryKeyID, aspect.getColumns(eObject), aspect.getForeignKeys(eObject), aspect.getIndexes(eObject), aspect.getUniqueKeys(eObject), aspect.getAccessPatterns(eObject), materializedTableID, materializedStageTableID, modelPath, name, wordEntries);
    }

    static void addTableWord(String objectID, String fullName, String nameInSource, String parentObjectID, int cardinality, int tableType, boolean isVirtual, boolean isSystem, boolean isMaterialized, boolean supportsUpdate, String primaryKeyID, List columnIDs, Collection foreignKeyIDs, Collection indexIDs, Collection uniqueKeyIDs, Collection accessPatternIDs, String materializedTableID, String materializedStageTableID, String modelPath, String name, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader('B', objectID, fullName, nameInSource, parentObjectID, sb);
        sb.append(cardinality);
        sb.append('\u00a0');
        sb.append(tableType);
        sb.append('\u00a0');
        RuntimeAdapter.appendBoolean(isVirtual, sb);
        RuntimeAdapter.appendBoolean(isSystem, sb);
        RuntimeAdapter.appendBoolean(supportsUpdate, sb);
        RuntimeAdapter.appendBoolean(isMaterialized, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendIDs(Collections.EMPTY_LIST, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendID(primaryKeyID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendIDs(foreignKeyIDs, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendIDs(indexIDs, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendIDs(uniqueKeyIDs, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendIDs(accessPatternIDs, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendID(materializedTableID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendID(materializedStageTableID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addColumnWord(SqlColumnAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String parentObjectID = RuntimeAdapter.getObjectIdString(aspect.getParentObjectID(eObject));
        String name = aspect.getName(eObject);
        String fullName = aspect.getFullName(eObject);
        String minValue = aspect.getMinValue(eObject) != null ? aspect.getMinValue(eObject).toString() : null;
        String maxValue = aspect.getMaxValue(eObject) != null ? aspect.getMaxValue(eObject).toString() : null;
        String defaultValue = aspect.getDefaultValue(eObject) != null ? aspect.getDefaultValue(eObject).toString() : null;
        RuntimeAdapter.addColumnWord(objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, aspect.isSelectable(eObject), aspect.isUpdatable(eObject), aspect.getNullType(eObject), aspect.isAutoIncrementable(eObject), aspect.isCaseSensitive(eObject), aspect.isSigned(eObject), aspect.isCurrency(eObject), aspect.isFixedLength(eObject), aspect.isTranformationInputParameter(eObject), aspect.getSearchType(eObject), aspect.getLength(eObject), aspect.getScale(eObject), aspect.getPrecision(eObject), aspect.getCharOctetLength(eObject), aspect.getRadix(eObject), aspect.getDistinctValues(eObject), aspect.getNullValues(eObject), minValue, maxValue, aspect.getFormat(eObject), aspect.getRuntimeType(eObject), aspect.getNativeType(eObject), aspect.getDatatypeObjectID(eObject), defaultValue, aspect.getPosition(eObject), modelPath, name, wordEntries);
    }

    static void addColumnWord(String objectID, String fullName, String nameInSource, String parentObjectID, boolean isSelectable, boolean isUpdatable, int nullType, boolean isAutoIncrementable, boolean isCaseSensitive, boolean isSigned, boolean isCurrency, boolean isFixedLength, boolean isTranformationInputParameter, int searchType, int length, int scale, int precision, int charOctetLength, int radix, int distinctValues, int nullValues, String minValue, String maxValue, String format, String runtimeType, String nativeType, String datatypeObjectID, String defaultValue, int position, String modelPath, String name, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader('G', objectID, fullName, nameInSource, parentObjectID, sb);
        RuntimeAdapter.appendBoolean(isSelectable, sb);
        RuntimeAdapter.appendBoolean(isUpdatable, sb);
        RuntimeAdapter.appendBoolean(isAutoIncrementable, sb);
        RuntimeAdapter.appendBoolean(isCaseSensitive, sb);
        RuntimeAdapter.appendBoolean(isSigned, sb);
        RuntimeAdapter.appendBoolean(isCurrency, sb);
        RuntimeAdapter.appendBoolean(isFixedLength, sb);
        RuntimeAdapter.appendBoolean(isTranformationInputParameter, sb);
        sb.append('\u00a0');
        sb.append(nullType);
        sb.append('\u00a0');
        sb.append(searchType);
        sb.append('\u00a0');
        sb.append(length);
        sb.append('\u00a0');
        sb.append(scale);
        sb.append('\u00a0');
        sb.append(precision);
        sb.append('\u00a0');
        sb.append(position);
        sb.append('\u00a0');
        sb.append(charOctetLength);
        sb.append('\u00a0');
        sb.append(radix);
        sb.append('\u00a0');
        sb.append(distinctValues);
        sb.append('\u00a0');
        sb.append(nullValues);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(minValue, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(maxValue, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(format, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(runtimeType, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(nativeType, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(datatypeObjectID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(defaultValue, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addColumnSetWord(SqlColumnSetAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String parentObjectID = RuntimeAdapter.getObjectIdString(aspect.getParentObjectID(eObject));
        String fullName = aspect.getFullName(eObject);
        String name = aspect.getName(eObject);
        char recordType = 'L';
        if (aspect.isRecordType('H')) {
            recordType = 'H';
        }
        if (aspect.isRecordType('C')) {
            recordType = 'C';
        }
        RuntimeAdapter.addColumnSetWord(recordType, objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, aspect.getColumns(eObject), modelPath, name, wordEntries);
    }

    static void addColumnSetWord(char recordType, String objectID, String fullName, String nameInSource, String parentObjectID, List columnIDs, String modelPath, String name, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader(recordType, objectID, fullName, nameInSource, parentObjectID, sb);
        RuntimeAdapter.appendIDs(columnIDs, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addUniqueKeyWord(SqlUniqueKeyAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String parentObjectID = RuntimeAdapter.getObjectIdString(aspect.getParentObjectID(eObject));
        String name = aspect.getName(eObject);
        String fullName = aspect.getFullName(eObject);
        char recordType = 'K';
        if (aspect.isRecordType('I')) {
            recordType = 'I';
        }
        RuntimeAdapter.addUniqueKeyWord(recordType, objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, aspect.getColumns(eObject), aspect.getForeignKeys(eObject), modelPath, name, wordEntries);
    }

    static void addUniqueKeyWord(char recordType, String objectID, String fullName, String nameInSource, String parentObjectID, List columnIDs, List foreignKeyIDs, String modelPath, String name, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader(recordType, objectID, fullName, nameInSource, parentObjectID, sb);
        RuntimeAdapter.appendIDs(columnIDs, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendIDs(foreignKeyIDs, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addForeignKeyWord(SqlForeignKeyAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String parentObjectID = RuntimeAdapter.getObjectIdString(aspect.getParentObjectID(eObject));
        String name = aspect.getName(eObject);
        String fullName = aspect.getFullName(eObject);
        String uniqueKeyID = aspect.getUniqueKey(eObject) != null ? RuntimeAdapter.getObjectIdString(aspect.getUniqueKey(eObject)) : null;
        RuntimeAdapter.addForeignKeyWord(objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, aspect.getColumns(eObject), uniqueKeyID, modelPath, name, wordEntries);
    }

    static void addForeignKeyWord(String objectID, String fullName, String nameInSource, String parentObjectID, List columnIDs, String uniqueKeyID, String modelPath, String name, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader('J', objectID, fullName, nameInSource, parentObjectID, sb);
        RuntimeAdapter.appendIDs(columnIDs, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(uniqueKeyID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addDatatypeWord(SqlDatatypeAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        EObject container = eObject != null ? eObject.eContainer() : null;
        String parentObjectID = RuntimeAdapter.getObjectIdString(container);
        String fullName = aspect.getFullName(eObject);
        String name = aspect.getName(eObject);
        RuntimeAdapter.addDatatypeWord(objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, aspect.getLength(eObject), aspect.getPrecisionLength(eObject), aspect.getScale(eObject), aspect.getRadix(eObject), aspect.isSigned(eObject), aspect.isAutoIncrement(eObject), aspect.isCaseSensitive(eObject), aspect.getType(eObject), aspect.getSearchType(eObject), aspect.getNullType(eObject), aspect.getJavaClassName(eObject), aspect.getRuntimeTypeName(eObject), aspect.getDatatypeID(eObject), aspect.getBasetypeID(eObject), aspect.getPrimitiveTypeID(eObject), aspect.getVarietyType(eObject), aspect.getVarietyProps(eObject), modelPath, name, wordEntries);
    }

    static void addDatatypeWord(String objectID, String fullName, String nameInSource, String parentObjectID, int length, int precisionLength, int scale, int radix, boolean isSigned, boolean isAutoIncrement, boolean isCaseSensitive, short type, short searchType, short nullType, String javaClassName, String runtimeTypeName, String datatypeID, String baseTypeID, String primitiveTypeID, short varietyType, List varietyProps, String modelPath, String name, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        sb.append('M');
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(datatypeID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(baseTypeID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(fullName, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(objectID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(nameInSource, sb);
        sb.append('\u00a0');
        sb.append(varietyType);
        sb.append('\u00a0');
        RuntimeAdapter.appendIDs(varietyProps, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(runtimeTypeName, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(javaClassName, sb);
        sb.append('\u00a0');
        sb.append(type);
        sb.append('\u00a0');
        sb.append(searchType);
        sb.append('\u00a0');
        sb.append(nullType);
        sb.append('\u00a0');
        RuntimeAdapter.appendBoolean(isSigned, sb);
        RuntimeAdapter.appendBoolean(isAutoIncrement, sb);
        RuntimeAdapter.appendBoolean(isCaseSensitive, sb);
        sb.append('\u00a0');
        sb.append(length);
        sb.append('\u00a0');
        sb.append(precisionLength);
        sb.append('\u00a0');
        sb.append(scale);
        sb.append('\u00a0');
        sb.append(radix);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(primitiveTypeID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addPropertyWord(SqlAspect sqlAspect, EObject eObject, String modelPath, Collection wordEntries) {
        EObject extObject = null;
        Annotation annotationObject = null;
        try {
            ModelEditor editor = ModelerCore.getModelEditor();
            extObject = editor.getExtension(eObject);
            annotationObject = editor.getAnnotation(eObject, false);
        }
        catch (Exception e) {
            ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
        }
        LinkedList<String> propertyNames = new LinkedList<String>();
        String objectID = RuntimeAdapter.getObjectIdString(eObject);
        String name = sqlAspect.getName(eObject);
        if (extObject != null) {
            EClass eClass = extObject.eClass();
            for (EStructuralFeature feature : eClass.getEAttributes()) {
                String key = feature.getName();
                Object value2 = extObject.eGet(feature);
                if (key == null || value2 == null) continue;
                String propName = key.toString();
                String propValue = value2.toString();
                if (StringUtil.isEmpty((String)propName) || StringUtil.isEmpty((String)propValue)) continue;
                if (feature.isMany()) {
                    EList valueList = (EList)value2;
                    if (valueList.isEmpty()) continue;
                    for (Object value2 : eClass.getEAttributes()) {
                        if (value2 == null || !StringUtil.isEmpty((String)value2.toString())) continue;
                        RuntimeAdapter.addPropertyWord(objectID, name, propName, value2.toString(), true, modelPath, wordEntries);
                    }
                } else {
                    RuntimeAdapter.addPropertyWord(objectID, name, propName, propValue, true, modelPath, wordEntries);
                }
                propertyNames.add(propName);
            }
        }
        if (annotationObject != null) {
            SqlAnnotationAspect annotationAspect = (SqlAnnotationAspect)AspectManager.getSqlAspect((EObject)annotationObject);
            Map propValues = annotationAspect.getTags((EObject)annotationObject);
            if (propValues == null || propValues.isEmpty()) {
                return;
            }
            for (Map.Entry mapEntry : propValues.entrySet()) {
                if (mapEntry == null) continue;
                Object key = mapEntry.getKey();
                Object value = mapEntry.getValue();
                if (key == null || value == null) continue;
                String propName = key.toString();
                String propValue = value.toString();
                if (StringUtil.isEmpty((String)propName) || StringUtil.isEmpty((String)propValue) || propertyNames.contains(propName)) continue;
                RuntimeAdapter.addPropertyWord(objectID, name, propName, propValue, false, modelPath, wordEntries);
            }
        }
    }

    public static void addPropertyWord(String objectID, String name, String propName, String propValue, boolean isExtention, String modelPath, Collection wordEntries) {
        if (StringUtil.isEmpty((String)propName) || StringUtil.isEmpty((String)propValue)) {
            return;
        }
        StringBuffer sb = new StringBuffer(30);
        sb.append('X');
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(objectID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(propName, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(propValue, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendBoolean(isExtention, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addAnnotationWord(SqlAnnotationAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        SqlAspect sqlAspect;
        Annotation annotation;
        EObject target;
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String parentObjectID = null;
        String fullName = aspect.getFullName(eObject);
        String name = aspect.getName(eObject);
        if (eObject instanceof Annotation && (target = (annotation = (Annotation)eObject).getAnnotatedObject()) != null && (sqlAspect = AspectManager.getSqlAspect((EObject)target)) != null && !sqlAspect.isQueryable(target)) {
            return;
        }
        RuntimeAdapter.addAnnotationWord(objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, aspect.getDescription(eObject), modelPath, name, wordEntries);
    }

    static void addAnnotationWord(String objectID, String fullName, String nameInSource, String parentObjectID, String description, String modelPath, String name, Collection wordEntries) {
        if (StringUtil.isEmpty((String)description)) {
            return;
        }
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader('W', objectID, fullName, nameInSource, parentObjectID, sb);
        RuntimeAdapter.appendObject(description, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static IEntryResult joinEntryResults(IEntryResult result, IEntryResult[] continuationResults, int blockSize) {
        Assertion.isNotNull((Object)result);
        char[] baseResult = result.getWord();
        if (baseResult.length < blockSize || baseResult[blockSize - 1] != '&') {
            return result;
        }
        String baseStr = new String(baseResult);
        String objectID = RuntimeAdapter.extractUUIDString(result);
        StringBuffer sb = new StringBuffer();
        sb.append(baseStr.substring(0, blockSize - 1));
        IEntryResult[] sortedResults = RuntimeAdapter.sortContinuationResults(objectID, continuationResults);
        for (int i = 0; i < sortedResults.length; ++i) {
            int beginIndex;
            char[] continuation = sortedResults[i].getWord();
            int segNumber = RuntimeAdapter.getContinuationSegmentNumber(objectID, sortedResults[i]);
            for (int j = beginIndex = objectID.length() + Integer.toString(segNumber).length() + 5; j < continuation.length; ++j) {
                if (j >= blockSize - 1) continue;
                sb.append(continuation[j]);
            }
        }
        return new EntryResult(sb.toString().toCharArray(), result.getFileReferences());
    }

    private static IEntryResult[] sortContinuationResults(String objectID, IEntryResult[] continuationResults) {
        if (continuationResults.length < 10) {
            return continuationResults;
        }
        IEntryResult[] sortedResults = new IEntryResult[continuationResults.length];
        for (int i = 0; i < continuationResults.length; ++i) {
            int segNumber = RuntimeAdapter.getContinuationSegmentNumber(objectID, continuationResults[i]);
            sortedResults[segNumber - 1] = continuationResults[i];
        }
        return sortedResults;
    }

    private static int getContinuationSegmentNumber(String objectID, IEntryResult continuationResult) {
        char[] record = continuationResult.getWord();
        int segNumber = -1;
        int index = objectID.length() + 4;
        if (record[index + 1] == '\u00a0') {
            segNumber = Character.getNumericValue(record[index]);
        } else if (record[index + 2] == '\u00a0') {
            char[] temp = new char[]{record[index], record[index + 1]};
            String segCount = new String(temp);
            segNumber = Integer.parseInt(segCount);
        } else if (record[index + 3] == '\u00a0') {
            char[] temp = new char[]{record[index], record[index + 1], record[index + 2]};
            String segCount = new String(temp);
            segNumber = Integer.parseInt(segCount);
        }
        return segNumber;
    }

    public static String extractUUIDString(IEntryResult result) {
        Assertion.isNotNull((Object)result);
        char[] word = result.getWord();
        String baseStr = new String(word);
        int beginIndex = baseStr.indexOf("mmuuid");
        int endIndex = word.length;
        Assertion.assertTrue((beginIndex != -1 ? 1 : 0) != 0);
        for (int i = beginIndex; i < word.length; ++i) {
            if (word[i] != '\u00a0') continue;
            endIndex = i;
            break;
        }
        Assertion.assertTrue((beginIndex < endIndex ? 1 : 0) != 0);
        return baseStr.substring(beginIndex, endIndex);
    }

    public static List splitWordEntry(String objectID, WordEntry wordEntry, int blockSize) {
        Assertion.isNotNull((Object)objectID);
        Assertion.isNotNull((Object)wordEntry);
        String entryStr = wordEntry.toString();
        int length = entryStr.length();
        if (length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<WordEntry> result = new ArrayList<WordEntry>(9);
        if (length < blockSize) {
            result.add(wordEntry);
            return result;
        }
        Assertion.assertTrue((blockSize >= objectID.length() + 8 ? 1 : 0) != 0);
        char[] origEntry = entryStr.toCharArray();
        int segCount = 1;
        char recordType = origEntry[0];
        StringBuffer sb = new StringBuffer(blockSize);
        for (int i = 0; i < origEntry.length; ++i) {
            char c = origEntry[i];
            sb.append(c);
            if (sb.length() != blockSize - 1 || i >= origEntry.length - 1) continue;
            RuntimeAdapter.appendContinuationTrailer(blockSize, sb);
            WordEntry partialEntry = new WordEntry(sb.toString().toCharArray());
            result.add(partialEntry);
            sb.setLength(0);
            RuntimeAdapter.appendContinuationHeader(recordType, objectID, segCount, sb);
            ++segCount;
        }
        if (sb.length() > 0) {
            WordEntry partialEntry = new WordEntry(sb.toString().toCharArray());
            result.add(partialEntry);
        }
        return result;
    }

    protected static ModelRecord createModelRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        ModelRecordImpl model = new ModelRecordImpl();
        int indexVersion = RuntimeAdapter.getIndexVersion(record);
        model.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RuntimeAdapter.setRecordHeaderValues((AbstractMetadataRecord)model, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        model.setMaxSetSize(Integer.parseInt((String)tokens.get(tokenIndex++)));
        model.setModelType(Integer.parseInt((String)tokens.get(tokenIndex++)));
        model.setPrimaryMetamodelUri(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        char[] supportFlags = ((String)tokens.get(tokenIndex++)).toCharArray();
        model.setVisible(RuntimeAdapter.getBooleanValue(supportFlags[0]));
        model.setSupportsDistinct(RuntimeAdapter.getBooleanValue(supportFlags[1]));
        model.setSupportsJoin(RuntimeAdapter.getBooleanValue(supportFlags[2]));
        model.setSupportsOrderBy(RuntimeAdapter.getBooleanValue(supportFlags[3]));
        model.setSupportsOuterJoin(RuntimeAdapter.getBooleanValue(supportFlags[4]));
        model.setSupportsWhereAll(RuntimeAdapter.getBooleanValue(supportFlags[5]));
        RuntimeAdapter.setRecordFooterValues((AbstractMetadataRecord)model, tokens, tokenIndex);
        return model;
    }

    protected static VdbRecord createVdbRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        VdbRecordImpl vdb = new VdbRecordImpl();
        int indexVersion = RuntimeAdapter.getIndexVersion(record);
        vdb.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RuntimeAdapter.setRecordHeaderValues((AbstractMetadataRecord)vdb, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        vdb.setVersion(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        vdb.setIdentifier(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        vdb.setProducerName(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        vdb.setProducerVersion(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        vdb.setProvider(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        vdb.setTimeLastChanged(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        vdb.setTimeLastProduced(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        List uuids = RuntimeAdapter.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        vdb.setModelIDs(uuids);
        vdb.setDescription(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        RuntimeAdapter.setRecordFooterValues((AbstractMetadataRecord)vdb, tokens, tokenIndex);
        return vdb;
    }

    protected static TransformationRecord createTransformationRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        TransformationRecordImpl transform = new TransformationRecordImpl();
        int indexVersion = RuntimeAdapter.getIndexVersion(record);
        transform.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        char recordType = ((String)tokens.get(tokenIndex++)).charAt(0);
        transform.setTransformationType(RuntimeAdapter.getObjectValue(transform.getTransformTypeForRecordType(recordType)));
        transform.setFullName(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        transform.setTransformedObjectID((Object)RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        if (RuntimeAdapter.includeTransformationUUID(indexVersion)) {
            transform.setUUID(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        }
        transform.setTransformation(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        List bindings = RuntimeAdapter.getStrings((String)tokens.get(tokenIndex++), indexVersion);
        transform.setBindings(bindings);
        List schemaPaths = RuntimeAdapter.getStrings((String)tokens.get(tokenIndex++), indexVersion);
        transform.setSchemaPaths(schemaPaths);
        RuntimeAdapter.setRecordFooterValues((AbstractMetadataRecord)transform, tokens, tokenIndex);
        return transform;
    }

    protected static TableRecord createTableRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        TableRecordImpl table = new TableRecordImpl();
        int indexVersion = RuntimeAdapter.getIndexVersion(record);
        table.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RuntimeAdapter.setRecordHeaderValues((AbstractMetadataRecord)table, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        table.setCardinality(Integer.parseInt((String)tokens.get(tokenIndex++)));
        table.setTableType(Integer.parseInt((String)tokens.get(tokenIndex++)));
        char[] supportFlags = ((String)tokens.get(tokenIndex++)).toCharArray();
        table.setVirtual(RuntimeAdapter.getBooleanValue(supportFlags[0]));
        table.setSystem(RuntimeAdapter.getBooleanValue(supportFlags[1]));
        table.setSupportsUpdate(RuntimeAdapter.getBooleanValue(supportFlags[2]));
        if (RuntimeAdapter.includeMaterializationFlag(indexVersion)) {
            table.setMaterialized(RuntimeAdapter.getBooleanValue(supportFlags[3]));
        }
        List uuids = RuntimeAdapter.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        table.setColumnIDs(uuids);
        table.setPrimaryKeyID(tokens.get(tokenIndex++));
        uuids = RuntimeAdapter.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        table.setForeignKeyIDs((Collection)uuids);
        uuids = RuntimeAdapter.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        table.setIndexIDs((Collection)uuids);
        uuids = RuntimeAdapter.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        table.setUniqueKeyIDs((Collection)uuids);
        uuids = RuntimeAdapter.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        table.setAccessPatternIDs((Collection)uuids);
        if (RuntimeAdapter.includeMaterializationFlag(indexVersion)) {
            table.setMaterializedTableID(tokens.get(tokenIndex++));
            table.setMaterializedStageTableID(tokens.get(tokenIndex++));
        }
        RuntimeAdapter.setRecordFooterValues((AbstractMetadataRecord)table, tokens, tokenIndex);
        return table;
    }

    protected static ColumnRecord createColumnRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        ColumnRecordImpl column = new ColumnRecordImpl();
        int indexVersion = RuntimeAdapter.getIndexVersion(record);
        column.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RuntimeAdapter.setRecordHeaderValues((AbstractMetadataRecord)column, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        char[] supportFlags = ((String)tokens.get(tokenIndex++)).toCharArray();
        column.setSelectable(RuntimeAdapter.getBooleanValue(supportFlags[0]));
        column.setUpdatable(RuntimeAdapter.getBooleanValue(supportFlags[1]));
        column.setAutoIncrementable(RuntimeAdapter.getBooleanValue(supportFlags[2]));
        column.setCaseSensitive(RuntimeAdapter.getBooleanValue(supportFlags[3]));
        column.setSigned(RuntimeAdapter.getBooleanValue(supportFlags[4]));
        column.setCurrency(RuntimeAdapter.getBooleanValue(supportFlags[5]));
        column.setFixedLength(RuntimeAdapter.getBooleanValue(supportFlags[6]));
        if (RuntimeAdapter.includeInputParameterFlag(indexVersion)) {
            column.setTransformationInputParameter(RuntimeAdapter.getBooleanValue(supportFlags[7]));
        }
        column.setNullType(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setSearchType(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setLength(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setScale(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setPrecision(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setPosition(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setCharOctetLength(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setRadix(Integer.parseInt((String)tokens.get(tokenIndex++)));
        if (RuntimeAdapter.includeColumnNullDistinctValues(indexVersion)) {
            column.setDistinctValues(Integer.parseInt((String)tokens.get(tokenIndex++)));
            column.setNullValues(Integer.parseInt((String)tokens.get(tokenIndex++)));
        }
        column.setMinValue((Object)RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        column.setMaxValue((Object)RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        column.setFormat(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        column.setRuntimeType(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        if (RuntimeAdapter.includeColumnNativeType(indexVersion)) {
            column.setNativeType(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        }
        column.setDatatypeUUID(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        column.setDefaultValue((Object)RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        RuntimeAdapter.setRecordFooterValues((AbstractMetadataRecord)column, tokens, tokenIndex);
        return column;
    }

    protected static ColumnSetRecord createColumnSetRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        ColumnSetRecordImpl columnSet = new ColumnSetRecordImpl();
        int indexVersion = RuntimeAdapter.getIndexVersion(record);
        columnSet.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RuntimeAdapter.setRecordHeaderValues((AbstractMetadataRecord)columnSet, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        List uuids = RuntimeAdapter.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        columnSet.setColumnIDs(uuids);
        RuntimeAdapter.setRecordFooterValues((AbstractMetadataRecord)columnSet, tokens, tokenIndex);
        return columnSet;
    }

    protected static ForeignKeyRecord createForeignKeyRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        ForeignKeyRecordImpl fkRecord = new ForeignKeyRecordImpl();
        int indexVersion = RuntimeAdapter.getIndexVersion(record);
        fkRecord.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RuntimeAdapter.setRecordHeaderValues((AbstractMetadataRecord)fkRecord, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        List uuids = RuntimeAdapter.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        fkRecord.setColumnIDs(uuids);
        fkRecord.setUniqueKeyID((Object)RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        RuntimeAdapter.setRecordFooterValues((AbstractMetadataRecord)fkRecord, tokens, tokenIndex);
        return fkRecord;
    }

    protected static UniqueKeyRecord createUniqueKeyRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        UniqueKeyRecordImpl ukRecord = new UniqueKeyRecordImpl();
        int indexVersion = RuntimeAdapter.getIndexVersion(record);
        ukRecord.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RuntimeAdapter.setRecordHeaderValues((AbstractMetadataRecord)ukRecord, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        List columnUUIDs = RuntimeAdapter.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        ukRecord.setColumnIDs(columnUUIDs);
        List fkUUIDs = RuntimeAdapter.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        ukRecord.setForeignKeyIDs(fkUUIDs);
        RuntimeAdapter.setRecordFooterValues((AbstractMetadataRecord)ukRecord, tokens, tokenIndex);
        return ukRecord;
    }

    protected static DatatypeRecord createDatatypeRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        DatatypeRecordImpl dt = new DatatypeRecordImpl();
        int indexVersion = RuntimeAdapter.getIndexVersion(record);
        dt.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        dt.setRecordType(((String)tokens.get(tokenIndex++)).toCharArray()[0]);
        dt.setDatatypeID(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        dt.setBasetypeID(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        dt.setFullName((String)tokens.get(tokenIndex++));
        dt.setUUID(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        dt.setNameInSource(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        dt.setVarietyType(Short.parseShort((String)tokens.get(tokenIndex++)));
        List props = RuntimeAdapter.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        dt.setVarietyProps(props);
        dt.setRuntimeTypeName(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        dt.setJavaClassName(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        dt.setType(Short.parseShort((String)tokens.get(tokenIndex++)));
        dt.setSearchType(Short.parseShort((String)tokens.get(tokenIndex++)));
        dt.setNullType(Short.parseShort((String)tokens.get(tokenIndex++)));
        char[] booleanValues = ((String)tokens.get(tokenIndex++)).toCharArray();
        dt.setSigned(RuntimeAdapter.getBooleanValue(booleanValues[0]));
        dt.setAutoIncrement(RuntimeAdapter.getBooleanValue(booleanValues[1]));
        dt.setCaseSensitive(RuntimeAdapter.getBooleanValue(booleanValues[2]));
        dt.setLength(Integer.parseInt((String)tokens.get(tokenIndex++)));
        dt.setPrecisionLength(Integer.parseInt((String)tokens.get(tokenIndex++)));
        dt.setScale(Integer.parseInt((String)tokens.get(tokenIndex++)));
        dt.setRadix(Integer.parseInt((String)tokens.get(tokenIndex++)));
        if (RuntimeAdapter.includePrimitiveTypeIdValue(indexVersion)) {
            dt.setPrimitiveTypeID(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        }
        RuntimeAdapter.setRecordFooterValues((AbstractMetadataRecord)dt, tokens, tokenIndex);
        return dt;
    }

    protected static ProcedureRecord createProcedureRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        ProcedureRecordImpl procRd = new ProcedureRecordImpl();
        int indexVersion = RuntimeAdapter.getIndexVersion(record);
        procRd.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RuntimeAdapter.setRecordHeaderValues((AbstractMetadataRecord)procRd, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        char[] booleanValues = ((String)tokens.get(tokenIndex++)).toCharArray();
        procRd.setFunction(RuntimeAdapter.getBooleanValue(booleanValues[0]));
        procRd.setVirtual(RuntimeAdapter.getBooleanValue(booleanValues[1]));
        List uuids = RuntimeAdapter.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        procRd.setParameterIDs(uuids);
        procRd.setResultSetID((Object)RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        if (RuntimeAdapter.includeProcedureUpdateCount(indexVersion)) {
            procRd.setUpdateCount(Integer.parseInt((String)tokens.get(tokenIndex++)));
        }
        RuntimeAdapter.setRecordFooterValues((AbstractMetadataRecord)procRd, tokens, tokenIndex);
        return procRd;
    }

    protected static ProcedureParameterRecord createProcedureParameterRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        ProcedureParameterRecordImpl paramRd = new ProcedureParameterRecordImpl();
        int indexVersion = RuntimeAdapter.getIndexVersion(record);
        paramRd.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RuntimeAdapter.setRecordHeaderValues((AbstractMetadataRecord)paramRd, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        paramRd.setDefaultValue((Object)RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        paramRd.setRuntimeType(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        paramRd.setDatatypeUUID(RuntimeAdapter.getObjectValue((String)tokens.get(tokenIndex++)));
        paramRd.setLength(Integer.parseInt((String)tokens.get(tokenIndex++)));
        paramRd.setRadix(Integer.parseInt((String)tokens.get(tokenIndex++)));
        paramRd.setScale(Integer.parseInt((String)tokens.get(tokenIndex++)));
        paramRd.setNullType(Integer.parseInt((String)tokens.get(tokenIndex++)));
        paramRd.setPrecision(Integer.parseInt((String)tokens.get(tokenIndex++)));
        paramRd.setPosition(Integer.parseInt((String)tokens.get(tokenIndex++)));
        paramRd.setType(Integer.parseInt((String)tokens.get(tokenIndex++)));
        char[] flags = ((String)tokens.get(tokenIndex++)).toCharArray();
        paramRd.setOptional(RuntimeAdapter.getBooleanValue(flags[0]));
        RuntimeAdapter.setRecordFooterValues((AbstractMetadataRecord)paramRd, tokens, tokenIndex);
        return paramRd;
    }

    protected static AnnotationRecord createAnnotationRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        AnnotationRecordImpl annotation = new AnnotationRecordImpl();
        int indexVersion = RuntimeAdapter.getIndexVersion(record);
        annotation.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RuntimeAdapter.setRecordHeaderValues((AbstractMetadataRecord)annotation, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        if (RuntimeAdapter.includeAnnotationProperties(indexVersion)) {
            // empty if block
        }
        int n = ++tokenIndex;
        annotation.setDescription((String)tokens.get(n));
        RuntimeAdapter.setRecordFooterValues((AbstractMetadataRecord)annotation, tokens, ++tokenIndex);
        return annotation;
    }

    protected static PropertyRecord createPropertyRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        PropertyRecordImpl property = new PropertyRecordImpl();
        int indexVersion = RuntimeAdapter.getIndexVersion(record);
        property.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        String recordType = (String)tokens.get(tokenIndex++);
        property.setRecordType(recordType.toCharArray()[0]);
        String objectID = (String)tokens.get(tokenIndex++);
        property.setUUID(RuntimeAdapter.getObjectValue(objectID));
        property.setPropertyName((String)tokens.get(tokenIndex++));
        property.setPropertyValue((String)tokens.get(tokenIndex++));
        if (!RuntimeAdapter.includeAnnotationProperties(indexVersion)) {
            char isExtension = ((String)tokens.get(tokenIndex++)).charAt(0);
            property.setExtension(RuntimeAdapter.getBooleanValue(isExtension));
        }
        RuntimeAdapter.setRecordFooterValues((AbstractMetadataRecord)property, tokens, tokenIndex);
        return property;
    }

    protected static FileRecord createFileRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        FileRecordImpl file = new FileRecordImpl();
        int indexVersion = RuntimeAdapter.getIndexVersion(record);
        file.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        String recordType = (String)tokens.get(tokenIndex++);
        file.setRecordType(recordType.toCharArray()[0]);
        file.setPathInVdb((String)tokens.get(tokenIndex++));
        return file;
    }

    protected static void appendIndexVersion(int indexVersion, StringBuffer sb) {
        Assertion.assertTrue((indexVersion > -1 && indexVersion < 100 ? 1 : 0) != 0);
        sb.append('\u00a1');
        if (indexVersion < 10) {
            sb.append(Integer.toString(0));
            sb.append(Integer.toString(indexVersion));
        } else {
            sb.append(Integer.toString(indexVersion));
        }
    }

    protected static int getIndexVersion(char[] record) {
        Assertion.isNotNull((Object)record);
        int endIndex = record.length;
        int beginIndex = endIndex - 6 > 0 ? endIndex - 6 : 1;
        int version = NONVERSIONED_RECORD_INDEX_VERSION;
        for (int i = beginIndex; i < endIndex; ++i) {
            if (record[i] != '\u00a1') continue;
            char versionPart1 = record[i + 1];
            char versionPart2 = record[i + 2];
            if (!Character.isDigit(versionPart1) || !Character.isDigit(versionPart2)) continue;
            version = Character.digit(versionPart1, 10) * 10 + Character.digit(versionPart2, 10);
        }
        return version;
    }

    protected static void appendObject(Object obj, StringBuffer sb) {
        if (obj != null) {
            String objectString = obj.toString();
            if (obj instanceof URI) {
                objectString = URI.decode((String)objectString);
            }
            if (objectString.length() == 0) {
                sb.append(' ');
            }
            sb.append(objectString);
        } else {
            sb.append(' ');
        }
    }

    protected static void appendBoolean(boolean b, StringBuffer sb) {
        if (b) {
            sb.append('1');
        } else {
            sb.append('0');
        }
    }

    protected static void appendStrings(Collection objs, StringBuffer sb) {
        String obj;
        if (objs == null || objs.isEmpty()) {
            sb.append(' ');
            return;
        }
        ArrayList tmp = new ArrayList(objs);
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            obj = (String)iter.next();
            if (obj != null && obj.trim().length() != 0) continue;
            iter.remove();
        }
        if (tmp.isEmpty()) {
            sb.append(' ');
            return;
        }
        iter = tmp.iterator();
        while (iter.hasNext()) {
            obj = (String)iter.next();
            sb.append(obj);
            if (!iter.hasNext()) continue;
            sb.append('\u001f');
        }
    }

    protected static void appendStrings(Map objs, int indexVersionNumber, StringBuffer sb) {
        if (objs == null || objs.isEmpty()) {
            sb.append(' ');
            return;
        }
        Iterator entryIter = objs.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry mapEntry = entryIter.next();
            if (mapEntry == null) continue;
            Object key = mapEntry.getKey();
            Object value = mapEntry.getValue();
            if (key == null || value == null) {
                sb.append(' ');
                if (!entryIter.hasNext()) continue;
                sb.append('\u001f');
                continue;
            }
            sb.append(key.toString());
            sb.append('\u2060');
            sb.append(value.toString());
            if (!entryIter.hasNext()) continue;
            sb.append('\u001f');
        }
    }

    protected static void appendIDs(Collection objs, StringBuffer sb) {
        String obj;
        if (objs == null || objs.isEmpty()) {
            sb.append(' ');
            return;
        }
        ArrayList tmp = new ArrayList(objs);
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            obj = RuntimeAdapter.getObjectIdString(iter.next());
            if (obj != null && obj.trim().length() != 0) continue;
            iter.remove();
        }
        if (tmp.isEmpty()) {
            sb.append(' ');
            return;
        }
        iter = tmp.iterator();
        while (iter.hasNext()) {
            obj = iter.next();
            RuntimeAdapter.appendID(obj, sb);
            if (!iter.hasNext()) continue;
            sb.append('\u001f');
        }
    }

    protected static void appendID(Object obj, StringBuffer sb) {
        String id = RuntimeAdapter.getObjectIdString(obj);
        if (id == null || id.length() == 0) {
            sb.append(' ');
        } else {
            sb.append(id);
        }
    }

    protected static String getObjectIdString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof EClass) {
            return null;
        }
        if (obj instanceof EObject) {
            ModelEditorImpl modelEditor = (ModelEditorImpl)ModelerCore.getModelEditor();
            return modelEditor.getSearchIndexObjectID((EObject)obj);
        }
        if (obj instanceof ObjectID) {
            return obj.toString();
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    protected static void appendURIs(Collection objs, int indexVersionNumber, StringBuffer sb) {
        String obj;
        if (objs == null || objs.isEmpty()) {
            sb.append(' ');
            return;
        }
        ArrayList tmp = new ArrayList(objs);
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            obj = RuntimeAdapter.getObjectIdString(iter.next());
            if (obj != null && obj.trim().length() != 0) continue;
            iter.remove();
        }
        if (tmp.isEmpty()) {
            sb.append(' ');
            return;
        }
        iter = tmp.iterator();
        while (iter.hasNext()) {
            obj = iter.next();
            RuntimeAdapter.appendURI(obj, sb, false);
            if (!iter.hasNext()) continue;
            sb.append('\u001f');
        }
    }

    protected static void appendURI(Object obj, StringBuffer sb, boolean isMetaClass) {
        String id = RuntimeAdapter.getObjectURIString(obj, isMetaClass);
        if (id == null || id.length() == 0) {
            sb.append(' ');
        } else {
            sb.append(id);
        }
    }

    protected static String getObjectURIString(Object obj, boolean isMetaClass) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof EObject) {
            String cachedUri;
            if (isMetaClass && (cachedUri = (String)metaClassUriMap.get(((EClass)obj).getName())) != null) {
                return cachedUri;
            }
            EObject eObj = (EObject)obj;
            String theUri = ModelerCore.getModelEditor().getUri(eObj).toString();
            if (isMetaClass) {
                metaClassUriMap.put(((EClass)obj).getName(), theUri);
            }
            return theUri;
        }
        if (obj instanceof URI) {
            return obj.toString();
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    protected static String getObjectValue(String str) {
        if (str != null && str.length() == 1 && str.charAt(0) == ' ') {
            return null;
        }
        return str;
    }

    protected static boolean getBooleanValue(char b) {
        return b == '1';
    }

    protected static List getIDs(String values, int indexVersionNumber) {
        if (StringUtil.isEmpty((String)values)) {
            return Collections.EMPTY_LIST;
        }
        if (values.length() == 1 && values.charAt(0) == ' ') {
            return Collections.EMPTY_LIST;
        }
        char listDelimiter = RuntimeAdapter.getListDelimiter(indexVersionNumber);
        List tokens = StringUtil.split((String)values, (String)String.valueOf(listDelimiter));
        ArrayList<String> result = new ArrayList<String>(tokens.size());
        Iterator iter = tokens.iterator();
        while (iter.hasNext()) {
            String token = RuntimeAdapter.getObjectValue((String)iter.next());
            if (token == null) continue;
            result.add(token);
        }
        return result;
    }

    protected static List getStrings(String values, int indexVersionNumber) {
        if (StringUtil.isEmpty((String)values)) {
            return Collections.EMPTY_LIST;
        }
        if (values.length() == 1 && values.charAt(0) == ' ') {
            return Collections.EMPTY_LIST;
        }
        char listDelimiter = RuntimeAdapter.getListDelimiter(indexVersionNumber);
        List tokens = StringUtil.split((String)values, (String)String.valueOf(listDelimiter));
        ArrayList<String> result = new ArrayList<String>(tokens.size());
        for (String token : tokens) {
            if (token == null) continue;
            result.add(token);
        }
        return result;
    }

    protected static Properties getProperties(String values, int indexVersionNumber) {
        char listDelimiter = RuntimeAdapter.getListDelimiter(indexVersionNumber);
        char propDelimiter = RuntimeAdapter.getPropDelimiter(indexVersionNumber);
        return RuntimeAdapter.getProperties(values, listDelimiter, propDelimiter);
    }

    protected static Properties getProperties(String values, char listDelimiter, char propDelimiter) {
        Properties props = new Properties();
        if (StringUtil.isEmpty((String)values)) {
            return props;
        }
        if (values.length() == 1 && values.charAt(0) == ' ') {
            return props;
        }
        List tokens = StringUtil.split((String)values, (String)String.valueOf(listDelimiter));
        for (String token : tokens) {
            List propTokens;
            if (token == null || (propTokens = StringUtil.split((String)token, (String)String.valueOf(propDelimiter))).size() != 2) continue;
            props.put(propTokens.get(0), propTokens.get(1));
        }
        return props;
    }

    protected static char getListDelimiter(int indexVersionNumber) {
        if (indexVersionNumber < DELIMITER_INDEX_VERSION) {
            return ',';
        }
        return '\u001f';
    }

    protected static boolean includeMaterializationFlag(int indexVersionNumber) {
        return indexVersionNumber >= TABLE_MATERIALIZATION_INDEX_VERSION;
    }

    protected static boolean includeMaterializedTables(int indexVersionNumber) {
        return indexVersionNumber >= TABLE_MATERIALIZATION_INDEX_VERSION;
    }

    protected static boolean includeColumnNativeType(int indexVersionNumber) {
        return indexVersionNumber >= COLUMN_NATIVE_TYPE_INDEX_VERSION;
    }

    protected static boolean includeColumnNullDistinctValues(int indexVersionNumber) {
        return indexVersionNumber >= COLUMN_NULL_DISTINCT_INDEX_VERSION;
    }

    protected static boolean includePrimitiveTypeIdValue(int indexVersionNumber) {
        return indexVersionNumber >= PRIMITIVE_TYPE_ID_INDEX_VERSION;
    }

    protected static boolean includeInputParameterFlag(int indexVersionNumber) {
        return indexVersionNumber >= COLUMN_INPUT_PARAMETER_FLAG_INDEX_VERSION;
    }

    protected static boolean includeAnnotationProperties(int indexVersionNumber) {
        return indexVersionNumber < ANNOTATION_TAGS_INDEX_VERSION;
    }

    protected static boolean includeTransformationUUID(int indexVersionNumber) {
        return indexVersionNumber >= TRANSFORMATION_UUID_INDEX_VERSION;
    }

    private static boolean includeProcedureUpdateCount(int indexVersionNumber) {
        return indexVersionNumber >= PROCEDURE_UPDATE_COUNT_VERSION;
    }

    protected static char getPropDelimiter(int indexVersionNumber) {
        if (indexVersionNumber < DELIMITER_INDEX_VERSION) {
            return '=';
        }
        return '\u2060';
    }

    protected static int getCurrentIndexVersionNumber() {
        return CURRENT_INDEX_VERSION;
    }

    protected static void addNewWordEntryToList(String objectID, StringBuffer sb, Collection wordEntries) {
        String word = sb.toString().trim();
        if (!StringUtil.isEmpty((String)word)) {
            WordEntry wordEntry = new WordEntry(word.toCharArray());
            if (word.length() < 8160) {
                wordEntries.add(wordEntry);
                return;
            }
            List splitEntries = RuntimeAdapter.splitWordEntry(objectID, wordEntry, 8160);
            for (WordEntry entry : splitEntries) {
                wordEntries.add(entry);
            }
        }
    }

    private static void appendWordHeader(char recordType, String objectID, String fullName, String nameInSource, String parentObjectID, StringBuffer sb) {
        sb.append(recordType);
        sb.append('\u00a0');
        String upperName = fullName != null ? fullName.toUpperCase() : null;
        RuntimeAdapter.appendObject(upperName, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(objectID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(fullName, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(nameInSource, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(parentObjectID, sb);
        sb.append('\u00a0');
    }

    private static void setRecordHeaderValues(AbstractMetadataRecord record, String recordType, String upperName, String objectID, String fullName, String nameInSource, String parentObjectID) {
        record.setRecordType(recordType.toCharArray()[0]);
        record.setUUID(RuntimeAdapter.getObjectValue(objectID));
        record.setFullName(fullName);
        record.setNameInSource(RuntimeAdapter.getObjectValue(nameInSource));
        record.setParentUUID(RuntimeAdapter.getObjectValue(parentObjectID));
    }

    private static void appendWordFooter(String modelPath, String name, StringBuffer sb) {
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(modelPath, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(name, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendIndexVersion(RuntimeAdapter.getCurrentIndexVersionNumber(), sb);
        sb.append('\u00a0');
    }

    private static void setRecordFooterValues(AbstractMetadataRecord record, List tokens, int tokenIndex) {
        record.setResourcePath(RuntimeAdapter.getOptionalToken(tokens, tokenIndex++));
        record.setName(RuntimeAdapter.getOptionalToken(tokens, tokenIndex++));
        String version = RuntimeAdapter.getOptionalToken(tokens, tokenIndex++);
        if (version != null && version.length() > 0) {
            if (version.charAt(0) == '\u00a1') {
                version = version.substring(1);
            }
            try {
                record.setIndexVersion(Integer.parseInt(version));
            }
            catch (NumberFormatException err) {
                // empty catch block
            }
        }
    }

    private static String getOptionalToken(List tokens, int tokenIndex) {
        if (tokens.size() > tokenIndex) {
            return (String)tokens.get(tokenIndex);
        }
        return null;
    }

    private static void appendContinuationHeader(char recordType, String objectID, int segCount, StringBuffer sb) {
        sb.append('&');
        sb.append(recordType);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(objectID, sb);
        sb.append('\u00a0');
        sb.append(segCount);
        sb.append('\u00a0');
    }

    private static void appendContinuationTrailer(int blockSize, StringBuffer sb) {
        int blanksToAdd = blockSize - sb.length() - 1;
        Assertion.assertTrue((blanksToAdd >= 0 ? 1 : 0) != 0);
        for (int i = 0; i < blanksToAdd; ++i) {
            sb.append(' ');
        }
        sb.append('&');
    }

    public static WordEntry createTestWordEntry(char recordType, int numFields, String fieldValue) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        sb.append(recordType);
        sb.append('\u00a0');
        for (int i = 0; i < numFields; ++i) {
            RuntimeAdapter.appendObject(fieldValue, sb);
            sb.append('\u00a0');
        }
        RuntimeAdapter.appendIndexVersion(RuntimeAdapter.getCurrentIndexVersionNumber(), sb);
        sb.append('\u00a0');
        return new WordEntry(sb.toString().toCharArray());
    }

    public static WordEntry createTestWordEntry(char recordType, int numFields, Collection fieldValue) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        sb.append(recordType);
        sb.append('\u00a0');
        int indexVersion = RuntimeAdapter.getCurrentIndexVersionNumber();
        for (int i = 0; i < numFields; ++i) {
            RuntimeAdapter.appendStrings(fieldValue, sb);
            sb.append('\u00a0');
        }
        RuntimeAdapter.appendIndexVersion(indexVersion, sb);
        sb.append('\u00a0');
        return new WordEntry(sb.toString().toCharArray());
    }

    public static WordEntry createTestWordEntry(char recordType, int numFields, Map fieldValue) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        sb.append(recordType);
        sb.append('\u00a0');
        int indexVersion = RuntimeAdapter.getCurrentIndexVersionNumber();
        for (int i = 0; i < numFields; ++i) {
            RuntimeAdapter.appendStrings(fieldValue, indexVersion, sb);
            sb.append('\u00a0');
        }
        RuntimeAdapter.appendIndexVersion(indexVersion, sb);
        sb.append('\u00a0');
        return new WordEntry(sb.toString().toCharArray());
    }

    protected static int getIniitalBufferSize() {
        return 500;
    }

    static {
        CURRENT_INDEX_VERSION = PROCEDURE_UPDATE_COUNT_VERSION = 9;
        metaClassUriMap = new HashMap();
    }
}

