/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relate.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.mapping.relational.QueryNode;
import com.metamatrix.query.mapping.xml.MappingNode;
import com.metamatrix.query.mapping.xml.MappingNodeConstants;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.metadata.TempMetadataStore;
import com.metamatrix.query.optimizer.relate.xml.AliasMappingVisitor;
import com.metamatrix.query.optimizer.relate.xml.CriteriaContextInfo;
import com.metamatrix.query.optimizer.relate.xml.QueryUtil;
import com.metamatrix.query.optimizer.relate.xml.RelateWrapperFunctionVisitor;
import com.metamatrix.query.optimizer.relate.xml.Relationship;
import com.metamatrix.query.optimizer.relate.xml.XMLPlanner;
import com.metamatrix.query.optimizer.relate.xml.XMLPlannerEnvironment;
import com.metamatrix.query.resolver.util.BindVariableVisitor;
import com.metamatrix.query.resolver.util.ResolveElementsVisitor;
import com.metamatrix.query.resolver.util.ResolveGroupsVisitor;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.AllInGroupSymbol;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.symbol.Symbol;
import com.metamatrix.query.sql.visitor.CommandCollectorVisitor;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.ExpressionMappingVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.sql.visitor.ReferenceCollectorVisitor;
import com.metamatrix.query.sql.visitor.SubqueryFromClauseCollectorVisitor;
import com.metamatrix.query.util.RelateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RelatePlanner {
    private static final String GENERATED_STAGING_TABLE_PREFIX = "STGEN_";
    private static final String ALIASING_SUFFIX = "_R";

    public static void modifyForRelate(Query query, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Select select = query.getSelect();
        Function relateFunction = RelateUtil.findRelateFunction((Select)select);
        if (relateFunction == null) {
            return;
        }
        String critString = (String)((Constant)relateFunction.getArg(3)).getValue();
        Criteria crit = QueryUtil.parseCriteria((String)critString, (XMLPlannerEnvironment)planEnv);
        QueryUtil.resolveCriteria((Criteria)crit, (Query)query, (QueryMetadataInterface)planEnv.getGlobalMetadata());
        crit = XMLPlanner.convertCriteria((Criteria)crit, (MappingNode)planEnv.rootNode, (QueryMetadataInterface)planEnv.metadata);
        Relationship rel = RelatePlanner.createRelationship(relateFunction, planEnv);
        planEnv.addRelationship(rel);
        RelatePlanner.initAlternateMappingClassQueries(rel, planEnv);
        if (rel.sourceState.resultSet.equals(rel.targetState.resultSet)) {
            RelatePlanner.setupSelfEntityRelationship(rel, (ElementSymbol)relateFunction.getArgs()[1], planEnv);
        }
        RelatePlanner.rewriteSelectForRelate(select, relateFunction);
        RelatePlanner.aliasMappingClasses(rel, planEnv);
        QueryMetadataInterface metadata = planEnv.getGlobalMetadata();
        rel.sourceState.originalSymbolMap = RelatePlanner.createResultSetSymbolMap(rel.sourceState.resultSet, metadata, planEnv);
        rel.targetState.originalSymbolMap = RelatePlanner.createResultSetSymbolMap(rel.targetState.resultSet, metadata, planEnv);
        rel.mappingState.originalSymbolMap = RelatePlanner.createResultSetSymbolMap(rel.mappingState.resultSet, metadata, planEnv);
        Query mappingQuery = (Query)planEnv.getAlternateMappingClassQuery(rel.mappingState.resultSet);
        rel.mappingState.selectedCols = RelatePlanner.extractLinkColumns(mappingQuery);
        RelatePlanner.applyRelateCriteria(mappingQuery, rel, planEnv, crit);
        rel.sourceState.stagingTableName = RelatePlanner.createStagingTable(rel.sourceState.resultSet, true, rel, planEnv);
        rel.targetState.stagingTableName = RelatePlanner.createStagingTable(rel.targetState.resultSet, false, rel, planEnv);
        RelatePlanner.createMappingClass(rel.sourceState.resultSet, rel.sourceState.stagingTableName, rel.sourceState.stagingTableColumns, rel, planEnv);
        RelatePlanner.createMappingClass(rel.targetState.resultSet, rel.targetState.stagingTableName, rel.targetState.stagingTableColumns, rel, planEnv);
        RelatePlanner.createMappingClass(rel.mappingState.resultSet, rel.targetState.stagingTableName, rel.targetState.selectedCols, rel, planEnv);
        if (select.isDistinct()) {
            RelatePlanner.addDupRemovalCriteria(rel, planEnv);
        }
    }

    private static Relationship createRelationship(Function relateFunction, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        ElementSymbol mappingSymbol = (ElementSymbol)relateFunction.getArg(0);
        ElementSymbol sourceSymbol = (ElementSymbol)relateFunction.getArg(1);
        ElementSymbol objectSymbol = (ElementSymbol)relateFunction.getArg(2);
        String mappingResultSet = RelatePlanner.getClosestResultSet(mappingSymbol, planEnv);
        String sourceResultSet = RelatePlanner.getClosestResultSet(sourceSymbol, planEnv);
        String objectResultSet = RelatePlanner.getClosestResultSet(objectSymbol, planEnv);
        Relationship rel = new Relationship(mappingResultSet, sourceResultSet, objectResultSet);
        rel.sourceFragmentPath = XMLPlanner.getFullyQualifiedName((ElementSymbol)sourceSymbol, (XMLPlannerEnvironment)planEnv) + ".";
        rel.targetFragmentPath = XMLPlanner.getFullyQualifiedName((ElementSymbol)objectSymbol, (XMLPlannerEnvironment)planEnv) + ".";
        return rel;
    }

    private static String getClosestResultSet(ElementSymbol symbol, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        String fullyQualifiedNodeName = XMLPlanner.getFullyQualifiedName((ElementSymbol)symbol, (XMLPlannerEnvironment)planEnv);
        MappingNode node = MappingNode.findNode((MappingNode)planEnv.rootNode, (String)fullyQualifiedNodeName, (boolean)false);
        String critResultSet = XMLPlanner.getClosestResultSet((MappingNode)node, (String)fullyQualifiedNodeName, (boolean)true);
        if (critResultSet == null) {
            critResultSet = XMLPlanner.getClosestResultSet((MappingNode)node, (String)fullyQualifiedNodeName, (boolean)false);
        }
        return critResultSet.toUpperCase();
    }

    private static void initAlternateMappingClassQueries(Relationship rel, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        RelatePlanner.initAlternateMappingClassQuery(rel.sourceState.resultSet, planEnv);
        if (!rel.sourceState.resultSet.equals(rel.targetState.resultSet)) {
            RelatePlanner.initAlternateMappingClassQuery(rel.targetState.resultSet, planEnv);
        }
        RelatePlanner.initAlternateMappingClassQuery(rel.mappingState.resultSet, planEnv);
    }

    private static void setupSelfEntityRelationship(Relationship rel, ElementSymbol symbol, XMLPlannerEnvironment planEnv) throws QueryMetadataException, MetaMatrixComponentException, QueryPlannerException {
        rel.isSelfRelationship = true;
        rel.sourceEntityKeyCols = new ArrayList();
        rel.targetEntityKeyCols = new ArrayList();
        rel.targetCloneSymbolMap = new HashMap();
        rel.clonedNestedMappingClasses = new HashSet();
        String sourceRS = rel.sourceState.resultSet;
        rel.targetState.resultSet = RelatePlanner.cloneMappingClass(sourceRS, rel, planEnv);
        String fullyQualifiedNodeName = XMLPlanner.getFullyQualifiedName((ElementSymbol)symbol, (XMLPlannerEnvironment)planEnv);
        MappingNode node = MappingNode.findNode((MappingNode)planEnv.rootNode, (String)fullyQualifiedNodeName, (boolean)false);
        MappingNode copy = RelatePlanner.copyAndSpliceNode(node);
        RelatePlanner.remapNode(copy, rel, planEnv);
    }

    private static String cloneMappingClass(String sourceRS, Relationship rel, XMLPlannerEnvironment planEnv) throws MetaMatrixComponentException, QueryMetadataException, QueryPlannerException {
        String targetRS = sourceRS + ALIASING_SUFFIX;
        Command sourceCommand = planEnv.getAlternateMappingClassQuery(sourceRS);
        if (sourceCommand == null) {
            QueryNode queryNode = XMLPlanner.getQueryNode((String)sourceRS, (QueryMetadataInterface)planEnv.metadata);
            sourceCommand = QueryUtil.parseQuery((QueryNode)queryNode, (XMLPlannerEnvironment)planEnv);
            QueryUtil.resolveQuery((Command)sourceCommand, (XMLPlannerEnvironment)planEnv);
            List bindings = queryNode.getBindings();
            if (bindings != null) {
                HashMap boundReferences = new HashMap();
                try {
                    BindVariableVisitor.bindReferences((LanguageObject)sourceCommand, (List)bindings, (QueryMetadataInterface)planEnv.metadata, boundReferences);
                }
                catch (QueryResolverException e) {
                    throw new QueryPlannerException((Throwable)e, e.getMessage());
                }
                for (Map.Entry entry : boundReferences.entrySet()) {
                    List refs = (List)entry.getValue();
                    for (Reference ref : refs) {
                        Expression mapped = (Expression)rel.targetCloneSymbolMap.get(ref.getExpression());
                        if (mapped == null) continue;
                        ref.setExpression(mapped);
                    }
                }
            }
        } else {
            sourceCommand = (Command)sourceCommand.clone();
        }
        TempMetadataStore store = new TempMetadataStore(planEnv.globalTempMetadata);
        store.addTempGroup(targetRS, sourceCommand.getProjectedSymbols());
        planEnv.setAlternateMappingClassQuery(targetRS, sourceCommand);
        RelatePlanner.aliasMappingClass(targetRS, new HashSet(((Query)sourceCommand).getFrom().getGroups()), planEnv);
        List oldSymbols = RelatePlanner.getMappingClassSymbols(sourceRS, planEnv.metadata);
        TempMetadataAdapter adapter = new TempMetadataAdapter(planEnv.metadata, store);
        List newSymbols = RelatePlanner.getMappingClassSymbols(targetRS, (QueryMetadataInterface)adapter);
        for (int i = 0; i < oldSymbols.size(); ++i) {
            rel.targetCloneSymbolMap.put(oldSymbols.get(i), newSymbols.get(i));
        }
        return targetRS;
    }

    static MappingNode copyAndSpliceNode(MappingNode node) {
        MappingNode copyNode = (MappingNode)node.clone();
        MappingNode parentNode = node.getParent();
        List children = parentNode.getChildren();
        ArrayList childrenCopy = new ArrayList(children);
        children.clear();
        for (MappingNode child : childrenCopy) {
            parentNode.addChild(child);
            if (child != node) continue;
            parentNode.addChild(copyNode);
        }
        return copyNode;
    }

    private static List getMappingClassSymbols(String rsName, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryMetadataException {
        GroupSymbol group = new GroupSymbol(rsName);
        try {
            ResolveGroupsVisitor.resolveGroups((LanguageObject)group, (QueryMetadataInterface)metadata);
            List elems = ResolverUtil.resolveElementsInGroup(group, metadata);
            elems.add(group);
            return elems;
        }
        catch (QueryResolverException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    private static void remapNode(MappingNode node, Relationship rel, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Map symbolMap = rel.targetCloneSymbolMap;
        RelatePlanner.remapCriteriaProperty(node, MappingNodeConstants.Properties.CRITERIA, symbolMap, planEnv);
        RelatePlanner.remapCriteriaProperty(node, MappingNodeConstants.Properties.RECURSION_CRITERIA, symbolMap, planEnv);
        String oldRS = RelatePlanner.remapMappingClassProperty(node, MappingNodeConstants.Properties.RESULT_SET_NAME, symbolMap, rel, planEnv);
        if (oldRS != null) {
            rel.clonedNestedMappingClasses.add(oldRS);
        }
        RelatePlanner.remapMappingClassProperty(node, MappingNodeConstants.Properties.RECURSION_ROOT_MAPPING_CLASS, symbolMap, rel, planEnv);
        RelatePlanner.remapElementProperty(node, MappingNodeConstants.Properties.ELEMENT_NAME, symbolMap);
        Iterator childIter = node.getChildren().iterator();
        while (childIter.hasNext()) {
            RelatePlanner.remapNode((MappingNode)childIter.next(), rel, planEnv);
        }
    }

    private static void remapCriteriaProperty(MappingNode node, Integer property, Map symbolMap, XMLPlannerEnvironment planEnv) throws QueryPlannerException {
        String value = (String)node.getProperty(property);
        if (value == null || value.length() == 0) {
            return;
        }
        Criteria crit = QueryUtil.parseCriteria((String)value, (XMLPlannerEnvironment)planEnv);
        ExpressionMappingVisitor.mapExpressions(crit, symbolMap);
        node.setProperty(property, (Object)crit.toString());
    }

    private static String remapMappingClassProperty(MappingNode node, Integer property, Map symbolMap, Relationship rel, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        String value = (String)node.getProperty(property);
        if (value == null || value.length() == 0) {
            return null;
        }
        GroupSymbol group = new GroupSymbol(value);
        GroupSymbol mappedGroup = (GroupSymbol)symbolMap.get(group);
        String oldRS = null;
        if (mappedGroup != null) {
            node.setProperty(property, (Object)mappedGroup.getCanonicalName());
        } else {
            String oldValue = value.toUpperCase();
            String newValue = RelatePlanner.cloneMappingClass(oldValue, rel, planEnv);
            node.setProperty(property, (Object)newValue);
            oldRS = oldValue;
        }
        return oldRS;
    }

    private static void remapElementProperty(MappingNode node, Integer property, Map symbolMap) {
        String value = (String)node.getProperty(property);
        if (value == null || value.length() == 0) {
            return;
        }
        ElementSymbol element = new ElementSymbol(value);
        ElementSymbol mappedElement = (ElementSymbol)symbolMap.get(element);
        if (mappedElement != null) {
            node.setProperty(property, (Object)mappedElement.getCanonicalName());
        }
    }

    static void initAlternateMappingClassQuery(String resultSet, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        QueryNode queryNode = XMLPlanner.getQueryNode((String)resultSet, (QueryMetadataInterface)planEnv.metadata);
        Query mappingQuery = (Query)QueryUtil.parseQuery((QueryNode)queryNode, (XMLPlannerEnvironment)planEnv);
        QueryUtil.resolveQuery((Command)mappingQuery, (XMLPlannerEnvironment)planEnv);
        List bindings = queryNode.getBindings();
        if (bindings != null) {
            try {
                BindVariableVisitor.bindReferences((LanguageObject)mappingQuery, (List)bindings, (QueryMetadataInterface)planEnv.metadata);
            }
            catch (QueryResolverException e) {
                throw new QueryPlannerException((Throwable)e, e.getMessage());
            }
        }
        planEnv.setAlternateMappingClassQuery(resultSet, (Command)mappingQuery);
    }

    private static void rewriteSelectForRelate(Select select, Function relateFunction) {
        boolean onlyRelateFunctions = true;
        for (SelectSymbol symbol : select.getSymbols()) {
            if (symbol instanceof ElementSymbol || symbol instanceof AllInGroupSymbol) {
                onlyRelateFunctions = false;
                break;
            }
            if (RelatePlanner.getRelateSourceOrRelateTargetFunction(symbol) == null) continue;
            onlyRelateFunctions = false;
            break;
        }
        if (onlyRelateFunctions) {
            select.clearSymbols();
            ElementSymbol mappingSymbol = (ElementSymbol)relateFunction.getArg(0);
            select.addSymbol((SelectSymbol)RelatePlanner.createAllInFragmentSymbol(mappingSymbol));
            ElementSymbol sourceSymbol = (ElementSymbol)relateFunction.getArg(1);
            select.addSymbol((SelectSymbol)RelatePlanner.createAllInFragmentSymbol(sourceSymbol));
            ElementSymbol targetSymbol = (ElementSymbol)relateFunction.getArg(2);
            if (!targetSymbol.equals((Object)sourceSymbol)) {
                select.addSymbol((SelectSymbol)RelatePlanner.createAllInFragmentSymbol(targetSymbol));
            }
        }
    }

    static Function getRelateSourceOrRelateTargetFunction(SelectSymbol symbol) {
        ExpressionSymbol expressionSymbol;
        Function result = null;
        if (symbol instanceof ExpressionSymbol && (expressionSymbol = (ExpressionSymbol)symbol).getExpression() instanceof Function) {
            Function function = (Function)expressionSymbol.getExpression();
            if (function.getName().equalsIgnoreCase("relatesource")) {
                result = function;
            } else if (function.getName().equalsIgnoreCase("relatetarget")) {
                result = function;
            }
        }
        return result;
    }

    private static AllInGroupSymbol createAllInFragmentSymbol(ElementSymbol elementSymbol) {
        return new AllInGroupSymbol(elementSymbol.getCanonicalName() + ".*");
    }

    private static void aliasMappingClasses(Relationship rel, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        HashSet tables = new HashSet();
        RelatePlanner.aliasMappingClass(rel.sourceState.resultSet, tables, planEnv);
        RelatePlanner.aliasMappingClass(rel.targetState.resultSet, tables, planEnv);
        RelatePlanner.aliasMappingClass(rel.mappingState.resultSet, tables, planEnv);
    }

    static void aliasMappingClass(String resultSet, Set tables, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        HashMap<GroupSymbol, GroupSymbol> symbolMap = null;
        Query mappingQuery = (Query)planEnv.getAlternateMappingClassQuery(resultSet);
        List groups = mappingQuery.getFrom().getGroups();
        for (GroupSymbol group : groups) {
            if (tables.contains(group)) {
                GroupSymbol newGroup = null;
                newGroup = RelatePlanner.createAliasedGroup(group, tables);
                if (symbolMap == null) {
                    symbolMap = new HashMap<GroupSymbol, GroupSymbol>();
                }
                symbolMap.put(group, newGroup);
                List elements = null;
                List newElements = null;
                try {
                    TempMetadataAdapter adapter = new TempMetadataAdapter(planEnv.metadata, new TempMetadataStore(mappingQuery.getTemporaryMetadata()));
                    ResolveGroupsVisitor.resolveGroups((LanguageObject)newGroup, (QueryMetadataInterface)adapter);
                    elements = ResolverUtil.resolveElementsInGroup(group, (QueryMetadataInterface)adapter);
                    newElements = ResolverUtil.resolveElementsInGroup(newGroup, (QueryMetadataInterface)adapter);
                }
                catch (QueryResolverException e) {
                    throw new MetaMatrixComponentException((Throwable)e);
                }
                Iterator elemIter = elements.iterator();
                Iterator newElemIter = newElements.iterator();
                while (elemIter.hasNext()) {
                    ElementSymbol elem = (ElementSymbol)elemIter.next();
                    ElementSymbol newElem = (ElementSymbol)newElemIter.next();
                    symbolMap.put((GroupSymbol)elem, (GroupSymbol)newElem);
                }
                tables.add(newGroup);
                continue;
            }
            tables.add(group);
        }
        if (symbolMap != null) {
            AliasMappingVisitor visitor = new AliasMappingVisitor(symbolMap);
            PreOrderNavigator.doVisit((LanguageObject)mappingQuery, (LanguageVisitor)visitor);
            List oldRefs = ReferenceCollectorVisitor.getReferences((LanguageObject)mappingQuery);
            mappingQuery = (Query)QueryUtil.parseQuery((String)mappingQuery.toString(), (String)resultSet, (XMLPlannerEnvironment)planEnv);
            QueryUtil.resolveQuery((Command)mappingQuery, (XMLPlannerEnvironment)planEnv);
            if (oldRefs.size() > 0) {
                HashMap refMap = new HashMap();
                List newRefs = ReferenceCollectorVisitor.getReferences((LanguageObject)mappingQuery);
                Iterator oldRefIter = oldRefs.iterator();
                Iterator newRefIter = newRefs.iterator();
                while (oldRefIter.hasNext()) {
                    Object oldRef = oldRefIter.next();
                    Object newRef = newRefIter.next();
                    refMap.put(newRef, oldRef);
                }
                ExpressionMappingVisitor.mapExpressions((LanguageObject)mappingQuery, refMap);
            }
            planEnv.setAlternateMappingClassQuery(resultSet, (Command)mappingQuery);
        }
    }

    static String createAlias(GroupSymbol group, Set tables) {
        String rootName = group.getName();
        int dotIndex = rootName.lastIndexOf(".");
        if (dotIndex >= 0) {
            rootName = group.getName().substring(dotIndex + 1);
        }
        int count = 1;
        String alias;
        GroupSymbol testGroup;
        while (tables.contains(testGroup = new GroupSymbol(alias = rootName + ALIASING_SUFFIX + count))) {
            ++count;
        }
        return alias;
    }

    private static GroupSymbol createAliasedGroup(GroupSymbol group, Set tables) {
        GroupSymbol newGroup;
        String aliasedName = RelatePlanner.createAlias(group, tables);
        if (group.getDefinition() == null) {
            newGroup = new GroupSymbol(aliasedName, group.getName());
        } else {
            newGroup = (GroupSymbol)group.clone();
            newGroup.setName(aliasedName);
        }
        return newGroup;
    }

    private static List extractLinkColumns(Query query) {
        ArrayList<Symbol> linkElements = new ArrayList<Symbol>();
        Iterator selectSymbols = query.getSelect().getSymbols().iterator();
        int lastSize = 0;
        while (selectSymbols.hasNext()) {
            Symbol selectSymbol = (Symbol)selectSymbols.next();
            ElementCollectorVisitor.getElements((LanguageObject)selectSymbol, linkElements);
            int currentSize = linkElements.size();
            if (currentSize == lastSize) {
                linkElements.add(selectSymbol);
                ++lastSize;
                continue;
            }
            lastSize = currentSize;
        }
        return linkElements;
    }

    private static void applyRelateCriteria(Query query, Relationship rel, XMLPlannerEnvironment planEnv, Criteria relateCriteria) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        if (relateCriteria == null) {
            throw new QueryPlannerException(QueryExecPlugin.Util.getString("RelatePlanner.bad_mapping_rs_for_relate", (Object)rel.mappingState.resultSet, (Object)rel.sourceState.resultSet, (Object)rel.targetState.resultSet));
        }
        HashMap mappingClassProjections = new HashMap();
        mappingClassProjections.putAll(rel.sourceState.originalSymbolMap);
        mappingClassProjections.putAll(rel.targetState.originalSymbolMap);
        mappingClassProjections.putAll(rel.mappingState.originalSymbolMap);
        Iterator iter1 = mappingClassProjections.keySet().iterator();
        HashSet groupsUsedByCriteria = new HashSet();
        while (iter1.hasNext()) {
            ElementSymbol e = (ElementSymbol)iter1.next();
            GroupsUsedByElementsVisitor.getGroups((LanguageObject)e, groupsUsedByCriteria);
        }
        Criteria newCrit = null;
        List conjuncts = CompoundCriteria.separateCriteriaByAnd((Criteria)relateCriteria);
        block1: for (Criteria conjunct : conjuncts) {
            QueryUtil.resolveCriteria((Criteria)conjunct, groupsUsedByCriteria, (XMLPlannerEnvironment)planEnv);
            short wrapperCode = RelateWrapperFunctionVisitor.removeWrappers((Criteria)conjunct);
            Collection elements = ElementCollectorVisitor.getElements((LanguageObject)conjunct, true);
            if (elements.size() > 0) {
                HashMap replacementMap = new HashMap();
                HashSet groups = new HashSet();
                for (ElementSymbol element : elements) {
                    ElementSymbol newExpr;
                    if (rel.isSelfRelationship && wrapperCode == 1 && (newExpr = (ElementSymbol)rel.targetCloneSymbolMap.get(element)) != null && newExpr != element) {
                        rel.sourceEntityKeyCols.add(element);
                        rel.targetEntityKeyCols.add(newExpr);
                        HashMap<ElementSymbol, ElementSymbol> elementReplacementMap = new HashMap<ElementSymbol, ElementSymbol>();
                        elementReplacementMap.put(element, newExpr);
                        ExpressionMappingVisitor.mapExpressions(conjunct, elementReplacementMap);
                        element = newExpr;
                    }
                    GroupsUsedByElementsVisitor.getGroups((LanguageObject)element, groups);
                    replacementMap.put(element, mappingClassProjections.get(element));
                }
                ExpressionMappingVisitor.mapExpressions(conjunct, replacementMap);
                for (GroupSymbol group : groups) {
                    if (group.getCanonicalName().equalsIgnoreCase(rel.sourceState.resultSet)) {
                        if (wrapperCode == 1) {
                            throw new QueryPlannerException(QueryExecPlugin.Util.getString("RelatePlanner.misapplied_wrapper", (Object)"source", (Object)"target", (Object)conjunct));
                        }
                        rel.sourceState.joinCrits.add(conjunct);
                        continue block1;
                    }
                    if (!group.getCanonicalName().equalsIgnoreCase(rel.targetState.resultSet)) continue;
                    if (wrapperCode == 0) {
                        throw new QueryPlannerException(QueryExecPlugin.Util.getString("RelatePlanner.misapplied_wrapper", (Object)"target", (Object)"source", (Object)conjunct));
                    }
                    rel.targetState.joinCrits.add(conjunct);
                    continue block1;
                }
                continue;
            }
            if (conjunct == null) continue;
            rel.sourceState.joinCrits.add(conjunct);
            rel.targetState.joinCrits.add(conjunct);
            newCrit = CompoundCriteria.combineCriteria(newCrit, (Criteria)conjunct);
        }
        query.setCriteria(newCrit);
    }

    static String createStagingTable(String rsName, boolean isSrc, Relationship rel, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Query mappingQuery = (Query)planEnv.getAlternateMappingClassQuery(rsName);
        String stagingTableName = RelatePlanner.createStagingTableName(rsName, GENERATED_STAGING_TABLE_PREFIX);
        TempMetadataStore store = new TempMetadataStore(planEnv.globalTempMetadata);
        store.addTempGroup(stagingTableName, mappingQuery.getProjectedSymbols(), false);
        TempMetadataAdapter adapter = new TempMetadataAdapter(planEnv.metadata, store);
        GroupSymbol stGroup = new GroupSymbol(stagingTableName);
        try {
            ResolveGroupsVisitor.resolveGroups((LanguageObject)stGroup, (QueryMetadataInterface)adapter);
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((Throwable)e, e.getMessage());
        }
        Criteria mappingCrit = mappingQuery.getCriteria();
        if (isSrc) {
            mappingCrit = RelatePlanner.addJoinCrits(mappingCrit, rel.sourceState.joinCrits);
            mappingCrit = RelatePlanner.addJoinCrits(mappingCrit, rel.targetState.joinCrits);
        } else {
            mappingCrit = RelatePlanner.addJoinCrits(mappingCrit, rel.targetState.joinCrits);
            HashMap stagingMap = new HashMap();
            RelatePlanner.getSourceStagingTableReverseMap(rel, stagingMap, planEnv);
            Iterator critIter = rel.sourceState.joinCrits.iterator();
            while (critIter.hasNext()) {
                Criteria crit = (Criteria)((Criteria)critIter.next()).clone();
                ExpressionMappingVisitor.mapExpressions(crit, stagingMap);
                mappingCrit = CompoundCriteria.combineCriteria((Criteria)mappingCrit, (Criteria)crit);
            }
        }
        mappingQuery.setCriteria(mappingCrit);
        Collection critGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)mappingCrit);
        List existingGroups = mappingQuery.getFrom().getGroups();
        critGroups.removeAll(existingGroups);
        HashSet subqueryFromClauses = new HashSet(1);
        HashSet<GroupSymbol> subqueryFromClauseGroups = new HashSet<GroupSymbol>(1);
        Query otherMappingQuery = null;
        otherMappingQuery = isSrc ? (Query)planEnv.getAlternateMappingClassQuery(rel.targetState.resultSet) : (Query)planEnv.getAlternateMappingClassQuery(rel.sourceState.resultSet);
        for (Object fromClause : otherMappingQuery.getFrom().getClauses()) {
            if (!(fromClause instanceof SubqueryFromClause)) continue;
            subqueryFromClauses.add(fromClause);
            subqueryFromClauseGroups.add(((SubqueryFromClause)fromClause).getGroupSymbol());
        }
        if (!subqueryFromClauses.isEmpty() && critGroups.removeAll(subqueryFromClauseGroups)) {
            mappingQuery.getFrom().addGroups(critGroups);
            mappingQuery.getFrom().addClauses(subqueryFromClauses);
        } else {
            mappingQuery.getFrom().addGroups(critGroups);
        }
        if (!isSrc) {
            RelatePlanner.makeDependent(mappingQuery, planEnv.metadata);
        }
        mappingQuery.getSelect().setDistinct(true);
        List stCols = QueryUtil.resolveElements((GroupSymbol)stGroup, (QueryMetadataInterface)adapter);
        if (isSrc) {
            rel.sourceState.stagingTableColumns = stCols;
        } else {
            rel.targetState.stagingTableColumns = stCols;
            rel.targetState.selectedCols = RelatePlanner.addLinkSymbolsToStaging(mappingQuery, rel.mappingState.selectedCols, rel.mappingState.resultSet, stagingTableName, planEnv);
            rel.targetState.selectedCols.removeAll(rel.targetState.stagingTableColumns);
        }
        planEnv.setAlternateMappingClassQuery(stagingTableName, (Command)mappingQuery);
        ArrayList<String> stagingTableNames = (ArrayList<String>)planEnv.rootNode.getProperty(MappingNodeConstants.Properties.TEMP_GROUP_NAMES);
        if (stagingTableNames == null || stagingTableNames.size() == 0) {
            stagingTableNames = new ArrayList<String>();
        }
        stagingTableNames.add(stagingTableName);
        planEnv.rootNode.setProperty(MappingNodeConstants.Properties.TEMP_GROUP_NAMES, stagingTableNames);
        return stagingTableName;
    }

    static void makeDependent(Query mappingQuery, QueryMetadataInterface metadata) {
        HashSet groups = new HashSet();
        List commands = CommandCollectorVisitor.getCommands((LanguageObject)mappingQuery, false);
        Iterator it = commands.iterator();
        while (it.hasNext()) {
            RelatePlanner.findNestedGroups((Command)it.next(), groups);
        }
        Option option = mappingQuery.getOption();
        if (option == null) {
            option = new Option();
            mappingQuery.setOption(option);
        }
        for (GroupSymbol group : groups) {
            try {
                if (metadata.isVirtualGroup(group.getMetadataID())) continue;
                option.addDependentGroup(group.getCanonicalName());
            }
            catch (Exception e) {}
        }
    }

    private static void findNestedGroups(Command command, Set groups) {
        GroupCollectorVisitor.getGroups((LanguageObject)command, (Collection)groups);
        List clauses = SubqueryFromClauseCollectorVisitor.getClauses((LanguageObject)command);
        for (SubqueryFromClause sfc : clauses) {
            RelatePlanner.findNestedGroups(sfc.getCommand(), groups);
        }
    }

    private static String createStagingTableName(String mappingClassName, String prefix) {
        int index = mappingClassName.lastIndexOf(".");
        if (index >= 0) {
            return mappingClassName.substring(0, index + 1) + prefix + mappingClassName.substring(index + 1);
        }
        return prefix + mappingClassName;
    }

    static List addLinkSymbolsToStaging(Query mappingQuery, List linkColumns, String mappingRSName, String stagingTableName, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        int addedColsOffset = mappingQuery.getSelect().getProjectedSymbols().size();
        ArrayList<Object> newSelectColumns = new ArrayList<Object>(linkColumns.size());
        for (Object symbol : linkColumns) {
            if (symbol instanceof ElementSymbol) {
                ElementSymbol elem = (ElementSymbol)symbol;
                String aliasName = GENERATED_STAGING_TABLE_PREFIX + elem.getShortName();
                AliasSymbol alias = new AliasSymbol(aliasName, (SingleElementSymbol)elem);
                newSelectColumns.add(alias);
                continue;
            }
            newSelectColumns.add(symbol);
        }
        mappingQuery.getSelect().addSymbols(newSelectColumns);
        planEnv.globalTempMetadata.remove(stagingTableName);
        TempMetadataStore store = new TempMetadataStore(planEnv.globalTempMetadata);
        store.addTempGroup(stagingTableName, mappingQuery.getProjectedSymbols(), false);
        QueryMetadataInterface adapter = planEnv.getGlobalMetadata();
        GroupSymbol stGroup = new GroupSymbol(stagingTableName);
        try {
            ResolveGroupsVisitor.resolveGroups((LanguageObject)stGroup, (QueryMetadataInterface)adapter);
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((Throwable)e, e.getMessage());
        }
        List allSTCols = QueryUtil.resolveElements((GroupSymbol)stGroup, (QueryMetadataInterface)adapter);
        GroupSymbol relationshipGroup = new GroupSymbol(mappingRSName);
        try {
            ResolveGroupsVisitor.resolveGroups((LanguageObject)relationshipGroup, (QueryMetadataInterface)adapter);
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((Throwable)e, e.getMessage());
        }
        List originalMappingRSCols = QueryUtil.resolveElements((GroupSymbol)relationshipGroup, (QueryMetadataInterface)adapter);
        ArrayList<AliasSymbol> aliasedLinkCols = new ArrayList<AliasSymbol>();
        for (int i = 0; i < originalMappingRSCols.size(); ++i) {
            ElementSymbol originalMappingRSCol = (ElementSymbol)originalMappingRSCols.get(i);
            ElementSymbol stCol = (ElementSymbol)allSTCols.get(i + addedColsOffset);
            aliasedLinkCols.add(new AliasSymbol(originalMappingRSCol.getShortName(), (SingleElementSymbol)stCol));
        }
        return aliasedLinkCols;
    }

    private static Criteria addJoinCrits(Criteria mappingCrit, List sourceCrits) {
        Criteria finalCrit = mappingCrit;
        Iterator iter = sourceCrits.iterator();
        while (iter.hasNext()) {
            Criteria crit = (Criteria)((Criteria)iter.next()).clone();
            finalCrit = CompoundCriteria.combineCriteria((Criteria)finalCrit, (Criteria)crit);
        }
        return finalCrit;
    }

    private static Map createResultSetSymbolMap(String resultSetName, QueryMetadataInterface metadata, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        HashMap<ElementSymbol, Object> symbolMap = new HashMap<ElementSymbol, Object>();
        Command command = planEnv.getAlternateMappingClassQuery(resultSetName);
        List projectedSymbols = command.getProjectedSymbols();
        List rsElements = null;
        GroupSymbol rsGroup = new GroupSymbol(resultSetName);
        try {
            ResolveGroupsVisitor.resolveGroups((LanguageObject)rsGroup, (QueryMetadataInterface)metadata);
            rsElements = ResolverUtil.resolveElementsInGroup(rsGroup, metadata);
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((Throwable)e, e.getMessage());
        }
        for (int i = 0; i < rsElements.size(); ++i) {
            ElementSymbol elem = (ElementSymbol)rsElements.get(i);
            SingleElementSymbol projSymbol = (SingleElementSymbol)projectedSymbols.get(i);
            if (projSymbol instanceof AliasSymbol) {
                projSymbol = ((AliasSymbol)projSymbol).getSymbol();
            }
            if (projSymbol instanceof ElementSymbol) {
                symbolMap.put(elem, projSymbol);
                continue;
            }
            if (!(projSymbol instanceof ExpressionSymbol) || projSymbol instanceof AggregateSymbol) continue;
            symbolMap.put(elem, ((ExpressionSymbol)projSymbol).getExpression());
        }
        return symbolMap;
    }

    private static void getSourceStagingTableReverseMap(Relationship rel, Map symbolMap, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        QueryMetadataInterface tempMetadata = planEnv.getGlobalMetadata();
        Command command = planEnv.getAlternateMappingClassQuery(rel.sourceState.stagingTableName);
        List projectedSymbols = command.getProjectedSymbols();
        List rsElements = null;
        GroupSymbol rsGroup = new GroupSymbol(rel.sourceState.stagingTableName);
        try {
            ResolveGroupsVisitor.resolveGroups((LanguageObject)rsGroup, (QueryMetadataInterface)tempMetadata);
            rsElements = ResolverUtil.resolveElementsInGroup(rsGroup, tempMetadata);
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((Throwable)e, e.getMessage());
        }
        for (int i = 0; i < rsElements.size(); ++i) {
            ElementSymbol elem = (ElementSymbol)rsElements.get(i);
            SingleElementSymbol projSymbol = (SingleElementSymbol)projectedSymbols.get(i);
            if (projSymbol instanceof AliasSymbol) {
                projSymbol = ((AliasSymbol)projSymbol).getSymbol();
            }
            if (!(projSymbol instanceof ElementSymbol)) continue;
            String colName = rel.sourceState.stagingTableName + "." + elem.getShortName();
            ElementSymbol stCol = new ElementSymbol(colName);
            try {
                ResolveElementsVisitor.resolveElements((LanguageObject)stCol, (QueryMetadataInterface)tempMetadata);
            }
            catch (QueryResolverException e) {
                throw new QueryPlannerException((Throwable)e, e.getMessage());
            }
            symbolMap.put(projSymbol, stCol);
        }
    }

    private static void createMappingClass(String mappingClass, String sourceStagingTable, List selectElements, Relationship rel, XMLPlannerEnvironment planEnv) throws QueryMetadataException, MetaMatrixComponentException, QueryPlannerException {
        Query query = new Query();
        Select select = new Select();
        select.setDistinct(true);
        select.addSymbols((Collection)selectElements);
        query.setSelect(select);
        From from = new From();
        GroupSymbol group = new GroupSymbol(sourceStagingTable);
        try {
            ResolveGroupsVisitor.resolveGroups((LanguageObject)group, (QueryMetadataInterface)planEnv.getGlobalMetadata());
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((Throwable)e, e.getMessage());
        }
        from.addGroup(group);
        query.setFrom(from);
        if (planEnv.orderByWithRS != null) {
            OrderBy orderBy = RelatePlanner.createOrderByForSTGEN(planEnv.orderByWithRS, mappingClass);
            query.setOrderBy(orderBy);
        }
        query.setTemporaryMetadata(planEnv.globalTempMetadata);
        planEnv.setAlternateMappingClassQuery(mappingClass, (Command)query);
    }

    public static void markSelfEntityTree(MappingNode node, String fragmentDocumentPath, XMLPlannerEnvironment planEnv) {
        if (planEnv.relationships == null) {
            return;
        }
        block0: for (Relationship rel : planEnv.relationships) {
            if (!rel.isSelfRelationship || !rel.sourceFragmentPath.equalsIgnoreCase(fragmentDocumentPath + ".")) continue;
            MappingNode parentNode = node.getParent();
            Iterator childIter = parentNode.getChildren().iterator();
            while (childIter.hasNext()) {
                if (childIter.next() != node) continue;
                MappingNode copyNode = (MappingNode)childIter.next();
                XMLPlanner.markIncluded((MappingNode)copyNode);
                XMLPlanner.markTree((MappingNode)copyNode, (Integer)MappingNodeConstants.Properties.IS_INCLUDED);
                continue block0;
            }
        }
    }

    public static boolean validateRelateSourceAndTargetUse(String symbolName, XMLPlannerEnvironment planEnv, boolean outputInTarget, boolean outputInSource) throws QueryPlannerException {
        boolean isSelfEntityRelationship = false;
        if (planEnv.relationships == null) {
            return false;
        }
        Relationship rel = (Relationship)planEnv.relationships.iterator().next();
        isSelfEntityRelationship = rel.isSelfRelationship;
        if (outputInTarget != outputInSource) {
            String docPath = XMLPlanner.getQualifiedName((String)symbolName, (XMLPlannerEnvironment)planEnv);
            if (!rel.isSelfRelationship) {
                if (!docPath.startsWith(rel.sourceFragmentPath) && !docPath.startsWith(rel.targetFragmentPath)) {
                    throw new QueryPlannerException(QueryExecPlugin.Util.getString("RelatePlanner.misapplied_ToMappingEntity", (Object)symbolName));
                }
                if (!outputInSource && docPath.startsWith(rel.sourceFragmentPath)) {
                    throw new QueryPlannerException(QueryExecPlugin.Util.getString("RelatePlanner.misapplied_relateTarget", (Object)symbolName));
                }
                if (!outputInTarget && docPath.startsWith(rel.targetFragmentPath)) {
                    throw new QueryPlannerException(QueryExecPlugin.Util.getString("RelatePlanner.misapplied_relateSource", (Object)symbolName));
                }
            }
        }
        return isSelfEntityRelationship;
    }

    public static void markSelfEntityNode(String symbolName, XMLPlannerEnvironment planEnv) {
        if (planEnv.relationships == null) {
            return;
        }
        block0: for (Relationship rel : planEnv.relationships) {
            String docPath = XMLPlanner.getQualifiedName((String)symbolName, (XMLPlannerEnvironment)planEnv);
            if (!rel.isSelfRelationship || !docPath.startsWith(rel.sourceFragmentPath)) continue;
            MappingNode sourceFragmentNode = MappingNode.findNode((MappingNode)planEnv.rootNode, (String)rel.sourceFragmentPath.substring(0, rel.sourceFragmentPath.length() - 1), (boolean)false);
            MappingNode targetFragmentNode = null;
            Iterator childIter = sourceFragmentNode.getParent().getChildren().iterator();
            while (childIter.hasNext()) {
                if (childIter.next() != sourceFragmentNode) continue;
                targetFragmentNode = (MappingNode)childIter.next();
                break;
            }
            String subPath = docPath.substring(rel.sourceFragmentPath.length());
            for (MappingNode childNode : targetFragmentNode.getChildren()) {
                MappingNode targetSelection = MappingNode.findNode((MappingNode)childNode, (String)subPath, (boolean)false);
                if (targetSelection == null) continue;
                XMLPlanner.markIncluded((MappingNode)targetSelection);
                continue block0;
            }
        }
    }

    public static void processUserCritForRelate(Map criteriaMap, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        if (planEnv.hasRelationships()) {
            for (Relationship rel : planEnv.relationships) {
                CriteriaContextInfo mappingInfo;
                CriteriaContextInfo targetInfo;
                Criteria invalidCriteria;
                CriteriaContextInfo sourceInfo = (CriteriaContextInfo)criteriaMap.remove(rel.sourceState.resultSet);
                if (sourceInfo != null) {
                    Criteria srcCrit = sourceInfo.getCriteria(new int[]{3, 4, 0, 1});
                    rel.sourceState.userCrit = RelatePlanner.addUserCriteria(srcCrit, sourceInfo.critRSNames, rel.sourceState.resultSet, rel.sourceState.userCrit, planEnv);
                    if (rel.isSelfRelationship) {
                        HashSet<String> mappedRSNames = new HashSet<String>();
                        for (String name : sourceInfo.critRSNames) {
                            mappedRSNames.add(RelatePlanner.mapResultSetName(name, rel));
                        }
                        ExpressionMappingVisitor.mapExpressions(sourceInfo.crits[2], rel.targetCloneSymbolMap);
                        rel.targetState.userCrit = RelatePlanner.addUserCriteria(sourceInfo.crits[2], mappedRSNames, rel.targetState.resultSet, rel.targetState.userCrit, planEnv);
                        ExpressionMappingVisitor.mapExpressions(sourceInfo.crits[5], rel.targetCloneSymbolMap);
                        rel.targetState.userContextCrit = RelatePlanner.addUserCriteria(sourceInfo.crits[5], mappedRSNames, rel.targetState.resultSet, rel.targetState.userContextCrit, planEnv);
                    } else {
                        invalidCriteria = sourceInfo.getCriteria(new int[]{2, 5});
                        if (invalidCriteria != null) {
                            throw new QueryPlannerException(QueryExecPlugin.Util.getString("RelatePlanner.misapplied_wrapper", (Object)"source", (Object)"target", (Object)invalidCriteria));
                        }
                    }
                }
                if ((targetInfo = (CriteriaContextInfo)criteriaMap.remove(rel.targetState.resultSet)) != null) {
                    rel.targetState.userCrit = RelatePlanner.addUserCriteria(targetInfo.getCriteria(new int[]{0, 2}), targetInfo.critRSNames, rel.targetState.resultSet, rel.targetState.userCrit, planEnv);
                    rel.targetState.userContextCrit = RelatePlanner.addUserCriteria(targetInfo.getCriteria(new int[]{3, 5}), targetInfo.critRSNames, rel.targetState.resultSet, rel.targetState.userContextCrit, planEnv);
                    invalidCriteria = targetInfo.getCriteria(new int[]{1, 4});
                    if (invalidCriteria != null) {
                        throw new QueryPlannerException(QueryExecPlugin.Util.getString("RelatePlanner.misapplied_wrapper", (Object)"target", (Object)"source", (Object)invalidCriteria));
                    }
                }
                if ((mappingInfo = (CriteriaContextInfo)criteriaMap.remove(rel.mappingState.resultSet)) != null) {
                    rel.mappingState.userCrit = RelatePlanner.addUserCriteria(mappingInfo.getCriteria(new int[]{0, 3}), mappingInfo.critRSNames, rel.mappingState.resultSet, rel.mappingState.userCrit, planEnv);
                    Criteria invalidCriteria2 = mappingInfo.getCriteria(new int[]{1, 4});
                    if (invalidCriteria2 != null) {
                        throw new QueryPlannerException(QueryExecPlugin.Util.getString("RelatePlanner.misapplied_wrapper", (Object)"mapping", (Object)"source", (Object)invalidCriteria2));
                    }
                    invalidCriteria2 = mappingInfo.getCriteria(new int[]{2, 5});
                    if (invalidCriteria2 != null) {
                        throw new QueryPlannerException(QueryExecPlugin.Util.getString("RelatePlanner.misapplied_wrapper", (Object)"mapping", (Object)"target", (Object)invalidCriteria2));
                    }
                }
                if (!rel.isSelfRelationship) continue;
                for (Map.Entry entry : new HashSet(criteriaMap.entrySet())) {
                    String contextKey = (String)entry.getKey();
                    if (!rel.clonedNestedMappingClasses.contains(contextKey)) continue;
                    CriteriaContextInfo nestedSrcInfo = (CriteriaContextInfo)entry.getValue();
                    Criteria tgtCrits = nestedSrcInfo.getCriteria(new int[]{5, 2});
                    nestedSrcInfo.crits[5] = null;
                    nestedSrcInfo.crits[2] = null;
                    ExpressionMappingVisitor.mapExpressions(tgtCrits, rel.targetCloneSymbolMap);
                    String mappedContext = RelatePlanner.mapResultSetName(contextKey, rel);
                    HashSet<String> mappedCritRS = new HashSet<String>();
                    for (String oldCritRS : nestedSrcInfo.critRSNames) {
                        mappedCritRS.add(RelatePlanner.mapResultSetName(oldCritRS, rel));
                    }
                    tgtCrits = XMLPlanner.sortUserContextCriteria(mappedCritRS, (String)mappedContext, (Criteria)tgtCrits, (XMLPlannerEnvironment)planEnv);
                    HashMap symbolMap = new HashMap();
                    List mcSymbols = RelatePlanner.getMappingClassSymbols(mappedContext, planEnv.getGlobalMetadata());
                    List projSymbols = planEnv.getAlternateMappingClassQuery(mappedContext).getProjectedSymbols();
                    for (int i = 0; i < projSymbols.size(); ++i) {
                        symbolMap.put(mcSymbols.get(i), projSymbols.get(i));
                    }
                    ExpressionMappingVisitor.mapExpressions(tgtCrits, symbolMap);
                    Query query = (Query)planEnv.getAlternateMappingClassQuery(mappedContext);
                    if (tgtCrits == null) continue;
                    query.setCriteria(CompoundCriteria.combineCriteria((Criteria)query.getCriteria(), (Criteria)tgtCrits));
                    XMLPlanner.adjustFromClauseIfNecessary((Query)query, (Criteria)tgtCrits);
                    planEnv.setAlternateMappingClassQuery(mappedContext, (Command)query);
                }
            }
        }
    }

    private static String mapResultSetName(String name, Relationship rel) {
        GroupSymbol oldGroup = new GroupSymbol(name);
        GroupSymbol newGroup = (GroupSymbol)rel.targetCloneSymbolMap.get(oldGroup);
        if (newGroup != null) {
            return newGroup.getCanonicalName();
        }
        return name;
    }

    private static Criteria addUserCriteria(Criteria userCrit, Set rsNames, String contextRS, Criteria existingCrit, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Criteria srcCrit = null;
        if (userCrit != null) {
            srcCrit = XMLPlanner.sortUserContextCriteria((Collection)rsNames, (String)contextRS, (Criteria)userCrit, (XMLPlannerEnvironment)planEnv);
        }
        return CompoundCriteria.combineCriteria((Criteria)existingCrit, srcCrit);
    }

    public static void addCritsForRelate(Map rsCrits, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        if (planEnv.relationships == null) {
            return;
        }
        for (Relationship rel : planEnv.relationships) {
            HashMap symbolMap = new HashMap();
            symbolMap.putAll(rel.sourceState.originalSymbolMap);
            symbolMap.putAll(rel.targetState.originalSymbolMap);
            symbolMap.putAll(rel.mappingState.originalSymbolMap);
            RelatePlanner.addCritsForRelate(rel.sourceState.userCrit, rel.sourceState.stagingTableName, rel.sourceState.resultSet, symbolMap, planEnv);
            RelatePlanner.addCritsForRelate(rel.targetState.userCrit, rel.sourceState.stagingTableName, rel.targetState.resultSet, symbolMap, planEnv);
            RelatePlanner.addCritsForRelate(rel.targetState.userContextCrit, rel.targetState.stagingTableName, rel.targetState.resultSet, symbolMap, planEnv);
            RelatePlanner.addCritsForRelate(rel.mappingState.userCrit, rel.targetState.stagingTableName, rel.mappingState.resultSet, symbolMap, planEnv);
            if (rel.mappingState.userCrit == null) continue;
            ExpressionMappingVisitor.mapExpressions(rel.mappingState.userCrit, symbolMap);
            Collection userCritGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)rel.mappingState.userCrit);
            List sourceMappingJoinCrits = rel.sourceState.joinCrits;
            ArrayList<Criteria> useJoinCrits = new ArrayList<Criteria>();
            for (Criteria crit : sourceMappingJoinCrits) {
                Collection joinCritGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)crit);
                int priorSize = joinCritGroups.size();
                joinCritGroups.removeAll(userCritGroups);
                if (joinCritGroups.size() >= priorSize) continue;
                useJoinCrits.add(crit);
            }
            Query sourceStagingTable = (Query)planEnv.getAlternateMappingClassQuery(rel.sourceState.stagingTableName);
            HashSet stGroups = new HashSet(sourceStagingTable.getFrom().getGroups());
            Criteria stagingCrit = sourceStagingTable.getCriteria();
            HashMap aliasMap = new HashMap();
            for (GroupSymbol userGroup : userCritGroups) {
                GroupSymbol newGroup = RelatePlanner.createAliasedGroup(userGroup, stGroups);
                List userElements = QueryUtil.resolveElements((GroupSymbol)userGroup, (QueryMetadataInterface)planEnv.getGlobalMetadata());
                TempMetadataStore store = new TempMetadataStore(planEnv.globalTempMetadata);
                store.addTempGroup(newGroup.getName(), userElements);
                try {
                    ResolveGroupsVisitor.resolveGroups((LanguageObject)newGroup, (QueryMetadataInterface)planEnv.getGlobalMetadata());
                }
                catch (QueryResolverException e) {
                    throw new MetaMatrixComponentException((Throwable)e);
                }
                List newElements = QueryUtil.resolveElements((GroupSymbol)newGroup, (QueryMetadataInterface)planEnv.getGlobalMetadata());
                Iterator oldIter = userElements.iterator();
                Iterator newIter = newElements.iterator();
                while (oldIter.hasNext()) {
                    aliasMap.put(oldIter.next(), newIter.next());
                }
                sourceStagingTable.getFrom().addGroup(newGroup);
            }
            Criteria userCrit = (Criteria)rel.mappingState.userCrit.clone();
            ExpressionMappingVisitor.mapExpressions(userCrit, aliasMap);
            stagingCrit = CompoundCriteria.combineCriteria((Criteria)stagingCrit, (Criteria)userCrit);
            for (Criteria joinCrit : useJoinCrits) {
                ExpressionMappingVisitor.mapExpressions(joinCrit, aliasMap);
                stagingCrit = CompoundCriteria.combineCriteria((Criteria)stagingCrit, (Criteria)joinCrit);
            }
            sourceStagingTable.setCriteria(stagingCrit);
        }
    }

    private static void addCritsForRelate(Criteria userCrit, String stagingTableRS, String sourceRS, Map symbolMap, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        if (userCrit == null) {
            return;
        }
        ExpressionMappingVisitor.mapExpressions(userCrit, symbolMap);
        Query stagingQuery = (Query)planEnv.getAlternateMappingClassQuery(stagingTableRS);
        Criteria stagingCrit = stagingQuery.getCriteria();
        stagingCrit = CompoundCriteria.combineCriteria((Criteria)stagingCrit, (Criteria)userCrit);
        stagingQuery.setCriteria(stagingCrit);
    }

    static OrderBy createOrderByForSTGEN(Map orderByWithRS, String mappingClassName) {
        OrderBy origOrderBy = (OrderBy)orderByWithRS.get(mappingClassName);
        OrderBy orderBy = new OrderBy();
        if (origOrderBy != null) {
            List variables = origOrderBy.getVariables();
            ArrayList<ElementSymbol> stgenVariables = new ArrayList<ElementSymbol>();
            Iterator variablesIterator = variables.iterator();
            while (variablesIterator.hasNext()) {
                String shortName = ((ElementSymbol)variablesIterator.next()).getShortName().toUpperCase();
                stgenVariables.add(new ElementSymbol(shortName));
            }
            orderBy.addVariables(stgenVariables);
        }
        return orderBy;
    }

    private static void addDupRemovalCriteria(Relationship rel, XMLPlannerEnvironment planEnv) throws MetaMatrixComponentException, QueryPlannerException, QueryMetadataException {
        if (!rel.isSelfRelationship) {
            return;
        }
        try {
            Iterator oldIter = rel.sourceEntityKeyCols.iterator();
            Iterator newIter = rel.targetEntityKeyCols.iterator();
            while (oldIter.hasNext()) {
                ElementSymbol oldElem = (ElementSymbol)oldIter.next();
                ElementSymbol newElem = (ElementSymbol)newIter.next();
                SubquerySetCriteria ssc = new SubquerySetCriteria();
                ssc.setNegated(true);
                ElementSymbol tgtID = new ElementSymbol(rel.targetState.stagingTableName + "." + oldElem.getShortName());
                ResolveElementsVisitor.resolveElements((LanguageObject)tgtID, (QueryMetadataInterface)planEnv.getGlobalMetadata());
                ssc.setExpression((Expression)tgtID);
                Query subCommand = new Query();
                From from = new From();
                GroupSymbol sourceStagingTable = new GroupSymbol(rel.sourceState.stagingTableName);
                ResolveGroupsVisitor.resolveGroups((LanguageObject)sourceStagingTable, (QueryMetadataInterface)planEnv.getGlobalMetadata());
                from.addGroup(sourceStagingTable);
                subCommand.setFrom(from);
                Select select = new Select();
                select.setDistinct(true);
                ElementSymbol srcID = new ElementSymbol(rel.sourceState.stagingTableName + "." + newElem.getShortName());
                ResolveElementsVisitor.resolveElements((LanguageObject)srcID, (QueryMetadataInterface)planEnv.getGlobalMetadata());
                select.addSymbol((SelectSymbol)srcID);
                subCommand.setSelect(select);
                QueryUtil.resolveQuery((Command)subCommand, (XMLPlannerEnvironment)planEnv);
                ssc.setCommand((Command)subCommand);
                Query mappingQuery = (Query)planEnv.getAlternateMappingClassQuery(rel.targetState.resultSet);
                mappingQuery.setCriteria(CompoundCriteria.combineCriteria((Criteria)mappingQuery.getCriteria(), (Criteria)ssc));
            }
        }
        catch (QueryResolverException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }
}

