/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.salesforce.execution.visitors;

import com.metamatrix.connector.salesforce.execution.visitors.CriteriaVisitor;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IInsert;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.metadata.runtime.Element;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.message.MessageElement;

public class InsertVisitor
extends CriteriaVisitor {
    List<MessageElement> elements = new ArrayList<MessageElement>();

    public InsertVisitor(RuntimeMetadata metadata) {
        super(metadata);
    }

    public void visit(IInsert insert) {
        super.visit(insert);
        try {
            this.loadColumnMetadata(insert.getGroup());
            List columns = insert.getElements();
            List values = insert.getValues();
            if (columns.size() != values.size()) {
                throw new ConnectorException("Error:  columns.size and values.size are not the same.");
            }
            for (int i = 0; i < columns.size(); ++i) {
                String val;
                IElement element = (IElement)columns.get(i);
                Element column = (Element)this.metadata.getObject(element.getMetadataID());
                Object value = values.get(i);
                if (value instanceof ILiteral) {
                    ILiteral literalValue = (ILiteral)value;
                    val = this.stripQutes(literalValue.getValue().toString());
                } else {
                    val = value.toString();
                }
                MessageElement messageElem = new MessageElement(new QName(column.getNameInSource()), (Object)val);
                this.elements.add(messageElem);
            }
        }
        catch (ConnectorException ce) {
            this.exceptions.add(ce);
        }
    }

    public MessageElement[] getMessageElements() {
        return this.elements.toArray(new MessageElement[0]);
    }

    private String stripQutes(String id) {
        if (id.startsWith("'") && id.endsWith("'")) {
            id = id.substring(1, id.length() - 1);
        } else if (id.startsWith("\"") && id.endsWith("\"")) {
            id = id.substring(1, id.length() - 1);
        }
        return id;
    }
}

