/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.salesforce.model.impl;

import com.metamatrix.modeler.modelgenerator.salesforce.connection.SalesforceConnection;
import com.metamatrix.modeler.modelgenerator.salesforce.model.DataModel;
import com.metamatrix.modeler.modelgenerator.salesforce.model.SalesforceObject;
import com.metamatrix.modeler.modelgenerator.salesforce.model.impl.Messages;
import com.metamatrix.modeler.modelgenerator.salesforce.model.impl.SalesforceObjectImpl;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.SoapBindingStub;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;

public class DataModelImpl
implements DataModel {
    Integer maxBatchSize;
    String encoding;
    private Map<String, SalesforceObject> salesforceObjects = new TreeMap<String, SalesforceObject>();
    private int selectedCount = 0;

    public void load(SalesforceConnection conn, IProgressMonitor monitor) throws Exception {
        int arrayLength;
        DescribeGlobalResult describeGlobalResult;
        monitor.beginTask(Messages.getString((String)"DataModelImpl.gathering.metadata"), -1);
        SoapBindingStub binding = conn.getBinding();
        try {
            describeGlobalResult = binding.describeGlobal();
        }
        catch (RemoteException e) {
            Exception ce = new Exception(e.getCause().getMessage());
            ce.initCause(e.getCause());
            throw ce;
        }
        DescribeGlobalSObjectResult[] types = describeGlobalResult.getSobjects();
        for (int i = 0; i < types.length; i += arrayLength) {
            DescribeSObjectResult[] describeSObjectResults;
            arrayLength = i + 100 > types.length ? types.length - i : 100;
            String[] typesBatch = new String[arrayLength];
            for (int j = 0; j < arrayLength; ++j) {
                typesBatch[j] = types[i + j].getName();
            }
            try {
                describeSObjectResults = binding.describeSObjects(typesBatch);
            }
            catch (RemoteException e) {
                Exception ce = new Exception(e.getCause().getMessage());
                ce.initCause(e.getCause());
                throw ce;
            }
            for (int x = 0; x < describeSObjectResults.length; ++x) {
                DescribeSObjectResult describeSObjectResult = describeSObjectResults[x];
                SalesforceObjectImpl object = new SalesforceObjectImpl();
                monitor.subTask(Messages.getString((String)"DataModelImpl.gathering.metadata.table") + describeSObjectResult.getLabel());
                object.setObjectMetadata(describeSObjectResult, (DataModel)this);
                this.addSalesforceObject(typesBatch[x], (SalesforceObject)object);
                monitor.worked(1);
            }
        }
    }

    public Integer getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(Integer maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void addSalesforceObject(String objectName, SalesforceObject sObject) throws Exception {
        SalesforceObject result = this.salesforceObjects.put(objectName, sObject);
        if (null != result) {
            throw new Exception(Messages.getString((String)"DataModelImpl.duplicate.found") + objectName);
        }
    }

    public Object[] getSalesforceObjects() {
        return this.salesforceObjects.values().toArray();
    }

    public SalesforceObject getSalesforceObject(String name) {
        return this.salesforceObjects.get(name);
    }

    public boolean hasSelectedObjects() {
        return this.selectedCount > 0;
    }

    public void incrementSelectionCount() {
        ++this.selectedCount;
    }

    public void decrementSelectionCount() {
        --this.selectedCount;
    }
}

