/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.extension.impl;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.types.MMJDBCSQLTypeInfo;
import com.metamatrix.common.util.exception.SQLExceptionUnroller;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.extension.ResultsTranslator;
import com.metamatrix.connector.jdbc.extension.TranslatedCommand;
import com.metamatrix.connector.jdbc.extension.ValueRetriever;
import com.metamatrix.connector.jdbc.extension.impl.BasicValueRetriever;
import com.metamatrix.connector.jdbc.extension.impl.BlobValueTranslator;
import com.metamatrix.connector.jdbc.extension.impl.ByteArrayValueTranslator;
import com.metamatrix.connector.jdbc.extension.impl.ClobToStringValueTranslator;
import com.metamatrix.connector.jdbc.extension.impl.ClobValueTranslator;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.IParameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class BasicResultsTranslator
implements ResultsTranslator {
    private static final TimeZone LOCAL_TIME_ZONE = TimeZone.getDefault();
    private List valueTranslators = new ArrayList();
    private ValueRetriever valueRetriever = new BasicValueRetriever();
    private TimeZone dbmsTimeZone = null;
    private int maxResultRows = 0;
    private int fetchSize = 0;

    public void initialize(ConnectorEnvironment env) throws ConnectorException {
        String fetchSizeString;
        String maxResultRowsString = env.getProperties().getProperty("MaxResultRows");
        if (maxResultRowsString != null && maxResultRowsString.trim().length() > 0) {
            try {
                this.maxResultRows = Integer.parseInt(maxResultRowsString);
                String exceptionOnMaxRowsString = env.getProperties().getProperty("ExceptionOnMaxRows");
                this.maxResultRows = Math.max(0, this.maxResultRows);
                if (this.maxResultRows > 0 && Boolean.valueOf(exceptionOnMaxRowsString).booleanValue()) {
                    ++this.maxResultRows;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((fetchSizeString = env.getProperties().getProperty("FetchSize")) != null && fetchSizeString.trim().length() > 0) {
            try {
                this.fetchSize = Integer.parseInt(fetchSizeString);
            }
            catch (NumberFormatException e) {
                Object[] params = new Object[]{"FetchSize"};
                String msg = JDBCPlugin.Util.getString("BasicResultsTranslator.Couldn__t_parse_property", params);
                env.getLogger().logWarning(msg);
            }
        }
        BlobValueTranslator valueTranslator = new BlobValueTranslator();
        valueTranslator.initialize(env);
        this.valueTranslators.add(valueTranslator);
        valueTranslator = new ClobValueTranslator();
        valueTranslator.initialize(env);
        this.valueTranslators.add(valueTranslator);
        valueTranslator = new ByteArrayValueTranslator();
        valueTranslator.initialize(env);
        this.valueTranslators.add(valueTranslator);
        valueTranslator = new ClobToStringValueTranslator();
        valueTranslator.initialize(env);
        this.valueTranslators.add(valueTranslator);
        String timeZone = env.getProperties().getProperty("DatabaseTimeZone");
        if (timeZone != null && timeZone.trim().length() > 0 && !LOCAL_TIME_ZONE.equals(timeZone)) {
            this.dbmsTimeZone = TimeZone.getTimeZone(timeZone);
        }
    }

    public ResultSet executeStoredProcedure(CallableStatement statement, TranslatedCommand command) throws SQLException {
        int update_count;
        List params = command.getPreparedValues();
        int index = 1;
        for (IParameter param : params) {
            if (param.getDirection() != 3) continue;
            this.registerSpecificTypeOfOutParameter(statement, param, index++);
        }
        Calendar cal = this.getDatabaseCalendar();
        for (IParameter param : params) {
            if (param.getDirection() == 2) {
                this.registerSpecificTypeOfOutParameter(statement, param, index);
            } else if (param.getDirection() == 1) {
                this.registerSpecificTypeOfOutParameter(statement, param, index++);
            }
            if (param.getDirection() != 0 && param.getDirection() != 2) continue;
            this.bindValue(statement, param.getValue(), param.getType(), index++, cal);
        }
        if (this.maxResultRows > 0) {
            statement.setMaxRows(this.maxResultRows + 1);
        }
        if (this.fetchSize > 0) {
            if (this.maxResultRows > 0) {
                statement.setFetchSize(Math.min(this.fetchSize, this.maxResultRows + 1));
            } else {
                statement.setFetchSize(this.fetchSize);
            }
        }
        boolean resultSetNext = statement.execute();
        while (!resultSetNext && (update_count = statement.getUpdateCount()) != -1) {
            resultSetNext = statement.getMoreResults();
        }
        return statement.getResultSet();
    }

    public List getValueTranslators() {
        return this.valueTranslators;
    }

    public ValueRetriever getValueRetriever() {
        return this.valueRetriever;
    }

    protected void registerSpecificTypeOfOutParameter(CallableStatement statement, IParameter param, int index) throws SQLException {
        Class runtimeType = param.getType();
        int typeToSet = MMJDBCSQLTypeInfo.getSQLTypeFromRuntimeType((Class)runtimeType);
        try {
            statement.registerOutParameter(index, typeToSet);
        }
        catch (SQLException e) {
            SQLException e2 = SQLExceptionUnroller.unRollException((SQLException)e);
            throw e2;
        }
    }

    public void bindPreparedStatementValues(Connection conn, PreparedStatement stmt, TranslatedCommand command) throws SQLException {
        Calendar cal = this.getDatabaseCalendar();
        List params = command.getPreparedValues();
        this.setPreparedStatementValues(stmt, params, command.getPreparedTypes(), cal);
    }

    private Calendar getDatabaseCalendar() {
        Calendar cal = this.dbmsTimeZone != null ? Calendar.getInstance(this.dbmsTimeZone) : Calendar.getInstance();
        return cal;
    }

    private void setPreparedStatementValues(PreparedStatement stmt, List paramValues, List paramTypes, Calendar cal) throws SQLException {
        for (int i = 0; i < paramValues.size(); ++i) {
            Object parmvalue = paramValues.get(i);
            Class paramType = (Class)paramTypes.get(i);
            this.bindValue(stmt, parmvalue, paramType, i + 1, cal);
        }
    }

    protected void bindValue(PreparedStatement stmt, Object param, Class paramType, int i, Calendar cal) throws SQLException {
        int type = MMJDBCSQLTypeInfo.getSQLTypeFromRuntimeType((Class)paramType);
        if (param == null) {
            stmt.setNull(i, type);
            return;
        }
        if (paramType.equals(DataTypeManager.DefaultDataClasses.DATE)) {
            stmt.setDate(i, (Date)param, cal);
            return;
        }
        if (paramType.equals(DataTypeManager.DefaultDataClasses.TIME)) {
            stmt.setTime(i, (Time)param, cal);
            return;
        }
        if (paramType.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
            stmt.setTimestamp(i, (Timestamp)param, cal);
            return;
        }
        if (DataTypeManager.DefaultDataClasses.BIG_INTEGER.equals(paramType)) {
            param = new BigDecimal((BigInteger)param);
        } else if (DataTypeManager.DefaultDataClasses.FLOAT.equals(paramType)) {
            param = new Double(((Float)param).doubleValue());
        } else if (DataTypeManager.DefaultDataClasses.CHAR.equals(paramType)) {
            param = ((Character)param).toString();
        }
        stmt.setObject(i, param, type);
    }

    public int executeStatementForBulkInsert(Connection conn, PreparedStatement stmt, TranslatedCommand command) throws SQLException {
        List rows = command.getPreparedValues();
        Calendar cal = this.getDatabaseCalendar();
        int updateCount = 0;
        for (int i = 0; i < rows.size(); ++i) {
            List row = (List)rows.get(i);
            this.setPreparedStatementValues(stmt, row, command.getPreparedTypes(), cal);
            stmt.addBatch();
        }
        int[] results = stmt.executeBatch();
        for (int i = 0; i < results.length; ++i) {
            updateCount += results[i];
        }
        return updateCount;
    }

    public TimeZone getDatabaseTimezone() {
        return this.dbmsTimeZone;
    }

    public Batch modifyBatch(Batch batch, ExecutionContext context, ICommand command) {
        return batch;
    }

    public int getMaxResultRows() {
        return this.maxResultRows;
    }
}

