/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.CommandPlanner;
import com.metamatrix.query.optimizer.CommandTreeNode;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.GenerateCanonical;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.PlanHints;
import com.metamatrix.query.optimizer.relational.PlanToProcessConverter;
import com.metamatrix.query.optimizer.relational.RelationalCommandConstants;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.RuleConstants;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.SubqueryContainer;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.CorrelatedReferenceCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RelationalPlanner
implements CommandPlanner {
    public void generateCanonical(CommandTreeNode node, QueryMetadataInterface metadata, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanHints hints;
        Command command = node.getCommand();
        PlanNode canonicalPlan = GenerateCanonical.generatePlan((Command)command, (PlanHints)(hints = (PlanHints)node.getProperty(RelationalCommandConstants.HINTS)), (QueryMetadataInterface)metadata);
        if (canonicalPlan == null) {
            return;
        }
        node.setCanonicalPlan((Object)canonicalPlan);
        HashSet groupSymbols = new HashSet();
        RelationalPlanner.findGroupsFromSourceNodes(canonicalPlan, groupSymbols);
        RelationalPlanner.connectCorrelatedReferences(canonicalPlan, groupSymbols);
    }

    public ProcessorPlan optimize(CommandTreeNode node, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanNode plan = (PlanNode)node.getCanonicalPlan();
        Map planMap = RelationalPlanner.connectChildPlans(plan, node);
        Command command = node.getCommand();
        PlanHints hints = (PlanHints)node.getProperty(RelationalCommandConstants.HINTS);
        RelationalPlanner.checkForVirtualGroups(command, hints, metadata);
        if (hints.makeDepGroups != null) {
            RelationalPlanner.distributeDependentHints(hints.makeDepGroups, plan, metadata, NodeConstants.Info.MAKE_DEP);
        }
        if (hints.makeNotDepGroups != null) {
            RelationalPlanner.distributeDependentHints(hints.makeNotDepGroups, plan, metadata, NodeConstants.Info.MAKE_NOT_DEP);
        }
        if (!planMap.isEmpty()) {
            RelationalPlanner.connectSubqueryContainers(planMap, plan);
        }
        RuleStack rules = RelationalPlanner.buildRules(hints);
        plan = RelationalPlanner.executeRules(rules, plan, metadata, capFinder, analysisRecord, context);
        node.setCanonicalPlan((Object)plan);
        if (!planMap.isEmpty()) {
            RelationalPlanner.connectSubqueryContainers(planMap, plan);
        }
        ProcessorPlan result = PlanToProcessConverter.convert((PlanNode)plan, (QueryMetadataInterface)metadata, (IDGenerator)idGenerator, (AnalysisRecord)analysisRecord, (CapabilitiesFinder)capFinder);
        return result;
    }

    private static void findGroupsFromSourceNodes(PlanNode node, Set groupSymbols) {
        if (node.getType() == 19) {
            groupSymbols.addAll(node.getGroups());
        } else if (node.getChildCount() > 0) {
            List children = node.getChildren();
            for (PlanNode childNode : children) {
                RelationalPlanner.findGroupsFromSourceNodes(childNode, groupSymbols);
            }
        }
    }

    private static void connectCorrelatedReferences(PlanNode node, Set groupSymbols) {
        if (node.getType() == 13 || node.getType() == 11 || node.getType() == 7) {
            Object criteria;
            ArrayList subqueryContainers = new ArrayList();
            if (node.getType() == 13) {
                criteria = (Criteria)node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)criteria, subqueryContainers);
            } else if (node.getType() == 11) {
                Collection projectCols = (Collection)node.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((Collection)projectCols, subqueryContainers);
            } else if (node.getType() == 7 && (criteria = (Collection)node.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA)) != null) {
                ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((Collection)criteria, subqueryContainers);
            }
            if (subqueryContainers.size() > 0) {
                ArrayList correlatedReferences = new ArrayList();
                for (SubqueryContainer container : subqueryContainers) {
                    Command subCommand = container.getCommand();
                    CorrelatedReferenceCollectorVisitor.collectReferences((LanguageObject)subCommand, (Collection)groupSymbols, correlatedReferences);
                }
                if (!correlatedReferences.isEmpty()) {
                    node.setProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES, correlatedReferences);
                }
            }
        }
        if (node.getChildCount() > 0) {
            List children = node.getChildren();
            for (PlanNode childNode : children) {
                RelationalPlanner.connectCorrelatedReferences(childNode, groupSymbols);
            }
        }
    }

    private static void connectSubqueryContainers(Map planMap, PlanNode plan) {
        if (plan.getType() == 13 || plan.getType() == 11 || plan.getType() == 7) {
            Object criteria;
            ArrayList subqueryContainers = new ArrayList();
            if (plan.getType() == 13) {
                criteria = (Criteria)plan.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)criteria, subqueryContainers);
            } else if (plan.getType() == 11) {
                Collection projectCols = (Collection)plan.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((Collection)projectCols, subqueryContainers);
            } else {
                criteria = (Collection)plan.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
                if (criteria != null) {
                    ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((Collection)criteria, subqueryContainers);
                }
            }
            if (subqueryContainers.size() > 0) {
                ArrayList plans = new ArrayList(subqueryContainers.size());
                for (SubqueryContainer container : subqueryContainers) {
                    Command subCommand = container.getCommand();
                    Object processorPlan = planMap.get(subCommand);
                    plans.add(processorPlan);
                }
                plan.setProperty((Object)NodeConstants.Info.SUBQUERY_PLANS, plans);
                plan.setProperty((Object)NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS, subqueryContainers);
            }
        }
        if (plan.getChildCount() > 0) {
            List children = plan.getChildren();
            for (PlanNode childNode : children) {
                RelationalPlanner.connectSubqueryContainers(planMap, childNode);
            }
        }
    }

    private static Map connectChildPlans(PlanNode plan, CommandTreeNode commandNode) {
        List commandChildren = commandNode.getChildren();
        if (commandChildren.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        IdentityHashMap<Command, ProcessorPlan> planMap = new IdentityHashMap<Command, ProcessorPlan>();
        Iterator childIter = commandChildren.iterator();
        int i = 0;
        while (childIter.hasNext()) {
            CommandTreeNode child = (CommandTreeNode)childIter.next();
            planMap.put(child.getCommand(), child.getProcessorPlan());
            ++i;
        }
        RelationalPlanner.setProcessorPlans(plan, planMap);
        return planMap;
    }

    private static void setProcessorPlans(PlanNode plan, Map planMap) {
        Object nodeCommand;
        ProcessorPlan subPlan;
        if (plan.getType() == 19 && (subPlan = (ProcessorPlan)planMap.get(nodeCommand = plan.getProperty((Object)NodeConstants.Info.NESTED_COMMAND))) != null) {
            plan.setProperty((Object)NodeConstants.Info.PROCESSOR_PLAN, (Object)subPlan);
        }
        if (plan.getChildCount() > 0) {
            List children = plan.getChildren();
            for (PlanNode childNode : children) {
                RelationalPlanner.setProcessorPlans(childNode, planMap);
            }
        }
    }

    private static void checkForVirtualGroups(Command command, PlanHints hints, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)command, (boolean)true);
        for (GroupSymbol group : groups) {
            if (!metadata.isVirtualGroup(group.getMetadataID())) continue;
            hints.hasVirtualGroups = true;
            break;
        }
    }

    private static void distributeDependentHints(Collection groups, PlanNode plan, QueryMetadataInterface metadata, Integer hintProperty) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        if (groups != null && groups.size() > 0) {
            List nodes = NodeEditor.findAllNodes((PlanNode)plan, (int)19);
            for (String groupName : groups) {
                boolean appliedHint = RelationalPlanner.applyHint(nodes, groupName, hintProperty);
                if (appliedHint) continue;
                Collection groupNames = metadata.getGroupsForPartialName(groupName);
                if (groupNames.size() == 1) {
                    groupName = (String)groupNames.iterator().next();
                    appliedHint = RelationalPlanner.applyHint(nodes, groupName, hintProperty);
                }
                if (appliedHint) continue;
                LogManager.logWarning((String)"QUERY_PLANNER", (Object[])new Object[]{QueryExecPlugin.Util.getString("ERR.015.004.0010", (Object)groupName)});
            }
        }
    }

    private static boolean applyHint(List nodes, String groupName, Integer hintProperty) {
        boolean appliedHint = false;
        for (PlanNode node : nodes) {
            GroupSymbol nodeGroup = (GroupSymbol)node.getGroups().iterator().next();
            String sDefinition = nodeGroup.getDefinition();
            if (!nodeGroup.getName().equalsIgnoreCase(groupName) && (sDefinition == null || !sDefinition.equalsIgnoreCase(groupName))) continue;
            node.setProperty((Object)hintProperty, (Object)Boolean.TRUE);
            appliedHint = true;
        }
        return appliedHint;
    }

    public static RuleStack buildRules(PlanHints hints) {
        RuleStack rules = new RuleStack();
        if (hints.needsWhereAllValidation) {
            rules.push(RuleConstants.VALIDATE_WHERE_ALL);
        }
        rules.push(RuleConstants.ACCESS_PATTERN_VALIDATION);
        rules.push(RuleConstants.COLLAPSE_SOURCE);
        if (hints.hasJoin) {
            rules.push(RuleConstants.ADD_PROJECTS);
        }
        rules.push(RuleConstants.ASSIGN_OUTPUT_ELEMENTS);
        rules.push(RuleConstants.CALCULATE_COST);
        if (hints.hasLimit) {
            rules.push(RuleConstants.PUSH_LIMIT);
        }
        if (hints.hasJoin || hints.hasCriteria) {
            rules.push(RuleConstants.MERGE_CRITERIA);
        }
        if (hints.hasRelationalProc) {
            rules.push(RuleConstants.PLAN_PROCEDURES);
        }
        if (hints.hasJoin) {
            rules.push(RuleConstants.IMPLEMENT_JOIN_STRATEGY);
            rules.push(RuleConstants.CHOOSE_DEPENDENT);
            rules.push(RuleConstants.CHOOSE_JOIN_STRATEGY);
        } else {
            rules.push(RuleConstants.CHOOSE_DEPENDENT);
        }
        rules.push(RuleConstants.FIX_ACCESS_FRAME);
        if (hints.hasCriteria || hints.hasJoin) {
            rules.push(RuleConstants.ATTACH_SUBQUERY_PLANS);
        }
        if (hints.hasAggregates) {
            rules.push(RuleConstants.PUSH_AGGREGATES);
        }
        if (hints.hasJoin) {
            rules.push(RuleConstants.RAISE_ACCESS);
            rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
            rules.push(RuleConstants.PLAN_JOINS);
        }
        rules.push(RuleConstants.RAISE_ACCESS);
        if (hints.hasUnion) {
            rules.push(RuleConstants.PLAN_UNIONS);
        }
        if (hints.hasCriteria || hints.hasJoin) {
            rules.push(RuleConstants.CLEAN_CRITERIA);
        }
        if (hints.hasJoin) {
            rules.push(RuleConstants.COPY_CRITERIA);
            rules.push(RuleConstants.PUSH_NON_JOIN_CRITERIA);
        }
        if (hints.hasVirtualGroups) {
            rules.push(RuleConstants.MERGE_VIRTUAL);
        }
        if (hints.hasCriteria) {
            rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
        }
        if (hints.hasJoin && hints.hasOptionalJoin) {
            rules.push(RuleConstants.REMOVE_OPTIONAL_JOINS);
        }
        if (hints.hasCriteria) {
            rules.push(RuleConstants.BREAK_CRITERIA);
        }
        rules.push(RuleConstants.PLACE_ACCESS);
        if (hints.hasSort) {
            rules.push(RuleConstants.REMOVE_SORTS);
        }
        if (hints.isUpdate) {
            rules.push(RuleConstants.REMOVE_UPDATE_SOURCE);
        }
        return rules;
    }

    private static PlanNode executeRules(RuleStack rules, PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        boolean debug = analysisRecord.recordDebug();
        while (!rules.isEmpty()) {
            if (debug) {
                analysisRecord.println("\n============================================================================");
            }
            OptimizerRule rule = rules.pop();
            if (debug) {
                analysisRecord.println("EXECUTING " + rule);
            }
            plan = rule.execute(plan, metadata, capFinder, rules, analysisRecord, context);
            if (!debug) continue;
            analysisRecord.println("\nAFTER: \n" + plan);
        }
        return plan;
    }
}

