/*
 * Decompiled with CFR 0.152.
 */
package jdbc.sql.cli;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import jdbc.sql.cli.oacliexception;
import jdbc.sql.cli.oaclistmt;
import jdbc.sql.cli.oacliwarning;
import jdbc.sql.oapooledconnection;
import jdbc.sql.oautilobj;
import jdbc.sql.oaxaconnection;

public class oacli
extends oautilobj {
    private Object _lock = null;
    private int _lockcount = 0;
    private long _lastUsedXa = 0L;
    private static HashMap _xaclis;
    private static Timer _xaTimer;
    reconnect _rec = new reconnect();
    private long _sql_henv = 0L;
    private long _sql_hdbc = 0L;
    private oacliwarning _sql_warning = null;
    oaclistmt _systemStmt = null;
    private boolean _inXATransaction = false;
    private int _transactionLevel = 0;
    boolean _localAutocommit;
    int _xaOptions;
    private boolean _badConnection = false;
    private oapooledconnection _pooledConnection = null;
    private oaxaconnection _XAConnection = null;
    private List _listOfStatements;
    private boolean _initialAutocommit;
    private boolean _initialReadonly;
    private String _initialCatalog;
    private int _initialTxnIsolation;

    public void markConnectionAsBad() {
        if (this._badConnection) {
            return;
        }
        this._badConnection = true;
        if (this._pooledConnection != null) {
            this._pooledConnection.notifyError(new oacliexception("Connection lost", "08S01"));
        }
    }

    public oacli(int n, boolean bl) {
        if (oacli.traceOn()) {
            oacli.trace("oacli() called");
        }
        this._sql_warning = null;
        this._listOfStatements = Collections.synchronizedList(new LinkedList());
        this._xaOptions = n;
        if (bl) {
            throw new IllegalArgumentException("allocEnv not supported");
        }
    }

    public static native void initStaticVarsCLI();

    private native void initCLI();

    private native void freeCLI() throws oacliexception;

    public void openConnectionInt(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, boolean bl6, int n2, boolean bl7, int n3) throws oacliexception {
        this._rec._login = string;
        this._rec._passwd = string2;
        this._rec._traceSet = bl;
        this._rec._trace = bl2;
        this._rec._readonlySet = bl3;
        this._rec._readOnly = bl4;
        this._rec._queryTimeoutSet = bl5;
        this._rec._queryTimeout = n;
        this._rec._logonTimeoutSet = bl6;
        this._rec._loginTimeout = n2;
        this._rec._isolationLevelSet = bl7;
        this._rec._isolationLevel = n3;
        this._rec._database = string3;
        this._rec._custom = string4;
        this._rec._connectionId = string5;
        this.Reconnect();
    }

    public void Reconnect() throws oacliexception {
        if (this._systemStmt != null) {
            block4: {
                if (oacli.traceOn()) {
                    oacli.trace("oacli:Reconnect - removing _systemStmt before reconnecting " + this._systemStmt);
                }
                try {
                    this._systemStmt.close();
                }
                catch (oacliexception oacliexception2) {
                    if (!oacli.traceOn()) break block4;
                    oacli.trace("oacli:Reconnect - ignoring error: " + oacliexception2.getMessage() + "when closing " + this._systemStmt);
                }
            }
            this._systemStmt = null;
        }
        this._rec.Reconnect();
    }

    private native void openConnectionWithProperties(String var1, String var2, String var3, String var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, int var10, boolean var11, int var12, boolean var13, int var14) throws oacliexception;

    public void setPooledConnection(oapooledconnection oapooledconnection2) {
        this._pooledConnection = oapooledconnection2;
    }

    public void setXAConnection(oaxaconnection oaxaconnection2) {
        this._XAConnection = oaxaconnection2;
        this._lock = new Object();
    }

    public void setSpecialOwner(oaxaconnection oaxaconnection2) {
        this._XAConnection = oaxaconnection2;
    }

    private native void closeConnection() throws oacliexception;

    public void close() throws oacliexception {
        while (!this._listOfStatements.isEmpty()) {
            oaclistmt oaclistmt2 = (oaclistmt)this._listOfStatements.get(0);
            oaclistmt2.close();
        }
        this._systemStmt = null;
        this.internalClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalClose() {
        try {
            block13: {
                if (this._sql_hdbc != 0L) {
                    if (oacli.traceOn()) {
                        oacli.trace("closing _sql_hdbc = " + this._sql_hdbc);
                    }
                    try {
                        this.closeConnection();
                    }
                    catch (oacliexception oacliexception2) {
                        if (!oacli.traceOn()) break block13;
                        oacli.trace("close of _sql_hdbc = " + this._sql_hdbc + " failed with " + oacliexception2.getMessage());
                    }
                }
            }
            if (this._sql_henv != 0L) {
                if (oacli.traceOn()) {
                    oacli.trace("closing _sql_henv = " + this._sql_henv);
                }
                try {
                    this.freeCLI();
                }
                catch (oacliexception oacliexception3) {
                    if (oacli.traceOn()) {
                        oacli.trace("close of _sql_henv = " + this._sql_henv + " failed with " + oacliexception3.getMessage());
                    }
                }
            }
        }
        finally {
            this._sql_hdbc = 0L;
            this._sql_henv = 0L;
            for (int i = 0; i < this._listOfStatements.size(); ++i) {
                oaclistmt oaclistmt2 = (oaclistmt)this._listOfStatements.get(i);
                oaclistmt2.clearStmtHandle();
            }
        }
        this._sql_warning = null;
    }

    public void removeoaclistmt(oaclistmt oaclistmt2) {
        this._listOfStatements.remove(oaclistmt2);
    }

    public boolean isClosed() {
        return this._sql_hdbc == 0L;
    }

    protected void finalize() throws Throwable {
        if (oacli.traceOn()) {
            oacli.trace("finalize() called for " + this);
        }
        this.close();
        super.finalize();
        if (oacli.traceOn()) {
            oacli.trace("finalize() done for " + this);
        }
    }

    public native String getTraceFileName();

    public native int getTraceLevel();

    public void saveState() throws oacliexception {
        this._initialAutocommit = this.getAutoCommit();
        this._initialReadonly = this.isReadOnly();
        this._initialCatalog = this.getCatalog();
        this._initialTxnIsolation = this.getTransactionIsolation();
    }

    public void restoreState(boolean bl) throws oacliexception {
        if (!this.inXATransaction()) {
            this.setAutoCommit(this._initialAutocommit, true);
        } else {
            this._localAutocommit = this._initialAutocommit;
        }
        if (!bl) {
            this.setReadOnly(this._initialReadonly);
            this.setCatalog(this._initialCatalog);
            this.setTransactionIsolation(this._initialTxnIsolation);
        }
    }

    public void setAutoCommit(boolean bl, boolean bl2) throws oacliexception {
        if (this.inXATransaction()) {
            throw new oacliexception("Can't change autocommit when enlisted on a global transaction", "25000");
        }
        if (this.getAutoCommit() != bl) {
            if (!bl2 && this.inLocalTransaction()) {
                this.internalCommit();
            }
            oaclistmt oaclistmt2 = this.getSystemStatement();
            oaclistmt2.ExecuteLocked("_OA_SET_INFO SQL_AUTOCOMMIT " + (bl ? "'1'" : "'0'"));
            this.internalSetAutoCommit(bl);
        }
        if (bl) {
            this._transactionLevel = 0;
        }
    }

    public oaclistmt getSystemStatement() throws oacliexception {
        if (this._systemStmt == null) {
            this._systemStmt = this.createStmt();
        }
        return this._systemStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSystemStatement() {
        try {
            if (this._systemStmt != null) {
                this._systemStmt.close();
            }
        }
        catch (oacliexception oacliexception2) {
            if (oacli.traceOn()) {
                oacli.trace("Unexpected error when resetting system statement");
            }
        }
        finally {
            this._systemStmt = null;
        }
    }

    private native void internalSetAutoCommit(boolean var1) throws oacliexception;

    private native void internalCommit() throws oacliexception;

    private native void internalRollback() throws oacliexception;

    public native String getSubProtocol() throws oacliexception;

    public native void setAutoCommit(boolean var1) throws oacliexception;

    public native boolean getAutoCommit() throws oacliexception;

    public native void setReadOnly(boolean var1) throws oacliexception;

    public native boolean isReadOnly() throws oacliexception;

    public native void setCatalog(String var1) throws oacliexception;

    public native String getCatalog() throws oacliexception;

    public native void setTransactionIsolation(int var1) throws oacliexception;

    public native int getTransactionIsolation() throws oacliexception;

    public native String nativeSql(String var1) throws oacliexception;

    public native boolean allProceduresAreCallable() throws oacliexception;

    public native boolean allTablesAreSelectable() throws oacliexception;

    public native String getURL() throws oacliexception;

    public native String getUserName() throws oacliexception;

    public native boolean nullsAreSortedHigh() throws oacliexception;

    public native boolean nullsAreSortedLow() throws oacliexception;

    public native boolean nullsAreSortedAtStart() throws oacliexception;

    public native boolean nullsAreSortedAtEnd() throws oacliexception;

    public native String getDatabaseProductName() throws oacliexception;

    public native String getDatabaseProductVersion() throws oacliexception;

    public native String getDriverName() throws oacliexception;

    public native String getDriverVersion() throws oacliexception;

    public native int getDriverMajorVersion() throws oacliexception;

    public native int getDriverMinorVersion() throws oacliexception;

    public native boolean usesLocalFiles() throws oacliexception;

    public native boolean usesLocalFilePerTable() throws oacliexception;

    public native boolean supportsMixedCaseIdentifiers() throws oacliexception;

    public native boolean storesUpperCaseIdentifiers() throws oacliexception;

    public native boolean storesLowerCaseIdentifiers() throws oacliexception;

    public native boolean storesMixedCaseIdentifiers() throws oacliexception;

    public native boolean supportsMixedCaseQuotedIdentifiers() throws oacliexception;

    public native boolean storesUpperCaseQuotedIdentifiers() throws oacliexception;

    public native boolean storesLowerCaseQuotedIdentifiers() throws oacliexception;

    public native boolean storesMixedCaseQuotedIdentifiers() throws oacliexception;

    public native String getIdentifierQuoteString() throws oacliexception;

    public native String getSQLKeywords() throws oacliexception;

    public native String getNumericFunctions() throws oacliexception;

    public native String getStringFunctions() throws oacliexception;

    public native String getSystemFunctions() throws oacliexception;

    public native String getTimeDateFunctions() throws oacliexception;

    public native String getSearchStringEscape() throws oacliexception;

    public native String getExtraNameCharacters() throws oacliexception;

    public native boolean supportsAlterTableWithAddColumn() throws oacliexception;

    public native boolean supportsAlterTableWithDropColumn() throws oacliexception;

    public native boolean supportsColumnAliasing() throws oacliexception;

    public native boolean nullPlusNonNullIsNull() throws oacliexception;

    public native boolean supportsConvert() throws oacliexception;

    public native boolean supportsSpecificConvert(int var1, int var2) throws oacliexception;

    public native boolean supportsTableCorrelationNames() throws oacliexception;

    public native boolean supportsDifferentTableCorrelationNames() throws oacliexception;

    public native boolean supportsExpressionsInOrderBy() throws oacliexception;

    public native boolean supportsOrderByUnrelated() throws oacliexception;

    public native boolean supportsGroupBy() throws oacliexception;

    public native boolean supportsGroupByUnrelated() throws oacliexception;

    public native boolean supportsGroupByBeyondSelect() throws oacliexception;

    public native boolean supportsLikeEscapeClause() throws oacliexception;

    public native boolean supportsMultipleResultSets() throws oacliexception;

    public native boolean supportsMultipleTransactions() throws oacliexception;

    public native boolean supportsNonNullableColumns() throws oacliexception;

    public native boolean supportsMinimumSQLGrammar() throws oacliexception;

    public native boolean supportsCoreSQLGrammar() throws oacliexception;

    public native boolean supportsExtendedSQLGrammar() throws oacliexception;

    public native boolean supportsANSI92EntryLevelSQL() throws oacliexception;

    public native boolean supportsANSI92IntermediateSQL() throws oacliexception;

    public native boolean supportsANSI92FullSQL() throws oacliexception;

    public native boolean supportsIntegrityEnhancementFacility() throws oacliexception;

    public native boolean supportsOuterJoins() throws oacliexception;

    public native boolean supportsFullOuterJoins() throws oacliexception;

    public native boolean supportsLimitedOuterJoins() throws oacliexception;

    public native String getSchemaTerm() throws oacliexception;

    public native String getProcedureTerm() throws oacliexception;

    public native String getCatalogTerm() throws oacliexception;

    public native boolean isCatalogAtStart() throws oacliexception;

    public native String getCatalogSeparator() throws oacliexception;

    public native boolean supportsSchemasInDataManipulation() throws oacliexception;

    public native boolean supportsSchemasInProcedureCalls() throws oacliexception;

    public native boolean supportsSchemasInTableDefinitions() throws oacliexception;

    public native boolean supportsSchemasInIndexDefinitions() throws oacliexception;

    public native boolean supportsSchemasInPrivilegeDefinitions() throws oacliexception;

    public native boolean supportsCatalogsInDataManipulation() throws oacliexception;

    public native boolean supportsCatalogsInProcedureCalls() throws oacliexception;

    public native boolean supportsCatalogsInTableDefinitions() throws oacliexception;

    public native boolean supportsCatalogsInIndexDefinitions() throws oacliexception;

    public native boolean supportsCatalogsInPrivilegeDefinitions() throws oacliexception;

    public native boolean supportsPositionedDelete() throws oacliexception;

    public native boolean supportsPositionedUpdate() throws oacliexception;

    public native boolean supportsSelectForUpdate() throws oacliexception;

    public native boolean supportsStoredProcedures() throws oacliexception;

    public native boolean supportsSubqueriesInComparisons() throws oacliexception;

    public native boolean supportsSubqueriesInExists() throws oacliexception;

    public native boolean supportsSubqueriesInIns() throws oacliexception;

    public native boolean supportsSubqueriesInQuantifieds() throws oacliexception;

    public native boolean supportsCorrelatedSubqueries() throws oacliexception;

    public native boolean supportsUnion() throws oacliexception;

    public native boolean supportsUnionAll() throws oacliexception;

    public native boolean supportsOpenCursorsAcrossCommit() throws oacliexception;

    public native boolean supportsOpenCursorsAcrossRollback() throws oacliexception;

    public native boolean supportsOpenStatementsAcrossCommit() throws oacliexception;

    public native boolean supportsOpenStatementsAcrossRollback() throws oacliexception;

    public native int getMaxBinaryLiteralLength() throws oacliexception;

    public native int getMaxCharLiteralLength() throws oacliexception;

    public native int getMaxColumnNameLength() throws oacliexception;

    public native int getMaxColumnsInGroupBy() throws oacliexception;

    public native int getMaxColumnsInIndex() throws oacliexception;

    public native int getMaxColumnsInOrderBy() throws oacliexception;

    public native int getMaxColumnsInSelect() throws oacliexception;

    public native int getMaxColumnsInTable() throws oacliexception;

    public native int getMaxConnections() throws oacliexception;

    public native int getMaxCursorNameLength() throws oacliexception;

    public native int getMaxIndexLength() throws oacliexception;

    public native int getMaxSchemaNameLength() throws oacliexception;

    public native int getMaxProcedureNameLength() throws oacliexception;

    public native int getMaxCatalogNameLength() throws oacliexception;

    public native int getMaxRowSize() throws oacliexception;

    public native boolean doesMaxRowSizeIncludeBlobs() throws oacliexception;

    public native int getMaxStatementLength() throws oacliexception;

    public native int getMaxStatements() throws oacliexception;

    public native int getMaxTableNameLength() throws oacliexception;

    public native int getMaxTablesInSelect() throws oacliexception;

    public native int getMaxUserNameLength() throws oacliexception;

    public native int getDefaultTransactionIsolation() throws oacliexception;

    public native boolean supportsTransactions() throws oacliexception;

    public native boolean supportsTransactionIsolationLevel(int var1) throws oacliexception;

    public native boolean supportsDataDefinitionAndDataManipulationTransactions() throws oacliexception;

    public native boolean supportsDataManipulationTransactionsOnly() throws oacliexception;

    public native boolean dataDefinitionCausesTransactionCommit() throws oacliexception;

    public native boolean dataDefinitionIgnoredInTransactions() throws oacliexception;

    public native boolean isConnected();

    public native boolean getAutoClose() throws oacliexception;

    public void commit() throws oacliexception {
        if (this.inXATransaction()) {
            throw new oacliexception("No local commit supported when in a distributed transaction", "2D000");
        }
        if (this.getAutoCommit()) {
            throw new oacliexception("Can't use explict commit when autocommit is true", "2D000");
        }
        if (this.inLocalTransaction()) {
            this.internalCommit();
        }
    }

    public void rollback() throws oacliexception {
        if (this.inXATransaction()) {
            throw new oacliexception("No local rollback supported when in a distributed transaction", "2D000");
        }
        if (this.getAutoCommit()) {
            throw new oacliexception("Can't use explict rollback when autocommit is true", "2D000");
        }
        if (this.inLocalTransaction()) {
            this.internalRollback();
        }
    }

    public oaclistmt createStmt() throws oacliexception {
        oaclistmt oaclistmt2 = new oaclistmt(this._sql_hdbc, this);
        this._listOfStatements.add(oaclistmt2);
        oaclistmt2.createStmt();
        return oaclistmt2;
    }

    public oaclistmt createStmt(String string) throws oacliexception {
        oaclistmt oaclistmt2 = new oaclistmt(this._sql_hdbc, this);
        this._listOfStatements.add(oaclistmt2);
        oaclistmt2.doPrepareAndSaveQuery(string);
        return oaclistmt2;
    }

    public oacliwarning getWarnings() {
        return this._sql_warning;
    }

    public void setNextWarning(oacliwarning oacliwarning2) {
        if (oacli.traceOn()) {
            oacli.trace("setNextWarning(oacliwarning) called on connection");
        }
        if (this._sql_warning == null) {
            this._sql_warning = oacliwarning2;
        } else {
            this._sql_warning.setNextWarning(oacliwarning2);
        }
        if (oacli.traceOn()) {
            oacli.trace("setNextWarning(oacliwarning) return");
        }
    }

    public void clearWarnings() {
        this._sql_warning = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lock(boolean bl) throws oacliexception {
        if (this._XAConnection == null) {
            return 0;
        }
        Object object = this._lock;
        synchronized (object) {
            try {
                if (bl) {
                    if (this._lockcount == 0) {
                        this._lockcount = -1;
                        if (oacli.traceOn()) {
                            oacli.trace("lock: Lock taken by XA. oacli =" + this);
                        }
                    }
                } else if (this._lockcount >= 0) {
                    ++this._lockcount;
                    if (oacli.traceOn()) {
                        oacli.trace("lock: Lock taken by normal sql. Count = " + this._lockcount + " oacli =" + this);
                    }
                }
            }
            catch (Exception exception) {
                if (oacli.traceOn()) {
                    oacli.trace("lock: Unexpcted error in locking " + exception.getMessage() + " oacli " + this);
                }
                this.markConnectionAsBad();
                throw new oacliexception("Connection lost", "08S01");
            }
            return this._lockcount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unlock(boolean bl) throws oacliexception {
        if (this._XAConnection == null) {
            return 0;
        }
        Object object = this._lock;
        synchronized (object) {
            block12: {
                try {
                    if (bl) {
                        if (this._lockcount == -1) {
                            this._lockcount = 0;
                            if (oacli.traceOn()) {
                                oacli.trace("unlock: Lock released by XA. oacli =" + this);
                            }
                            break block12;
                        }
                        throw new Exception("unlock: Internal logic error, oacli not locked (XA)");
                    }
                    if (this._lockcount > 0) {
                        --this._lockcount;
                        if (oacli.traceOn()) {
                            oacli.trace("unlock: Lock released by normal sql. Count = " + this._lockcount + " oacli =" + this);
                        }
                        break block12;
                    }
                    throw new Exception("Internal logic error, oacli not locked (normal)");
                }
                catch (Exception exception) {
                    if (oacli.traceOn()) {
                        oacli.trace("unlock: Unexpcted error in locking " + exception.getMessage() + " oacli " + this);
                    }
                    this.markConnectionAsBad();
                    throw new oacliexception("Connection lost", "08S01");
                }
            }
            return this._lockcount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterLocked() throws oacliexception {
        while (this.lock(false) < 0) {
            oaxaconnection oaxaconnection2 = this._XAConnection;
            synchronized (oaxaconnection2) {
                if (oacli.traceOn()) {
                    oacli.trace("enterLocked: Wait for XAConnection ended, oacli =" + this);
                }
            }
        }
    }

    public void exitLocked() throws oacliexception {
        this.unlock(false);
    }

    public boolean inTransaction() {
        return this.inXATransaction() || this.inLocalTransaction();
    }

    public void setXaTransaction(boolean bl) {
        this._inXATransaction = bl;
    }

    public boolean inLocalTransaction() {
        return this._transactionLevel > 0 && !this.inXATransaction();
    }

    public boolean inXATransaction() {
        return this._inXATransaction;
    }

    public void handleXAautocommit(boolean bl) throws oacliexception {
        if (bl) {
            this._localAutocommit = this.getAutoCommit();
            if (this._localAutocommit) {
                this.internalSetAutoCommit(false);
            }
        } else if (this._localAutocommit != this.getAutoCommit()) {
            this.internalSetAutoCommit(this._localAutocommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public oacli getXaCli() throws oacliexception {
        if (oacli.traceOn()) {
            oacli.trace("getXaCli: Invoked for to get an oacli for " + this + " ConnectionId=" + this._rec._connectionId);
        }
        oacli oacli2 = null;
        if (oacli.traceOn()) {
            oacli.trace("getXaCli: attempting to locate a suitable oacli for ConnectionId=" + this._rec._connectionId);
        }
        HashMap hashMap = _xaclis;
        synchronized (hashMap) {
            oacli2 = (oacli)_xaclis.get(this._rec._connectionId);
        }
        if (oacli2 == null) {
            if (oacli.traceOn()) {
                oacli.trace("getXaCli: no suitable oacli for ConnectionId = " + this._rec._connectionId + ", creating new");
            }
            oacli2 = new oacli(this._xaOptions, false);
            try {
                oacli2.openConnectionInt("XA_RECOVERY", "XA_RECOVERY", this._rec._database, this._rec._custom, this._rec._connectionId, false, false, false, false, false, 0, false, 0, false, 0);
            }
            catch (oacliexception oacliexception2) {
                try {
                    oacli2.close();
                }
                catch (oacliexception oacliexception3) {
                    // empty catch block
                }
                if (oacli.traceOn()) {
                    oacli.trace("getXaCli: Failed to create special oacli object for ConnectionId = " + this._rec._connectionId);
                }
                throw new oacliexception("Connection error", "08S01");
            }
            hashMap = _xaclis;
            synchronized (hashMap) {
                oacli oacli3 = (oacli)_xaclis.get(this._rec._connectionId);
                if (oacli3 != null) {
                    if (oacli.traceOn()) {
                        oacli.trace("getXaCli: Race condition detected, two oacli created for connectionId= " + this._rec._connectionId + " removing " + oacli2 + " keeping " + oacli3);
                    }
                    try {
                        oacli2.close();
                    }
                    catch (oacliexception oacliexception4) {
                        // empty catch block
                    }
                    oacli2 = oacli3;
                } else {
                    if (oacli.traceOn()) {
                        oacli.trace("getXaCli: Saving created oacli " + this + " for connectionId= " + this._rec._connectionId);
                    }
                    _xaclis.put(this._rec._connectionId, oacli2);
                }
                if (_xaclis.size() > 0) {
                    oacli.xaTimer();
                }
            }
        }
        oacli2.setSpecialOwner(this._XAConnection);
        oacli2._xaOptions = this._xaOptions;
        oacli2._lastUsedXa = System.currentTimeMillis();
        if (oacli.traceOn()) {
            oacli.trace("getXaCli: Returing cli " + oacli2 + " ConnectionId=" + oacli2._rec._connectionId);
        }
        return oacli2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeXaCli() {
        oacli oacli2 = null;
        HashMap hashMap = _xaclis;
        synchronized (hashMap) {
            oacli2 = (oacli)_xaclis.get(this._rec._connectionId);
            if (oacli2 != null) {
                _xaclis.put(this._rec._connectionId, null);
            }
            if (_xaclis.size() < 1) {
                oacli.xaTimer();
            }
        }
        if (oacli2 != null) {
            try {
                oacli2.close();
            }
            catch (oacliexception oacliexception2) {
                // empty catch block
            }
            if (oacli.traceOn()) {
                oacli.trace("getXaCli: Removed the oacli object for ConnectionId = " + this._rec._connectionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xaTimer() {
        HashMap hashMap = _xaclis;
        synchronized (hashMap) {
            if (_xaclis.size() > 0) {
                if (_xaTimer == null) {
                    if (oacli.traceOn()) {
                        oacli.trace("xaTimer: Starting timer");
                    }
                    _xaTimer = new Timer();
                    _xaTimer.scheduleAtFixedRate(new TimerTask(){

                        public void run() {
                            oacli.cleanXaCli();
                        }
                    }, 60000L, 60000L);
                }
            } else if (_xaTimer != null) {
                if (oacli.traceOn()) {
                    oacli.trace("xaTimer: Stopping timer");
                }
                _xaTimer.cancel();
                _xaTimer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanXaCli() {
        block13: {
            LinkedList<oacli> linkedList = new LinkedList<oacli>();
            try {
                oacli oacli2;
                Iterator<Object> iterator;
                long l = System.currentTimeMillis();
                if (oacli.traceOn()) {
                    oacli.trace("cleanXaCli: started at " + l);
                }
                HashMap hashMap = _xaclis;
                synchronized (hashMap) {
                    if (_xaclis != null && !_xaclis.isEmpty()) {
                        iterator = _xaclis.values().iterator();
                        while (iterator.hasNext()) {
                            oacli2 = (oacli)iterator.next();
                            if (l <= oacli2._lastUsedXa + 120000L) continue;
                            linkedList.add(oacli2);
                            iterator.remove();
                        }
                    }
                    oacli.xaTimer();
                }
                iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    oacli2 = (oacli)iterator.next();
                    if (oacli.traceOn()) {
                        oacli.trace("cleanXaCli: closing oacli " + oacli2 + " last used at " + oacli2._lastUsedXa);
                    }
                    try {
                        oacli2.close();
                    }
                    catch (oacliexception oacliexception2) {}
                }
            }
            catch (Exception exception) {
                if (!oacli.traceOn()) break block13;
                oacli.trace("cleanXaCli: Execption during cleanup: " + exception.getMessage());
            }
        }
        if (oacli.traceOn()) {
            oacli.trace("cleanXaCli: ended at " + System.currentTimeMillis());
        }
    }

    public void initTrace() {
        block2: {
            try {
                this.initCLI();
                oacli.SetTraceInfo(this.getTraceLevel(), this.getTraceFileName());
                this.freeCLI();
            }
            catch (Exception exception) {
                if (!oacli.traceOn()) break block2;
                oacli.trace("cleanXaCli: Execption in initTrace: " + exception.getMessage());
            }
        }
    }

    static {
        System.loadLibrary("oajdbc");
        oacli.initStaticVarsCLI();
        _xaclis = new HashMap();
        _xaTimer = null;
    }

    private class reconnect {
        String _database = null;
        String _custom = null;
        String _connectionId = null;
        String _login;
        String _passwd;
        boolean _traceSet;
        boolean _trace;
        boolean _readonlySet;
        boolean _readOnly;
        boolean _queryTimeoutSet;
        int _queryTimeout;
        boolean _logonTimeoutSet;
        int _loginTimeout;
        boolean _isolationLevelSet;
        int _isolationLevel;

        private reconnect() {
        }

        void Reconnect() throws oacliexception {
            if (oacli.traceOn()) {
                oacli.trace("oacli:(re)connect invoked for " + this);
            }
            oacli.this.internalClose();
            oacli.this.initCLI();
            oacli.this.removeXaCli();
            oacli.this.openConnectionWithProperties(this._login, this._passwd, this._database, this._custom, this._traceSet, this._trace, this._readonlySet, this._readOnly, this._queryTimeoutSet, this._queryTimeout, this._logonTimeoutSet, this._loginTimeout, this._isolationLevelSet, this._isolationLevel);
            for (int i = 0; i < oacli.this._listOfStatements.size(); ++i) {
                oaclistmt oaclistmt2 = (oaclistmt)oacli.this._listOfStatements.get(i);
                oaclistmt2.Reconnect(oacli.this._sql_hdbc);
            }
        }
    }
}

