/*
 * Decompiled with CFR 0.152.
 */
package jdbc.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import jdbc.sql.cli.oacli;
import jdbc.sql.oabaseconnection;
import jdbc.sql.oaprepstatement;

public class oacallablestatement
extends oaprepstatement
implements CallableStatement {
    private int _iWasNull;

    protected oacallablestatement(Connection connection, String string, oacli oacli2, oabaseconnection oabaseconnection2) throws SQLException {
        super(connection, string, oacli2, oabaseconnection2);
        if (oacallablestatement.traceOn()) {
            oacallablestatement.trace("oacallablestatement(" + connection + ",sql) called");
        }
        this._iWasNull = -1;
        if (oacallablestatement.traceOn()) {
            oacallablestatement.trace("oacallablestatement() returns");
        }
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.throwErrorWhenClosed();
        this.registerOutParameter(n, n2, 0);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.throwErrorWhenClosed();
        this._oaCLIStmt.registerOutParameter(n, n2, n3);
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.throwErrorWhenClosed();
        throw new SQLException("registerOutParameter(int,int,String) not yet supported.");
    }

    public boolean wasNull() throws SQLException {
        this.throwErrorWhenClosed();
        boolean bl = this._iWasNull == -1 ? this._oaCLIStmt.wasParamNull() : this._iWasNull == 1;
        return bl;
    }

    public String getString(int n) throws SQLException {
        String string = null;
        this.throwErrorWhenClosed();
        string = this._oaCLIStmt.getParamString(n);
        this._iWasNull = string == null ? 1 : 0;
        return string;
    }

    public boolean getBoolean(int n) throws SQLException {
        this.throwErrorWhenClosed();
        String string = this._oaCLIStmt.getParamString(n);
        int n2 = this._iWasNull = string == null ? 1 : 0;
        return string != null && !string.equals("") && !string.equals("0");
    }

    public byte getByte(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0;
        }
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("getByte failed: " + numberFormatException.getMessage(), "22000", 0);
        }
    }

    public short getShort(int n) throws SQLException {
        this.throwErrorWhenClosed();
        this._iWasNull = -1;
        return this._oaCLIStmt.getParamShort(n);
    }

    public int getInt(int n) throws SQLException {
        this.throwErrorWhenClosed();
        this._iWasNull = -1;
        return this._oaCLIStmt.getParamInt(n);
    }

    public long getLong(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("getLong failed: " + numberFormatException.getMessage(), "22000", 0);
        }
    }

    public float getFloat(int n) throws SQLException {
        this.throwErrorWhenClosed();
        this._iWasNull = -1;
        return this._oaCLIStmt.getParamFloat(n);
    }

    public double getDouble(int n) throws SQLException {
        this.throwErrorWhenClosed();
        this._iWasNull = -1;
        return this._oaCLIStmt.getParamDouble(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            BigDecimal bigDecimal;
            try {
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("getBigDecimal failed: " + numberFormatException.getMessage(), "22000", 0);
            }
            if (n2 < 0) {
                return bigDecimal;
            }
            try {
                return bigDecimal.setScale(n2);
            }
            catch (ArithmeticException arithmeticException) {
                throw new SQLException("getBigDecimal failed: " + arithmeticException.getMessage(), "22000", 0);
            }
        }
        return null;
    }

    public byte[] getBytes(int n) throws SQLException {
        this.throwErrorWhenClosed();
        byte[] byArray = this._oaCLIStmt.getParamBytes(n);
        int n2 = this._iWasNull = byArray == null ? 1 : 0;
        if (byArray == null) {
            return null;
        }
        return byArray;
    }

    public Date getDate(int n) throws SQLException {
        return this.getDate(n, null);
    }

    public Time getTime(int n) throws SQLException {
        return this.getTime(n, null);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, null);
    }

    public Object getObject(int n) throws SQLException {
        Comparable<Boolean> comparable;
        this.throwErrorWhenClosed();
        int n2 = this._oaCLIStmt.getParamType(n);
        switch (n2) {
            case -7: {
                comparable = new Boolean(this.getBoolean(n));
                break;
            }
            case -6: {
                comparable = new Integer(this.getByte(n));
                break;
            }
            case 5: {
                comparable = new Integer(this.getShort(n));
                break;
            }
            case 4: {
                comparable = new Integer(this.getInt(n));
                break;
            }
            case -5: {
                comparable = new Long(this.getLong(n));
                break;
            }
            case 7: {
                comparable = new Float(this.getFloat(n));
                break;
            }
            case 6: 
            case 8: {
                comparable = new Double(this.getDouble(n));
                break;
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(n);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n, null);
            }
            case 92: {
                return this.getTime(n, null);
            }
            case 93: {
                return this.getTimestamp(n, null);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
            default: {
                throw new SQLException("Unsupported data type: " + n2, "22000", 0);
            }
        }
        return this.wasNull() ? null : comparable;
    }

    public Array getArray(int n) throws SQLException {
        if (oacallablestatement.traceOn()) {
            oacallablestatement.trace("getArray(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        if (oacallablestatement.traceOn()) {
            oacallablestatement.trace("getArray() returns null");
        }
        return null;
    }

    public Blob getBlob(int n) throws SQLException {
        if (oacallablestatement.traceOn()) {
            oacallablestatement.trace("getBlob(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        if (oacallablestatement.traceOn()) {
            oacallablestatement.trace("getBlob() returns null");
        }
        return null;
    }

    public Clob getClob(int n) throws SQLException {
        if (oacallablestatement.traceOn()) {
            oacallablestatement.trace("getClob(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        if (oacallablestatement.traceOn()) {
            oacallablestatement.trace("getClob() returns null");
        }
        return null;
    }

    public Ref getRef(int n) throws SQLException {
        if (oacallablestatement.traceOn()) {
            oacallablestatement.trace("getRef(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        if (oacallablestatement.traceOn()) {
            oacallablestatement.trace("getRef() returns null");
        }
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, -1);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.throwErrorWhenClosed();
        Calendar calendar2 = calendar == null ? Calendar.getInstance() : (Calendar)calendar.clone();
        int[] nArray = this._oaCLIStmt.getParamDate(n);
        int n2 = this._iWasNull = nArray == null ? 1 : 0;
        if (nArray != null) {
            calendar2.set(14, 0);
            calendar2.set(nArray[0], nArray[1] - 1, nArray[2], 0, 0, 0);
            long l = calendar2.getTime().getTime();
            Date date = new Date(l);
            return date;
        }
        return null;
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.throwErrorWhenClosed();
        Calendar calendar2 = calendar == null ? Calendar.getInstance() : (Calendar)calendar.clone();
        int[] nArray = this._oaCLIStmt.getParamTime(n);
        int n2 = this._iWasNull = nArray == null ? 1 : 0;
        if (nArray != null) {
            calendar2.set(14, 0);
            calendar2.set(1970, 0, 1, nArray[0], nArray[1], nArray[2]);
            long l = calendar2.getTime().getTime();
            Time time = new Time(l);
            return time;
        }
        return null;
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.throwErrorWhenClosed();
        Calendar calendar2 = calendar == null ? Calendar.getInstance() : (Calendar)calendar.clone();
        int[] nArray = this._oaCLIStmt.getParamTimestamp(n);
        int n2 = this._iWasNull = nArray == null ? 1 : 0;
        if (nArray != null) {
            calendar2.set(14, 0);
            calendar2.set(nArray[0], nArray[1] - 1, nArray[2], nArray[3], nArray[4], nArray[5]);
            long l = calendar2.getTime().getTime();
            Timestamp timestamp = new Timestamp(l);
            timestamp.setNanos(nArray[6]);
            return timestamp;
        }
        return null;
    }

    public Object getObject(int n, Map map) throws SQLException {
        if (oacallablestatement.traceOn()) {
            oacallablestatement.trace("getObject(" + n + "," + map + ") called");
        }
        this.throwErrorWhenClosed();
        if (oacallablestatement.traceOn()) {
            oacallablestatement.trace("getObject() returns null");
        }
        return null;
    }

    public URL getURL(int n) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return null;
    }

    public void setURL(String string, URL uRL) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setNull(String string, int n) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setByte(String string, byte by) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setShort(String string, short s) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setInt(String string, int n) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setLong(String string, long l) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setFloat(String string, float f) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setDouble(String string, double d) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setString(String string, String string2) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setDate(String string, Date date) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setTime(String string, Time time) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setObject(String string, Object object) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public String getString(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return null;
    }

    public boolean getBoolean(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return false;
    }

    public byte getByte(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return 0;
    }

    public short getShort(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return 0;
    }

    public int getInt(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return 0;
    }

    public long getLong(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return 0L;
    }

    public float getFloat(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return 0.0f;
    }

    public double getDouble(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return 0.0;
    }

    public byte[] getBytes(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return null;
    }

    public Date getDate(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return null;
    }

    public Time getTime(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return null;
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return null;
    }

    public Object getObject(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return null;
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return null;
    }

    public Object getObject(String string, Map map) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return null;
    }

    public Ref getRef(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return null;
    }

    public Blob getBlob(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return null;
    }

    public Clob getClob(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return null;
    }

    public Array getArray(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return null;
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return null;
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return null;
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return null;
    }

    public URL getURL(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return null;
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }
}

