# ilinux environment specific script for Korn shell
# RELEASE BUILD
#
#
# Usage:
#
#    . ./config/{platform}/setenv.ksh
#
#
# This file must be run before any of the makefiles
# are executed in this directory structure.  This script
# sets the local environment, so each window (shell)
# must have this script sourced before compiling.

export PORTDEPS_DIR_NAME=ilinux
export OA_ARCHITECTURE=_x86_64
export OA_ROOT=`pwd`
export ENV_MAKEFILE=$OA_ROOT/config/$PORTDEPS_DIR_NAME/env.mk
export NO_UNICODE=n

if [ "$CLASSPATH" = "" ]; 
then
	export CLASSPATH=.:$OA_ROOT/jdbc/oadriver.jar
else
	export CLASSPATH=.:$OA_ROOT/jdbc/oadriver.jar:$CLASSPATH
fi

if [ "$LD_LIBRARY_PATH" = "" ]; 
then
	export LD_LIBRARY_PATH=$OA_ROOT/lib/$PORTDEPS_DIR_NAME
else
	export LD_LIBRARY_PATH=$OA_ROOT/lib/$PORTDEPS_DIR_NAME:$LD_LIBRARY_PATH
fi

export ODBCINI=$OA_ROOT/config/$PORTDEPS_DIR_NAME/odbc.ini

#Flags related to NO_UNICODE=n
export NO_UNICODE_FLAGS="" 
export UNICODE_SYS_LIB=
export OA_ODBC_CFLAGS=-DODBCVER=0x0351

if [ ! -e $ENV_MAKEFILE ] 
then
	echo ""
	echo "ERROR: Please change to the root of your installation"
	echo "       before sourcing this file."
	echo ""
	echo "Example:"
	echo "    $ cd /usr/odbcddk"
	echo "    $ . ./config/$PORTDEPS_DIR_NAME/setenv.sh"
	echo ""
else
	export OPENRDA_INI=$OA_ROOT/config/$PORTDEPS_DIR_NAME/openrda.ini
	export SEP=/

	echo ""
	echo "OpenRDA Environment Configuration"
	echo ""
	echo "   Build: RELEASE (Unicode)"
	echo "Platform: $PORTDEPS_DIR_NAME"
	echo "    Root: $OA_ROOT"
	echo "Makefile: $ENV_MAKEFILE"
	echo "     INI: $OPENRDA_INI"
	echo ""
fi
