# Linux environment specific script for C shell
# RELEASE BUILD
#
#
# Usage:
#
#    ./setenv.sh 
#
#
# This file must be run before any of the makefiles
# are executed in this directory structure.  This script
# sets the local environment, so each window (shell)
# must have this script sourced before compiling.

setenv PORTDEPS_DIR_NAME ilinux
setenv OA_ARCHITECTURE _x86_64
setenv OA_ROOT `pwd`
setenv ENV_MAKEFILE $OA_ROOT/config/$PORTDEPS_DIR_NAME/env.mk
setenv NO_UNICODE n

if ($?CLASSPATH == 1) then
        setenv CLASSPATH  .:${OA_ROOT}/jdbc/oadriver.jar:${CLASSPATH}
else
        setenv CLASSPATH  .:${OA_ROOT}/jdbc/oadriver.jar
endif          


if ($?LD_LIBRARY_PATH == 1) then
        setenv LD_LIBRARY_PATH  $OA_ROOT/lib/${PORTDEPS_DIR_NAME}:${LD_LIBRARY_PATH}
else
        setenv LD_LIBRARY_PATH  $OA_ROOT/lib/${PORTDEPS_DIR_NAME}
endif          

setenv ODBCINI	$OA_ROOT/config/$PORTDEPS_DIR_NAME/odbc.ini

#Flags related to NO_UNICODE=n
setenv NO_UNICODE_FLAGS 
setenv UNICODE_SYS_LIB 
setenv OA_ODBC_CFLAGS -DODBCVER=0x0351

if (! -e $ENV_MAKEFILE) then
	echo ""
	echo "ERROR: Please change to the root of your installation"
	echo "       before sourcing this file."
	echo ""
	echo "Example:"
	echo "    % cd /usr/odbcddk"
	echo "    % source config/$PORTDEPS_DIR_NAME/setenv.sh"
	echo ""
else
	setenv OPENRDA_INI $OA_ROOT/config/$PORTDEPS_DIR_NAME/openrda.ini
	setenv SEP /

	echo ""
	echo "OpenRDA Environment Configuration"
	echo ""
	echo "   Build: RELEASE (Unicode)"
	echo "Platform: $PORTDEPS_DIR_NAME"
	echo "    Root: $OA_ROOT"
	echo "Makefile: $ENV_MAKEFILE"
	echo "     INI: $OPENRDA_INI"
	echo ""
endif

