#include <stdio.h>
#include <string.h>
#include "sql.h"
#include "sqlext.h"

#define MAX_QUERY_SIZE 128
#define MAX_RESULT_SIZE 64
#define MAXFSIZE 20
#define MAXBINDS 20

HENV henv=SQL_NULL_HENV;
HDBC hdbc=SQL_NULL_HDBC;


int printerror(void) {

	RETCODE returncode;
	UCHAR szSQLState[SQL_MAX_MESSAGE_LENGTH - 1];
	SDWORD pfNativeError;
	UCHAR szErrorMsg[SQL_MAX_MESSAGE_LENGTH - 1];
	SWORD pcbErrorMsg;

	while (1) {
		pcbErrorMsg = SQL_MAX_MESSAGE_LENGTH - 1;
		returncode = SQLError( henv, hdbc, SQL_NULL_HSTMT, szSQLState, &pfNativeError, szErrorMsg, sizeof(szErrorMsg), &pcbErrorMsg );
		if ((returncode == SQL_NO_DATA_FOUND) ||
		    (returncode == SQL_ERROR) ||
		    (returncode == SQL_INVALID_HANDLE)) {
			break;
		}

		printf( "[%s] [0x%lx] %s\n", szSQLState, pfNativeError, szErrorMsg );
	} /* end while */

	return 1;
}


int openconnect(char *szDsn, char *szLogin, char *szPassword)
{
	RETCODE returncode;

	returncode = SQLAllocConnect(henv,&hdbc);

	if(returncode==SQL_SUCCESS)
	    returncode = SQLConnect(hdbc,(unsigned char *)szDsn,SQL_NTS,
					(unsigned char *)szLogin,SQL_NTS,
					(unsigned char *)szPassword,SQL_NTS);	
	if(returncode!=SQL_SUCCESS) {
		printerror( );
		return 0;
	}
	else
		return 1;
}


int closeconnect()
{
	RETCODE returncode;
	
	returncode=SQLDisconnect(hdbc);
	returncode=SQLFreeConnect(hdbc);

	if(returncode!=SQL_SUCCESS)
		return 0;
	else
		return 1;
}


int main(int argc, char *argv[])
{
	char szDsn[128] ="" ,szLogin[128] ="",szPassword[128] = "";
	int count,i;
	RETCODE returncode;

	printf(" Starting Test...\n");

        /* get command line arguments */
	if( argc < 3 ){
		printf("Invalid syntax: multiconnect datasource count userName password \n");
	return 1;
	}

	if( argc > 1 )
		strcpy( szDsn, argv[1] );
	
	if( argc > 2 )
		count=atoi(argv[2] );
	
	
	if( argc > 3 )
		strcpy( szLogin, argv[3] );
	
	if( argc > 4 )
		strcpy( szPassword, argv[4] );

	returncode = SQLAllocEnv(&henv);
	if(returncode!=SQL_SUCCESS)
		return 1;

	for(i=0;i<count;i++)
	{
		if(!openconnect(szDsn,szLogin,szPassword))
			printf("\nConnect failure\n");

#if 0
		if(i == 0)
		{
			/* Print DM info
			*/
			char szDmVerInfo[128];

			szDmVerInfo[0] = '\0';
			returncode = SQLGetInfo(hdbc,SQL_ODBC_VER,szDmVerInfo,sizeof(szDmVerInfo),NULL);
			if(returncode == SQL_SUCCESS)
				printf("Driver Manager Version (SQL_ODBC_VER) = %s\n",szDmVerInfo);
			else
			{
				printf("Couldn't get Driver Manager Version (SQL_ODBC_VER). Error code=%d\n",returncode);
				printerror();
			}
		}
#endif

		printf("\nconnection %d\n",i);
		if(!closeconnect())
			printf("\nDisConnect failure\n");
	}
	
	returncode=SQLFreeEnv(henv);
	return 0;
}
	
