/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.buffer;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.core.util.ArgCheck;
import java.io.Serializable;

public class TupleSourceID
implements Serializable {
    private static final String LOCATION_SEPARATOR = ":";
    private String idValue;
    private String location;

    public TupleSourceID(String stringID) {
        int index;
        if (stringID == null) {
            ArgCheck.isNotNull(stringID, CommonPlugin.Util.getString("ERR.003.006.0003"));
        }
        if ((index = stringID.indexOf(LOCATION_SEPARATOR)) >= 0) {
            this.location = stringID.substring(0, index);
            this.idValue = stringID.substring(index + 1);
        } else {
            this.location = null;
            this.idValue = stringID;
        }
    }

    public TupleSourceID(String idValue, String location) {
        if (idValue == null) {
            ArgCheck.isNotNull(idValue, CommonPlugin.Util.getString("ERR.003.006.0003"));
        }
        this.idValue = idValue;
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public String getIDValue() {
        return this.idValue;
    }

    public String getStringID() {
        if (this.location == null) {
            return this.idValue;
        }
        return this.location + LOCATION_SEPARATOR + this.idValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TupleSourceID)) {
            return false;
        }
        TupleSourceID other = (TupleSourceID)obj;
        return other.getIDValue().equals(this.getIDValue());
    }

    public int hashCode() {
        return this.idValue.hashCode();
    }

    public String toString() {
        return this.getStringID();
    }
}

