/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import com.metamatrix.common.CommonPlugin;
import java.util.Collection;
import java.util.Map;

public class I18nArgCheck {
    private I18nArgCheck() {
    }

    public static final void isTrue(boolean condition, String messageID) {
        if (!condition) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID));
        }
    }

    public static final void isTrue(boolean condition, String messageID, Object[] messageParams) {
        if (!condition) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID, messageParams));
        }
    }

    public static final void isNonNegative(int value) {
        I18nArgCheck.isNonNegative(value, CommonPlugin.Util.getString("ERR.003.030.0005", value));
    }

    public static final void isNonNegative(int value, String messageID) {
        if (value < 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID));
        }
    }

    public static final void isNonNegative(int value, String messageID, Object[] messageParams) {
        if (value < 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID, messageParams));
        }
    }

    public static final void isNonPositive(int value) {
        I18nArgCheck.isNonPositive(value, CommonPlugin.Util.getString("ERR.003.030.0006", value));
    }

    public static final void isNonPositive(int value, String messageID) {
        if (value > 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID));
        }
    }

    public static final void isNonPositive(int value, String messageID, Object[] messageParams) {
        if (value > 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID, messageParams));
        }
    }

    public static final void isNegative(int value) {
        I18nArgCheck.isNegative(value, CommonPlugin.Util.getString("ERR.003.030.0007", value));
    }

    public static final void isNegative(int value, String messageID) {
        if (value >= 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID));
        }
    }

    public static final void isNegative(int value, String messageID, Object[] messageParams) {
        if (value >= 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID, messageParams));
        }
    }

    public static final void isPositive(int value) {
        I18nArgCheck.isPositive(value, CommonPlugin.Util.getString("ERR.003.030.0008", value));
    }

    public static final void isPositive(int value, String messageID) {
        if (value <= 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID));
        }
    }

    public static final void isPositive(int value, String messageID, Object[] messageParams) {
        if (value <= 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID, messageParams));
        }
    }

    public static final void isNonNegative(long value) {
        I18nArgCheck.isNonNegative(value, CommonPlugin.Util.getString("ERR.003.030.0005", value));
    }

    public static final void isNonNegative(long value, String messageID) {
        if (value < 0L) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID));
        }
    }

    public static final void isNonNegative(long value, String messageID, Object[] messageParams) {
        if (value < 0L) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID, messageParams));
        }
    }

    public static final void isNonPositive(long value) {
        I18nArgCheck.isNonPositive(value, CommonPlugin.Util.getString("ERR.003.030.0006", value));
    }

    public static final void isNonPositive(long value, String messageID) {
        if (value > 0L) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID));
        }
    }

    public static final void isNonPositive(long value, String messageID, Object[] messageParams) {
        if (value > 0L) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID, messageParams));
        }
    }

    public static final void isNegative(long value) {
        I18nArgCheck.isNegative(value, CommonPlugin.Util.getString("ERR.003.030.0007", value));
    }

    public static final void isNegative(long value, String messageID) {
        if (value >= 0L) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID));
        }
    }

    public static final void isNegative(long value, String messageID, Object[] messageParams) {
        if (value >= 0L) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID, messageParams));
        }
    }

    public static final void isPositive(long value) {
        I18nArgCheck.isPositive(value, CommonPlugin.Util.getString("ERR.003.030.0008", value));
    }

    public static final void isPositive(long value, String messageID) {
        if (value <= 0L) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID));
        }
    }

    public static final void isPositive(long value, String messageID, Object[] messageParams) {
        if (value <= 0L) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID, messageParams));
        }
    }

    public static final void isNotZeroLength(String value) {
        I18nArgCheck.isNotZeroLength(value, CommonPlugin.Util.getString("ERR.003.030.0009"));
    }

    public static final void isNotZeroLength(String value, String messageID) {
        I18nArgCheck.isNotNull(value);
        if (value.length() <= 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID));
        }
    }

    public static final void isNotZeroLength(String value, String messageID, Object[] messageParams) {
        I18nArgCheck.isNotNull(value);
        if (value.length() <= 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID, messageParams));
        }
    }

    public static final void isNotNull(Object value) {
        I18nArgCheck.isNotNull(value, CommonPlugin.Util.getString("ERR.003.030.0010"));
    }

    public static final void isNotNull(Object value, String messageID) {
        if (value == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID));
        }
    }

    public static final void isNotNull(Object value, String messageID, Object[] messageParams) {
        if (value == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID, messageParams));
        }
    }

    public static final void isInstanceOf(Class theClass, Object value) {
        I18nArgCheck.isInstanceOf(theClass, value, CommonPlugin.Util.getString("ERR.003.030.0011", theClass.getName()));
    }

    public static final void isInstanceOf(Class theClass, Object value, String messageID) {
        I18nArgCheck.isNotNull(value);
        if (!theClass.isInstance(value)) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID));
        }
    }

    public static final void isInstanceOf(Class theClass, Object value, String messageID, Object[] messageParams) {
        I18nArgCheck.isNotNull(value);
        if (!theClass.isInstance(value)) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID, messageParams));
        }
    }

    public static final void isNotEmpty(Collection collection) {
        I18nArgCheck.isNotEmpty(collection, CommonPlugin.Util.getString("ERR.003.030.0012"));
    }

    public static final void isNotEmpty(Collection collection, String messageID) {
        I18nArgCheck.isNotNull(collection);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID));
        }
    }

    public static final void isNotEmpty(Collection collection, String messageID, Object[] messageParams) {
        I18nArgCheck.isNotNull(collection);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID, messageParams));
        }
    }

    public static final void isNotEmpty(Map map) {
        I18nArgCheck.isNotEmpty(map, CommonPlugin.Util.getString("ERR.003.030.0013"));
    }

    public static final void isNotEmpty(Map map, String messageID) {
        I18nArgCheck.isNotNull(map);
        if (map.isEmpty()) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID));
        }
    }

    public static final void isNotEmpty(Map map, String messageID, Object[] messageParams) {
        I18nArgCheck.isNotNull(map);
        if (map.isEmpty()) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID, messageParams));
        }
    }

    public static final void isNotEmpty(Object[] array) {
        I18nArgCheck.isNotEmpty(array, CommonPlugin.Util.getString("ERR.003.030.0014"));
    }

    public static final void isNotEmpty(Object[] array, String messageID) {
        I18nArgCheck.isNotNull(array);
        if (array.length == 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID));
        }
    }

    public static final void isNotEmpty(Object[] array, String messageID, Object[] messageParams) {
        I18nArgCheck.isNotNull(array);
        if (array.length == 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID, messageParams));
        }
    }

    public static final void isNotEmpty(String string) {
        I18nArgCheck.isNotEmpty(string, CommonPlugin.Util.getString("ERR.003.030.0015"));
    }

    public static final void isNotEmpty(String string, String messageID) {
        I18nArgCheck.isNotNull(string);
        if (string.length() == 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID));
        }
    }

    public static final void isNotEmpty(String string, String messageID, Object[] messageParams) {
        I18nArgCheck.isNotNull(string);
        if (string.length() == 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID, messageParams));
        }
    }

    public static void isNotSame(Object firstObject, String firstName, Object secondObject, String secondName) {
        if (firstObject == secondObject) {
            if (firstName == null) {
                firstName = firstObject == null ? null : firstObject.toString();
            }
            if (secondName == null) {
                secondName = secondObject == null ? null : secondObject.toString();
            }
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.030.0016", firstName, secondName));
        }
    }

    public static final void contains(Collection collection, Object value) {
        I18nArgCheck.contains(collection, value, CommonPlugin.Util.getString("ERR.003.030.0017"));
    }

    public static final void contains(Collection collection, Object value, String messageID) {
        I18nArgCheck.isNotNull(collection);
        if (!collection.contains(value)) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID));
        }
    }

    public static final void contains(Collection collection, Object value, String messageID, Object[] messageParams) {
        I18nArgCheck.isNotNull(collection);
        if (!collection.contains(value)) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID, messageParams));
        }
    }

    public static final void containsKey(Map map, Object key) {
        I18nArgCheck.containsKey(map, key, CommonPlugin.Util.getString("ERR.003.030.0018"));
    }

    public static final void containsKey(Map map, Object key, String messageID) {
        I18nArgCheck.isNotNull(map);
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID));
        }
    }

    public static final void containsKey(Map map, Object key, String messageID, Object[] messageParams) {
        I18nArgCheck.isNotNull(map);
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString(messageID, messageParams));
        }
    }
}

