/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.lang.PredicateCriteria;
import com.metamatrix.query.sql.symbol.Expression;

public abstract class AbstractCompareCriteria
extends PredicateCriteria {
    public static final int EQ = 1;
    public static final int NE = 2;
    public static final int LT = 3;
    public static final int GT = 4;
    public static final int LE = 5;
    public static final int GE = 6;
    private Expression leftExpression;
    private int operator = 1;

    public int getOperator() {
        return this.operator;
    }

    private boolean isValidOperator(int operator) {
        return operator >= 1 && operator <= 6;
    }

    public void setOperator(int operator) {
        if (!this.isValidOperator(operator)) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0001", operator));
        }
        this.operator = operator;
    }

    public static int getOperator(String op) {
        if (op.equals("=")) {
            return 1;
        }
        if (op.equals("<>")) {
            return 2;
        }
        if (op.equals("<>")) {
            return 2;
        }
        if (op.equals("<")) {
            return 3;
        }
        if (op.equals(">")) {
            return 4;
        }
        if (op.equals("<=")) {
            return 5;
        }
        if (op.equals(">=")) {
            return 6;
        }
        return -1;
    }

    public void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public abstract Expression getRightExpression();

    public String getOperatorAsString() {
        switch (this.operator) {
            case 1: {
                return "=";
            }
            case 2: {
                return "<>";
            }
            case 3: {
                return "<";
            }
            case 4: {
                return ">";
            }
            case 5: {
                return "<=";
            }
            case 6: {
                return ">=";
            }
        }
        return "??";
    }
}

