/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateHelperImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

class StateWriter {
    private Map objectTable = new HashMap();
    private ArrayList forcedWrite = new ArrayList();

    StateWriter() {
    }

    private int addToObjectTable(Object object) {
        Integer cur = (Integer)this.objectTable.get(object);
        if (cur != null) {
            return cur;
        }
        this.objectTable.put(object, new Integer(this.objectTable.size()));
        return this.objectTable.size() - 1;
    }

    private int getFromObjectTable(Object object) {
        Object objectResult;
        if (this.objectTable != null && (objectResult = this.objectTable.get(object)) != null) {
            return (Integer)objectResult;
        }
        return -1;
    }

    private boolean writePrefix(Object object, DataOutputStream out) throws IOException {
        if (this.writeIndex(object, out)) {
            return true;
        }
        int index = this.addToObjectTable(object);
        out.writeByte(1);
        out.writeInt(index);
        return false;
    }

    private void writeStateDeprecated(StateImpl state, DataOutputStream out) throws IOException {
        int i;
        state.setSystemExports(null);
        out.write(21);
        if (this.writePrefix(state, out)) {
            return;
        }
        out.writeLong(state.getTimeStamp());
        Dictionary[] propSet = state.getPlatformProperties();
        out.writeInt(propSet.length);
        for (int i2 = 0; i2 < propSet.length; ++i2) {
            Dictionary props = propSet[i2];
            out.writeInt(StateImpl.PROPS.length);
            for (int j = 0; j < StateImpl.PROPS.length; ++j) {
                this.writePlatformProp(props.get(StateImpl.PROPS[j]), out);
            }
        }
        BundleDescription[] bundles = state.getBundles();
        StateHelperImpl.getInstance().sortBundles(bundles);
        out.writeInt(bundles.length);
        if (bundles.length == 0) {
            return;
        }
        for (i = 0; i < bundles.length; ++i) {
            this.writeBundleDescription(bundles[i], out, false);
        }
        out.writeBoolean(state.isResolved());
        out.writeInt(out.size());
        for (i = 0; i < bundles.length; ++i) {
            this.writeBundleDescriptionLazyData(bundles[i], out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveState(StateImpl state, File stateFile, File lazyFile) throws IOException {
        DataOutputStream outLazy = null;
        DataOutputStream outState = null;
        FileOutputStream fosLazy = null;
        FileOutputStream fosState = null;
        try {
            int i;
            int i2;
            state.setSystemExports(null);
            BundleDescription[] bundles = state.getBundles();
            StateHelperImpl.getInstance().sortBundles(bundles);
            for (i2 = 0; i2 < bundles.length; ++i2) {
                this.addToObjectTable(bundles[i2]);
            }
            fosLazy = new FileOutputStream(lazyFile);
            outLazy = new DataOutputStream(fosLazy);
            for (i2 = 0; i2 < bundles.length; ++i2) {
                this.writeBundleDescriptionLazyData(bundles[i2], outLazy);
            }
            fosState = new FileOutputStream(stateFile);
            outState = new DataOutputStream(fosState);
            outState.write(21);
            if (this.writePrefix(state, outState)) {
                return;
            }
            outState.writeLong(state.getTimeStamp());
            Dictionary[] propSet = state.getPlatformProperties();
            outState.writeInt(propSet.length);
            for (i = 0; i < propSet.length; ++i) {
                Dictionary props = propSet[i];
                outState.writeInt(StateImpl.PROPS.length);
                for (int j = 0; j < StateImpl.PROPS.length; ++j) {
                    this.writePlatformProp(props.get(StateImpl.PROPS[j]), outState);
                }
            }
            outState.writeInt(bundles.length);
            if (bundles.length == 0) {
                return;
            }
            for (i = 0; i < bundles.length; ++i) {
                this.writeBundleDescription(bundles[i], outState, true);
            }
            outState.writeBoolean(state.isResolved());
            return;
        }
        finally {
            if (outLazy != null) {
                try {
                    outLazy.flush();
                    fosLazy.getFD().sync();
                }
                catch (IOException e) {}
            }
            try {
                outLazy.close();
            }
            catch (IOException e) {}
            if (outState != null) {
                try {
                    outState.flush();
                    fosState.getFD().sync();
                }
                catch (IOException e) {}
            }
            try {
                outState.close();
            }
            catch (IOException e) {}
        }
    }

    private void writePlatformProp(Object obj, DataOutputStream out) throws IOException {
        if (obj == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            if (obj instanceof String) {
                out.writeInt(1);
                this.writeStringOrNull((String)obj, out);
            } else {
                String[] props = (String[])obj;
                out.writeInt(props.length);
                for (int i = 0; i < props.length; ++i) {
                    this.writeStringOrNull(props[i], out);
                }
            }
        }
    }

    private void writeBundleDescription(BundleDescription bundle, DataOutputStream out, boolean force) throws IOException {
        if (force && !this.forcedWrite.contains(bundle)) {
            int index = this.addToObjectTable(bundle);
            out.writeByte(1);
            out.writeInt(index);
            this.forcedWrite.add(bundle);
        } else if (this.writePrefix(bundle, out)) {
            return;
        }
        out.writeLong(bundle.getBundleId());
        this.writeBaseDescription(bundle, out);
        out.writeInt(((BundleDescriptionImpl)bundle).getLazyDataOffset());
        out.writeInt(((BundleDescriptionImpl)bundle).getLazyDataSize());
        out.writeBoolean(bundle.isResolved());
        out.writeBoolean(bundle.isSingleton());
        out.writeBoolean(bundle.hasDynamicImports());
        out.writeBoolean(bundle.attachFragments());
        out.writeBoolean(bundle.dynamicFragments());
        this.writeHostSpec((HostSpecificationImpl)bundle.getHost(), out, force);
        List dependencies = ((BundleDescriptionImpl)bundle).getBundleDependencies();
        out.writeInt(dependencies.size());
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            this.writeBundleDescription((BundleDescription)iter.next(), out, force);
        }
    }

    private void writeBundleDescriptionLazyData(BundleDescription bundle, DataOutputStream out) throws IOException {
        int dataStart = out.size();
        int index = this.getFromObjectTable(bundle);
        ((BundleDescriptionImpl)bundle).setLazyDataOffset(out.size());
        out.writeInt(index);
        this.writeStringOrNull(bundle.getLocation(), out);
        this.writeStringOrNull(bundle.getPlatformFilter(), out);
        ExportPackageDescription[] exports = bundle.getExportPackages();
        out.writeInt(exports.length);
        for (int i = 0; i < exports.length; ++i) {
            this.writeExportPackageDesc((ExportPackageDescriptionImpl)exports[i], out);
        }
        ImportPackageSpecification[] imports = bundle.getImportPackages();
        out.writeInt(imports.length);
        for (int i = 0; i < imports.length; ++i) {
            this.writeImportPackageSpec(imports[i], out);
        }
        BundleSpecification[] requiredBundles = bundle.getRequiredBundles();
        out.writeInt(requiredBundles.length);
        for (int i = 0; i < requiredBundles.length; ++i) {
            this.writeBundleSpec((BundleSpecificationImpl)requiredBundles[i], out);
        }
        ExportPackageDescription[] selectedExports = bundle.getSelectedExports();
        if (selectedExports == null) {
            out.writeInt(0);
        } else {
            out.writeInt(selectedExports.length);
            for (int i = 0; i < selectedExports.length; ++i) {
                this.writeExportPackageDesc((ExportPackageDescriptionImpl)selectedExports[i], out);
            }
        }
        ExportPackageDescription[] resolvedImports = bundle.getResolvedImports();
        if (resolvedImports == null) {
            out.writeInt(0);
        } else {
            out.writeInt(resolvedImports.length);
            for (int i = 0; i < resolvedImports.length; ++i) {
                this.writeExportPackageDesc((ExportPackageDescriptionImpl)resolvedImports[i], out);
            }
        }
        BundleDescription[] resolvedRequires = bundle.getResolvedRequires();
        if (resolvedRequires == null) {
            out.writeInt(0);
        } else {
            out.writeInt(resolvedRequires.length);
            for (int i = 0; i < resolvedRequires.length; ++i) {
                this.writeBundleDescription(resolvedRequires[i], out, false);
            }
        }
        ((BundleDescriptionImpl)bundle).setLazyDataSize(out.size() - dataStart);
    }

    private void writeBundleSpec(BundleSpecificationImpl bundle, DataOutputStream out) throws IOException {
        this.writeVersionConstraint(bundle, out);
        this.writeBundleDescription((BundleDescription)bundle.getSupplier(), out, false);
        out.writeBoolean(bundle.isExported());
        out.writeBoolean(bundle.isOptional());
    }

    private void writeExportPackageDesc(ExportPackageDescriptionImpl exportPackageDesc, DataOutputStream out) throws IOException {
        if (this.writePrefix(exportPackageDesc, out)) {
            return;
        }
        this.writeBaseDescription(exportPackageDesc, out);
        out.writeBoolean(exportPackageDesc.isRoot());
        this.writeMap(out, exportPackageDesc.getAttributes());
        this.writeMap(out, exportPackageDesc.getDirectives());
    }

    private void writeMap(DataOutputStream out, Map source) throws IOException {
        if (source == null) {
            out.writeInt(0);
        } else {
            out.writeInt(source.size());
            Iterator iter = source.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = source.get(key);
                this.writeStringOrNull(key, out);
                if (value instanceof String) {
                    out.writeByte(0);
                    this.writeStringOrNull((String)value, out);
                    continue;
                }
                if (value instanceof String[]) {
                    out.writeByte(1);
                    this.writeList(out, (String[])value);
                    continue;
                }
                if (!(value instanceof Boolean)) continue;
                out.writeByte(2);
                out.writeBoolean((Boolean)value);
            }
        }
    }

    private void writeList(DataOutputStream out, String[] list) throws IOException {
        if (list == null) {
            out.writeInt(0);
        } else {
            out.writeInt(list.length);
            for (int i = 0; i < list.length; ++i) {
                this.writeStringOrNull(list[i], out);
            }
        }
    }

    private void writeBaseDescription(BaseDescription rootDesc, DataOutputStream out) throws IOException {
        this.writeStringOrNull(rootDesc.getName(), out);
        this.writeVersion(rootDesc.getVersion(), out);
    }

    private void writeImportPackageSpec(ImportPackageSpecification importPackageSpec, DataOutputStream out) throws IOException {
        this.writeVersionConstraint(importPackageSpec, out);
        if (importPackageSpec.getBundle().isResolved()) {
            this.writeExportPackageDesc((ExportPackageDescriptionImpl)importPackageSpec.getSupplier(), out);
        } else {
            out.writeByte(0);
        }
        this.writeStringOrNull(importPackageSpec.getBundleSymbolicName(), out);
        this.writeVersionRange(importPackageSpec.getBundleVersionRange(), out);
        this.writeMap(out, importPackageSpec.getAttributes());
        this.writeMap(out, importPackageSpec.getDirectives());
    }

    private void writeHostSpec(HostSpecificationImpl host, DataOutputStream out, boolean force) throws IOException {
        if (host == null) {
            out.writeByte(0);
            return;
        }
        out.writeByte(1);
        this.writeVersionConstraint(host, out);
        BundleDescription[] hosts = host.getHosts();
        if (hosts == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(hosts.length);
        for (int i = 0; i < hosts.length; ++i) {
            this.writeBundleDescription(hosts[i], out, force);
        }
    }

    private void writeVersionConstraint(VersionConstraint constraint, DataOutputStream out) throws IOException {
        this.writeStringOrNull(constraint.getName(), out);
        this.writeVersionRange(constraint.getVersionRange(), out);
    }

    private void writeVersion(Version version, DataOutputStream out) throws IOException {
        if (version == null || version.equals(Version.emptyVersion)) {
            out.writeByte(0);
            return;
        }
        out.writeByte(1);
        out.writeInt(version.getMajor());
        out.writeInt(version.getMinor());
        out.writeInt(version.getMicro());
        this.writeQualifier(version.getQualifier(), out);
    }

    private void writeVersionRange(VersionRange versionRange, DataOutputStream out) throws IOException {
        if (versionRange == null || versionRange.equals(VersionRange.emptyRange)) {
            out.writeByte(0);
            return;
        }
        out.writeByte(1);
        this.writeVersion(versionRange.getMinimum(), out);
        out.writeBoolean(versionRange.getIncludeMinimum());
        this.writeVersion(versionRange.getMaximum(), out);
        out.writeBoolean(versionRange.getIncludeMaximum());
    }

    private boolean writeIndex(Object object, DataOutputStream out) throws IOException {
        if (object == null) {
            out.writeByte(0);
            return true;
        }
        int index = this.getFromObjectTable(object);
        if (index == -1) {
            return false;
        }
        out.writeByte(2);
        out.writeInt(index);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveStateDeprecated(StateImpl state, DataOutputStream output) throws IOException {
        try {
            this.writeStateDeprecated(state, output);
        }
        finally {
            output.close();
        }
    }

    private void writeStringOrNull(String string, DataOutputStream out) throws IOException {
        if (string == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(string);
        }
    }

    private void writeQualifier(String string, DataOutputStream out) throws IOException {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.writeStringOrNull(string, out);
    }
}

