/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="multicast")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MulticastDefinition
extends OutputDefinition<MulticastDefinition>
implements ExecutorServiceAwareDefinition<MulticastDefinition> {
    @XmlAttribute(required=false)
    private Boolean parallelProcessing;
    @XmlAttribute(required=false)
    private String strategyRef;
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute(required=false)
    private String executorServiceRef;
    @XmlAttribute(required=false)
    private Boolean streaming;
    @XmlAttribute(required=false)
    private Boolean stopOnException;
    @XmlAttribute(required=false)
    private Long timeout;
    @XmlTransient
    private AggregationStrategy aggregationStrategy;

    public String toString() {
        return "Multicast[" + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "multicast";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        return this.createChildProcessor(routeContext, true);
    }

    public MulticastDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public MulticastDefinition aggregationStrategyRef(String aggregationStrategyRef) {
        this.setStrategyRef(aggregationStrategyRef);
        return this;
    }

    public MulticastDefinition parallelProcessing() {
        this.setParallelProcessing(true);
        return this;
    }

    public MulticastDefinition streaming() {
        this.setStreaming(true);
        return this;
    }

    public MulticastDefinition stopOnException() {
        this.setStopOnException(true);
        return this;
    }

    @Override
    public MulticastDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public MulticastDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public MulticastDefinition timeout(long timeout) {
        this.setTimeout(timeout);
        return this;
    }

    @Override
    protected Processor createCompositeProcessor(RouteContext routeContext, List<Processor> list) throws Exception {
        if (this.strategyRef != null) {
            this.aggregationStrategy = routeContext.lookup(this.strategyRef, AggregationStrategy.class);
        }
        if (this.aggregationStrategy == null) {
            this.aggregationStrategy = new UseLatestAggregationStrategy();
        }
        this.executorService = ExecutorServiceHelper.getConfiguredExecutorService(routeContext, "Multicast", this);
        if (this.isParallelProcessing() && this.executorService == null) {
            this.executorService = routeContext.getCamelContext().getExecutorServiceStrategy().newDefaultThreadPool(this, "Multicast");
        }
        if (this.getTimeout() > 0L && !this.isParallelProcessing()) {
            throw new IllegalArgumentException("Timeout is used but ParallelProcessing has not been enabled.");
        }
        return new MulticastProcessor(routeContext.getCamelContext(), list, this.aggregationStrategy, this.isParallelProcessing(), this.executorService, this.isStreaming(), this.isStopOnException(), this.getTimeout());
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public MulticastDefinition setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
        return this;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing != null ? this.parallelProcessing : false;
    }

    public void setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public boolean isStreaming() {
        return this.streaming != null ? this.streaming : false;
    }

    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    public Boolean isStopOnException() {
        return this.stopOnException != null ? this.stopOnException : false;
    }

    public void setStopOnException(Boolean stopOnException) {
        this.stopOnException = stopOnException;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String getStrategyRef() {
        return this.strategyRef;
    }

    public void setStrategyRef(String strategyRef) {
        this.strategyRef = strategyRef;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    @Override
    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Long getTimeout() {
        return this.timeout != null ? this.timeout : 0L;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }
}

