/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.ThreadsProcessor;
import org.apache.camel.processor.UnitOfWorkProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="threads")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ThreadsDefinition
extends OutputDefinition<ProcessorDefinition> {
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute(required=false)
    private String executorServiceRef;
    @XmlAttribute(required=false)
    private Integer poolSize;
    @XmlAttribute(required=false)
    private WaitForTaskToComplete waitForTaskToComplete = WaitForTaskToComplete.IfReplyExpected;

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        if (this.executorServiceRef != null) {
            this.executorService = routeContext.lookup(this.executorServiceRef, ExecutorService.class);
        }
        if (this.executorService == null && this.poolSize != null) {
            this.executorService = ExecutorServiceHelper.newScheduledThreadPool(this.poolSize, "Threads", true);
        }
        Processor childProcessor = routeContext.createProcessor(this);
        UnitOfWorkProcessor uow = new UnitOfWorkProcessor(childProcessor);
        return new ThreadsProcessor(uow, this.executorService, this.waitForTaskToComplete);
    }

    @Override
    public String getLabel() {
        return "threads";
    }

    @Override
    public String getShortName() {
        return "threads";
    }

    public String toString() {
        return "Threads[" + this.getOutputs() + "]";
    }

    public ThreadsDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    public ThreadsDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public ThreadsDefinition poolSize(int poolSize) {
        this.setPoolSize(poolSize);
        return this;
    }

    public ThreadsDefinition waitForTaskToComplete(WaitForTaskToComplete wait) {
        this.setWaitForTaskToComplete(wait);
        return this;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Integer getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(Integer poolSize) {
        this.poolSize = poolSize;
    }

    public WaitForTaskToComplete getWaitForTaskToComplete() {
        return this.waitForTaskToComplete;
    }

    public void setWaitForTaskToComplete(WaitForTaskToComplete waitForTaskToComplete) {
        this.waitForTaskToComplete = waitForTaskToComplete;
    }
}

