/*
 * #%L
 * Fuse EAP :: Config
 * %%
 * Copyright (C) 2015 RedHat
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.jboss.fuse.eap.config;

import java.net.URL;
import java.nio.file.Paths;
import java.util.List;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.extras.config.ConfigContext;
import org.wildfly.extras.config.ConfigPlugin;
import org.wildfly.extras.config.ConfigSupport;
import org.wildfly.extras.config.NamespaceRegistry;

import static org.jboss.fuse.eap.config.SwitchyardConfigPlugin.NS_SWITCHYARD;
import static org.wildfly.extras.config.NamespaceConstants.NS_DOMAIN;
import static org.wildfly.extras.config.NamespaceConstants.NS_INFINISPAN;
import static org.wildfly.extras.config.NamespaceConstants.NS_LOGGING;
import static org.wildfly.extras.config.NamespaceConstants.NS_SECURITY;

public class StandaloneConfigTest {

    @Test
    public void testStandaloneConfig() throws Exception {

        URL resurl = StandaloneConfigTest.class.getResource("/standalone-ha.xml");
        SAXBuilder jdom = new SAXBuilder();
        Document doc = jdom.build(resurl);

        NamespaceRegistry registry = new NamespaceRegistry();
        ConfigPlugin plugin = new SwitchyardConfigPlugin(registry);

        Namespace[] domain = registry.getNamespaces(NS_DOMAIN);
        Namespace[] security = registry.getNamespaces(NS_SECURITY);
        Namespace[] infinispan = registry.getNamespaces(NS_INFINISPAN);
        Namespace[] logging = registry.getNamespaces(NS_LOGGING);
        Namespace[] switchyard = registry.getNamespaces(NS_SWITCHYARD);

        ConfigContext context = ConfigSupport.createContext(null, Paths.get(resurl.toURI()), doc);
        plugin.applyStandaloneConfigChange(context, true);

        // Verify extension
        Element element = ConfigSupport.findElementWithAttributeValue(doc.getRootElement(), "extension", "module", "org.switchyard", domain);
        Assert.assertNotNull("Extension not null", element);

        List<Element> profiles = ConfigSupport.findProfileElements(doc, domain);

        // Verify SwitchYard
        element = ConfigSupport.findChildElement(profiles.get(0), "subsystem", switchyard);
        Assert.assertNotNull("switchyard not null", element);

        // Verify logging
        Element loggingSubsystem = ConfigSupport.findChildElement(profiles.get(0), "subsystem", logging);
        element = ConfigSupport.findElementWithAttributeValue(loggingSubsystem, "logger", "category", "org.switchyard", logging);
        Assert.assertNotNull("switchyard logging not null", element);

        element = ConfigSupport.findElementWithAttributeValue(loggingSubsystem, "logger", "category", "org.apache.deltaspike.core.api.provider.BeanManagerProvider", logging);
        Assert.assertNotNull("BeanManagerProvider logging not null", element);

        // Verify infinispan cache
        Element infinispanSubsystem = ConfigSupport.findChildElement(profiles.get(0), "subsystem", infinispan);
        element = ConfigSupport.findElementWithAttributeValue(infinispanSubsystem, "cache-container", "name", "switchyard", infinispan);
        Assert.assertNotNull("switchyard cache-container not null", element);

        // Verify bpel-console
        element = ConfigSupport.findElementWithAttributeValue(doc.getRootElement(), "security-domain", "name", "bpel-console", security);
        Assert.assertNotNull("bpel-console security domain not null", element);

        XMLOutputter output = new XMLOutputter();
        output.setFormat(Format.getRawFormat());
//        System.out.println(output.outputString(doc));
    }
}
