/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v2alpha1

import (
	time "time"

	brokerv2alpha1 "github.com/artemiscloud/activemq-artemis-operator/pkg/apis/broker/v2alpha1"
	versioned "github.com/artemiscloud/activemq-artemis-operator/pkg/client/clientset/versioned"
	internalinterfaces "github.com/artemiscloud/activemq-artemis-operator/pkg/client/informers/externalversions/internalinterfaces"
	v2alpha1 "github.com/artemiscloud/activemq-artemis-operator/pkg/client/listers/broker/v2alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// ActiveMQArtemisInformer provides access to a shared informer and lister for
// ActiveMQArtemises.
type ActiveMQArtemisInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v2alpha1.ActiveMQArtemisLister
}

type activeMQArtemisInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewActiveMQArtemisInformer constructs a new informer for ActiveMQArtemis type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewActiveMQArtemisInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredActiveMQArtemisInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredActiveMQArtemisInformer constructs a new informer for ActiveMQArtemis type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredActiveMQArtemisInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.BrokerV2alpha1().ActiveMQArtemises(namespace).List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.BrokerV2alpha1().ActiveMQArtemises(namespace).Watch(options)
			},
		},
		&brokerv2alpha1.ActiveMQArtemis{},
		resyncPeriod,
		indexers,
	)
}

func (f *activeMQArtemisInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredActiveMQArtemisInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *activeMQArtemisInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&brokerv2alpha1.ActiveMQArtemis{}, f.defaultInformer)
}

func (f *activeMQArtemisInformer) Lister() v2alpha1.ActiveMQArtemisLister {
	return v2alpha1.NewActiveMQArtemisLister(f.Informer().GetIndexer())
}
