# Contributing to Brotli4j
Thank you for considering contributing to Brotli4j! This guide is designed to help you get started with contributing to our open source project.

# Code of Conduct
We have adopted a Code of Conduct that we expect project participants to adhere to. Please read the Code of Conduct before contributing.

# How to Contribute
Contributing to Brotli4j can be done in various ways, including:

<li> Submitting bug reports or feature requests through the issue tracker </li>
<li> Contributing code improvements or new features by submitting a pull request </li>
<li> Improving documentation through the Wiki </li>
<li> Participating in discussions on Discussions </li>
<li> Bug Reports and Feature Requests </li>

</br>
We welcome bug reports and feature requests through our issue tracker. Please provide as much detail as possible, including steps to reproduce the issue, expected behavior, and actual behavior. If you have a feature request, please describe the feature in detail and why you think it would be valuable to the project.

# Contributing Code

### Before contributing code, please make sure you have read the code of conduct and license files.

To contribute code, follow these steps:

<li> Fork the Brotli4j repository on GitHub. </li> 
<li> Clone your forked repository to your local machine. </li>
<li> Create a new branch from the master branch to work on your changes. Give your branch a descriptive name (e.g., fix-issue-123).  </li>
<li> Make your changes and ensure all tests pass. </li>
<li> Commit your changes with a descriptive commit message. </li>
<li> Push your changes to your forked repository on GitHub. </li>
<li> Submit a pull request to the master branch of the Brotli4j repository. </li>

### Improving Documentation </li>
If you want to contribute to the documentation of Brotli4j, you can do so by editing the Wiki. You can edit existing pages or create new ones. Please make sure that your changes are accurate and well-written.

# Testing
Brotli4j has a comprehensive test suite. Before submitting a pull request, make sure all tests pass. You can run tests by executing mvn test from the project root directory.

# Pull Request Process
To submit a pull request:

<li> Fork the Brotli4j repository on GitHub
<li> Clone your forked repository to your local machine.
<li> Create a new branch from the master branch to work on your changes. Give your branch a descriptive name (e.g., fix-issue-123).
<li> Make your changes and ensure all tests pass.
<li> Commit your changes with a descriptive commit message.
<li> Push your changes to your forked repository on GitHub.

# Submit a pull request to the master branch of the Brotli4j repository.
In your pull request, please include a detailed description of the changes you made and why they are valuable to the project. Also, make sure that your code adheres to the Google Java Style Guide.

</br>
Once your pull request is submitted, it will be reviewed by one or more maintainers. They may ask for additional changes or provide feedback. Once your pull request is approved, it will be merged into the master branch.

# Attribution
We appreciate all contributions to Brotli4j and want to make sure that contributors are properly credited for their work. In your pull request, please add yourself to the list of contributors in the AUTHORS.md file. You can also add yourself to the list by opening a pull request that only modifies that file.

# Conclusion
Thank you for considering contributing to Brotli4j! Your contributions help make the project better for everyone. If you have any questions, feel free to reach out to the maintainers through the issue tracker or Discussions.
