"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.globalBreakpoints = exports.DataToolbarContentContext = exports.DataToolbarContext = void 0;

var React = _interopRequireWildcard(require("react"));

var _reactTokens = require("@patternfly/react-tokens");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var DataToolbarContext = React.createContext({
  isExpanded: false,
  toggleIsExpanded: function toggleIsExpanded() {},
  chipGroupContentRef: null,
  updateNumberFilters: function updateNumberFilters(categoryName, numberOfFilters) {}
});
exports.DataToolbarContext = DataToolbarContext;
var DataToolbarContentContext = React.createContext({
  expandableContentRef: null,
  expandableContentId: ''
});
exports.DataToolbarContentContext = DataToolbarContentContext;

var globalBreakpoints = function globalBreakpoints(breakpoint) {
  var breakpoints = {
    md: parseInt(_reactTokens.global_breakpoint_md.value),
    lg: parseInt(_reactTokens.global_breakpoint_lg.value),
    xl: parseInt(_reactTokens.global_breakpoint_xl.value),
    '2xl': parseInt(_reactTokens.global_breakpoint_2xl.value)
  };
  return breakpoints[breakpoint];
};

exports.globalBreakpoints = globalBreakpoints;
//# sourceMappingURL=DataToolbarUtils.js.map