(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "react", "@patternfly/react-tokens"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("react"), require("@patternfly/react-tokens"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.react, global.reactTokens);
    global.undefined = mod.exports;
  }
})(this, function (exports, _react, _reactTokens) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.globalBreakpoints = exports.DataToolbarContentContext = exports.DataToolbarContext = undefined;

  var React = _interopRequireWildcard(_react);

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;
    var cache = new WeakMap();

    _getRequireWildcardCache = function () {
      return cache;
    };

    return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }

    var cache = _getRequireWildcardCache();

    if (cache && cache.has(obj)) {
      return cache.get(obj);
    }

    var newObj = {};

    if (obj != null) {
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;

      for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;

          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
    }

    newObj.default = obj;

    if (cache) {
      cache.set(obj, newObj);
    }

    return newObj;
  }

  const DataToolbarContext = exports.DataToolbarContext = React.createContext({
    isExpanded: false,
    toggleIsExpanded: () => {},
    chipGroupContentRef: null,
    updateNumberFilters: (categoryName, numberOfFilters) => {}
  });
  const DataToolbarContentContext = exports.DataToolbarContentContext = React.createContext({
    expandableContentRef: null,
    expandableContentId: ''
  });

  const globalBreakpoints = exports.globalBreakpoints = breakpoint => {
    const breakpoints = {
      md: parseInt(_reactTokens.global_breakpoint_md.value),
      lg: parseInt(_reactTokens.global_breakpoint_lg.value),
      xl: parseInt(_reactTokens.global_breakpoint_xl.value),
      '2xl': parseInt(_reactTokens.global_breakpoint_2xl.value)
    };
    return breakpoints[breakpoint];
  };
});
//# sourceMappingURL=DataToolbarUtils.js.map