"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.symbol.description");

require("core-js/modules/es.symbol.iterator");

require("core-js/modules/es.array.concat");

require("core-js/modules/es.array.from");

require("core-js/modules/es.array.is-array");

require("core-js/modules/es.array.iterator");

require("core-js/modules/es.date.to-string");

require("core-js/modules/es.object.assign");

require("core-js/modules/es.object.define-property");

require("core-js/modules/es.object.to-string");

require("core-js/modules/es.regexp.to-string");

require("core-js/modules/es.string.iterator");

require("core-js/modules/web.dom-collections.iterator");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.webpack = webpack;
exports.addons = addons;

var _mdxCompilerPlugin = _interopRequireDefault(require("@storybook/addon-docs/mdx-compiler-plugin"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function createBabelOptions(babelOptions, configureJSX) {
  if (!configureJSX) {
    return babelOptions;
  }

  var babelPlugins = babelOptions && babelOptions.plugins || [];
  return Object.assign({}, babelOptions, {
    // for frameworks that are not working with react, we need to configure
    // the jsx to transpile mdx, for now there will be a flag for that
    // for more complex solutions we can find alone that we need to add '@babel/plugin-transform-react-jsx'
    plugins: [].concat(_toConsumableArray(babelPlugins), ['@babel/plugin-transform-react-jsx'])
  });
}

function webpack() {
  var webpackConfig = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _webpackConfig$module = webpackConfig.module,
      module = _webpackConfig$module === void 0 ? {} : _webpackConfig$module; // it will reuse babel options that are already in use in storybook
  // also, these babel options are chained with other presets.

  var babelOptions = options.babelOptions,
      configureJSX = options.configureJSX,
      _options$sourceLoader = options.sourceLoaderOptions,
      sourceLoaderOptions = _options$sourceLoader === void 0 ? {} : _options$sourceLoader; // set `sourceLoaderOptions` to `null` to disable for manual configuration

  var sourceLoader = sourceLoaderOptions ? [{
    test: /\.(stories|story)\.[tj]sx?$/,
    loader: require.resolve('@storybook/source-loader'),
    options: sourceLoaderOptions,
    enforce: 'pre'
  }] : [];
  return Object.assign({}, webpackConfig, {
    module: Object.assign({}, module, {
      rules: [].concat(_toConsumableArray(module.rules || []), [{
        test: /\.(stories|story).mdx$/,
        use: [{
          loader: 'babel-loader',
          options: createBabelOptions(babelOptions, configureJSX)
        }, {
          loader: '@mdx-js/loader',
          options: {
            compilers: [(0, _mdxCompilerPlugin["default"])(options)]
          }
        }]
      }, {
        test: /\.mdx$/,
        exclude: /\.(stories|story).mdx$/,
        use: [{
          loader: 'babel-loader',
          options: createBabelOptions(babelOptions, configureJSX)
        }, {
          loader: '@mdx-js/loader'
        }]
      }], sourceLoader)
    })
  });
}

function addons() {
  var entry = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  return [].concat(_toConsumableArray(entry), [require.resolve('../../register')]);
}