import { Component } from 'react';
import PropTypes from 'prop-types';
import { KnobStoreKnob } from '../KnobStore';
interface PropFormProps {
    knobs: KnobStoreKnob[];
    onFieldChange: (changedKnob: KnobStoreKnob) => void;
    onFieldClick: (knob: KnobStoreKnob) => void;
}
export default class PropForm extends Component<PropFormProps> {
    static displayName: string;
    static defaultProps: {
        knobs: KnobStoreKnob[];
        onFieldChange: () => void;
        onFieldClick: () => void;
    };
    static propTypes: {
        knobs: PropTypes.Validator<KnobStoreKnob[]>;
        onFieldChange: PropTypes.Validator<(changedKnob: KnobStoreKnob) => void>;
        onFieldClick: PropTypes.Validator<(knob: KnobStoreKnob) => void>;
    };
    makeChangeHandler(name: string, type: string): (value?: string) => void;
    render(): JSX.Element;
}
export {};
