"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.symbol.description");

require("core-js/modules/es.symbol.iterator");

require("core-js/modules/es.array.is-array");

require("core-js/modules/es.array.iterator");

require("core-js/modules/es.object.define-property");

require("core-js/modules/es.object.to-string");

require("core-js/modules/es.string.iterator");

require("core-js/modules/web.dom-collections.iterator");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reactHook = exports.error = exports.inline = exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _Story = require("./Story");

var _Button = require("../Button/Button");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var _default = {
  title: 'Docs|Story',
  component: _Story.Story
};
exports["default"] = _default;

var _ref =
/*#__PURE__*/
_react["default"].createElement(_Button.Button, {
  secondary: true
}, "Inline story");

var buttonFn = function buttonFn() {
  return _ref;
};

buttonFn.displayName = "buttonFn";

var buttonHookFn = function buttonHookFn() {
  var _React$useState = _react["default"].useState(0),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      count = _React$useState2[0],
      setCount = _React$useState2[1];

  return _react["default"].createElement(_Button.Button, {
    secondary: true,
    onClick: function onClick() {
      return setCount(count + 1);
    }
  }, "count: ".concat(count));
};

buttonHookFn.displayName = "buttonHookFn";

var _ref2 =
/*#__PURE__*/
_react["default"].createElement(_Story.Story, {
  inline: true,
  storyFn: buttonFn,
  title: "hello button"
});

var inline = function inline() {
  return _ref2;
};

exports.inline = inline;
inline.displayName = "inline";

var error = function error() {
  return _react["default"].createElement(_Story.Story, {
    error: _Story.StoryError.NO_STORY
  });
};

exports.error = error;
error.displayName = "error";

var _ref3 =
/*#__PURE__*/
_react["default"].createElement(_Story.Story, {
  inline: true,
  storyFn: buttonHookFn,
  title: "hello button"
});

var reactHook = function reactHook() {
  return _ref3;
};

exports.reactHook = reactHook;
reactHook.displayName = "reactHook";