/**
 * ISC License
 *
 * Copyright (c) 2018, Aleck Greenham
 *
 * Permission to use, copy, modify, and/or distribute this software for any purpose with or without fee is hereby granted, provided that the above copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * PLEASE NOTE: SOURCE CODE FOUND IN THE lib/vendor DIRECTORY IS UNDER THE MIT LICENSE - PLEASE SEE THE LICENSE FILE FOR EACH DIRECTORY FOR MORE INFORMATION
 */

import PropTypes from 'prop-types';
import React, { PureComponent, Component } from 'react';

function _typeof(obj) {
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function (obj) {
      return typeof obj;
    };
  } else {
    _typeof = function (obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };
  }

  return _typeof(obj);
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

function _objectSpread(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};
    var ownKeys = Object.keys(source);

    if (typeof Object.getOwnPropertySymbols === 'function') {
      ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
        return Object.getOwnPropertyDescriptor(source, sym).enumerable;
      }));
    }

    ownKeys.forEach(function (key) {
      _defineProperty(target, key, source[key]);
    });
  }

  return target;
}

function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  if (superClass) _setPrototypeOf(subClass, superClass);
}

function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}

function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };

  return _setPrototypeOf(o, p);
}

function isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct) return false;
  if (Reflect.construct.sham) return false;
  if (typeof Proxy === "function") return true;

  try {
    Date.prototype.toString.call(Reflect.construct(Date, [], function () {}));
    return true;
  } catch (e) {
    return false;
  }
}

function _construct(Parent, args, Class) {
  if (isNativeReflectConstruct()) {
    _construct = Reflect.construct;
  } else {
    _construct = function _construct(Parent, args, Class) {
      var a = [null];
      a.push.apply(a, args);
      var Constructor = Function.bind.apply(Parent, a);
      var instance = new Constructor();
      if (Class) _setPrototypeOf(instance, Class.prototype);
      return instance;
    };
  }

  return _construct.apply(null, arguments);
}

function _isNativeFunction(fn) {
  return Function.toString.call(fn).indexOf("[native code]") !== -1;
}

function _wrapNativeSuper(Class) {
  var _cache = typeof Map === "function" ? new Map() : undefined;

  _wrapNativeSuper = function _wrapNativeSuper(Class) {
    if (Class === null || !_isNativeFunction(Class)) return Class;

    if (typeof Class !== "function") {
      throw new TypeError("Super expression must either be null or a function");
    }

    if (typeof _cache !== "undefined") {
      if (_cache.has(Class)) return _cache.get(Class);

      _cache.set(Class, Wrapper);
    }

    function Wrapper() {
      return _construct(Class, arguments, _getPrototypeOf(this).constructor);
    }

    Wrapper.prototype = Object.create(Class.prototype, {
      constructor: {
        value: Wrapper,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    return _setPrototypeOf(Wrapper, Class);
  };

  return _wrapNativeSuper(Class);
}

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

function _objectWithoutProperties(source, excluded) {
  if (source == null) return {};

  var target = _objectWithoutPropertiesLoose(source, excluded);

  var key, i;

  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

    for (i = 0; i < sourceSymbolKeys.length; i++) {
      key = sourceSymbolKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }

  return target;
}

function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

function _possibleConstructorReturn(self, call) {
  if (call && (typeof call === "object" || typeof call === "function")) {
    return call;
  }

  return _assertThisInitialized(self);
}

function _superPropBase(object, property) {
  while (!Object.prototype.hasOwnProperty.call(object, property)) {
    object = _getPrototypeOf(object);
    if (object === null) break;
  }

  return object;
}

function _get(target, property, receiver) {
  if (typeof Reflect !== "undefined" && Reflect.get) {
    _get = Reflect.get;
  } else {
    _get = function _get(target, property, receiver) {
      var base = _superPropBase(target, property);

      if (!base) return;
      var desc = Object.getOwnPropertyDescriptor(base, property);

      if (desc.get) {
        return desc.get.call(receiver);
      }

      return desc.value;
    };
  }

  return _get(target, property, receiver || target);
}

function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
}

function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
}

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

    return arr2;
  }
}

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

function _iterableToArray(iter) {
  if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
}

function _iterableToArrayLimit(arr, i) {
  var _arr = [];
  var _n = true;
  var _d = false;
  var _e = undefined;

  try {
    for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance");
}

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance");
}

function dictionaryFrom(a){var b=1<arguments.length&&arguments[1]!==void 0?arguments[1]:null;return a.reduce(function(a,c){return a[c]=b||{value:c},a},{})}

var _defaultConfiguration={logLevel:"warn",defaultKeyEvent:"keydown",defaultComponent:"div",defaultTabIndex:"-1",ignoreTags:["input","select","textarea"],enableHardSequences:!1,ignoreKeymapAndHandlerChangesByDefault:!0,ignoreEventsCondition:function c(a){var b=a.target;if(b&&b.tagName){var d=b.tagName.toLowerCase();return Configuration.option("_ignoreTagsDict")[d]||b.isContentEditable}return !1},simulateMissingKeyPressEvents:!0,stopEventPropagationAfterHandling:!0,stopEventPropagationAfterIgnoring:!0},_configuration=_objectSpread({},_defaultConfiguration);_configuration._ignoreTagsDict=dictionaryFrom(_configuration.ignoreTags,!0);var Configuration=function(){function a(){_classCallCheck(this,a);}return _createClass(a,null,[{key:"init",value:function d(a){var b=this,c=a.ignoreTags;c&&(a._ignoreTagsDict=dictionaryFrom(a.ignoreTags)),-1!==["verbose","debug","info"].indexOf(a.logLevel)&&console.warn("React HotKeys: You have requested log level '".concat(a.logLevel,"' but for performance reasons, logging below severity level 'warning' is disabled in production. Please use the development build for complete logs.")),Object.keys(a).forEach(function(c){b.set(c,a[c]);});}},{key:"set",value:function c(a,b){_configuration[a]=b;}},{key:"reset",value:function b(a){_configuration[a]=_defaultConfiguration[a];}},{key:"option",value:function b(a){return _configuration[a]}}]),a}();

var Logger=function(){function a(){var b=this,c=0<arguments.length&&void 0!==arguments[0]?arguments[0]:"warn";if(_classCallCheck(this,a),_defineProperty(this,"verbose",this.noop),_defineProperty(this,"debug",this.noop),_defineProperty(this,"info",this.noop),_defineProperty(this,"warn",this.noop),_defineProperty(this,"error",this.noop),this.logLevel=this.constructor.levels[c],this.logLevel>=this.constructor.levels.error)this.error=console.error;else return;if(this.logLevel>=this.constructor.levels.warn)this.warn=console.warn;else return;["info","debug","verbose"].some(function(a){return !(b.logLevel>=b.constructor.levels[a])||(b[a]=console.log,!1)});}return _createClass(a,[{key:"noop",value:function a(){}}]),a}();_defineProperty(Logger,"logIcons",["\uD83D\uDCD5","\uD83D\uDCD7","\uD83D\uDCD8","\uD83D\uDCD9"]),_defineProperty(Logger,"componentIcons",["\uD83D\uDD3A","\u2B50\uFE0F","\uD83D\uDD37","\uD83D\uDD36","\u2B1B\uFE0F"]),_defineProperty(Logger,"eventIcons",["\u2764\uFE0F","\uD83D\uDC9A","\uD83D\uDC99","\uD83D\uDC9B","\uD83D\uDC9C","\uD83E\uDDE1"]),_defineProperty(Logger,"levels",{none:0,error:1,warn:2,info:3,debug:4,verbose:5});

function isUndefined(a){return "undefined"==typeof a}

var KeyEventBitmapManager=function(){function a(){_classCallCheck(this,a);}return _createClass(a,null,[{key:"newBitmap",value:function c(a){var b=[!1,!1,!1];if(!isUndefined(a))for(var d=0;d<=a;d++)b[d]=!0;return b}},{key:"setBit",value:function c(a,b){return a[b]=!0,a}},{key:"clone",value:function d(a){for(var b=this.newBitmap(),c=0;c<a.length;c++)b[c]=a[c];return b}},{key:"and",value:function e(a,b){for(var c=[],d=0;d<a.length;d++)c[d]=a[d]&b[d];return c}}]),a}();

var KeyEventBitmapIndex={keydown:0,keypress:1,keyup:2};

var ShiftedKeysDictionary={"`":["~"],1:["!"],2:["@","\""],3:["#","\xA3"],4:["$"],5:["%"],6:["^"],7:["&"],8:["*"],9:["("],0:[")"],"-":["_"],"=":["plus"],";":[":"],"'":["\"","@"],",":["<"],".":[">"],"/":["?"],"\\":["|"],"[":["{"],"]":["}"],"#":["~"]};

function resolveShiftedAlias(a){return ShiftedKeysDictionary[a]||[1===a.length?a.toUpperCase():a]}

function hasKey(a,b){return a.hasOwnProperty(b)}

function invertArrayDictionary(a){return Object.keys(a).reduce(function(b,c){var d=a[c];return d.forEach(function(a){hasKey(b,a)||(b[a]=[]),b[a].push(c);}),b},{})}

var UnshiftedKeysDictionary=invertArrayDictionary(ShiftedKeysDictionary);

function resolveUnshiftedAlias(a){return UnshiftedKeysDictionary[a]||[1===a.length?a.toLowerCase():a]}

var KeyOSAndLayoutAliasesDictionary={Backspace:["Delete"]};

function isString(a){return "string"==typeof a}

function stripSuperfluousWhitespace(a){return isString(a)?a.trim().replace(/\s+/g," "):a}

var MousetrapToReactKeyNamesDictionary={tab:"Tab",capslock:"CapsLock",shift:"Shift",meta:"Meta",alt:"Alt",ctrl:"Control",space:" ",spacebar:" ",escape:"Escape",esc:"Escape",left:"ArrowLeft",right:"ArrowRight",up:"ArrowUp",down:"ArrowDown",return:"Enter",del:"Backspace",command:"Meta",option:"Alt",enter:"Enter",backspace:"Backspace",ins:"Insert",pageup:"PageUp",pagedown:"PageDown",end:"End",home:"Home",contextmenu:"ContextMenu",numlock:"Clear"};

var KeyShorthandDictionary={cmd:"Meta"};

function standardizeKeyName(a){var b=a.toLowerCase();return MousetrapToReactKeyNamesDictionary[b]||KeyShorthandDictionary[b]||(a.match(/^f\d+$/)?a.toUpperCase():a)}

var SpecialKeysDictionary={Shift:!0,Control:!0,Alt:!0,Meta:!0,Enter:!0,Tab:!0,CapsLock:!0,BackSpace:!0,Escape:!0};

function isSpecialKey(a){return !!SpecialKeysDictionary[a]}

function isValidKey(a){return isSpecialKey(a)||String.fromCharCode(a.charCodeAt(0))===a}var InvalidKeyNameError=function(a){function b(){return _classCallCheck(this,b),_possibleConstructorReturn(this,_getPrototypeOf(b).apply(this,arguments))}return _inherits(b,a),b}(_wrapNativeSuper(Error));

function normalizedCombinationId(a){return a.sort().join("+")}var KeySequenceParser=function(){function a(){_classCallCheck(this,a);}return _createClass(a,null,[{key:"parse",value:function k(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},c=stripSuperfluousWhitespace(a),d=c.split(" ");try{var e=d.slice(0,d.length-1),f=d[d.length-1],g=e.map(function(a){var c=parseCombination(a,b);return normalizedCombinationId(Object.keys(c))}).join(" "),h=parseCombination(f,b),i=normalizedCombinationId(Object.keys(h)),j={id:i,keyDictionary:h,eventBitmapIndex:b.eventBitmapIndex,size:Object.keys(h).length};return {sequence:{prefix:g,size:e.length+1},combination:j}}catch(a){return {sequence:null,combination:null}}}}]),a}();function parseCombination(a){var b=1<arguments.length&&arguments[1]!==void 0?arguments[1]:{};return a.replace(/^\+|(\s|[^+]\+)\+/,"$1plus").split("+").reduce(function(a,c){var d=standardizeKeyName(c);if(b.ensureValidKeys&&!isValidKey(d))throw new InvalidKeyNameError;return a[d]=!0,a},{})}

var AltedKeysDictionary={"`":["`"],1:["\xA1"],2:["\u2122"],3:["\xA3"],4:["\xA2"],5:["\u221E"],6:["\xA7"],7:["\xB6"],8:["\u2022"],9:["\xAA"],0:["\xBA"],"-":["\u2013"],"=":["\u2260"],a:["\xE5"],b:["\u222B"],c:["\xE7"],d:["\u2202"],e:["\xB4"],f:["\u0192"],g:["\xA9"],h:["\u02D9"],i:["\u02C6"],j:["\u2206"],k:["\u02DA"],l:["\xAC"],m:["\xB5"],n:["\u02DC"],o:["\xF8"],p:["\u03C0"],q:["\u0153"],r:["\xAE"],s:["\xDF"],t:["\u2020"],u:["\xA8"],v:["\u221A"],w:["\u2211"],x:["\u2248"],y:["\xA5"],z:["\u03A9"],"[":["\u201C"],"]":["\u2018"],"\\":["\xAB"],"'":["\xE6"],";":["\u2026"],",":["\u2264"],".":["\u2265"],"/":["\xF7"]};

var UnaltedKeysDictionary=invertArrayDictionary(AltedKeysDictionary);

function resolveUnaltedAlias(a){return UnaltedKeysDictionary[a]||[a]}

function resolveAltedAlias(a){return AltedKeysDictionary[a]||[a]}

var AltShiftedKeysDictionary={"`":["`"],1:["\u2044"],2:["\u20AC"],3:["\u2039"],4:["\u203A"],5:["\uFB01"],6:["\uFB02"],7:["\u2021"],8:["\xB0"],9:["\xB7"],0:["\u201A"],"-":["\u2014"],"=":["\xB1"],a:["\xC5"],b:["\u0131"],c:["\xC7"],d:["\xCE"],e:["\xB4"],f:["\xCF"],g:["\u02DD"],h:["\xD3"],i:["\u02C6"],j:["\xD4"],k:["\uF8FF"],l:["\xD2"],m:["\xC2"],n:["\u02DC"],o:["\xD8"],p:["\u03C0"],q:["\u0152"],r:["\u2030"],s:["\xCD"],t:["\xCE"],u:["\xA8"],v:["\u25CA"],w:["\u201E"],x:["\u02DB"],y:["\xC1"],z:["\xB8"],"[":["\u201D"],"]":["\u2019"],"\\":["\xBB"],"'":["\xC6"],";":["\xDA"],",":["\xAF"],".":["\u02D8"]};

var UnaltShiftedKeysDictionary=invertArrayDictionary(AltShiftedKeysDictionary);

function resolveUnaltShiftedAlias(a){return UnaltShiftedKeysDictionary[a]||resolveUnshiftedAlias(a)}

function resolveAltShiftedAlias(a){return AltShiftedKeysDictionary[a]||[a]}

var KeyCombinationSerializer=function(){function a(){_classCallCheck(this,a);}return _createClass(a,null,[{key:"serialize",value:function f(a){var b=a.Shift,c=a.Alt,d={},e=Object.keys(a).sort();return e.forEach(function(a){var e=[];if(b){if(c){var f=resolveUnaltShiftedAlias(a),g=resolveAltShiftedAlias(a);e=[].concat(_toConsumableArray(e),[a],_toConsumableArray(f),_toConsumableArray(g));}else{var h=resolveUnshiftedAlias(a),i=resolveShiftedAlias(a);e=[].concat(_toConsumableArray(e),[a],_toConsumableArray(h),_toConsumableArray(i));}}else if(c){var j=resolveUnaltedAlias(a),k=resolveAltedAlias(a);e=[].concat(_toConsumableArray(e),[a],_toConsumableArray(j),_toConsumableArray(k));}else{e.push(a);var m=KeyOSAndLayoutAliasesDictionary[a];m&&(e=[].concat(_toConsumableArray(e),_toConsumableArray(m)));}var l=Object.keys(d);0<l.length?l.forEach(function(a){e.forEach(function(b){d[a+"+".concat(b)]=_objectSpread({},d[a],_defineProperty({},b,!0));}),delete d[a];}):e.forEach(function(a){d[a]=_defineProperty({},a,!0);});}),Object.values(d).map(function(a){return Object.keys(a).sort().join("+")})}},{key:"isValidKeySerialization",value:function b(a){return !!(0<a.length)&&!!KeySequenceParser.parse(a,{ensureValidKeys:!0}).combination}}]),a}();

function arrayFrom(a){return Array.isArray(a)?a:a?[a]:[]}

function indexFromEnd(a,b){return a[a.length-(b+1)]}

function isObject(a){return !Array.isArray(a)&&"object"===_typeof(a)&&null!==a}

function isEmpty(a){return isObject(a)?0===Object.keys(a).length:!a||0===a.length}

function describeKeyEventType(a){switch(parseInt(a,10)){case 0:return "keydown";case 1:return "keypress";default:return "keyup";}}

var KeyEventSequenceIndex={previous:0,current:1};

function resolveKeyAlias(a){return KeyOSAndLayoutAliasesDictionary[a]||[a]}

var ModifierFlagsDictionary={Shift:["shiftKey"],Meta:["metaKey"],Control:["ctrlKey"],Alt:["altKey"]};

function without(a){var b=1<arguments.length&&arguments[1]!==void 0?arguments[1]:[],c=2<arguments.length&&arguments[2]!==void 0?arguments[2]:{},d=dictionaryFrom(arrayFrom(b));return Array.isArray(a)?a.reduce(function(a,b){return d[b]&&(c.stringifyFirst||d[b].value===b)||a.push(b),a},[]):isObject(a)?Object.keys(a).reduce(function(b,c){return d[c]||(b[c]=a[c]),b},{}):a}

for(var KeysWithoutPressEventDictionary={Shift:!0,Control:!0,Alt:!0,Meta:!0,Enter:!0,Tab:!0,BackSpace:!0,ArrowRight:!0,ArrowLeft:!0,ArrowUp:!0,ArrowDown:!0,CapsLock:!0},i=1;13>i;i++)KeysWithoutPressEventDictionary["F".concat(i)]=!0;

function hasKeyPressEvent(a){return !KeysWithoutPressEventDictionary[a]}

var AbstractKeyEventStrategy=function(){function a(){var b=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{},c=1<arguments.length?arguments[1]:void 0;_classCallCheck(this,a),this.logger=b.logger||new Logger("warn"),this.componentId=-1,this.keyEventManager=c,this.keyMapRegistry={},this.componentRegistry={},this.rootComponentId=null,this._reset(),this._resetKeyCombinationHistory();}return _createClass(a,[{key:"_reset",value:function a(){this._initRegisteredKeyMapsState(),this._initHandlerResolutionState();}},{key:"_initRegisteredKeyMapsState",value:function a(){this.componentList=[],this.longestSequence=1,this.longestSequenceComponentIndex=null,this.keyMapEventBitmap=KeyEventBitmapManager.newBitmap(),this.componentIdDict={};}},{key:"_initHandlerResolutionState",value:function a(){this.keyMaps=null,this.handlerResolutionSearchIndex=0,this.unmatchedHandlerStatus=null,this.handlersDictionary={},this.keySequencesDictionary={};}},{key:"_resetKeyCombinationHistory",value:function c(){if(this.keyCombinationIncludesKeyUp=!1,this.keypressEventsToSimulate=[],this.keyupEventsToSimulate=[],!this.keyCombinationHistory||1>this.keyCombinationHistory.length)this.keyCombinationHistory=[];else{var a=this._getCurrentKeyCombination(),b=Object.keys(a.keys).reduce(function(b,c){var d=a.keys[c],e=d[KeyEventSequenceIndex.current];return e[KeyEventBitmapIndex.keydown]&&!e[KeyEventBitmapIndex.keyup]&&(b[c]=d),b},{});this.keyCombinationHistory=[{keys:b,ids:KeyCombinationSerializer.serialize(b)}];}}},{key:"getApplicationKeyMap",value:function a(){return null===this.rootComponentId?{}:this._buildApplicationKeyMap([this.rootComponentId],{})}},{key:"_buildApplicationKeyMap",value:function d(a,b){var c=this;return a.forEach(function(a){var d=c.componentRegistry[a],e=c.keyMapRegistry[a];e&&Object.keys(e).forEach(function(a){b[a]=[],arrayFrom(e[a]).forEach(function(c){var d=function(){return isObject(c)?c.sequence:c}();b[a].push(d);});}),c._buildApplicationKeyMap(d.childIds,b);}),b}},{key:"registerKeyMap",value:function b(a){return this.componentId+=1,this.keyMapRegistry[this.componentId]=a,this.componentRegistry[this.componentId]=newComponentRegistryItem(),this.componentId}},{key:"reregisterKeyMap",value:function c(a,b){this.keyMapRegistry[a]=b;}},{key:"registerComponentMount",value:function c(a,b){isUndefined(b)?this.rootComponentId=a:(this.componentRegistry[a].parentId=b,this.componentRegistry[b].childIds.push(a)),void 0;}},{key:"deregisterKeyMap",value:function d(a){var b=this.componentRegistry[a].parentId,c=this.componentRegistry[b];c&&(c.childIds=without(c.childIds,a)),delete this.componentRegistry[a],delete this.keyMapRegistry[a],a===this.rootComponentId&&(this.rootComponentId=null);}},{key:"_addComponentToList",value:function f(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},c=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},d=3<arguments.length?arguments[3]:void 0,e=this._buildComponentOptions(a,b,c,d);this.componentList.push(e),this._setComponentPosition(a,this.componentList.length-1);}},{key:"_buildComponentOptions",value:function h(a,b,c,d){var e=this._applyHardSequences(b,c),f=e.keyMap,g=e.handlers;return {actions:this._buildActionDictionary(_objectSpread({},b,f),d,a),handlers:g,componentId:a,options:d}}},{key:"_applyHardSequences",value:function c(a,b){return Configuration.option("enableHardSequences")?Object.keys(b).reduce(function(c,d){var e=!!a[d];return !e&&KeyCombinationSerializer.isValidKeySerialization(d)&&(c.keyMap[d]=d),c.handlers[d]=b[d],c},{keyMap:{},handlers:{}}):{keyMap:a,handlers:b}}},{key:"_buildActionDictionary",value:function e(a,b,c){var d=this;return Object.keys(a).reduce(function(e,f){var g=arrayFrom(a[f]);return g.forEach(function(a){var g=function(){if(isObject(a)){var c=a.sequence,d=a.action;return {keySequence:c,eventBitmapIndex:isUndefined(d)?KeyEventBitmapIndex[b.defaultKeyEvent]:KeyEventBitmapIndex[d]}}return {keySequence:a,eventBitmapIndex:KeyEventBitmapIndex[b.defaultKeyEvent]}}(),h=g.keySequence,i=g.eventBitmapIndex,j=KeySequenceParser.parse(h,{eventBitmapIndex:i}),k=j.sequence,l=j.combination;k.size>d.longestSequence&&(d.longestSequence=k.size,d.longestSequenceComponentIndex=c),KeyEventBitmapManager.setBit(d.keyMapEventBitmap,i),e[f]||(e[f]=[]),e[f].push(_objectSpread({prefix:k.prefix,actionName:f,sequenceLength:k.size},l));}),e},{})}},{key:"_getCurrentKeyCombination",value:function a(){return 0<this.keyCombinationHistory.length?this.keyCombinationHistory[this.keyCombinationHistory.length-1]:{keys:{},ids:[""],keyAliases:{}}}},{key:"_addToCurrentKeyCombination",value:function f(a,b){0===this.keyCombinationHistory.length&&this.keyCombinationHistory.push({keys:{},ids:[""],keyAliases:{}});var c=this._getCurrentKeyCombination(),d=getKeyAlias(c,a),e=getKeyState(c,a);c.keys[d]=e?[KeyEventBitmapManager.clone(e[1]),KeyEventBitmapManager.newBitmap(b)]:[KeyEventBitmapManager.newBitmap(),KeyEventBitmapManager.newBitmap(b)],c.ids=KeyCombinationSerializer.serialize(c.keys),c.keyAliases=this._buildCombinationKeyAliases(c.keys),b===KeyEventBitmapIndex.keyup&&(this.keyCombinationIncludesKeyUp=!0);}},{key:"_startNewKeyCombination",value:function e(a,b){this.keyCombinationHistory.length>this.longestSequence&&this.keyCombinationHistory.shift();var c=this._getCurrentKeyCombination(),d=_objectSpread({},this._withoutKeyUps(c),_defineProperty({},a,[KeyEventBitmapManager.newBitmap(),KeyEventBitmapManager.newBitmap(b)]));this.keyCombinationHistory.push({keys:d,ids:KeyCombinationSerializer.serialize(d),keyAliases:this._buildCombinationKeyAliases(d)}),this.keyCombinationIncludesKeyUp=!1;}},{key:"_withoutKeyUps",value:function b(a){return Object.keys(a.keys).reduce(function(b,c){var d=a.keys[c];return d[KeyEventSequenceIndex.current][KeyEventBitmapIndex.keyup]||(b[c]=d),b},{})}},{key:"_shouldSimulate",value:function d(a,b){var c=hasKeyPressEvent(b);return a===KeyEventBitmapIndex.keypress?!c||c&&this._keyIsCurrentlyDown("Meta"):a===KeyEventBitmapIndex.keyup&&c&&keyIsCurrentlyTriggeringEvent(this._getCurrentKeyState("Meta"),KeyEventBitmapIndex.keyup)}},{key:"_cloneAndMergeEvent",value:function d(a,b){var c=Object.keys(ModifierFlagsDictionary).reduce(function(b,c){return b[c]=a[c],b},{});return _objectSpread({},c,b)}},{key:"_callMatchingHandlerClosestToEventTarget",value:function v(a,b,c,d,e){var f=this;for(this.keyMaps&&this.unmatchedHandlerStatus||(this.keyMaps=[],this.unmatchedHandlerStatus=[],this.componentList.forEach(function(a){var b=a.handlers;f.unmatchedHandlerStatus.push([Object.keys(b).length,{}]),f.keyMaps.push({});}));e<=d;){var g=this.unmatchedHandlerStatus[e],h=g[0];if(0<h)for(var i=function(){var a=f.componentList[f.handlerResolutionSearchIndex],b=a.handlers,c=a.actions;Object.keys(b).forEach(function(a){f.handlersDictionary[a]||(f.handlersDictionary[a]=[]),f.handlersDictionary[a].push(f.handlerResolutionSearchIndex);}),Object.keys(c).forEach(function(a){var b=f.handlersDictionary[a];if(b){var d=b[0],e=f.componentList[d].handlers[a],g=f.keyMaps[d];g.sequences||(g.sequences={});var h=c[a];h.forEach(function(a){var b=[a.prefix,a.id].join(" "),c=f.keySequencesDictionary[b]&&f.keySequencesDictionary[b].some(function(b){return b[1]===a.eventBitmapIndex});if(!c){g.sequences[a.prefix]||(g.sequences[a.prefix]={combinations:{}});var h=a.prefix,i=a.sequenceLength,j=a.id,k=a.keyDictionary,l=a.size,m=a.eventBitmapIndex,n=a.actionName,o=g.sequences[a.prefix].combinations[a.id];g.sequences[a.prefix].combinations[a.id]=o?_objectSpread({},o,{events:_objectSpread({},o.events,_defineProperty({},m,{actionName:n,eventBitmapIndex:m,handler:e}))}):{prefix:h,sequenceLength:i,id:j,keyDictionary:k,size:l,events:_defineProperty({},m,{actionName:n,eventBitmapIndex:m,handler:e})},g.eventBitmap||(g.eventBitmap=KeyEventBitmapManager.newBitmap()),KeyEventBitmapManager.setBit(g.eventBitmap,a.eventBitmapIndex),(!g.longestSequence||g.longestSequence<a.sequenceLength)&&(g.longestSequence=a.sequenceLength),f.keySequencesDictionary[b]||(f.keySequencesDictionary[b]=[]),f.keySequencesDictionary[b].push([d,a.eventBitmapIndex]);}}),b.forEach(function(b){var c=f.unmatchedHandlerStatus[b];c[1][a]||(c[1][a]=!0,c[0]--);});}}),f.handlerResolutionSearchIndex++;};this.handlerResolutionSearchIndex<this.componentList.length&&0<h;)i();var w=this.keyMaps[e];if(!w||isEmpty(w.sequences)||!w.eventBitmap[c]);else{for(var j=w.sequences,k=w.longestSequence,l=this._getCurrentKeyCombination(),m=getKeyAlias(l,b),n=k;0<=n;){var o=this.keyCombinationHistory.slice(-n,-1),p=o.map(function(a){var b=a.ids;return b}),q=this._tryMatchSequenceWithKeyAliases(j,p);if(q){q.order||function(){var a=Object.values(q.combinations).reduce(function(a,b){var c=b.id,d=b.size;return a[d]||(a[d]=[]),a[d].push(c),a},{});q.order=Object.keys(a).sort(function(c,a){return a-c}).reduce(function(b,c){return b.concat(a[c])},[]);}();for(var r=q.order,s=0;s<r.length;){var t=r[s],u=q.combinations[t];if(this._combinationMatchesKeys(m,l,u,c)){var x=KeyCombinationSerializer.serialize(u.keyDictionary);return u.events[c].handler(a),this._stopEventPropagationAfterHandlingIfEnabled(a,e),!0}s++;}}n--;}}e++;}}},{key:"_stopEventPropagationAfterHandlingIfEnabled",value:function c(a,b){return !!Configuration.option("stopEventPropagationAfterHandling")&&(this._stopEventPropagation(a,b),!0)}},{key:"_stopEventPropagationAfterIgnoringIfEnabled",value:function c(a,b){return !!Configuration.option("stopEventPropagationAfterIgnoring")&&(this._stopEventPropagation(a,b),!0)}},{key:"_describeCurrentKeyCombination",value:function a(){return this._getCurrentKeyCombination().ids[0]}},{key:"_tryMatchSequenceWithKeyAliases",value:function l(a,b){if(0===b.length)return a[""];for(var c=b.map(function(a){return a.length}),d=b.map(function(){return 0}),e=!1;!e;){var f=d.map(function(a,c){return b[c][a]}),g=f.join(" ");if(a[g])return a[g];for(var h=0,i=!0;i&&h<d.length;){var j=indexFromEnd(d,h),k=(j+1)%(indexFromEnd(c,h)||1);d[d.length-(h+1)]=k,i=0==k,i&&h++;}e=h===d.length;}}},{key:"_combinationMatchesKeys",value:function h(a,b,c,d){var e=c.events[d];if(!e)return !1;var f=!1,g=!Object.keys(c.keyDictionary).some(function(c){var e=getKeyState(b,c);return !e||!keyIsCurrentlyTriggeringEvent(e,d)||(a&&a===getKeyAlias(b,c)&&(f=!keyAlreadyTriggeredEvent(e,d)),!1)});return g&&f}},{key:"_checkForModifierFlagDiscrepancies",value:function c(a){var b=this;Object.keys(ModifierFlagsDictionary).forEach(function(c){var d=b._keyIsCurrentlyDown(c);ModifierFlagsDictionary[c].forEach(function(e){!1===a[e]&&d&&b._addToCurrentKeyCombination(c,KeyEventBitmapIndex.keyup);});});}},{key:"_keyIsCurrentlyDown",value:function d(a){var b=this._getCurrentKeyState(a),c=keyIsCurrentlyTriggeringEvent(b,KeyEventBitmapIndex.keypress)&&!keyIsCurrentlyTriggeringEvent(b,KeyEventBitmapIndex.keyup);return !!c}},{key:"_getCurrentKeyState",value:function c(a){var b=this._getCurrentKeyCombination();return getKeyState(b,a)}},{key:"_buildCombinationKeyAliases",value:function c(a){var b=function(){if(a.Shift)return a.Alt?[resolveAltShiftedAlias,resolveUnaltShiftedAlias]:[resolveShiftedAlias,resolveUnshiftedAlias];if(a.Alt)return [resolveAltedAlias,resolveUnaltedAlias];var b=function(a){return [a]};return [b,b]}();return Object.keys(a).reduce(function(a,c){return resolveKeyAlias(c).forEach(function(d){b.forEach(function(b){b(d).forEach(function(b){(b!==c||c!==d)&&(a[b]=c);});});}),a},{})}},{key:"_setComponentPosition",value:function c(a,b){this.componentIdDict[a]=b;}},{key:"_getComponentPosition",value:function b(a){return this.componentIdDict[a]}},{key:"_getComponent",value:function c(a){var b=this._getComponentPosition(a);return this.componentList[b]}},{key:"_getComponentAndPosition",value:function c(a){var b=this._getComponentPosition(a);return [this.componentList[b],b]}},{key:"_logPrefix",value:function a(){}}]),a}();function keyIsCurrentlyTriggeringEvent(a,b){return a&&a[KeyEventSequenceIndex.current][b]}function getKeyAlias(a,b){var c=a.keys[b];if(c)return b;var d=a.keyAliases[b];return d?d:b}function getKeyState(a,b){var c=a.keys[b];if(c)return c;var d=a.keyAliases[b];if(d)return a.keys[d]}function newComponentRegistryItem(){return {childIds:[],parentId:null}}function keyAlreadyTriggeredEvent(a,b){return a&&a[KeyEventSequenceIndex.previous][b]}

var KeyEventCounter=function(){function a(){_classCallCheck(this,a);}return _createClass(a,null,[{key:"getId",value:function a(){return isUndefined(this.id)&&(this.id=0),this.id}},{key:"incrementId",value:function a(){this.id=this.getId()+1;}}]),a}();

function normalizeKeyName(a){return "+"===a?"plus":a}

function isCmdKey(a){return "Meta"===a}

var EventResponse={unseen:0,ignored:1,seen:2,recorded:3,handled:4};

var FocusOnlyKeyEventStrategy=function(a){function b(){var a,c=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{},d=1<arguments.length?arguments[1]:void 0;return _classCallCheck(this,b),a=_possibleConstructorReturn(this,_getPrototypeOf(b).call(this,c,d)),a.focusTreeId=0,a.currentEvent={key:null,type:null,handled:!1,ignored:!1},a}return _inherits(b,a),_createClass(b,[{key:"_reset",value:function a(){_get(_getPrototypeOf(b.prototype),"_reset",this).call(this),this.keypressEventsToSimulate=[],this.focusTreeId+=1,this._clearEventPropagationState();}},{key:"_clearEventPropagationState",value:function a(){this.eventPropagationState={previousComponentPosition:-1,actionHandled:!1,ignoreEvent:!1,forceObserveEvent:!1,stopping:!1};}},{key:"enableHotKeys",value:function f(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},c=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},d=3<arguments.length?arguments[3]:void 0;(this.resetOnNextFocus||this.keyMaps)&&(this._reset(),this.resetOnNextFocus=!1),this._addComponentToList(a,b,c,d),void 0;var e=this._getComponent(a);return this.focusTreeId}},{key:"updateEnabledHotKeys",value:function h(a,b){var c=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},d=3<arguments.length&&void 0!==arguments[3]?arguments[3]:{},e=4<arguments.length?arguments[4]:void 0,f=this._getComponentPosition(b);if(!(a!==this.focusTreeId||isUndefined(f))){this.componentList[f]=this._buildComponentOptions(b,c,d,e),void 0;var g=this._getComponent(b);}}},{key:"disableHotKeys",value:function f(a,b){this.resetOnNextFocus||(this.resetOnNextFocus=!0);var c=this._getComponentPosition(b),d=this.eventPropagationState.previousComponentPosition,e=-1!==d&&d+1<c;return e}},{key:"handleKeydown",value:function g(a,b,c){var d=3<arguments.length&&void 0!==arguments[3]?arguments[3]:{},e=normalizeKeyName(a.key);if(b!==this.focusTreeId)return this._ignoreEvent(a,c),!0;var f=this._howToHandleKeyDownEvent(a,b,c,e,d,KeyEventBitmapIndex.keydown);if(f===EventResponse.handled){var h=!!this._getCurrentKeyState(e);h||this.keyCombinationIncludesKeyUp?this._startAndLogNewKeyCombination(e,KeyEventBitmapIndex.keydown,b,c):this._addToAndLogCurrentKeyCombination(e,KeyEventBitmapIndex.keydown,b,c),this._callHandlerIfActionNotHandled(a,e,KeyEventBitmapIndex.keydown,c,b);}return this._simulateKeyPressesMissingFromBrowser(a,e,b,c,d),this._updateEventPropagationHistory(c),!1}},{key:"_howToHandleKeyDownEvent",value:function g(a,b,c,d,e,f){if(this._shouldIgnoreEvent())return this._ignoreEvent(a,c),EventResponse.ignored;if(this._isNewKeyEvent(c)){if(this._setNewEventParameters(a,f),this._setIgnoreEventFlag(a,e),this._shouldIgnoreEvent())return this._ignoreEvent(a,c),EventResponse.ignored;this._checkForModifierFlagDiscrepancies(a);}return EventResponse.handled}},{key:"handleKeypress",value:function h(a,b,c,d){var e=normalizeKeyName(a.key),f=b!==this.focusTreeId,g=this._howToHandleKeyDownEvent(a,b,c,e,d,KeyEventBitmapIndex.keypress);return this._isNewKeyEvent(c)&&this._getCurrentKeyState(e)&&this._addToAndLogCurrentKeyCombination(e,KeyEventBitmapIndex.keypress,b,c),g===EventResponse.handled&&this._callHandlerIfActionNotHandled(a,e,KeyEventBitmapIndex.keypress,c,b),this._updateEventPropagationHistory(c),f}},{key:"handleKeyup",value:function h(a,b,c,d){var e=normalizeKeyName(a.key),f=b!==this.focusTreeId,g=this._howToHandleKeyDownEvent(a,b,c,e,d,KeyEventBitmapIndex.keyup);return this._isNewKeyEvent(c)&&this._getCurrentKeyState(e)&&this._addToAndLogCurrentKeyCombination(e,KeyEventBitmapIndex.keyup,b,c),g===EventResponse.handled&&this._callHandlerIfActionNotHandled(a,e,KeyEventBitmapIndex.keyup,c,b),this._simulateKeyUpEventsHiddenByCmd(a,e,b,c,d),this._updateEventPropagationHistory(c),f}},{key:"_simulateKeyPressesMissingFromBrowser",value:function f(a,b,c,d,e){this._handleEventSimulation("keypressEventsToSimulate","simulatePendingKeyPressEvents",this._shouldSimulate(KeyEventBitmapIndex.keypress,b),{event:a,key:b,focusTreeId:c,componentId:d,options:e});}},{key:"_simulateKeyUpEventsHiddenByCmd",value:function g(a,b,c,d,e){var f=this;isCmdKey(b)&&Object.keys(this._getCurrentKeyCombination().keys).forEach(function(b){isCmdKey(b)||f._handleEventSimulation("keyupEventsToSimulate","simulatePendingKeyUpEvents",f._shouldSimulate(KeyEventBitmapIndex.keyup,b),{event:a,key:b,focusTreeId:c,componentId:d,options:e});});}},{key:"_ignoreEvent",value:function c(a,b){this.currentEvent.ignored=!0,this._stopEventPropagationAfterIgnoringIfEnabled(a,b)?this._updateEventPropagationHistory(b,{forceReset:!0}):this._updateEventPropagationHistory(b);}},{key:"_shouldIgnoreEvent",value:function d(){var a=this.eventPropagationState,b=a.ignoreEvent,c=a.forceObserveEvent;return !c&&b}},{key:"_isNewKeyEvent",value:function c(a){var b=this.eventPropagationState.previousComponentPosition;return -1===b||b>=this._getComponentPosition(a)}},{key:"_updateEventPropagationHistory",value:function c(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{forceReset:!1};b.forceReset||this._isFocusTreeRoot(a)?this._clearEventPropagationState():this.eventPropagationState.previousComponentPosition=this._getComponentPosition(a);}},{key:"_setIgnoreEventFlag",value:function c(a,b){this.eventPropagationState.ignoreEvent=b.ignoreEventsCondition(a);}},{key:"ignoreEvent",value:function a(){this.eventPropagationState.ignoreEvent=!0;}},{key:"forceObserveEvent",value:function a(){this.eventPropagationState.forceObserveEvent=!0;}},{key:"_isFocusTreeRoot",value:function b(a){return this._getComponentPosition(a)>=this.componentList.length-1}},{key:"_setNewEventParameters",value:function c(a,b){KeyEventCounter.incrementId(),this.currentEvent={key:a.key,type:b,handled:!1,ignored:!1};}},{key:"_startAndLogNewKeyCombination",value:function e(a,b,c,d){this._startNewKeyCombination(a,b),void 0;}},{key:"_addToAndLogCurrentKeyCombination",value:function e(a,b,c,d){this._addToCurrentKeyCombination(a,b),void 0;}},{key:"_stopEventPropagation",value:function c(a,b){this.eventPropagationState.stopping||(this.eventPropagationState.stopping=!0,!a.simulated&&a.stopPropagation());}},{key:"_handleEventSimulation",value:function j(a,b,c,d){var e=d.event,f=d.key,g=d.focusTreeId,h=d.componentId,i=d.options;if(c&&Configuration.option("simulateMissingKeyPressEvents")){var k=this._cloneAndMergeEvent(e,{key:f,simulated:!0});this[a].push({event:k,focusTreeId:g,componentId:h,options:i});}(this._isFocusTreeRoot(h)||this.eventPropagationState.stopping)&&!this.keyEventManager.isGlobalListenersBound()&&this[b]();}},{key:"simulatePendingKeyPressEvents",value:function a(){this._simulatePendingKeyEvents("keypressEventsToSimulate","handleKeypress");}},{key:"simulatePendingKeyUpEvents",value:function a(){this._simulatePendingKeyEvents("keyupEventsToSimulate","handleKeyup");}},{key:"_simulatePendingKeyEvents",value:function d(a,b){var c=this;0<this[a].length&&KeyEventCounter.incrementId(),this[a].forEach(function(a){var d=a.event,e=a.focusTreeId,f=a.componentId,g=a.options;c[b](d,e,f,g);}),this[a]=[],this._clearEventPropagationState();}},{key:"_callHandlerIfActionNotHandled",value:function k(a,b,c,d,e){var g=this._describeCurrentKeyCombination();if(!this.keyMapEventBitmap[c]);else if(this.eventPropagationState.actionHandled);else{var h=this.eventPropagationState.previousComponentPosition,i=this._getComponentPosition(d),j=this._callMatchingHandlerClosestToEventTarget(a,b,c,i,-1===h?0:h);j&&(this.eventPropagationState.actionHandled=!0,this.currentEvent.handled=!0);}}},{key:"_logPrefix",value:function h(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},c=Logger.logIcons,d=Logger.eventIcons,e=Logger.componentIcons,f="HotKeys (";if(!1!==b.focusTreeId){var i=isUndefined(b.focusTreeId)?this.focusTreeId:b.focusTreeId;f+="F".concat(i).concat(c[i%c.length],"-");}if(!1!==b.eventId){var j=isUndefined(b.eventId)?KeyEventCounter.getId():b.eventId;f+="E".concat(j).concat(d[j%d.length],"-");}f+="C".concat(a).concat(e[a%e.length]);var g=this._getComponentPosition(a);return isUndefined(g)||(f+="-P".concat(g).concat(e[g%e.length],":")),"".concat(f,")")}}]),b}(AbstractKeyEventStrategy);

function capitalize(a){return a.replace(/\b\w/g,function(a){return a.toUpperCase()})}

function removeAtIndex(a,b){return [].concat(_toConsumableArray(a.slice(0,b)),_toConsumableArray(a.slice(b+1)))}

function getEventCharCode(a){var b,c=a.keyCode;return "charCode"in a?(b=a.charCode,0===b&&13===c&&(b=13)):b=c,10===b&&(b=13),32<=b||13===b?b:0}

var normalizeKey={Esc:"Escape",Spacebar:" ",Left:"ArrowLeft",Up:"ArrowUp",Right:"ArrowRight",Down:"ArrowDown",Del:"Delete",Win:"OS",Menu:"ContextMenu",Apps:"ContextMenu",Scroll:"ScrollLock",MozPrintableKey:"Unidentified"},translateToKey={8:"Backspace",9:"Tab",12:"Clear",13:"Enter",16:"Shift",17:"Control",18:"Alt",19:"Pause",20:"CapsLock",27:"Escape",32:" ",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"ArrowLeft",38:"ArrowUp",39:"ArrowRight",40:"ArrowDown",45:"Insert",46:"Delete",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"NumLock",145:"ScrollLock",224:"Meta"};function getEventKey(a){if(a.key){var b=normalizeKey[a.key]||a.key;if("Unidentified"!==b)return b}if("keypress"===a.type){var c=getEventCharCode(a);return 13===c?"Enter":String.fromCharCode(c)}return "keydown"===a.type||"keyup"===a.type?translateToKey[a.keyCode]||"Unidentified":""}

function contains(a,b){var c=2<arguments.length&&arguments[2]!==void 0?arguments[2]:{};return Array.isArray(a)||isString(a)?c.stringifyFirst?!isUndefined(a.find(function(a){return a.toString()===b.toString()})):-1!==a.indexOf(b):isObject(a)?hasKey(a,b):c.stringifyFirst?a.toString()===b.toString():a===b}

var GlobalKeyEventStrategy=function(a){function b(){var a,c=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{},d=1<arguments.length?arguments[1]:void 0;return _classCallCheck(this,b),a=_possibleConstructorReturn(this,_getPrototypeOf(b).call(this,c,d)),a.listenersBound=!1,a.eventOptions={ignoreEventsCondition:Configuration.option("ignoreEventsCondition")},a}return _inherits(b,a),_createClass(b,[{key:"enableHotKeys",value:function f(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},c=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},d=3<arguments.length?arguments[3]:void 0,e=4<arguments.length?arguments[4]:void 0;this.eventOptions=e,this._addComponentToList(a,b,c,d),this._updateDocumentHandlers(),void 0;}},{key:"updateEnabledHotKeys",value:function g(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},c=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},d=3<arguments.length?arguments[3]:void 0,e=4<arguments.length?arguments[4]:void 0;this.eventOptions=e;var f=this._getComponentPosition(a);this.componentList[f]=this._buildComponentOptions(a,b,c,d),this._updateLongestKeySequenceIfNecessary(a),this._updateDocumentHandlers(),this._initHandlerResolutionState(),void 0;}},{key:"disableHotKeys",value:function f(a){var b=this._getComponentAndPosition(a),c=_slicedToArray(b,2),d=c[0].keyMapEventBitmap,e=c[1];this.componentList=removeAtIndex(this.componentList,e),this._updateLongestKeySequenceIfNecessary(a),this._updateComponentIndexDictFromList({startingAt:e}),this._updateDocumentHandlers(d,KeyEventBitmapManager.newBitmap()),this._initHandlerResolutionState(),void 0;}},{key:"_updateLongestKeySequenceIfNecessary",value:function c(a){var b=this;a===this.longestSequenceComponentIndex&&(this.longestSequence=1,this.componentList.forEach(function(a){var c=a.longestSequence;c>b.longestSequence&&(b.longestSequence=c);}));}},{key:"_updateComponentIndexDictFromList",value:function c(){for(var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{startingAt:0},b=a.startingAt;b<this.componentList.length;)this._setComponentPosition(this.componentList[b].componentId,b),b++;}},{key:"_updateDocumentHandlers",value:function e(){var a=this,b=this.keyMapEventBitmap.some(function(a){return a});if(!this.listenersBound&&b){for(var c=function(b){var c=describeKeyEventType(b);document["on".concat(c)]=function(b){a.keyEventManager["handleGlobal".concat(capitalize(c))](b);},void 0;},d=0;d<this.keyMapEventBitmap.length;d++)c(d);this.listenersBound=!0;}else if(this.listenersBound&&!b){for(var f,g=0;g<this.keyMapEventBitmap.length;g++)f=describeKeyEventType(g),delete document["on".concat(f)],void 0;this.listenersBound=!1;}}},{key:"handleKeydown",value:function d(a){this._checkForModifierFlagDiscrepancies(a);var b=normalizeKeyName(getEventKey(a)),c=this._howReactAppRespondedTo(a,b,KeyEventBitmapIndex.keydown);if(c===EventResponse.unseen&&this.eventOptions.ignoreEventsCondition(a))return void void 0;if(c!==EventResponse.ignored){var e=!!this._getCurrentKeyState(b);e||this.keyCombinationIncludesKeyUp?this._startAndLogNewKeyCombination(b,KeyEventBitmapIndex.keydown):this._addToAndLogCurrentKeyCombination(b,KeyEventBitmapIndex.keydown);}contains([EventResponse.ignored,EventResponse.handled],c)||this._callHandlerIfExists(a,b,KeyEventBitmapIndex.keydown),this._simulateKeyPressesMissingFromBrowser(a,b);}},{key:"_howReactAppRespondedTo",value:function e(a,b,c){var d=this.keyEventManager.reactAppHistoryWithEvent(b,c);return d===EventResponse.handled?void 0:d===EventResponse.ignored?void 0:d===EventResponse.seen?void 0:(KeyEventCounter.incrementId(),void 0),d}},{key:"handleKeypress",value:function d(a){var b=normalizeKeyName(getEventKey(a)),c=this._howReactAppRespondedTo(a,b,KeyEventBitmapIndex.keypress);return this._getCurrentKeyState(b)&&this._addToAndLogCurrentKeyCombination(b,KeyEventBitmapIndex.keypress),c===EventResponse.unseen&&this.eventOptions.ignoreEventsCondition(a)?void void 0:void(!contains([EventResponse.ignored,EventResponse.handled],c)&&this._callHandlerIfExists(a,b,KeyEventBitmapIndex.keypress))}},{key:"handleKeyup",value:function d(a){var b=normalizeKeyName(getEventKey(a)),c=this._howReactAppRespondedTo(a,b,KeyEventBitmapIndex.keyup);this._getCurrentKeyState(b)&&this._addToAndLogCurrentKeyCombination(b,KeyEventBitmapIndex.keyup),c===EventResponse.unseen&&this.eventOptions.ignoreEventsCondition(a)?void 0:!contains([EventResponse.ignored,EventResponse.handled],c)&&this._callHandlerIfExists(a,b,KeyEventBitmapIndex.keyup),this._simulateKeyUpEventsHiddenByCmd(a,b);}},{key:"_simulateKeyPressesMissingFromBrowser",value:function c(a,b){this.keyEventManager.simulatePendingKeyPressEvents(),this._handleEventSimulation("handleKeypress",this._shouldSimulate(KeyEventBitmapIndex.keypress,b),{event:a,key:b});}},{key:"_simulateKeyUpEventsHiddenByCmd",value:function d(a,b){var c=this;isCmdKey(b)&&(this.keyEventManager.simulatePendingKeyUpEvents(),Object.keys(this._getCurrentKeyCombination().keys).forEach(function(b){isCmdKey(b)||c._handleEventSimulation("handleKeyup",c._shouldSimulate(KeyEventBitmapIndex.keyup,b),{event:a,key:b});}));}},{key:"_startAndLogNewKeyCombination",value:function c(a,b){this._startNewKeyCombination(a,b),void 0;}},{key:"_addToAndLogCurrentKeyCombination",value:function c(a,b){this._addToCurrentKeyCombination(a,b),void 0;}},{key:"_handleEventSimulation",value:function f(a,b,c){var d=c.event,e=c.key;if(b&&Configuration.option("simulateMissingKeyPressEvents")){var g=this._cloneAndMergeEvent(d,{key:e,simulated:!0});this[a](g);}}},{key:"_callHandlerIfExists",value:function f(a,b,c){var e=this._describeCurrentKeyCombination();this.keyMapEventBitmap[c]?(this._callMatchingHandlerClosestToEventTarget(a,b,c)):void 0;}},{key:"_callMatchingHandlerClosestToEventTarget",value:function e(a,c,d){for(var f,g=0;g<this.componentList.length;g++)if(f=_get(_getPrototypeOf(b.prototype),"_callMatchingHandlerClosestToEventTarget",this).call(this,a,c,d,g,0),f)return void void 0}},{key:"_stopEventPropagation",value:function c(a,b){a.simulated||a.stopPropagation();}},{key:"_logPrefix",value:function f(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},c=Logger.eventIcons,d=Logger.componentIcons,e="HotKeys (GLOBAL";if(!1!==b.eventId){var g=isUndefined(b.eventId)?KeyEventCounter.getId():b.eventId;e="".concat(e,"-E").concat(g).concat(c[g%c.length]);}return isUndefined(a)?"".concat(e,"):"):"".concat(e,"-C").concat(a).concat(d[a%d.length],"):")}}]),b}(AbstractKeyEventStrategy);

function isFromFocusOnlyComponent(a){return !isUndefined(a)}

var KeyEventManager=function(){function a(){var b=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{};_classCallCheck(this,a),this.logger=b.logger||new Logger(Configuration.option("logLevel")),this._focusOnlyEventStrategy=new FocusOnlyKeyEventStrategy({configuration:b,logger:this.logger},this),this._globalEventStrategy=new GlobalKeyEventStrategy({configuration:b,logger:this.logger},this);}return _createClass(a,null,[{key:"getInstance",value:function c(){var b=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{};return this.instance||(this.instance=new a(b)),this.instance}},{key:"clear",value:function a(){delete this.instance;}}]),_createClass(a,[{key:"getApplicationKeyMap",value:function a(){return Object.assign(this._globalEventStrategy.getApplicationKeyMap(),this._focusOnlyEventStrategy.getApplicationKeyMap())}},{key:"registerKeyMap",value:function b(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{};return this._focusOnlyEventStrategy.registerKeyMap(a)}},{key:"reregisterKeyMap",value:function c(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};this._focusOnlyEventStrategy.reregisterKeyMap(a,b);}},{key:"deregisterKeyMap",value:function b(a){this._focusOnlyEventStrategy.deregisterKeyMap(a);}},{key:"registerComponentMount",value:function c(a,b){return this._focusOnlyEventStrategy.registerComponentMount(a,b)}},{key:"registerGlobalKeyMap",value:function b(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{};return this._globalEventStrategy.registerKeyMap(a)}},{key:"registerGlobalComponentMount",value:function c(a,b){return this._globalEventStrategy.registerComponentMount(a,b)}},{key:"reregisterGlobalKeyMap",value:function c(a,b){this._globalEventStrategy.reregisterKeyMap(a,b);}},{key:"deregisterGlobalKeyMap",value:function b(a){this._globalEventStrategy.deregisterKeyMap(a);}},{key:"enableHotKeys",value:function e(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},c=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},d=3<arguments.length?arguments[3]:void 0;return this._focusOnlyEventStrategy.enableHotKeys(a,b,c,d)}},{key:"updateEnabledHotKeys",value:function f(a,b){var c=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},d=3<arguments.length&&void 0!==arguments[3]?arguments[3]:{},e=4<arguments.length?arguments[4]:void 0;return this._focusOnlyEventStrategy.updateEnabledHotKeys(a,b,c,d,e)}},{key:"disableHotKeys",value:function c(a,b){return this._focusOnlyEventStrategy.disableHotKeys(a,b)}},{key:"handleKeydown",value:function e(a,b,c,d){if(isFromFocusOnlyComponent(b))return this._focusOnlyEventStrategy.handleKeydown(a,b,c,d)}},{key:"handleKeypress",value:function e(a,b,c,d){if(isFromFocusOnlyComponent(b))return this._focusOnlyEventStrategy.handleKeypress(a,b,c,d)}},{key:"handleKeyup",value:function e(a,b,c,d){if(isFromFocusOnlyComponent(b))return this._focusOnlyEventStrategy.handleKeyup(a,b,c,d)}},{key:"enableGlobalHotKeys",value:function f(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},c=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},d=3<arguments.length?arguments[3]:void 0,e=4<arguments.length?arguments[4]:void 0;return this._globalEventStrategy.enableHotKeys(a,b,c,d,e)}},{key:"updateEnabledGlobalHotKeys",value:function f(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},c=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},d=3<arguments.length?arguments[3]:void 0,e=4<arguments.length?arguments[4]:void 0;return this._globalEventStrategy.updateEnabledHotKeys(a,b,c,d,e)}},{key:"disableGlobalHotKeys",value:function b(a){return this._globalEventStrategy.disableHotKeys(a)}},{key:"handleGlobalKeydown",value:function b(a){return this._globalEventStrategy.handleKeydown(a)}},{key:"handleGlobalKeypress",value:function b(a){return this._globalEventStrategy.handleKeypress(a)}},{key:"handleGlobalKeyup",value:function b(a){return this._globalEventStrategy.handleKeyup(a)}},{key:"ignoreEvent",value:function b(a){this._focusOnlyEventStrategy.ignoreEvent(a);}},{key:"forceObserveEvent",value:function b(a){this._focusOnlyEventStrategy.forceObserveEvent(a);}},{key:"reactAppHistoryWithEvent",value:function d(a,b){var c=this._focusOnlyEventStrategy.currentEvent;return c.key===a&&c.type===b?c.handled?EventResponse.handled:c.ignored?EventResponse.ignored:EventResponse.seen:EventResponse.unseen}},{key:"simulatePendingKeyPressEvents",value:function a(){this._focusOnlyEventStrategy.simulatePendingKeyPressEvents();}},{key:"simulatePendingKeyUpEvents",value:function a(){this._focusOnlyEventStrategy.simulatePendingKeyUpEvents();}},{key:"isGlobalListenersBound",value:function a(){return this._globalEventStrategy.listenersBound}}]),a}();

function withHotKeys(a){function b(a,b){return _objectSpread({},g[a]||{},b[a]||{})}function c(a){return b("handlers",a)}function d(a){return b("keyMap",a)}var e,f,g=1<arguments.length&&arguments[1]!==void 0?arguments[1]:{};return f=e=function(b){function e(a){var b;return _classCallCheck(this,e),b=_possibleConstructorReturn(this,_getPrototypeOf(e).call(this,a)),b._handleFocus=b._handleFocus.bind(_assertThisInitialized(_assertThisInitialized(b))),b._handleBlur=b._handleBlur.bind(_assertThisInitialized(_assertThisInitialized(b))),b._handleKeyDown=b._handleKeyDown.bind(_assertThisInitialized(_assertThisInitialized(b))),b._handleKeyPress=b._handleKeyPress.bind(_assertThisInitialized(_assertThisInitialized(b))),b._handleKeyUp=b._handleKeyUp.bind(_assertThisInitialized(_assertThisInitialized(b))),b._componentIsFocused=b._componentIsFocused.bind(_assertThisInitialized(_assertThisInitialized(b))),b._id=KeyEventManager.getInstance().registerKeyMap(a.keyMap),b}return _inherits(e,b),_createClass(e,[{key:"getChildContext",value:function a(){return {hotKeysParentId:this._id}}},{key:"render",value:function h(){var b=this.props,c=b.keyMap,d=b.handlers,e=b.allowChanges,f=_objectWithoutProperties(b,["keyMap","handlers","allowChanges"]),g={onFocus:this._wrapFunction("onFocus",this._handleFocus),onBlur:this._wrapFunction("onBlur",this._handleBlur),tabIndex:Configuration.option("defaultTabIndex")};return this._shouldBindKeyListeners()&&(g.onKeyDown=this._handleKeyDown,g.onKeyPress=this._handleKeyPress,g.onKeyUp=this._handleKeyUp),React.createElement(a,_extends({hotKeys:g},f))}},{key:"_shouldBindKeyListeners",value:function b(){var a=d(this.props);return !isEmpty(a)||Configuration.option("enableHardSequences")&&this._handlersIncludeHardSequences(a,c(this.props))}},{key:"_handlersIncludeHardSequences",value:function c(a,b){return Object.keys(b).some(function(b){return !a[b]&&KeyCombinationSerializer.isValidKeySerialization(b)})}},{key:"_wrapFunction",value:function d(a,b){var c=this;return "function"==typeof this.props[a]?function(d){c.props[a](d),b(d);}:b}},{key:"_focusTreeIdsPush",value:function b(a){this._focusTreeIds||(this._focusTreeIds=[]),this._focusTreeIds.push(a);}},{key:"_focusTreeIdsShift",value:function a(){this._focusTreeIds&&this._focusTreeIds.shift();}},{key:"_getFocusTreeId",value:function a(){if(this._focusTreeIds)return this._focusTreeIds[0]}},{key:"componentDidUpdate",value:function e(){var a=KeyEventManager.getInstance();if(a.reregisterKeyMap(this._id,this.props.keyMap),this._componentIsFocused()&&(this.props.allowChanges||!Configuration.option("ignoreKeymapAndHandlerChangesByDefault"))){var b=this.props,c=b.keyMap,d=b.handlers;a.updateEnabledHotKeys(this._getFocusTreeId(),this._id,c,d,this._getComponentOptions());}}},{key:"_componentIsFocused",value:function a(){return !0===this._focused}},{key:"componentDidMount",value:function c(){var a=KeyEventManager.getInstance(),b=this.context.hotKeysParentId;a.registerComponentMount(this._id,b);}},{key:"_handleFocus",value:function e(){if(this.props.onFocus){var a;(a=this.props).onFocus.apply(a,arguments);}var b=KeyEventManager.getInstance().enableHotKeys(this._id,d(this.props),c(this.props),this._getComponentOptions());this._focusTreeIdsPush(b),this._focused=!0;}},{key:"componentWillUnmount",value:function b(){var a=KeyEventManager.getInstance();a.deregisterKeyMap(this._id),this._handleBlur();}},{key:"_handleBlur",value:function c(){if(this.props.onBlur){var a;(a=this.props).onBlur.apply(a,arguments);}var b=KeyEventManager.getInstance().disableHotKeys(this._getFocusTreeId(),this._id);b||this._focusTreeIdsShift(),this._focused=!1;}},{key:"_handleKeyDown",value:function c(a){var b=KeyEventManager.getInstance().handleKeydown(a,this._getFocusTreeId(),this._id,this._getEventOptions());b&&this._focusTreeIdsShift();}},{key:"_handleKeyPress",value:function c(a){var b=KeyEventManager.getInstance().handleKeypress(a,this._getFocusTreeId(),this._id,this._getEventOptions());b&&this._focusTreeIdsShift();}},{key:"_handleKeyUp",value:function c(a){var b=KeyEventManager.getInstance().handleKeyup(a,this._getFocusTreeId(),this._id,this._getEventOptions());b&&this._focusTreeIdsShift();}},{key:"_getComponentOptions",value:function a(){return {defaultKeyEvent:Configuration.option("defaultKeyEvent")}}},{key:"_getEventOptions",value:function a(){return {ignoreEventsCondition:Configuration.option("ignoreEventsCondition")}}}]),e}(PureComponent),_defineProperty(e,"propTypes",{keyMap:PropTypes.object,handlers:PropTypes.object,onFocus:PropTypes.func,onBlur:PropTypes.func,allowChanges:PropTypes.bool}),_defineProperty(e,"contextTypes",{hotKeysParentId:PropTypes.number}),_defineProperty(e,"childContextTypes",{hotKeysParentId:PropTypes.number}),f}

var HotKeysWrapper=function(a){function b(){return _classCallCheck(this,b),_possibleConstructorReturn(this,_getPrototypeOf(b).apply(this,arguments))}return _inherits(b,a),_createClass(b,[{key:"render",value:function g(){var a=this.props,b=a.hotKeys,c=a.innerRef,d=a.component,e=_objectWithoutProperties(a,["hotKeys","innerRef","component"]),f=d||Configuration.option("defaultComponent");return React.createElement(f,_objectSpread({},b,{ref:c},e))}}]),b}(Component),HotKeys=withHotKeys(HotKeysWrapper);HotKeys.propTypes={innerRef:PropTypes.object};

var GlobalHotKeys=function(a){function b(a){var c;return _classCallCheck(this,b),c=_possibleConstructorReturn(this,_getPrototypeOf(b).call(this,a)),c._id=KeyEventManager.getInstance().registerGlobalKeyMap(a.keyMap),c}return _inherits(b,a),_createClass(b,[{key:"getChildContext",value:function a(){return {globalHotKeysParentId:this._id}}},{key:"render",value:function a(){return this.props.children||null}},{key:"componentDidUpdate",value:function e(){var a=KeyEventManager.getInstance();if(a.reregisterGlobalKeyMap(this._id,this.props.keyMap),this.props.allowChanges||!Configuration.option("ignoreKeymapAndHandlerChangesByDefault")){var b=this.props,c=b.keyMap,d=b.handlers;a.updateEnabledGlobalHotKeys(this._id,c,d,this._getComponentOptions(),this._getEventOptions());}}}]),_createClass(b,[{key:"componentDidMount",value:function f(){var a=this.props,b=a.keyMap,c=a.handlers,d=this.context.globalHotKeysParentId,e=KeyEventManager.getInstance();e.registerGlobalComponentMount(this._id,d),e.enableGlobalHotKeys(this._id,b,c,this._getComponentOptions(),this._getEventOptions());}},{key:"componentWillUnmount",value:function b(){var a=KeyEventManager.getInstance();a.deregisterGlobalKeyMap(this._id),a.disableGlobalHotKeys(this._id);}},{key:"_getComponentOptions",value:function a(){return {defaultKeyEvent:Configuration.option("defaultKeyEvent")}}},{key:"_getEventOptions",value:function a(){return {ignoreEventsCondition:Configuration.option("ignoreEventsCondition")}}}]),b}(Component);_defineProperty(GlobalHotKeys,"propTypes",{keyMap:PropTypes.object,handlers:PropTypes.object,allowChanges:PropTypes.bool}),GlobalHotKeys.contextTypes={globalHotKeysParentId:PropTypes.number},GlobalHotKeys.childContextTypes=GlobalHotKeys.contextTypes;

function withHotKeysIgnoreOverride(a){var b,c,d=1<arguments.length&&arguments[1]!==void 0?arguments[1]:{only:[],except:[]},e=2<arguments.length?arguments[2]:void 0;return c=b=function(b){function c(a){var b;return _classCallCheck(this,c),b=_possibleConstructorReturn(this,_getPrototypeOf(c).call(this,a)),b._handleKeyEvent=b._handleKeyEvent.bind(_assertThisInitialized(_assertThisInitialized(b))),b._reloadDictionaries=b._reloadDictionaries.bind(_assertThisInitialized(_assertThisInitialized(b))),b}return _inherits(c,b),_createClass(c,[{key:"render",value:function g(){var b=this.props,c=b.only,d=b.except,e=_objectWithoutProperties(b,["only","except"]),f={onKeyDown:this._handleKeyEvent,onKeyPress:this._handleKeyEvent,onKeyUp:this._handleKeyEvent,onFocus:this._reloadDictionaries};return React.createElement(a,_extends({hotKeys:f},e))}},{key:"_reloadDictionaries",value:function d(){var a=this.props,b=a.only,c=a.except;this._onlyDict=keyDictionary(b),this._exceptDict=keyDictionary(c);}},{key:"_shouldIgnoreEvent",value:function c(a){var b=a.key;return isEmpty(this._onlyDict)?!!isEmpty(this._exceptDict)||!this._exceptDict[b]:isEmpty(this._exceptDict)?this._onlyDict[b]:this._onlyDict[b]&&!this._exceptDict[b]}},{key:"_handleKeyEvent",value:function b(a){this._shouldIgnoreEvent(a)&&KeyEventManager.getInstance()[e](a);}}]),c}(PureComponent),_defineProperty(b,"propTypes",{only:PropTypes.oneOfType([PropTypes.string,PropTypes.arrayOf(PropTypes.string)]),except:PropTypes.oneOfType([PropTypes.string,PropTypes.arrayOf(PropTypes.string)])}),_defineProperty(b,"defaultProps",d),c}function keyDictionary(a){return arrayFrom(a).reduce(function(a,b){var c=standardizeKeyName(b);if(!isValidKey(c))throw new InvalidKeyNameError(b);return [resolveAltShiftedAlias,resolveUnaltShiftedAlias,resolveShiftedAlias,resolveUnshiftedAlias,resolveAltedAlias,resolveUnaltedAlias].forEach(function(b){a[b(c)]=!0;}),a},{})}

var IgnoreKeys=function(a){function b(){return _classCallCheck(this,b),_possibleConstructorReturn(this,_getPrototypeOf(b).apply(this,arguments))}return _inherits(b,a),_createClass(b,[{key:"render",value:function e(){var a=this.props,b=a.hotKeys,c=_objectWithoutProperties(a,["hotKeys"]),d=c.component||Configuration.option("defaultComponent");return React.createElement(d,_objectSpread({},b,c))}}]),b}(Component);var IgnoreKeys$1 = withHotKeysIgnoreOverride(IgnoreKeys,{},"ignoreEvent");

var ObserveKeys=function(a){function b(){return _classCallCheck(this,b),_possibleConstructorReturn(this,_getPrototypeOf(b).apply(this,arguments))}return _inherits(b,a),_createClass(b,[{key:"render",value:function e(){var a=this.props,b=a.hotKeys,c=_objectWithoutProperties(a,["hotKeys"]),d=c.component||Configuration.option("defaultComponent");return React.createElement(d,_objectSpread({},b,c))}}]),b}(Component);var ObserveKeys$1 = withHotKeysIgnoreOverride(ObserveKeys,{},"forceObserveEvent");

function withIgnoreKeys(a){var b=1<arguments.length&&arguments[1]!==void 0?arguments[1]:{only:[],except:[]};return withHotKeysIgnoreOverride(a,b,"ignoreEvent")}

function withObserveKeys(a){var b=1<arguments.length&&arguments[1]!==void 0?arguments[1]:{only:[],except:[]};return withHotKeysIgnoreOverride(a,b,"forceObserveEvent")}

function configure(){var a=0<arguments.length&&arguments[0]!==void 0?arguments[0]:{};Configuration.init(a);}

function getApplicationKeyMap(){return KeyEventManager.getInstance().getApplicationKeyMap()}

export { HotKeys, GlobalHotKeys, IgnoreKeys$1 as IgnoreKeys, ObserveKeys$1 as ObserveKeys, withHotKeys, withIgnoreKeys, withObserveKeys, configure, getApplicationKeyMap };
