import * as React from 'react';
import { global_breakpoint_md as globalBreakpointMd, global_breakpoint_lg as globalBreakpointLg, global_breakpoint_xl as globalBreakpointXl, global_breakpoint_2xl as globalBreakpoint2xl } from '@patternfly/react-tokens';
export const DataToolbarContext = React.createContext({
  isExpanded: false,
  toggleIsExpanded: () => {},
  chipGroupContentRef: null,
  updateNumberFilters: (categoryName, numberOfFilters) => {}
});
export const DataToolbarContentContext = React.createContext({
  expandableContentRef: null,
  expandableContentId: ''
});
export const globalBreakpoints = breakpoint => {
  const breakpoints = {
    md: parseInt(globalBreakpointMd.value),
    lg: parseInt(globalBreakpointLg.value),
    xl: parseInt(globalBreakpointXl.value),
    '2xl': parseInt(globalBreakpoint2xl.value)
  };
  return breakpoints[breakpoint];
};
//# sourceMappingURL=DataToolbarUtils.js.map