import * as React from 'react';
import { RowKeyType } from './base/types';
import { IRow, IExtraRowData } from './Table';
export interface IComputedData {
    isInput: boolean;
    isButton: boolean;
}
export declare type OnRowClick = (event: React.MouseEvent, row: IRow, rowProps: IExtraRowData, computedData: IComputedData) => void;
export interface TableBodyProps {
    className?: string;
    children?: React.ReactNode;
    headerData?: IRow[];
    rows?: IRow[];
    rowKey?: RowKeyType;
    onRowClick?: OnRowClick;
    onRow?: Function;
}
export declare const TableBody: ({ onRow, className, children, rowKey, onRowClick, ...props }: TableBodyProps) => JSX.Element;
