"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.symbol.description");

require("core-js/modules/es.symbol.iterator");

require("core-js/modules/es.array.from");

require("core-js/modules/es.array.is-array");

require("core-js/modules/es.array.iterator");

require("core-js/modules/es.array.map");

require("core-js/modules/es.array.slice");

require("core-js/modules/es.date.to-string");

require("core-js/modules/es.function.name");

require("core-js/modules/es.object.assign");

require("core-js/modules/es.object.define-property");

require("core-js/modules/es.object.to-string");

require("core-js/modules/es.regexp.to-string");

require("core-js/modules/es.string.iterator");

require("core-js/modules/web.dom-collections.iterator");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocsPage = void 0;

var _react = _interopRequireDefault(require("react"));

var _router = require("@storybook/router");

var _components = require("@storybook/components");

var _html = require("@storybook/components/html");

var _DocsContext = require("./DocsContext");

var _Description = require("./Description");

var _Story = require("./Story");

var _Preview = require("./Preview");

var _Anchor = require("./Anchor");

var _Props = require("./Props");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var defaultTitleSlot = function defaultTitleSlot(_ref) {
  var selectedKind = _ref.selectedKind,
      parameters = _ref.parameters;

  var _ref2 = parameters && parameters.options || {
    hierarchyRootSeparator: '|',
    hierarchySeparator: /\/|\./
  },
      rootSeparator = _ref2.hierarchyRootSeparator,
      groupSeparator = _ref2.hierarchySeparator;

  var _parseKind = (0, _router.parseKind)(selectedKind, {
    rootSeparator: rootSeparator,
    groupSeparator: groupSeparator
  }),
      groups = _parseKind.groups;

  return groups && groups[groups.length - 1] || selectedKind;
};

var defaultSubtitleSlot = function defaultSubtitleSlot(_ref3) {
  var parameters = _ref3.parameters;
  return parameters && parameters.componentSubtitle;
};

var defaultPropsSlot = function defaultPropsSlot(context) {
  return (0, _Props.getPropsTableProps)({
    of: '.'
  }, context);
};

var defaultDescriptionSlot = function defaultDescriptionSlot(_ref4) {
  var parameters = _ref4.parameters;
  return parameters && (0, _Description.getDocgen)(parameters.component);
};

var defaultPrimarySlot = function defaultPrimarySlot(stories) {
  return stories && stories[0];
};

var defaultStoriesSlot = function defaultStoriesSlot(stories) {
  if (stories && stories.length > 1) {
    var _stories = _toArray(stories),
        first = _stories[0],
        rest = _stories.slice(1);

    return rest;
  }

  return null;
};

var StoriesHeading = _html.H2;
var StoryHeading = _html.H3;

var DocsStory = function DocsStory(_ref5) {
  var id = _ref5.id,
      name = _ref5.name,
      _ref5$expanded = _ref5.expanded,
      expanded = _ref5$expanded === void 0 ? true : _ref5$expanded,
      _ref5$withToolbar = _ref5.withToolbar,
      withToolbar = _ref5$withToolbar === void 0 ? false : _ref5$withToolbar,
      parameters = _ref5.parameters;
  return _react["default"].createElement(_Anchor.Anchor, {
    storyId: id
  }, expanded && _react["default"].createElement(StoryHeading, null, parameters && parameters.displayName || name), expanded && parameters && parameters.docs && parameters.docs.storyDescription && _react["default"].createElement(_Description.Description, {
    markdown: parameters.docs.storyDescription
  }), _react["default"].createElement(_Preview.Preview, {
    withToolbar: withToolbar
  }, _react["default"].createElement(_Story.Story, {
    id: id
  })));
};

var DocsPage = function DocsPage(_ref6) {
  var _ref6$titleSlot = _ref6.titleSlot,
      titleSlot = _ref6$titleSlot === void 0 ? defaultTitleSlot : _ref6$titleSlot,
      _ref6$subtitleSlot = _ref6.subtitleSlot,
      subtitleSlot = _ref6$subtitleSlot === void 0 ? defaultSubtitleSlot : _ref6$subtitleSlot,
      _ref6$descriptionSlot = _ref6.descriptionSlot,
      descriptionSlot = _ref6$descriptionSlot === void 0 ? defaultDescriptionSlot : _ref6$descriptionSlot,
      _ref6$primarySlot = _ref6.primarySlot,
      primarySlot = _ref6$primarySlot === void 0 ? defaultPrimarySlot : _ref6$primarySlot,
      _ref6$propsSlot = _ref6.propsSlot,
      propsSlot = _ref6$propsSlot === void 0 ? defaultPropsSlot : _ref6$propsSlot,
      _ref6$storiesSlot = _ref6.storiesSlot,
      storiesSlot = _ref6$storiesSlot === void 0 ? defaultStoriesSlot : _ref6$storiesSlot;
  return _react["default"].createElement(_DocsContext.DocsContext.Consumer, null, function (context) {
    var title = titleSlot(context) || '';
    var subtitle = subtitleSlot(context) || '';
    var description = descriptionSlot(context) || '';
    var propsTableProps = propsSlot(context);
    var selectedKind = context.selectedKind,
        storyStore = context.storyStore;
    var componentStories = storyStore.getStoriesForKind(selectedKind);
    var primary = primarySlot(componentStories, context);
    var stories = storiesSlot(componentStories, context);
    return _react["default"].createElement(_components.DocsPage, {
      title: title,
      subtitle: subtitle
    }, _react["default"].createElement(_Description.Description, {
      markdown: description
    }), primary && _react["default"].createElement(DocsStory, _extends({
      key: primary.id
    }, primary, {
      expanded: false,
      withToolbar: true
    })), propsTableProps && _react["default"].createElement(_components.PropsTable, propsTableProps), stories && stories.length > 0 && _react["default"].createElement(StoriesHeading, null, "Stories"), stories && stories.map(function (story) {
      return story && _react["default"].createElement(DocsStory, _extends({
        key: story.id
      }, story, {
        expanded: true
      }));
    }));
  });
};

exports.DocsPage = DocsPage;