"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectSpread3 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _focusLock = require("focus-lock");

var _Trap = _interopRequireWildcard(require("./Trap"));

var _FocusGuard = require("./FocusGuard");

var RenderChildren = function RenderChildren(_ref) {
  var children = _ref.children;
  return _react.default.createElement("div", null, children);
};

RenderChildren.propTypes = process.env.NODE_ENV !== "production" ? {
  children: _propTypes.default.node.isRequired
} : {};
var Fragment = _react.default.Fragment ? _react.default.Fragment : RenderChildren;
var emptyArray = [];

var FocusLock =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(FocusLock, _Component);

  function FocusLock() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, FocusLock);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(FocusLock)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)((0, _assertThisInitialized2.default)(_this)), "state", {
      observed: undefined
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)((0, _assertThisInitialized2.default)(_this)), "onActivation", function () {
      _this.originalFocusedElement = _this.originalFocusedElement || document && document.activeElement;

      if (_this.state.observed && _this.props.onActivation) {
        _this.props.onActivation(_this.state.observed);
      }

      _this.isActive = true;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)((0, _assertThisInitialized2.default)(_this)), "onDeactivation", function () {
      _this.isActive = false;

      if (_this.props.returnFocus && _this.originalFocusedElement && _this.originalFocusedElement.focus) {
        _this.originalFocusedElement.focus();

        _this.originalFocusedElement = null;
      }

      if (_this.props.onDeactivation) {
        _this.props.onDeactivation(_this.state.observed);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)((0, _assertThisInitialized2.default)(_this)), "onFocus", function (event) {
      if (_this.isActive) {
        (0, _Trap.onFocus)(event);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)((0, _assertThisInitialized2.default)(_this)), "onBlur", _Trap.onBlur);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)((0, _assertThisInitialized2.default)(_this)), "setObserveNode", function (observed) {
      if (_this.state.observed !== observed) {
        _this.setState({
          observed: observed
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)((0, _assertThisInitialized2.default)(_this)), "isActive", false);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)((0, _assertThisInitialized2.default)(_this)), "originalFocusedElement", null);
    return _this;
  }

  (0, _createClass2.default)(FocusLock, [{
    key: "render",
    value: function render() {
      var _objectSpread2;

      var _this$props = this.props,
          children = _this$props.children,
          disabled = _this$props.disabled,
          noFocusGuards = _this$props.noFocusGuards,
          persistentFocus = _this$props.persistentFocus,
          autoFocus = _this$props.autoFocus,
          allowTextSelection = _this$props.allowTextSelection,
          group = _this$props.group,
          className = _this$props.className,
          whiteList = _this$props.whiteList,
          _this$props$shards = _this$props.shards,
          shards = _this$props$shards === void 0 ? emptyArray : _this$props$shards,
          _this$props$as = _this$props.as,
          Container = _this$props$as === void 0 ? 'div' : _this$props$as,
          _this$props$lockProps = _this$props.lockProps,
          containerProps = _this$props$lockProps === void 0 ? {} : _this$props$lockProps;
      var observed = this.state.observed;

      if (process.env.NODE_ENV !== 'production') {
        if (typeof allowTextSelection !== 'undefined') {
          // eslint-disable-next-line no-console
          console.warn('React-Focus-Lock: allowTextSelection is deprecated and enabled by default');
        }
      }

      var lockProps = (0, _objectSpread3.default)((_objectSpread2 = {}, (0, _defineProperty2.default)(_objectSpread2, _focusLock.constants.FOCUS_DISABLED, disabled && 'disabled'), (0, _defineProperty2.default)(_objectSpread2, _focusLock.constants.FOCUS_GROUP, group), _objectSpread2), containerProps);
      var hasLeadingGuards = noFocusGuards !== true;
      var hasTailingGuards = hasLeadingGuards && noFocusGuards !== 'tail';
      return _react.default.createElement(Fragment, null, hasLeadingGuards && [_react.default.createElement("div", {
        key: "guard-first",
        "data-focus-guard": true,
        tabIndex: disabled ? -1 : 0,
        style: _FocusGuard.hiddenGuard
      }), // nearest focus guard
      _react.default.createElement("div", {
        key: "guard-nearest",
        "data-focus-guard": true,
        tabIndex: disabled ? -1 : 1,
        style: _FocusGuard.hiddenGuard
      })], _react.default.createElement(Container, (0, _extends2.default)({
        ref: this.setObserveNode
      }, lockProps, {
        className: className,
        onBlur: this.onBlur,
        onFocus: this.onFocus
      }), _react.default.createElement(_Trap.default, {
        observed: observed,
        disabled: disabled,
        persistentFocus: persistentFocus,
        autoFocus: autoFocus,
        whiteList: whiteList,
        shards: shards,
        onActivation: this.onActivation,
        onDeactivation: this.onDeactivation
      }), children), hasTailingGuards && _react.default.createElement("div", {
        "data-focus-guard": true,
        tabIndex: disabled ? -1 : 0,
        style: _FocusGuard.hiddenGuard
      }));
    }
  }]);
  return FocusLock;
}(_react.Component);

FocusLock.propTypes = process.env.NODE_ENV !== "production" ? {
  children: _propTypes.default.node.isRequired,
  disabled: _propTypes.default.bool,
  returnFocus: _propTypes.default.bool,
  noFocusGuards: _propTypes.default.bool,
  allowTextSelection: _propTypes.default.bool,
  autoFocus: _propTypes.default.bool,
  persistentFocus: _propTypes.default.bool,
  group: _propTypes.default.string,
  className: _propTypes.default.string,
  whiteList: _propTypes.default.func,
  shards: _propTypes.default.arrayOf(_propTypes.default.any),
  as: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.func, _propTypes.default.object]),
  lockProps: _propTypes.default.object,
  onActivation: _propTypes.default.func,
  onDeactivation: _propTypes.default.func
} : {};
FocusLock.defaultProps = {
  disabled: false,
  returnFocus: false,
  noFocusGuards: false,
  autoFocus: true,
  persistentFocus: false,
  allowTextSelection: undefined,
  group: undefined,
  className: undefined,
  whiteList: undefined,
  shards: undefined,
  as: 'div',
  lockProps: {},
  onActivation: undefined,
  onDeactivation: undefined
};
var _default = FocusLock;
exports.default = _default;