"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulletQualitativeRangeTheme = exports.BulletPrimarySegmentedMeasureTheme = exports.BulletPrimaryNegativeMeasureTheme = exports.BulletPrimaryDotMeasureTheme = exports.BulletGroupTitleTheme = exports.BulletComparativeWarningMeasureTheme = exports.BulletComparativeMeasureTheme = exports.BulletComparativeErrorMeasureTheme = exports.BulletTheme = void 0;

var _chart_bullet_Height = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_bullet_Height"));

var _chart_bullet_comparative_measure_Fill_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_Fill_Color"));

var _chart_bullet_comparative_measure_stroke_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_stroke_Color"));

var _chart_bullet_comparative_measure_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_stroke_Width"));

var _chart_bullet_comparative_measure_error_Fill_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_error_Fill_Color"));

var _chart_bullet_comparative_measure_error_stroke_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_error_stroke_Color"));

var _chart_bullet_comparative_measure_error_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_error_stroke_Width"));

var _chart_bullet_comparative_measure_warning_Fill_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_warning_Fill_Color"));

var _chart_bullet_comparative_measure_warning_stroke_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_warning_stroke_Color"));

var _chart_bullet_comparative_measure_warning_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_bullet_comparative_measure_warning_stroke_Width"));

var _chart_bullet_group_title_divider_Fill_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_bullet_group_title_divider_Fill_Color"));

var _chart_bullet_group_title_divider_stroke_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_bullet_group_title_divider_stroke_Color"));

var _chart_bullet_group_title_divider_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_bullet_group_title_divider_stroke_Width"));

var _chart_color_black_ = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_color_black_100"));

var _chart_color_black_2 = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_color_black_200"));

var _chart_color_black_3 = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_color_black_300"));

var _chart_color_black_4 = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_color_black_400"));

var _chart_color_black_5 = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_color_black_500"));

var _chart_color_red_ = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_color_red_100"));

var _chart_color_red_2 = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_color_red_200"));

var _chart_color_red_3 = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_color_red_300"));

var _chart_color_red_4 = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_color_red_400"));

var _chart_color_red_5 = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_color_red_500"));

var _chart_global_layout_Padding = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_global_layout_Padding"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/* eslint-disable camelcase */
// See https://docs.google.com/document/d/1cw10pJFXWruB1SA8TQwituxn5Ss6KpxYPCOYGrH8qAY/edit#
// See https://www.patternfly.org/v3/pattern-library/data-visualization/bullet-chart/#design
// Bullet theme
var BulletTheme = {
  chart: {
    height: _chart_bullet_Height["default"].value
  }
}; // Bullet comparative measure error theme

exports.BulletTheme = BulletTheme;
var BulletComparativeErrorMeasureTheme = {
  bar: {
    height: _chart_bullet_Height["default"].value,
    style: {
      data: {
        fill: _chart_bullet_comparative_measure_error_Fill_Color["default"].value,
        stroke: _chart_bullet_comparative_measure_error_stroke_Color["default"].value,
        strokeWidth: _chart_bullet_comparative_measure_error_stroke_Width["default"].value
      }
    }
  }
}; // Bullet comparative measure theme

exports.BulletComparativeErrorMeasureTheme = BulletComparativeErrorMeasureTheme;
var BulletComparativeMeasureTheme = {
  bar: {
    height: _chart_bullet_Height["default"].value,
    style: {
      data: {
        fill: _chart_bullet_comparative_measure_Fill_Color["default"].value,
        stroke: _chart_bullet_comparative_measure_stroke_Color["default"].value,
        strokeWidth: _chart_bullet_comparative_measure_stroke_Width["default"].value
      }
    }
  }
}; // Bullet comparative measure warning theme

exports.BulletComparativeMeasureTheme = BulletComparativeMeasureTheme;
var BulletComparativeWarningMeasureTheme = {
  bar: {
    height: _chart_bullet_Height["default"].value,
    style: {
      data: {
        fill: _chart_bullet_comparative_measure_warning_Fill_Color["default"].value,
        stroke: _chart_bullet_comparative_measure_warning_stroke_Color["default"].value,
        strokeWidth: _chart_bullet_comparative_measure_warning_stroke_Width["default"].value
      }
    }
  }
}; // Bullet group title theme

exports.BulletComparativeWarningMeasureTheme = BulletComparativeWarningMeasureTheme;
var BulletGroupTitleTheme = {
  chart: {
    padding: {
      bottom: 0,
      left: 0,
      right: 0,
      top: _chart_global_layout_Padding["default"].value
    }
  },
  line: {
    style: {
      data: {
        fill: _chart_bullet_group_title_divider_Fill_Color["default"].value,
        stroke: _chart_bullet_group_title_divider_stroke_Color["default"].value,
        strokeWidth: _chart_bullet_group_title_divider_stroke_Width["default"].value
      }
    }
  }
}; // Bullet primary dot measure theme

exports.BulletGroupTitleTheme = BulletGroupTitleTheme;
var BulletPrimaryDotMeasureTheme = {
  group: {
    height: _chart_bullet_Height["default"].value
  }
}; // Bullet primary negative measure theme

exports.BulletPrimaryDotMeasureTheme = BulletPrimaryDotMeasureTheme;
var BulletPrimaryNegativeMeasureTheme = {
  group: {
    colorScale: [_chart_color_red_["default"].value, _chart_color_red_2["default"].value, _chart_color_red_3["default"].value, _chart_color_red_4["default"].value, _chart_color_red_5["default"].value],
    height: _chart_bullet_Height["default"].value
  }
}; // Bullet primary segmented measure theme

exports.BulletPrimaryNegativeMeasureTheme = BulletPrimaryNegativeMeasureTheme;
var BulletPrimarySegmentedMeasureTheme = {
  group: {
    height: _chart_bullet_Height["default"].value
  }
}; // Bullet qualitative range theme

exports.BulletPrimarySegmentedMeasureTheme = BulletPrimarySegmentedMeasureTheme;
var BulletQualitativeRangeTheme = {
  group: {
    colorScale: [_chart_color_black_["default"].value, _chart_color_black_2["default"].value, _chart_color_black_3["default"].value, _chart_color_black_4["default"].value, _chart_color_black_5["default"].value],
    height: _chart_bullet_Height["default"].value
  }
};
exports.BulletQualitativeRangeTheme = BulletQualitativeRangeTheme;
//# sourceMappingURL=bullet-theme.js.map