/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.cli;

import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.model.KafkaResources;
import io.strimzi.api.kafka.model.KafkaTopic;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.resources.crd.KafkaTopicResource;
import io.strimzi.systemtest.utils.kafkaUtils.KafkaTopicUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import java.util.Arrays;
import java.util.List;

public class KafkaCmdClient {
    private static final int PORT = 9092;

    public static List<String> listTopicsUsingPodCli(String clusterName, int kafkaPodId) {
        String podName = KafkaResources.kafkaPodName((String)clusterName, (int)kafkaPodId);
        return Arrays.asList(KubeClusterResource.cmdKubeClient().execInPod(podName, new String[]{"/bin/bash", "-c", "bin/kafka-topics.sh --list --bootstrap-server localhost:9092"}).out().split("\\s+"));
    }

    public static String createTopicUsingPodCli(String clusterName, int kafkaPodId, String topic, int replicationFactor, int partitions) {
        String podName = KafkaResources.kafkaPodName((String)clusterName, (int)kafkaPodId);
        String response = KubeClusterResource.cmdKubeClient().execInPod(podName, new String[]{"/bin/bash", "-c", "bin/kafka-topics.sh --bootstrap-server localhost:9092 --create  --topic " + topic + " --replication-factor " + replicationFactor + " --partitions " + partitions}).out();
        KafkaTopicUtils.waitForKafkaTopicCreation(topic);
        KafkaTopic kafkaTopic = (KafkaTopic)((Resource)((NonNamespaceOperation)KafkaTopicResource.kafkaTopicClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(topic)).get();
        ResourceManager.getPointerResources().push(() -> ResourceManager.deleteLater(KafkaTopicResource.kafkaTopicClient(), kafkaTopic));
        return response;
    }

    public static String deleteTopicUsingPodCli(String clusterName, int kafkaPodId, String topic) {
        String podName = KafkaResources.kafkaPodName((String)clusterName, (int)kafkaPodId);
        return KubeClusterResource.cmdKubeClient().execInPod(podName, new String[]{"/bin/bash", "-c", "bin/kafka-topics.sh --bootstrap-server localhost:9092 --delete --topic " + topic}).out();
    }

    public static List<String> describeTopicUsingPodCli(String clusterName, int kafkaPodId, String topic) {
        String podName = KafkaResources.kafkaPodName((String)clusterName, (int)kafkaPodId);
        return Arrays.asList(KubeClusterResource.cmdKubeClient().execInPod(podName, new String[]{"/bin/bash", "-c", "bin/kafka-topics.sh --bootstrap-server localhost:9092 --describe --topic " + topic}).out().replace(": ", ":").split("\\s+"));
    }

    public static String updateTopicPartitionsCountUsingPodCli(String clusterName, int kafkaPodId, String topic, int partitions) {
        String podName = KafkaResources.kafkaPodName((String)clusterName, (int)kafkaPodId);
        return KubeClusterResource.cmdKubeClient().execInPod(podName, new String[]{"/bin/bash", "-c", "bin/kafka-topics.sh --bootstrap-server localhost:9092 --alter --topic " + topic + " --partitions " + partitions}).out();
    }
}

