/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.interfaces;

import io.strimzi.systemtest.interfaces.ExtensionContextParameterResolver;
import io.strimzi.test.timemeasuring.Operation;
import io.strimzi.test.timemeasuring.TimeMeasuringSystem;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;

@ExtendWith(value={ExtensionContextParameterResolver.class})
public interface TestSeparator {
    public static final Logger LOGGER = LogManager.getLogger(TestSeparator.class);
    public static final String SEPARATOR_CHAR = "#";

    @BeforeEach
    default public void beforeEachTest(ExtensionContext testContext) {
        TimeMeasuringSystem.getInstance().setTestName(testContext.getRequiredTestClass().getName(), testContext.getRequiredTestMethod().getName());
        TimeMeasuringSystem.getInstance().startOperation(Operation.TEST_EXECUTION);
        LOGGER.info(String.join((CharSequence)"", Collections.nCopies(76, SEPARATOR_CHAR)));
        LOGGER.info(String.format("%s.%s-STARTED", testContext.getRequiredTestClass().getName(), testContext.getRequiredTestMethod().getName()));
    }

    @AfterEach
    default public void afterEachTest(ExtensionContext testContext) {
        TimeMeasuringSystem.getInstance().stopOperation(Operation.TEST_EXECUTION);
        LOGGER.info(String.format("%s.%s-FINISHED", testContext.getRequiredTestClass().getName(), testContext.getRequiredTestMethod().getName()));
        LOGGER.info(String.join((CharSequence)"", Collections.nCopies(76, SEPARATOR_CHAR)));
    }
}

