/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.kafkaclients;

import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.api.kafka.model.status.ListenerStatus;
import io.strimzi.systemtest.kafkaclients.clientproperties.ConsumerProperties;
import io.strimzi.systemtest.kafkaclients.clientproperties.ProducerProperties;
import io.strimzi.systemtest.resources.crd.KafkaResource;
import io.strimzi.systemtest.utils.ClientUtils;
import java.security.InvalidParameterException;
import java.util.List;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractKafkaClient<C extends Builder<C>> {
    private static final Logger LOGGER = LogManager.getLogger(AbstractKafkaClient.class);
    protected String topicName;
    protected Integer partition;
    protected String namespaceName;
    protected String clusterName;
    protected int messageCount;
    protected String consumerGroup;
    protected String kafkaUsername;
    protected SecurityProtocol securityProtocol;
    protected String caCertName;
    protected String listenerName;
    protected ProducerProperties producerProperties;
    protected ConsumerProperties consumerProperties;
    protected String secretPrefix;

    protected abstract C newBuilder();

    protected Builder<C> toBuilder() {
        this.verifyEssentialInstanceAttributes();
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.newBuilder()).withTopicName(this.topicName)).withPartition(this.partition)).withNamespaceName(this.namespaceName)).withClusterName(this.clusterName)).withMessageCount(this.messageCount)).withConsumerGroupName(this.consumerGroup)).withKafkaUsername(this.kafkaUsername)).withSecurityProtocol(this.securityProtocol)).withCertificateAuthorityCertificateName(this.caCertName)).withListenerName(this.listenerName)).withProducerProperties(this.producerProperties)).withConsumerProperties(this.consumerProperties)).withSecretPrefix(this.secretPrefix);
    }

    protected AbstractKafkaClient(Builder<?> builder) {
        this.verifyEssentialAttributes(builder);
        this.topicName = builder.topicName;
        this.partition = builder.partition;
        this.namespaceName = builder.namespaceName;
        this.clusterName = builder.clusterName;
        this.messageCount = builder.messageCount;
        this.consumerGroup = builder.consumerGroup;
        this.kafkaUsername = builder.kafkaUsername;
        this.securityProtocol = builder.securityProtocol;
        this.caCertName = builder.caCertName;
        this.listenerName = builder.listenerName;
        this.producerProperties = builder.producerProperties;
        this.consumerProperties = builder.consumerProperties;
        this.secretPrefix = builder.secretPrefix;
    }

    private void verifyEssentialInstanceAttributes() {
        if (this.topicName == null || this.topicName.isEmpty()) {
            throw new InvalidParameterException("Topic name is not set.");
        }
        if (this.namespaceName == null || this.namespaceName.isEmpty()) {
            throw new InvalidParameterException("Namespace name is not set.");
        }
        if (this.clusterName == null || this.clusterName.isEmpty()) {
            throw new InvalidParameterException("Cluster name is not set.");
        }
        if (this.messageCount <= 0) {
            throw new InvalidParameterException("Message count is less than 1");
        }
        if (this.listenerName == null || this.listenerName.isEmpty()) {
            throw new InvalidParameterException("Listener name is not set.");
        }
        if (this.consumerGroup == null || this.consumerGroup.isEmpty()) {
            LOGGER.info("Consumer group were not specified going to create the random one.");
            this.consumerGroup = ClientUtils.generateRandomConsumerGroup();
        }
    }

    private void verifyEssentialAttributes(Builder<?> builder) {
        if (builder.topicName == null || builder.topicName.isEmpty()) {
            throw new InvalidParameterException("Topic name is not set.");
        }
        if (builder.namespaceName == null || builder.namespaceName.isEmpty()) {
            throw new InvalidParameterException("Namespace name is not set.");
        }
        if (builder.clusterName == null || builder.clusterName.isEmpty()) {
            throw new InvalidParameterException("Cluster name is not set.");
        }
        if (builder.messageCount <= 0) {
            throw new InvalidParameterException("Message count is less than 1");
        }
        if (builder.listenerName == null || builder.listenerName.isEmpty()) {
            throw new InvalidParameterException("Listener name is not set.");
        }
        if (builder.consumerGroup == null || builder.consumerGroup.isEmpty()) {
            LOGGER.info("Consumer group were not specified going to create the random one.");
            builder.consumerGroup = ClientUtils.generateRandomConsumerGroup();
        }
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }

    public void verifyProducedAndConsumedMessages(int producedMessages, int consumedMessages) {
        if (producedMessages != consumedMessages) {
            LOGGER.info("Producer produced {} messages", (Object)producedMessages);
            LOGGER.info("Consumer consumed {} messages", (Object)consumedMessages);
            throw new RuntimeException("Producer or consumer does not produce or consume required message");
        }
    }

    public ProducerProperties getProducerProperties() {
        return this.producerProperties;
    }

    public ConsumerProperties getConsumerProperties() {
        return this.consumerProperties;
    }

    public String getBootstrapServerFromStatus() {
        List listenerStatusList = ((Kafka)((Resource)((NonNamespaceOperation)KafkaResource.kafkaClient().inNamespace(this.namespaceName)).withName(this.clusterName)).get()).getStatus().getListeners();
        if (listenerStatusList == null || listenerStatusList.size() < 1) {
            LOGGER.error("There is no Kafka external listener specified in the Kafka CR Status");
            throw new RuntimeException("There is no Kafka external listener specified in the Kafka CR Status");
        }
        if (this.listenerName == null) {
            LOGGER.info("Listener name is not specified. Picking the first one from the Kafka Status.");
            return ((ListenerStatus)listenerStatusList.get(0)).getBootstrapServers();
        }
        return listenerStatusList.stream().filter(listener -> listener.getType().equals(this.listenerName)).findFirst().orElseThrow(RuntimeException::new).getBootstrapServers();
    }

    public String getTopicName() {
        return this.topicName;
    }

    public Integer getPartition() {
        return this.partition;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public String getKafkaUsername() {
        return this.kafkaUsername;
    }

    public SecurityProtocol getSecurityProtocol() {
        return this.securityProtocol;
    }

    public String getCaCertName() {
        return this.caCertName;
    }

    public String getListenerName() {
        return this.listenerName;
    }

    public String getSecretPrefix() {
        return this.secretPrefix;
    }

    public String toString() {
        return "AbstractKafkaClient{topicName='" + this.topicName + "', partition=" + this.partition + ", namespaceName='" + this.namespaceName + "', clusterName='" + this.clusterName + "', messageCount=" + this.messageCount + ", consumerGroup='" + this.consumerGroup + "', kafkaUsername='" + this.kafkaUsername + "', securityProtocol=" + this.securityProtocol + ", caCertName='" + this.caCertName + "', listenerName='" + this.listenerName + "', producerProperties=" + this.producerProperties + ", consumerProperties=" + this.consumerProperties + ", secretPrefix=" + this.secretPrefix + "}";
    }

    public static abstract class Builder<SELF extends Builder<SELF>> {
        private String topicName;
        protected Integer partition;
        private String namespaceName;
        private String clusterName;
        private int messageCount;
        private String consumerGroup;
        protected String kafkaUsername;
        protected SecurityProtocol securityProtocol;
        protected String caCertName;
        protected String listenerName;
        private ProducerProperties producerProperties;
        private ConsumerProperties consumerProperties;
        private String secretPrefix;

        public SELF withTopicName(String topicName) {
            this.topicName = topicName;
            return this.self();
        }

        public SELF withPartition(Integer partition) {
            this.partition = partition;
            return this.self();
        }

        public SELF withNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this.self();
        }

        public SELF withClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this.self();
        }

        public SELF withMessageCount(int messageCount) {
            this.messageCount = messageCount;
            return this.self();
        }

        public SELF withConsumerGroupName(String consumerGroup) {
            this.consumerGroup = consumerGroup;
            return this.self();
        }

        public SELF withKafkaUsername(String kafkaUsername) {
            this.kafkaUsername = kafkaUsername;
            return this.self();
        }

        public SELF withSecurityProtocol(SecurityProtocol securityProtocol) {
            this.securityProtocol = securityProtocol;
            return this.self();
        }

        public SELF withCertificateAuthorityCertificateName(String caCertName) {
            this.caCertName = caCertName;
            return this.self();
        }

        public SELF withListenerName(String listenerName) {
            this.listenerName = listenerName;
            return this.self();
        }

        public SELF withProducerProperties(ProducerProperties producerProperties) {
            this.producerProperties = producerProperties;
            return this.self();
        }

        public SELF withConsumerProperties(ConsumerProperties consumerProperties) {
            this.consumerProperties = consumerProperties;
            return this.self();
        }

        public SELF withSecretPrefix(String secretPrefix) {
            this.secretPrefix = secretPrefix;
            return this.self();
        }

        protected SELF self() {
            return (SELF)this;
        }

        public AbstractKafkaClient<?> build() throws InstantiationException {
            throw new InstantiationException();
        }
    }
}

