/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.kafkaclients.clientproperties;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.fabric8.kubernetes.api.model.Secret;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.test.executor.Exec;
import io.strimzi.test.k8s.KubeClusterResource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Base64;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;

@SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", "UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
public abstract class AbstractKafkaClientProperties<C extends AbstractKafkaClientProperties<C>> {
    private static final Logger LOGGER = LogManager.getLogger(AbstractKafkaClientProperties.class);
    private String namespaceName;
    private String clusterName;
    private String caSecretName;
    private String kafkaUsername;
    protected Properties properties;

    protected abstract KafkaClientPropertiesBuilder<?> toBuilder(C var1) throws ClassNotFoundException;

    protected AbstractKafkaClientProperties(KafkaClientPropertiesBuilder<?> builder) {
        if (builder.namespaceName == null || builder.namespaceName.isEmpty()) {
            throw new InvalidParameterException("Namespace name is not set.");
        }
        if (builder.clusterName == null || builder.clusterName.isEmpty()) {
            throw new InvalidParameterException("Cluster name is not set.");
        }
        if (builder.properties.getProperty("security.protocol") == null || builder.properties.getProperty("security.protocol").isEmpty()) {
            throw new InvalidParameterException("Security protocol is not set.");
        }
        this.properties = builder.properties;
        this.caSecretName = builder.caSecretName;
        this.kafkaUsername = builder.kafkaUsername;
        this.namespaceName = builder.namespaceName;
        this.clusterName = builder.clusterName;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private static File createKeystore(byte[] ca, byte[] cert, byte[] key, String password) throws IOException, InterruptedException {
        File caFile = File.createTempFile(AbstractKafkaClientProperties.class.getName(), ".crt");
        caFile.deleteOnExit();
        Files.write(caFile.toPath(), ca, new OpenOption[0]);
        File certFile = File.createTempFile(AbstractKafkaClientProperties.class.getName(), ".crt");
        certFile.deleteOnExit();
        Files.write(certFile.toPath(), cert, new OpenOption[0]);
        File keyFile = File.createTempFile(AbstractKafkaClientProperties.class.getName(), ".key");
        keyFile.deleteOnExit();
        Files.write(keyFile.toPath(), key, new OpenOption[0]);
        File keystore = File.createTempFile(AbstractKafkaClientProperties.class.getName(), ".keystore");
        keystore.delete();
        if (new ProcessBuilder("openssl", "pkcs12", "-export", "-in", certFile.getAbsolutePath(), "-inkey", keyFile.getAbsolutePath(), "-chain", "-CAfile", caFile.getAbsolutePath(), "-name", "dfbdbd", "-password", "pass:" + password, "-out", keystore.getAbsolutePath()).inheritIO().start().waitFor() != 0) {
            Assertions.fail();
        }
        keystore.deleteOnExit();
        return keystore;
    }

    private static void importKeycloakCertificateToTruststore(Properties clientProperties) throws IOException {
        String responseKeycloak = Exec.exec((String[])new String[]{"openssl", "s_client", "-showcerts", "-connect", ResourceManager.kubeClient().getNodeAddress() + ":32481"}).out();
        Matcher matcher = Pattern.compile("-----(?s)(.*)-----").matcher(responseKeycloak);
        if (matcher.find()) {
            String keycloakCertificateData = matcher.group(0);
            LOGGER.info("Keycloak cert is:{}\n", (Object)keycloakCertificateData);
            LOGGER.info("Creating keycloak.crt file");
            File keycloakCertFile = File.createTempFile("keycloak", ".crt");
            Files.write(keycloakCertFile.toPath(), keycloakCertificateData.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            LOGGER.info("Importing keycloak certificate {} to truststore", (Object)keycloakCertFile.getAbsolutePath());
            Exec.exec((String[])new String[]{"keytool", "-v", "-import", "-trustcacerts", "-file", keycloakCertFile.getAbsolutePath(), "-alias", "keycloakCrt1", "-keystore", clientProperties.get("ssl.truststore.location").toString(), "-noprompt", "-storepass", clientProperties.get("ssl.truststore.password").toString()});
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getCaSecretName() {
        return this.caSecretName;
    }

    public String getKafkaUsername() {
        return this.kafkaUsername;
    }

    public static abstract class KafkaClientPropertiesBuilder<T extends KafkaClientPropertiesBuilder<T>> {
        private static final String TRUSTSTORE_TYPE_CONFIG = "PKCS12";
        protected Properties properties = new Properties();
        private String namespaceName;
        private String clusterName;
        private String caSecretName;
        private String kafkaUsername = "";

        public T withNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this.self();
        }

        public T withClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this.self();
        }

        public T withCaSecretName(String caSecretName) {
            this.caSecretName = caSecretName;
            return this.self();
        }

        public T withKafkaUsername(String kafkaUsername) {
            this.kafkaUsername = kafkaUsername;
            return this.self();
        }

        public T withSecurityProtocol(SecurityProtocol securityProtocol) {
            this.properties.setProperty("security.protocol", securityProtocol.name);
            return this.self();
        }

        public T withSaslMechanism(String saslMechanismType) {
            this.properties.setProperty("sasl.mechanism", saslMechanismType);
            return this.self();
        }

        public T withSaslLoginCallbackHandlerClass() {
            this.properties.setProperty("sasl.login.callback.handler.class", "io.strimzi.kafka.oauth.client.JaasClientOauthLoginCallbackHandler");
            return this.self();
        }

        public T withSaslJassConfig(String clientId, String clientSecretName, String oauthTokenEndpointUri) {
            if (clientId.isEmpty() || clientSecretName.isEmpty() || oauthTokenEndpointUri.isEmpty()) {
                throw new InvalidParameterException("You do not specify client-id, client-secret name or oauth-token-endpoint-uri inside kafka client!");
            }
            this.properties.setProperty("sasl.jaas.config", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required oauth.client.id=\"" + clientId + "\" oauth.client.secret=\"" + clientSecretName + "\" oauth.token.endpoint.uri=\"" + oauthTokenEndpointUri + "\";");
            return this.self();
        }

        public T withSaslJassConfigAndTls(String clientId, String clientSecretName, String oauthTokenEndpointUri) {
            try {
                AbstractKafkaClientProperties.importKeycloakCertificateToTruststore(this.properties);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (clientId.isEmpty() || clientSecretName.isEmpty() || oauthTokenEndpointUri.isEmpty()) {
                throw new InvalidParameterException("You do not specify client-id, client-secret name or oauth-token-endpoint-uri inside kafka client!");
            }
            this.properties.setProperty("sasl.jaas.config", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required oauth.client.id=\"" + clientId + "\" oauth.client.secret=\"" + clientSecretName + "\" oauth.token.endpoint.uri=\"" + oauthTokenEndpointUri + "\" oauth.ssl.endpoint.identification.algorithm=\"\"oauth.ssl.truststore.location=\"" + this.properties.get("ssl.truststore.location") + "\" oauth.ssl.truststore.password=\"" + this.properties.get("ssl.truststore.password") + "\" oauth.ssl.truststore.type=\"" + this.properties.get("ssl.truststore.type") + "\" ;");
            return this.self();
        }

        public T withSharedProperties() {
            this.properties.setProperty("ssl.endpoint.identification.algorithm", "");
            try {
                Secret userSecret;
                if (!this.properties.getProperty("security.protocol").equals("PLAINTEXT") && !this.properties.getProperty("security.protocol").equals("SASL_PLAINTEXT")) {
                    Secret clusterCaCertSecret = KubeClusterResource.kubeClient((String)this.namespaceName).getSecret(this.caSecretName);
                    File tsFile = File.createTempFile(AbstractKafkaClientProperties.class.getName(), ".truststore");
                    tsFile.deleteOnExit();
                    KeyStore ts = KeyStore.getInstance(TRUSTSTORE_TYPE_CONFIG);
                    String tsPassword = "foo";
                    if (this.caSecretName.contains("custom-certificate")) {
                        ts.load(null, tsPassword.toCharArray());
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        String clusterCaCert = (String)KubeClusterResource.kubeClient((String)this.namespaceName).getSecret(this.caSecretName).getData().get("ca.crt");
                        Certificate cert = cf.generateCertificate(new ByteArrayInputStream(Base64.getDecoder().decode(clusterCaCert)));
                        ts.setCertificateEntry("ca.crt", cert);
                        try (FileOutputStream tsOs = new FileOutputStream(tsFile);){
                            ts.store(tsOs, tsPassword.toCharArray());
                        }
                    } else {
                        tsPassword = new String(Base64.getDecoder().decode((String)clusterCaCertSecret.getData().get("ca.password")), StandardCharsets.US_ASCII);
                        String truststore = (String)clusterCaCertSecret.getData().get("ca.p12");
                        Files.write(tsFile.toPath(), Base64.getDecoder().decode(truststore), new OpenOption[0]);
                    }
                    this.properties.setProperty("ssl.truststore.type", ts.getType());
                    this.properties.setProperty("ssl.truststore.password", tsPassword);
                    this.properties.setProperty("ssl.truststore.location", tsFile.getAbsolutePath());
                }
                if (!this.kafkaUsername.isEmpty() && this.properties.getProperty("security.protocol").equals(SecurityProtocol.SASL_SSL.name) && !this.properties.getProperty("sasl.mechanism").equals("OAUTHBEARER")) {
                    this.properties.setProperty("sasl.mechanism", "SCRAM-SHA-512");
                    userSecret = KubeClusterResource.kubeClient((String)this.namespaceName).getSecret(this.kafkaUsername);
                    String password = new String(Base64.getDecoder().decode((String)userSecret.getData().get("password")), StandardCharsets.UTF_8);
                    String jaasTemplate = "org.apache.kafka.common.security.scram.ScramLoginModule required username=\"%s\" password=\"%s\";";
                    String jaasCfg = String.format(jaasTemplate, this.kafkaUsername, password);
                    this.properties.setProperty("sasl.jaas.config", jaasCfg);
                } else if (!this.kafkaUsername.isEmpty()) {
                    userSecret = KubeClusterResource.kubeClient((String)this.namespaceName).getSecret(this.kafkaUsername);
                    String clientsCaCert = (String)userSecret.getData().get("ca.crt");
                    LOGGER.debug("Clients CA cert: {}", (Object)clientsCaCert);
                    String userCaCert = (String)userSecret.getData().get("user.crt");
                    String userCaKey = (String)userSecret.getData().get("user.key");
                    String ksPassword = "foo";
                    this.properties.setProperty("ssl.keystore.password", ksPassword);
                    LOGGER.debug("User CA cert: {}", (Object)userCaCert);
                    LOGGER.debug("User CA key: {}", (Object)userCaKey);
                    File ksFile = AbstractKafkaClientProperties.createKeystore(Base64.getDecoder().decode(clientsCaCert), Base64.getDecoder().decode(userCaCert), Base64.getDecoder().decode(userCaKey), ksPassword);
                    this.properties.setProperty("ssl.keystore.location", ksFile.getAbsolutePath());
                    this.properties.setProperty("ssl.keystore.type", TRUSTSTORE_TYPE_CONFIG);
                }
            }
            catch (IOException | InterruptedException | RuntimeException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                e.printStackTrace();
                throw new RuntimeException();
            }
            return this.self();
        }

        protected abstract AbstractKafkaClientProperties<?> build();

        protected abstract T self();
    }
}

