/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.kafkaclients.clientproperties;

import io.strimzi.systemtest.kafkaclients.clientproperties.AbstractKafkaClientProperties;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProducerProperties
extends AbstractKafkaClientProperties<ProducerProperties> {
    private static final Logger LOGGER = LogManager.getLogger(ProducerProperties.class);
    private static final String DEFAULT_MAX_BLOG_MS_CONFIG = "6000";
    private static final String DEFAULT_ACKS_CONFIG = "1";

    private ProducerProperties(ProducerPropertiesBuilder builder) {
        super(builder);
        if (builder.properties.getProperty("max.block.ms") == null || builder.properties.getProperty("max.block.ms").isEmpty()) {
            LOGGER.debug("Setting default value of {} to {}", (Object)"max.block.ms", (Object)DEFAULT_MAX_BLOG_MS_CONFIG);
            this.properties.setProperty("max.block.ms", DEFAULT_MAX_BLOG_MS_CONFIG);
        }
        if (builder.properties.getProperty("acks") == null || builder.properties.getProperty("acks").isEmpty()) {
            LOGGER.debug("Setting default value of {} to {}", (Object)"acks", (Object)DEFAULT_ACKS_CONFIG);
            this.properties.setProperty("acks", DEFAULT_ACKS_CONFIG);
        }
        this.properties = builder.properties;
    }

    public ProducerPropertiesBuilder toBuilder(ProducerProperties clientProperties) {
        ProducerPropertiesBuilder builder = new ProducerPropertiesBuilder();
        builder.withNamespaceName(clientProperties.getNamespaceName());
        builder.withClusterName(clientProperties.getClusterName());
        builder.withSecurityProtocol(SecurityProtocol.forName((String)clientProperties.getProperties().getProperty("security.protocol")));
        builder.withBootstrapServerConfig(clientProperties.getProperties().getProperty("bootstrap.servers"));
        try {
            builder.withKeySerializerConfig(Class.forName(clientProperties.getProperties().getProperty("key.serializer")));
            builder.withValueSerializerConfig(Class.forName(clientProperties.getProperties().getProperty("value.serializer")));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        builder.withClientIdConfig(clientProperties.getProperties().getProperty("client.id"));
        builder.withMaxBlockMsConfig(clientProperties.getProperties().getProperty("max.block.ms"));
        builder.withAcksConfig(clientProperties.getProperties().getProperty("acks"));
        builder.withSharedProperties();
        return builder;
    }

    public static class ProducerPropertiesBuilder
    extends AbstractKafkaClientProperties.KafkaClientPropertiesBuilder<ProducerPropertiesBuilder> {
        public ProducerPropertiesBuilder withBootstrapServerConfig(String bootstrapServer) {
            this.properties.setProperty("bootstrap.servers", bootstrapServer);
            return this;
        }

        public ProducerPropertiesBuilder withKeySerializerConfig(Class<? extends Serializer> keySerializer) {
            this.properties.setProperty("key.serializer", keySerializer.getName());
            return this;
        }

        public ProducerPropertiesBuilder withValueSerializerConfig(Class<? extends Serializer> valueSerializer) {
            this.properties.setProperty("value.serializer", valueSerializer.getName());
            return this;
        }

        public ProducerPropertiesBuilder withMaxBlockMsConfig(String maxBlockMsConfig) {
            this.properties.setProperty("max.block.ms", maxBlockMsConfig);
            return this;
        }

        public ProducerPropertiesBuilder withClientIdConfig(String clientId) {
            this.properties.setProperty("client.id", clientId);
            return this;
        }

        public ProducerPropertiesBuilder withAcksConfig(String acksConfig) {
            this.properties.setProperty("acks", acksConfig);
            return this;
        }

        public ProducerProperties build() {
            return new ProducerProperties(this);
        }

        @Override
        protected ProducerPropertiesBuilder self() {
            return this;
        }
    }
}

