/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.kafkaclients.externalClients;

import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.kafkaclients.AbstractKafkaClient;
import io.strimzi.systemtest.kafkaclients.KafkaClientOperations;
import io.strimzi.systemtest.kafkaclients.clientproperties.ConsumerProperties;
import io.strimzi.systemtest.kafkaclients.clientproperties.ProducerProperties;
import io.strimzi.systemtest.kafkaclients.externalClients.Consumer;
import io.strimzi.systemtest.kafkaclients.externalClients.Producer;
import io.strimzi.systemtest.resources.crd.KafkaResource;
import io.strimzi.test.WaitException;
import io.vertx.core.Verticle;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.IntPredicate;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasicExternalKafkaClient
extends AbstractKafkaClient<Builder>
implements KafkaClientOperations {
    private static final Logger LOGGER = LogManager.getLogger(BasicExternalKafkaClient.class);

    private BasicExternalKafkaClient(Builder builder) {
        super(builder);
    }

    @Override
    protected Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return (Builder)super.toBuilder();
    }

    public int sendMessagesPlain() {
        return this.sendMessagesPlain(Constants.GLOBAL_CLIENTS_TIMEOUT);
    }

    @Override
    public int sendMessagesPlain(long timeoutMs) {
        String clientName = "sender-plain-" + new Random().nextInt(Integer.MAX_VALUE);
        CompletableFuture<Integer> resultPromise = new CompletableFuture<Integer>();
        IntPredicate msgCntPredicate = x -> x == this.messageCount;
        ProducerProperties properties = this.producerProperties;
        if (properties == null || properties.getProperties().isEmpty()) {
            properties = ((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)new ProducerProperties.ProducerPropertiesBuilder().withNamespaceName(this.namespaceName)).withClusterName(this.clusterName)).withBootstrapServerConfig(this.getBootstrapServerFromStatus()).withKeySerializerConfig(StringSerializer.class).withValueSerializerConfig(StringSerializer.class).withClientIdConfig("producer-plain-" + new Random().nextInt(Integer.MAX_VALUE)).withSecurityProtocol(SecurityProtocol.PLAINTEXT)).withSharedProperties()).build();
        }
        Producer plainProducer = new Producer(properties, resultPromise, msgCntPredicate, this.topicName, clientName, this.partition);
        try {
            plainProducer.getVertx().deployVerticle((Verticle)plainProducer);
            int n = (Integer)plainProducer.getResultPromise().get(timeoutMs, TimeUnit.MILLISECONDS);
            plainProducer.close();
            return n;
        }
        catch (Throwable throwable) {
            try {
                try {
                    plainProducer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
                throw new WaitException((Throwable)e);
            }
        }
    }

    public int sendMessagesTls() {
        return this.sendMessagesTls(Constants.GLOBAL_CLIENTS_TIMEOUT);
    }

    @Override
    public int sendMessagesTls(long timeoutMs) {
        String clientName = "sender-ssl-" + new Random().nextInt(Integer.MAX_VALUE);
        CompletableFuture<Integer> resultPromise = new CompletableFuture<Integer>();
        IntPredicate msgCntPredicate = x -> x == this.messageCount;
        this.caCertName = this.caCertName == null ? KafkaResource.getKafkaExternalListenerCaCertName(this.namespaceName, this.clusterName, this.listenerName) : this.caCertName;
        LOGGER.info("Going to use the following CA certificate: {}", (Object)this.caCertName);
        ProducerProperties properties = this.producerProperties;
        if (properties == null || properties.getProperties().isEmpty()) {
            properties = ((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)new ProducerProperties.ProducerPropertiesBuilder().withNamespaceName(this.namespaceName)).withClusterName(this.clusterName)).withBootstrapServerConfig(this.getBootstrapServerFromStatus()).withKeySerializerConfig(StringSerializer.class).withValueSerializerConfig(StringSerializer.class).withClientIdConfig("producer-tls-" + new Random().nextInt(Integer.MAX_VALUE)).withCaSecretName(this.caCertName)).withKafkaUsername(this.kafkaUsername)).withSecurityProtocol(this.securityProtocol)).withSaslMechanism("")).withSharedProperties()).build();
        }
        Producer tlsProducer = new Producer(properties, resultPromise, msgCntPredicate, this.topicName, clientName, this.partition);
        try {
            tlsProducer.getVertx().deployVerticle((Verticle)tlsProducer);
            int n = (Integer)tlsProducer.getResultPromise().get(timeoutMs, TimeUnit.MILLISECONDS);
            tlsProducer.close();
            return n;
        }
        catch (Throwable throwable) {
            try {
                try {
                    tlsProducer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
                throw new WaitException((Throwable)e);
            }
        }
    }

    public int receiveMessagesPlain() {
        return this.receiveMessagesPlain(Constants.GLOBAL_CLIENTS_TIMEOUT);
    }

    @Override
    public int receiveMessagesPlain(long timeoutMs) {
        String clientName = "receiver-plain-" + new Random().nextInt(Integer.MAX_VALUE);
        CompletableFuture<Integer> resultPromise = new CompletableFuture<Integer>();
        IntPredicate msgCntPredicate = x -> x == this.messageCount;
        ConsumerProperties properties = this.consumerProperties;
        if (properties == null || properties.getProperties().isEmpty()) {
            properties = ((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)new ConsumerProperties.ConsumerPropertiesBuilder().withNamespaceName(this.namespaceName)).withClusterName(this.clusterName)).withBootstrapServerConfig(this.getBootstrapServerFromStatus()).withKeyDeserializerConfig(StringDeserializer.class).withValueDeserializerConfig(StringDeserializer.class).withClientIdConfig("consumer-plain-" + new Random().nextInt(Integer.MAX_VALUE)).withAutoOffsetResetConfig(OffsetResetStrategy.EARLIEST).withGroupIdConfig(this.consumerGroup).withSecurityProtocol(SecurityProtocol.PLAINTEXT)).withSharedProperties()).build();
        }
        Consumer plainConsumer = new Consumer(properties, resultPromise, msgCntPredicate, this.topicName, clientName);
        try {
            plainConsumer.getVertx().deployVerticle((Verticle)plainConsumer);
            int n = (Integer)plainConsumer.getResultPromise().get(timeoutMs, TimeUnit.MILLISECONDS);
            plainConsumer.close();
            return n;
        }
        catch (Throwable throwable) {
            try {
                try {
                    plainConsumer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
                throw new WaitException((Throwable)e);
            }
        }
    }

    public int receiveMessagesTls() {
        return this.receiveMessagesTls(Constants.GLOBAL_CLIENTS_TIMEOUT);
    }

    @Override
    public int receiveMessagesTls(long timeoutMs) {
        String clientName = "receiver-ssl-" + new Random().nextInt(Integer.MAX_VALUE);
        CompletableFuture<Integer> resultPromise = new CompletableFuture<Integer>();
        IntPredicate msgCntPredicate = x -> x == this.messageCount;
        this.caCertName = this.caCertName == null ? KafkaResource.getKafkaExternalListenerCaCertName(this.namespaceName, this.clusterName, this.listenerName) : this.caCertName;
        LOGGER.info("Going to use the following CA certificate: {}", (Object)this.caCertName);
        ConsumerProperties properties = this.consumerProperties;
        if (properties == null || properties.getProperties().isEmpty()) {
            properties = ((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)new ConsumerProperties.ConsumerPropertiesBuilder().withNamespaceName(this.namespaceName)).withClusterName(this.clusterName)).withBootstrapServerConfig(this.getBootstrapServerFromStatus()).withKeyDeserializerConfig(StringDeserializer.class).withValueDeserializerConfig(StringDeserializer.class).withClientIdConfig("consumer-tls-" + new Random().nextInt(Integer.MAX_VALUE)).withAutoOffsetResetConfig(OffsetResetStrategy.EARLIEST).withGroupIdConfig(this.consumerGroup).withSecurityProtocol(this.securityProtocol)).withCaSecretName(this.caCertName)).withKafkaUsername(this.kafkaUsername)).withSaslMechanism("")).withSharedProperties()).build();
        }
        Consumer tlsConsumer = new Consumer(properties, resultPromise, msgCntPredicate, this.topicName, clientName);
        try {
            tlsConsumer.getVertx().deployVerticle((Verticle)tlsConsumer);
            int n = (Integer)tlsConsumer.getResultPromise().get(timeoutMs, TimeUnit.MILLISECONDS);
            tlsConsumer.close();
            return n;
        }
        catch (Throwable throwable) {
            try {
                try {
                    tlsConsumer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
                throw new WaitException((Throwable)e);
            }
        }
    }

    @Override
    public String toString() {
        return "BasicKafkaClient{topicName='" + this.topicName + "', namespaceName='" + this.namespaceName + "', clusterName='" + this.clusterName + "', messageCount=" + this.messageCount + ", consumerGroup='" + this.consumerGroup + "', kafkaUsername='" + this.kafkaUsername + "', securityProtocol='" + this.securityProtocol + "', caCertName='" + this.caCertName + "'}";
    }

    public static class Builder
    extends AbstractKafkaClient.Builder<Builder> {
        public BasicExternalKafkaClient build() {
            return new BasicExternalKafkaClient(this);
        }
    }
}

