/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.kafkaclients.externalClients;

import io.strimzi.systemtest.kafkaclients.clientproperties.ConsumerProperties;
import io.strimzi.systemtest.kafkaclients.externalClients.ClientHandlerBase;
import io.vertx.core.Vertx;
import io.vertx.kafka.client.consumer.KafkaConsumer;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntPredicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Consumer
extends ClientHandlerBase<Integer>
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(Consumer.class);
    private final ConsumerProperties properties;
    private final AtomicInteger numReceived = new AtomicInteger(0);
    private final String topic;
    private final String clientName;
    private final KafkaConsumer<String, String> consumer;

    Consumer(ConsumerProperties properties, CompletableFuture<Integer> resultPromise, IntPredicate msgCntPredicate, String topic, String clientName) {
        super(resultPromise, msgCntPredicate);
        this.properties = properties;
        this.topic = topic;
        this.clientName = clientName;
        this.vertx = Vertx.vertx();
        this.consumer = KafkaConsumer.create((Vertx)this.vertx, (Properties)properties.getProperties());
    }

    @Override
    protected void handleClient() {
        LOGGER.info("Consumer is starting with following properties: {}", (Object)this.properties.getProperties().toString());
        if (this.msgCntPredicate.test(-1)) {
            this.vertx.eventBus().consumer(this.clientName, msg -> {
                if (msg.body().equals("stop")) {
                    LOGGER.debug("Received stop command! Consumed messages: {}", (Object)this.numReceived.get());
                    this.resultPromise.complete(this.numReceived.get());
                }
            });
        }
        this.consumer.subscribe(this.topic, ar -> {
            if (ar.succeeded()) {
                this.consumer.handler(record -> {
                    LOGGER.debug("Processing key=" + (String)record.key() + ",value=" + (String)record.value() + ",partition=" + record.partition() + ",offset=" + record.offset());
                    this.numReceived.getAndIncrement();
                    if (this.msgCntPredicate.test(this.numReceived.get())) {
                        LOGGER.info("Consumer consumed {} messages", (Object)this.numReceived.get());
                        this.resultPromise.complete(this.numReceived.get());
                    }
                });
            } else {
                LOGGER.warn("Consumer could not subscribe " + ar.cause().getMessage());
                this.resultPromise.completeExceptionally(ar.cause());
            }
        });
    }

    @Override
    public void close() {
        if (this.vertx != null) {
            LOGGER.info("Closing Consumer instance {} with client.id {}", (Object)this.consumer.getClass().getName(), this.properties.getProperties().get("client.id"));
            this.consumer.close();
            LOGGER.info("Closing Vert.x instance {}", (Object)this.getClass().getName());
            this.vertx.close();
        }
    }
}

