/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.kafkaclients.externalClients;

import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.kafkaclients.AbstractKafkaClient;
import io.strimzi.systemtest.kafkaclients.KafkaClientOperations;
import io.strimzi.systemtest.kafkaclients.clientproperties.ConsumerProperties;
import io.strimzi.systemtest.kafkaclients.clientproperties.ProducerProperties;
import io.strimzi.systemtest.kafkaclients.externalClients.Consumer;
import io.strimzi.systemtest.kafkaclients.externalClients.Producer;
import io.strimzi.systemtest.resources.crd.KafkaResource;
import io.strimzi.test.WaitException;
import io.vertx.core.Verticle;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.IntPredicate;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OauthExternalKafkaClient
extends AbstractKafkaClient<Builder>
implements KafkaClientOperations {
    private static final Logger LOGGER = LogManager.getLogger(OauthExternalKafkaClient.class);
    private String clientId;
    private String clientSecretName;
    private String oauthTokenEndpointUri;
    private String introspectionEndpointUri;

    @Override
    protected Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ((Builder)super.toBuilder()).withOauthClientId(this.clientId).withClientSecretName(this.clientSecretName).withOauthTokenEndpointUri(this.oauthTokenEndpointUri).withIntrospectionEndpointUri(this.introspectionEndpointUri);
    }

    private OauthExternalKafkaClient(Builder builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.clientSecretName = builder.clientSecretName;
        this.oauthTokenEndpointUri = builder.oauthTokenEndpointUri;
        this.introspectionEndpointUri = builder.introspectionEndpointUri;
    }

    public int sendMessagesPlain() {
        return this.sendMessagesPlain(Constants.GLOBAL_CLIENTS_TIMEOUT);
    }

    @Override
    public int sendMessagesPlain(long timeoutMs) {
        String clientName = "sender-plain-" + new Random().nextInt(Integer.MAX_VALUE);
        CompletableFuture<Integer> resultPromise = new CompletableFuture<Integer>();
        IntPredicate msgCntPredicate = x -> x == this.messageCount;
        ProducerProperties properties = this.producerProperties;
        if (properties == null || properties.getProperties().isEmpty()) {
            properties = ((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)new ProducerProperties.ProducerPropertiesBuilder().withNamespaceName(this.namespaceName)).withClusterName(this.clusterName)).withSecurityProtocol(SecurityProtocol.SASL_PLAINTEXT)).withBootstrapServerConfig(this.getBootstrapServerFromStatus()).withKeySerializerConfig(StringSerializer.class).withValueSerializerConfig(StringSerializer.class).withClientIdConfig(this.kafkaUsername + "-producer").withSaslMechanism("OAUTHBEARER")).withSaslLoginCallbackHandlerClass()).withSharedProperties()).withSaslJassConfig(this.clientId, this.clientSecretName, this.oauthTokenEndpointUri)).build();
        }
        Producer plainProducer = new Producer(properties, resultPromise, msgCntPredicate, this.topicName, clientName, this.partition);
        try {
            plainProducer.getVertx().deployVerticle((Verticle)plainProducer);
            int n = (Integer)plainProducer.getResultPromise().get(timeoutMs, TimeUnit.MILLISECONDS);
            plainProducer.close();
            return n;
        }
        catch (Throwable throwable) {
            try {
                try {
                    plainProducer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
                throw new WaitException((Throwable)e);
            }
        }
    }

    public int sendMessagesTls() {
        return this.sendMessagesTls(Constants.GLOBAL_CLIENTS_TIMEOUT);
    }

    @Override
    public int sendMessagesTls(long timeoutMs) {
        String clientName = "sender-ssl" + new Random().nextInt(Integer.MAX_VALUE);
        CompletableFuture<Integer> resultPromise = new CompletableFuture<Integer>();
        IntPredicate msgCntPredicate = x -> x == this.messageCount;
        this.caCertName = this.caCertName == null ? KafkaResource.getKafkaExternalListenerCaCertName(this.namespaceName, this.clusterName, this.listenerName) : this.caCertName;
        LOGGER.info("Going to use the following CA certificate: {}", (Object)this.caCertName);
        ProducerProperties properties = this.producerProperties;
        LOGGER.info("This is client.id={}, client.secret.name={}, oauthTokenEndpointUri={}", (Object)this.clientId, (Object)this.clientSecretName, (Object)this.oauthTokenEndpointUri);
        if (properties == null || properties.getProperties().isEmpty()) {
            properties = ((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)((ProducerProperties.ProducerPropertiesBuilder)new ProducerProperties.ProducerPropertiesBuilder().withNamespaceName(this.namespaceName)).withClusterName(this.clusterName)).withBootstrapServerConfig(this.getBootstrapServerFromStatus()).withKeySerializerConfig(StringSerializer.class).withValueSerializerConfig(StringSerializer.class).withCaSecretName(this.caCertName)).withKafkaUsername(this.kafkaUsername)).withSecurityProtocol(SecurityProtocol.SASL_SSL)).withClientIdConfig(this.kafkaUsername + "-producer").withSaslMechanism("OAUTHBEARER")).withSaslLoginCallbackHandlerClass()).withSharedProperties()).withSaslJassConfigAndTls(this.clientId, this.clientSecretName, this.oauthTokenEndpointUri)).build();
        }
        Producer tlsProducer = new Producer(properties, resultPromise, msgCntPredicate, this.topicName, clientName, this.partition);
        try {
            tlsProducer.getVertx().deployVerticle((Verticle)tlsProducer);
            int n = (Integer)tlsProducer.getResultPromise().get(timeoutMs, TimeUnit.MILLISECONDS);
            tlsProducer.close();
            return n;
        }
        catch (Throwable throwable) {
            try {
                try {
                    tlsProducer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
                throw new WaitException((Throwable)e);
            }
        }
    }

    public int receiveMessagesPlain() {
        return this.receiveMessagesPlain(Constants.GLOBAL_CLIENTS_TIMEOUT);
    }

    @Override
    public int receiveMessagesPlain(long timeoutMs) {
        String clientName = "receiver-plain-" + new Random().nextInt(Integer.MAX_VALUE);
        CompletableFuture<Integer> resultPromise = new CompletableFuture<Integer>();
        IntPredicate msgCntPredicate = x -> x == this.messageCount;
        ConsumerProperties properties = this.consumerProperties;
        if (properties == null || properties.getProperties().isEmpty()) {
            properties = ((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)new ConsumerProperties.ConsumerPropertiesBuilder().withNamespaceName(this.namespaceName)).withClusterName(this.clusterName)).withGroupIdConfig(this.consumerGroup).withSecurityProtocol(SecurityProtocol.SASL_PLAINTEXT)).withBootstrapServerConfig(this.getBootstrapServerFromStatus()).withKeyDeserializerConfig(StringDeserializer.class).withValueDeserializerConfig(StringDeserializer.class).withClientIdConfig(this.kafkaUsername + "-consumer").withAutoOffsetResetConfig(OffsetResetStrategy.EARLIEST).withSaslMechanism("OAUTHBEARER")).withSaslLoginCallbackHandlerClass()).withSharedProperties()).withSaslJassConfig(this.clientId, this.clientSecretName, this.oauthTokenEndpointUri)).build();
        }
        Consumer plainConsumer = new Consumer(properties, resultPromise, msgCntPredicate, this.topicName, clientName);
        try {
            plainConsumer.getVertx().deployVerticle((Verticle)plainConsumer);
            int n = (Integer)plainConsumer.getResultPromise().get(timeoutMs, TimeUnit.MILLISECONDS);
            plainConsumer.close();
            return n;
        }
        catch (Throwable throwable) {
            try {
                try {
                    plainConsumer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
                throw new WaitException((Throwable)e);
            }
        }
    }

    public int receiveMessagesTls() {
        return this.receiveMessagesTls(Constants.GLOBAL_CLIENTS_TIMEOUT);
    }

    @Override
    public int receiveMessagesTls(long timeoutMs) {
        String clientName = "receiver-ssl-" + new Random().nextInt(Integer.MAX_VALUE);
        CompletableFuture<Integer> resultPromise = new CompletableFuture<Integer>();
        IntPredicate msgCntPredicate = x -> x == this.messageCount;
        this.caCertName = this.caCertName == null ? KafkaResource.getKafkaExternalListenerCaCertName(this.namespaceName, this.clusterName, this.listenerName) : this.caCertName;
        LOGGER.info("Going to use the following CA certificate: {}", (Object)this.caCertName);
        ConsumerProperties properties = this.consumerProperties;
        if (properties == null || properties.getProperties().isEmpty()) {
            properties = ((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)((ConsumerProperties.ConsumerPropertiesBuilder)new ConsumerProperties.ConsumerPropertiesBuilder().withNamespaceName(this.namespaceName)).withClusterName(this.clusterName)).withCaSecretName(this.caCertName)).withBootstrapServerConfig(this.getBootstrapServerFromStatus()).withKeyDeserializerConfig(StringDeserializer.class).withValueDeserializerConfig(StringDeserializer.class).withKafkaUsername(this.kafkaUsername)).withSecurityProtocol(SecurityProtocol.SASL_SSL)).withGroupIdConfig(this.consumerGroup).withAutoOffsetResetConfig(OffsetResetStrategy.EARLIEST).withClientIdConfig(this.kafkaUsername + "-consumer").withSaslMechanism("OAUTHBEARER")).withSaslLoginCallbackHandlerClass()).withSharedProperties()).withSaslJassConfigAndTls(this.clientId, this.clientSecretName, this.oauthTokenEndpointUri)).build();
        }
        Consumer tlsConsumer = new Consumer(properties, resultPromise, msgCntPredicate, this.topicName, clientName);
        try {
            tlsConsumer.getVertx().deployVerticle((Verticle)tlsConsumer);
            int n = (Integer)tlsConsumer.getResultPromise().get(timeoutMs, TimeUnit.MILLISECONDS);
            tlsConsumer.close();
            return n;
        }
        catch (Throwable throwable) {
            try {
                try {
                    tlsConsumer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
                throw new WaitException((Throwable)e);
            }
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecretName() {
        return this.clientSecretName;
    }

    public String getOauthTokenEndpointUri() {
        return this.oauthTokenEndpointUri;
    }

    public String getIntrospectionEndpointUri() {
        return this.introspectionEndpointUri;
    }

    @Override
    public String toString() {
        return "OauthKafkaClient{oauthTokenEndpointUri='" + this.oauthTokenEndpointUri + "', introspectionEndpointUri='" + this.introspectionEndpointUri + "', topicName='" + this.topicName + "', namespaceName='" + this.namespaceName + "', clusterName='" + this.clusterName + "', messageCount=" + this.messageCount + ", consumerGroup='" + this.consumerGroup + "', kafkaUsername='" + this.kafkaUsername + "', securityProtocol='" + this.securityProtocol + "', caCertName='" + this.caCertName + "'}";
    }

    public static class Builder
    extends AbstractKafkaClient.Builder<Builder> {
        private String clientId;
        private String clientSecretName;
        private String oauthTokenEndpointUri;
        private String introspectionEndpointUri;

        public Builder withOauthClientId(String oauthClientId) {
            this.clientId = oauthClientId;
            return this;
        }

        public Builder withClientSecretName(String clientSecretName) {
            this.clientSecretName = clientSecretName;
            return this;
        }

        public Builder withOauthTokenEndpointUri(String oauthTokenEndpointUri) {
            this.oauthTokenEndpointUri = oauthTokenEndpointUri;
            return this;
        }

        public Builder withIntrospectionEndpointUri(String introspectionEndpointUri) {
            this.introspectionEndpointUri = introspectionEndpointUri;
            return this;
        }

        public OauthExternalKafkaClient build() {
            return new OauthExternalKafkaClient(this);
        }
    }
}

