/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.kafkaclients.internalClients;

import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.kafkaclients.AbstractKafkaClient;
import io.strimzi.systemtest.kafkaclients.KafkaClientOperations;
import io.strimzi.systemtest.kafkaclients.internalClients.ClientType;
import io.strimzi.systemtest.kafkaclients.internalClients.VerifiableClient;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.MatcherAssert;

public class InternalKafkaClient
extends AbstractKafkaClient<Builder>
implements KafkaClientOperations {
    private static final Logger LOGGER = LogManager.getLogger(InternalKafkaClient.class);
    private String podName;
    private String completeKafkaUsername;

    private InternalKafkaClient(Builder builder) {
        super(builder);
        this.completeKafkaUsername = this.secretPrefix == null ? this.kafkaUsername : this.secretPrefix + this.kafkaUsername;
        this.podName = builder.podName;
    }

    @Override
    protected Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ((Builder)super.toBuilder()).withUsingPodName(this.podName);
    }

    public int sendMessagesPlain() {
        return this.sendMessagesPlain(Constants.GLOBAL_CLIENTS_TIMEOUT);
    }

    @Override
    public int sendMessagesPlain(long timeout) {
        VerifiableClient producer = new VerifiableClient.VerifiableClientBuilder().withClientType(ClientType.CLI_KAFKA_VERIFIABLE_PRODUCER).withUsingPodName(this.podName).withPodNamespace(this.namespaceName).withMaxMessages(this.messageCount).withKafkaUsername(this.completeKafkaUsername).withBootstrapServer(this.getBootstrapServerFromStatus()).withTopicName(this.topicName).build();
        LOGGER.info("Starting verifiableClient plain producer with the following configuration: {}", (Object)producer.toString());
        LOGGER.info("Producing {} messages to {}:{} from pod {}", (Object)this.messageCount, (Object)producer.getBootstrapServer(), (Object)this.topicName, (Object)this.podName);
        boolean hasPassed = producer.run(Constants.PRODUCER_TIMEOUT);
        LOGGER.info("Producer finished correctly: {}", (Object)hasPassed);
        int sent = this.getSentMessagesCount(producer.getMessages().toString(), this.messageCount);
        LOGGER.info("Producer produced {} messages", (Object)sent);
        return sent;
    }

    public int sendMessagesTls() {
        return this.sendMessagesTls(Constants.GLOBAL_CLIENTS_TIMEOUT);
    }

    @Override
    public int sendMessagesTls(long timeout) {
        VerifiableClient producerTls = new VerifiableClient.VerifiableClientBuilder().withClientType(ClientType.CLI_KAFKA_VERIFIABLE_PRODUCER).withUsingPodName(this.podName).withPodNamespace(this.namespaceName).withMaxMessages(this.messageCount).withKafkaUsername(this.completeKafkaUsername).withBootstrapServer(this.getBootstrapServerFromStatus()).withTopicName(this.topicName).build();
        LOGGER.info("Starting verifiableClient tls producer with the following configuration: {}", (Object)producerTls.toString());
        LOGGER.info("Producing {} messages to {}:{} from pod {}", (Object)this.messageCount, (Object)producerTls.getBootstrapServer(), (Object)this.topicName, (Object)this.podName);
        boolean hasPassed = producerTls.run(timeout);
        LOGGER.info("Producer finished correctly: {}", (Object)hasPassed);
        int sent = this.getSentMessagesCount(producerTls.getMessages().toString(), this.messageCount);
        LOGGER.info("Producer produced {} messages", (Object)sent);
        return sent;
    }

    public int receiveMessagesPlain() {
        return this.receiveMessagesPlain(Constants.GLOBAL_CLIENTS_TIMEOUT);
    }

    @Override
    public int receiveMessagesPlain(long timeout) {
        VerifiableClient consumer = new VerifiableClient.VerifiableClientBuilder().withClientType(ClientType.CLI_KAFKA_VERIFIABLE_CONSUMER).withUsingPodName(this.podName).withPodNamespace(this.namespaceName).withMaxMessages(this.messageCount).withKafkaUsername(this.completeKafkaUsername).withBootstrapServer(this.getBootstrapServerFromStatus()).withTopicName(this.topicName).withConsumerGroupName(this.consumerGroup).withConsumerInstanceId("instance" + new Random().nextInt(Integer.MAX_VALUE)).build();
        LOGGER.info("Starting verifiableClient plain consumer with the following configuration: {}", (Object)consumer.toString());
        LOGGER.info("Consuming {} messages from {}#{} from pod {}", (Object)this.messageCount, (Object)consumer.getBootstrapServer(), (Object)this.topicName, (Object)this.podName);
        boolean hasPassed = consumer.run(timeout);
        LOGGER.info("Consumer finished correctly: {}", (Object)hasPassed);
        int received = this.getReceivedMessagesCount(consumer.getMessages().toString());
        LOGGER.info("Consumer consumed {} messages", (Object)received);
        return received;
    }

    public int receiveMessagesTls() {
        return this.receiveMessagesTls(Constants.GLOBAL_CLIENTS_TIMEOUT);
    }

    @Override
    public int receiveMessagesTls(long timeoutMs) {
        VerifiableClient consumerTls = new VerifiableClient.VerifiableClientBuilder().withClientType(ClientType.CLI_KAFKA_VERIFIABLE_CONSUMER).withUsingPodName(this.podName).withPodNamespace(this.namespaceName).withMaxMessages(this.messageCount).withKafkaUsername(this.completeKafkaUsername).withBootstrapServer(this.getBootstrapServerFromStatus()).withTopicName(this.topicName).withConsumerGroupName(this.consumerGroup).withConsumerInstanceId("instance" + new Random().nextInt(Integer.MAX_VALUE)).build();
        LOGGER.info("Starting verifiableClient tls consumer with the following configuration: {}", (Object)consumerTls.toString());
        LOGGER.info("Consuming {} messages from {}:{} from pod {}", (Object)this.messageCount, (Object)consumerTls.getBootstrapServer(), (Object)this.topicName, (Object)this.podName);
        boolean hasPassed = consumerTls.run(timeoutMs);
        LOGGER.info("Consumer finished correctly: {}", (Object)hasPassed);
        int received = this.getReceivedMessagesCount(consumerTls.getMessages().toString());
        LOGGER.info("Consumer consumed {} messages", (Object)received);
        return received;
    }

    public void checkProducedAndConsumedMessages(int producedMessages, int consumedMessages) {
        this.assertSentAndReceivedMessages(producedMessages, consumedMessages);
    }

    public void assertSentAndReceivedMessages(int sent, int received) {
        MatcherAssert.assertThat((String)String.format("Sent (%s) and receive (%s) message count is not equal", sent, received), (sent == received ? 1 : 0) != 0);
    }

    private int getSentMessagesCount(String response, int messageCount) {
        Pattern r = Pattern.compile("sent\":(" + messageCount + ")");
        Matcher m = r.matcher(response);
        int sentMessages = m.find() ? Integer.parseInt(m.group(1)) : -1;
        r = Pattern.compile("acked\":(" + messageCount + ")");
        m = r.matcher(response);
        if (m.find()) {
            return sentMessages == Integer.parseInt(m.group(1)) ? sentMessages : -1;
        }
        return -1;
    }

    private int getReceivedMessagesCount(String response) {
        int receivedMessages = 0;
        Pattern r = Pattern.compile("records_consumed\",\"count\":([0-9]*)");
        Matcher m = r.matcher(response);
        while (m.find()) {
            receivedMessages += Integer.parseInt(m.group(1));
        }
        return receivedMessages;
    }

    public String getPodName() {
        return this.podName;
    }

    public static class Builder
    extends AbstractKafkaClient.Builder<Builder> {
        private String podName;

        public Builder withUsingPodName(String podName) {
            this.podName = podName;
            return this;
        }

        public InternalKafkaClient build() {
            return new InternalKafkaClient(this);
        }
    }
}

