/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.keycloak;

import io.fabric8.kubernetes.api.model.Pod;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.test.k8s.KubeClusterResource;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeycloakInstance {
    private static final Logger LOGGER = LogManager.getLogger(KeycloakInstance.class);
    public static final String KEYCLOAK_SECRET_NAME = "sso-x509-https-secret";
    public static final String KEYCLOAK_SECRET_CERT = "tls.crt";
    private final int jwksExpireSeconds = 500;
    private final int jwksRefreshSeconds = 400;
    private final String username;
    private final String password;
    private final String namespace;
    private final String httpsUri;
    private final String httpUri;
    private String validIssuerUri;
    private String jwksEndpointUri;
    private String oauthTokenEndpointUri;
    private String introspectionEndpointUri;
    private String userNameClaim;
    private Pattern keystorePattern = Pattern.compile("<tls>\\s*<key-stores>\\s*<key-store name=\"kcKeyStore\">\\s*<credential-reference clear-text=\".*\"\\/>");
    private Pattern keystorePasswordPattern = Pattern.compile("\\\".*\\\"");

    public KeycloakInstance(String username, String password, String namespace) {
        this.username = username;
        this.password = password;
        this.namespace = namespace;
        this.httpsUri = "keycloak." + namespace + ".svc.cluster.local:8443";
        this.httpUri = "keycloak-discovery." + namespace + ".svc.cluster.local:8080";
        this.validIssuerUri = "https://" + this.httpsUri + "/auth/realms/internal";
        this.jwksEndpointUri = "https://" + this.httpsUri + "/auth/realms/internal/protocol/openid-connect/certs";
        this.oauthTokenEndpointUri = "https://" + this.httpsUri + "/auth/realms/internal/protocol/openid-connect/token";
        this.introspectionEndpointUri = "https://" + this.httpsUri + "/auth/realms/internal/protocol/openid-connect/token/introspect";
        this.userNameClaim = "preferred_username";
    }

    public void setRealm(String realmName, boolean tlsEnabled) {
        LOGGER.info("Replacing validIssuerUri: {} to pointing to {} realm", (Object)this.validIssuerUri, (Object)realmName);
        LOGGER.info("Replacing jwksEndpointUri: {} to pointing to {} realm", (Object)this.jwksEndpointUri, (Object)realmName);
        LOGGER.info("Replacing oauthTokenEndpointUri: {} to pointing to {} realm", (Object)this.oauthTokenEndpointUri, (Object)realmName);
        if (tlsEnabled) {
            LOGGER.info("Using HTTPS endpoints");
            this.validIssuerUri = "https://" + this.httpsUri + "/auth/realms/" + realmName;
            this.jwksEndpointUri = "https://" + this.httpsUri + "/auth/realms/" + realmName + "/protocol/openid-connect/certs";
            this.oauthTokenEndpointUri = "https://" + this.httpsUri + "/auth/realms/" + realmName + "/protocol/openid-connect/token";
        } else {
            LOGGER.info("Using HTTP endpoints");
            this.validIssuerUri = "http://" + this.httpUri + "/auth/realms/" + realmName;
            this.jwksEndpointUri = "http://" + this.httpUri + "/auth/realms/" + realmName + "/protocol/openid-connect/certs";
            this.oauthTokenEndpointUri = "http://" + this.httpUri + "/auth/realms/" + realmName + "/protocol/openid-connect/token";
        }
    }

    public String getKeystorePassword() {
        String keycloakPodName = ((Pod)KubeClusterResource.kubeClient().listPodsByPrefixInName("keycloak-").get(0)).getMetadata().getName();
        String inputFile = ResourceManager.cmdKubeClient().execInPod(keycloakPodName, new String[]{"cat", "/opt/jboss/keycloak/standalone/configuration/standalone-ha.xml"}).out().trim();
        Matcher keystoreMatcher = this.keystorePattern.matcher(inputFile);
        String keystorePassword = null;
        if (keystoreMatcher.find()) {
            String result = keystoreMatcher.group(0);
            LOGGER.info(result);
            String[] shards = result.split("\n");
            LOGGER.info(shards[3]);
            Matcher keystorePasswordMatcher = this.keystorePasswordPattern.matcher(shards[3]);
            if (keystorePasswordMatcher.find()) {
                keystorePassword = keystorePasswordMatcher.group(0);
                keystorePassword = keystorePassword.substring(1, keystorePassword.length() - 1);
                LOGGER.info(keystorePassword);
            }
        }
        return keystorePassword;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getHttpsUri() {
        return this.httpsUri;
    }

    public String getHttpUri() {
        return this.httpUri;
    }

    public String getValidIssuerUri() {
        return this.validIssuerUri;
    }

    public void setValidIssuerUri(String validIssuerUri) {
        this.validIssuerUri = validIssuerUri;
    }

    public String getJwksEndpointUri() {
        return this.jwksEndpointUri;
    }

    public void setJwksEndpointUri(String jwksEndpointUri) {
        this.jwksEndpointUri = jwksEndpointUri;
    }

    public String getOauthTokenEndpointUri() {
        return this.oauthTokenEndpointUri;
    }

    public void setOauthTokenEndpointUri(String oauthTokenEndpointUri) {
        this.oauthTokenEndpointUri = oauthTokenEndpointUri;
    }

    public String getIntrospectionEndpointUri() {
        return this.introspectionEndpointUri;
    }

    public void setIntrospectionEndpointUri(String introspectionEndpointUri) {
        this.introspectionEndpointUri = introspectionEndpointUri;
    }

    public String getUserNameClaim() {
        return this.userNameClaim;
    }

    public void setUserNameClaim(String userNameClaim) {
        this.userNameClaim = userNameClaim;
    }

    public Pattern getKeystorePattern() {
        return this.keystorePattern;
    }

    public void setKeystorePattern(Pattern keystorePattern) {
        this.keystorePattern = keystorePattern;
    }

    public int getJwksExpireSeconds() {
        return 500;
    }

    public int getJwksRefreshSeconds() {
        return 400;
    }

    public String toString() {
        return "KeycloakInstance{jwksExpireSeconds=500, jwksRefreshSeconds=400, username='" + this.username + "', password='" + this.password + "', httpsUri='" + this.httpsUri + "', httpUri='" + this.httpUri + "', validIssuerUri='" + this.validIssuerUri + "', jwksEndpointUri='" + this.jwksEndpointUri + "', oauthTokenEndpointUri='" + this.oauthTokenEndpointUri + "', introspectionEndpointUri='" + this.introspectionEndpointUri + "', userNameClaim='" + this.userNameClaim + "', keystorePattern=" + this.keystorePattern + ", keystorePasswordPattern=" + this.keystorePasswordPattern + "}";
    }
}

