/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.logs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClient;
import io.strimzi.test.k8s.KubeClusterResource;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogCollector {
    private static final Logger LOGGER = LogManager.getLogger(LogCollector.class);
    private KubeClient kubeClient;
    private String namespace;
    private File logDir;
    private File configMapDir;
    private File eventsDir;

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public LogCollector(KubeClient kubeClient, File logDir) {
        this.kubeClient = kubeClient;
        this.namespace = kubeClient.getNamespace();
        this.logDir = logDir;
        this.eventsDir = new File(logDir + "/events");
        this.configMapDir = new File(logDir + "/configMaps");
        logDir.mkdirs();
        if (!this.eventsDir.exists()) {
            this.eventsDir.mkdirs();
        }
        if (!this.configMapDir.exists()) {
            this.configMapDir.mkdirs();
        }
    }

    public void collectLogsFromPods() {
        LOGGER.info("Collecting logs for Pod(s) in namespace {}", (Object)this.namespace);
        try {
            this.kubeClient.listPods().forEach(pod -> {
                String podName = pod.getMetadata().getName();
                pod.getStatus().getContainerStatuses().forEach(containerStatus -> {
                    String log = ((ContainerResource)this.kubeClient.getPodResource(podName).inContainer((Object)containerStatus.getName())).getLog();
                    TestUtils.writeFile((String)(this.logDir + "/logs-pod-" + podName + "-container-" + containerStatus.getName() + ".log"), (String)log);
                    String describe = KubeClusterResource.cmdKubeClient().describe("pod", podName);
                    TestUtils.writeFile((String)(this.logDir + "/describe-pod-" + podName + "-container-" + containerStatus.getName() + ".log"), (String)describe);
                });
            });
        }
        catch (Exception allExceptions) {
            LOGGER.warn("Searching for logs in all pods failed! Some of the logs will not be stored.");
        }
    }

    public void collectEvents() {
        LOGGER.info("Collecting events in Namespace {}", (Object)this.namespace);
        String events = KubeClusterResource.cmdKubeClient().getEvents();
        TestUtils.writeFile((String)(this.eventsDir + "/events-in-namespace" + this.kubeClient.getNamespace() + ".log"), (String)events);
    }

    public void collectConfigMaps() {
        LOGGER.info("Collecting ConfigMaps in Namespace {}", (Object)this.namespace);
        this.kubeClient.listConfigMaps().forEach(configMap -> TestUtils.writeFile((String)(this.configMapDir + "/" + configMap.getMetadata().getName() + "-" + this.namespace + ".log"), (String)configMap.toString()));
    }

    public void collectDeployments() {
        LOGGER.info("Collecting Deployments in Namespace {}", (Object)this.namespace);
        TestUtils.writeFile((String)(this.logDir + "/deployments.log"), (String)KubeClusterResource.cmdKubeClient().getResourcesAsYaml("Deployment"));
    }

    public void collectStatefulSets() {
        LOGGER.info("Collecting StatefulSets in Namespace {}", (Object)this.namespace);
        TestUtils.writeFile((String)(this.logDir + "/statefulsets.log"), (String)KubeClusterResource.cmdKubeClient().getResourcesAsYaml("StatefulSet"));
    }

    public void collectReplicaSets() {
        LOGGER.info("Collecting ReplicaSet in Namespace {}", (Object)this.namespace);
        TestUtils.writeFile((String)(this.logDir + "/replicasets.log"), (String)KubeClusterResource.cmdKubeClient().getResourcesAsYaml("replicaset"));
    }

    public void collectStrimzi() {
        LOGGER.info("Collecting Strimzi in Namespace {}", (Object)this.namespace);
        String crData = KubeClusterResource.cmdKubeClient().exec(false, new String[]{"get", "strimzi", "-o", "yaml", "-n", this.namespace}).out();
        TestUtils.writeFile((String)(this.logDir + "/strimzi-custom-resources.log"), (String)crData);
    }

    public void collectClusterInfo() {
        LOGGER.info("Collecting cluster status");
        String nodes = KubeClusterResource.cmdKubeClient().exec(false, new String[]{"describe", "nodes"}).out();
        TestUtils.writeFile((String)(this.logDir + "/cluster-status.log"), (String)nodes);
    }
}

