/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.matchers;

import io.fabric8.kubernetes.api.model.Event;
import io.strimzi.systemtest.k8s.Events;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class HasAnyOfReasons
extends BaseMatcher<List<Event>> {
    private Events[] eventReasons;

    public HasAnyOfReasons(Events ... eventReasons) {
        this.eventReasons = eventReasons;
    }

    public boolean matches(Object actualValue) {
        List actualReasons = ((List)actualValue).stream().map(Event::getReason).collect(Collectors.toList());
        List expectedReasons = Arrays.stream(this.eventReasons).map(Enum::name).collect(Collectors.toList());
        for (String actualReason : actualReasons) {
            if (!expectedReasons.contains(actualReason)) continue;
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendValueList("The resource should contain at least one the following events {", ", ", "}. ", (Object[])this.eventReasons);
    }
}

