/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.matchers;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class LogHasNoUnexpectedErrors
extends BaseMatcher<String> {
    private static final Logger LOGGER = LogManager.getLogger(LogHasNoUnexpectedErrors.class);

    public boolean matches(Object actualValue) {
        if (!"".equals(actualValue)) {
            if (actualValue.toString().contains("Unhandled Exception")) {
                return false;
            }
            String logLineSplitPattern = "[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}";
            for (String line : ((String)actualValue).split(logLineSplitPattern)) {
                if (line.contains("DEBUG") || line.contains("WARN") || line.contains("INFO")) continue;
                if (line.startsWith("java.lang.NullPointerException")) {
                    return false;
                }
                String lineLowerCase = line.toLowerCase(Locale.ENGLISH);
                if (!lineLowerCase.contains("error") && !lineLowerCase.contains("exception")) continue;
                boolean whiteListResult = false;
                for (LogWhiteList value : LogWhiteList.values()) {
                    Matcher m = Pattern.compile(value.name).matcher(line);
                    if (!m.find()) continue;
                    whiteListResult = true;
                    break;
                }
                if (whiteListResult) continue;
                LOGGER.error(line);
                return false;
            }
            return true;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("The log should not contain unexpected errors.");
    }

    static enum LogWhiteList {
        CO_TIMEOUT_EXCEPTION("io.strimzi.operator.common.operator.resource.TimeoutException"),
        NO_ERROR("NoError\\(0\\)"),
        CAUGHT_EXCEPTION_FOR_NETWORK_POLICY("Caught exception while patching NetworkPolicy(?s)(.*?)io.fabric8.kubernetes.client.KubernetesClientException: Failure executing: PATCH"),
        EXIT_ON_OUT_OF_MEMORY("ExitOnOutOfMemoryError"),
        OPERATION_TIMEOUT("Util:[0-9]+ - Exceeded timeout of.*while waiting for.*"),
        RECONCILIATION_TIMEOUT("ERROR Abstract.*Operator:[0-9]+ - Reconciliation.*"),
        ASSEMBLY_OPERATOR_RECONCILIATION_TIMEOUT("ERROR .*AssemblyOperator:[0-9]+ - Reconciliation.*[fF]ailed.*"),
        WATCHER_CLOSED_EXCEPTION("ERROR AbstractOperator:.+ - Watcher closed with exception in namespace .*"),
        CONCURRENT_RESOURCE_DELETION("io.strimzi.operator.cluster.operator.resource.ConcurrentDeletionException"),
        RECOVERY_STS_DELETION("java\\.lang\\.IllegalStateException: Can't wait for StatefulSet: recovery-cluster-(kafka|zookeeper) in namespace: recovery-cluster-test to scale. Resource is no longer available.");

        final String name;

        private LogWhiteList(String name) {
            this.name = name;
        }
    }
}

