/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.batch.Job;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicy;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyFluent;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent;
import io.fabric8.kubernetes.api.model.rbac.Subject;
import io.fabric8.kubernetes.api.model.rbac.SubjectBuilder;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.strimzi.api.kafka.model.KafkaExporterResources;
import io.strimzi.api.kafka.model.KafkaResources;
import io.strimzi.api.kafka.model.Spec;
import io.strimzi.api.kafka.model.status.Status;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.Environment;
import io.strimzi.systemtest.enums.DefaultNetworkPolicy;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.utils.kubeUtils.controllers.DeploymentUtils;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KubernetesResource {
    private static final Logger LOGGER = LogManager.getLogger(KubernetesResource.class);

    public static Deployment deployNewDeployment(Deployment deployment) {
        TestUtils.waitFor((String)"Deployment creation", (long)Constants.POLL_INTERVAL_FOR_RESOURCE_CREATION, (long)ResourceManager.CR_CREATION_TIMEOUT, () -> {
            try {
                ResourceManager.kubeClient().createOrReplaceDeployment(deployment);
                return true;
            }
            catch (KubernetesClientException e) {
                if (e.getMessage().contains("object is being deleted")) {
                    return false;
                }
                throw e;
            }
        });
        return KubernetesResource.waitFor(KubernetesResource.deleteLater(deployment));
    }

    public static Job deployNewJob(Job job) {
        TestUtils.waitFor((String)("Job creation " + job.getMetadata().getName()), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_CREATION, (long)ResourceManager.CR_CREATION_TIMEOUT, () -> {
            try {
                ResourceManager.kubeClient().createJob(job);
                return true;
            }
            catch (KubernetesClientException e) {
                if (e.getMessage().contains("object is being deleted")) {
                    return false;
                }
                throw e;
            }
        });
        return KubernetesResource.deleteLater(job);
    }

    public static RoleBinding roleBinding(String yamlPath, String namespace, String clientNamespace) {
        LOGGER.info("Creating RoleBinding from {} in namespace {}", (Object)yamlPath, (Object)namespace);
        RoleBinding roleBinding = KubernetesResource.getRoleBindingFromYaml(yamlPath);
        if (Environment.isNamespaceRbacScope()) {
            LOGGER.info("Replacing ClusterRole RoleRef for Role RoleRef");
            roleBinding.getRoleRef().setKind("Role");
        }
        return KubernetesResource.roleBinding(((RoleBindingBuilder)((RoleBindingFluent.SubjectsNested)new RoleBindingBuilder(roleBinding).editFirstSubject().withNamespace(namespace)).endSubject()).build(), clientNamespace);
    }

    private static RoleBinding roleBinding(RoleBinding roleBinding, String clientNamespace) {
        ResourceManager.kubeClient().namespace(clientNamespace).createOrReplaceRoleBinding(roleBinding);
        KubernetesResource.deleteLater(roleBinding);
        return roleBinding;
    }

    public static ClusterRoleBinding clusterRoleBinding(String yamlPath, String namespace) {
        LOGGER.info("Creating ClusterRoleBinding from {} in namespace {}", (Object)yamlPath, (Object)namespace);
        ClusterRoleBinding clusterRoleBinding = KubernetesResource.getClusterRoleBindingFromYaml(yamlPath);
        return KubernetesResource.clusterRoleBinding(((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.SubjectsNested)new ClusterRoleBindingBuilder(clusterRoleBinding).editFirstSubject().withNamespace(namespace)).endSubject()).build());
    }

    public static ClusterRoleBinding clusterRoleBinding(ClusterRoleBinding clusterRoleBinding) {
        ResourceManager.kubeClient().createOrReplaceClusterRoleBinding(clusterRoleBinding);
        KubernetesResource.deleteLater(clusterRoleBinding);
        return clusterRoleBinding;
    }

    public static List<ClusterRoleBinding> clusterRoleBindingsForAllNamespaces(String namespace) {
        LOGGER.info("Creating ClusterRoleBinding that grant cluster-wide access to all OpenShift projects");
        ArrayList<ClusterRoleBinding> kCRBList = new ArrayList<ClusterRoleBinding>();
        kCRBList.add(((ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.RoleRefNested)((ClusterRoleBindingFluent.RoleRefNested)((ClusterRoleBindingFluent.RoleRefNested)((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.MetadataNested)new ClusterRoleBindingBuilder().withNewMetadata().withName("strimzi-cluster-operator-namespaced")).endMetadata()).withNewRoleRef().withApiGroup("rbac.authorization.k8s.io")).withKind("ClusterRole")).withName("strimzi-cluster-operator-namespaced")).endRoleRef()).withSubjects(new Subject[]{((SubjectBuilder)((SubjectBuilder)((SubjectBuilder)new SubjectBuilder().withKind("ServiceAccount")).withName("strimzi-cluster-operator")).withNamespace(namespace)).build()})).build());
        kCRBList.add(((ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.RoleRefNested)((ClusterRoleBindingFluent.RoleRefNested)((ClusterRoleBindingFluent.RoleRefNested)((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.MetadataNested)new ClusterRoleBindingBuilder().withNewMetadata().withName("strimzi-entity-operator")).endMetadata()).withNewRoleRef().withApiGroup("rbac.authorization.k8s.io")).withKind("ClusterRole")).withName("strimzi-entity-operator")).endRoleRef()).withSubjects(new Subject[]{((SubjectBuilder)((SubjectBuilder)((SubjectBuilder)new SubjectBuilder().withKind("ServiceAccount")).withName("strimzi-cluster-operator")).withNamespace(namespace)).build()})).build());
        kCRBList.add(((ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.RoleRefNested)((ClusterRoleBindingFluent.RoleRefNested)((ClusterRoleBindingFluent.RoleRefNested)((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.MetadataNested)new ClusterRoleBindingBuilder().withNewMetadata().withName("strimzi-topic-operator")).endMetadata()).withNewRoleRef().withApiGroup("rbac.authorization.k8s.io")).withKind("ClusterRole")).withName("strimzi-topic-operator")).endRoleRef()).withSubjects(new Subject[]{((SubjectBuilder)((SubjectBuilder)((SubjectBuilder)new SubjectBuilder().withKind("ServiceAccount")).withName("strimzi-cluster-operator")).withNamespace(namespace)).build()})).build());
        return kCRBList;
    }

    public static ServiceBuilder getSystemtestsServiceResource(String appName, int port, String namespace, String transportProtocol) {
        return (ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(appName)).withNamespace(namespace)).addToLabels("run", appName)).endMetadata()).withNewSpec().withSelector(Collections.singletonMap("app", appName))).addNewPort().withName("http")).withPort(Integer.valueOf(port))).withProtocol(transportProtocol)).endPort()).endSpec();
    }

    public static Service createServiceResource(String appName, int port, String clientNamespace, String transportProtocol) {
        Service service = KubernetesResource.getSystemtestsServiceResource(appName, port, clientNamespace, transportProtocol).build();
        LOGGER.info("Creating Service {} in namespace {}", (Object)service.getMetadata().getName(), (Object)clientNamespace);
        ResourceManager.kubeClient().createService(service);
        KubernetesResource.deleteLater(service);
        return service;
    }

    public static Service createServiceResource(Service service, String clientNamespace) {
        LOGGER.info("Creating Service {} in namespace {}", (Object)service.getMetadata().getName(), (Object)clientNamespace);
        ResourceManager.kubeClient().createService(service);
        KubernetesResource.deleteLater(service);
        return service;
    }

    public static Service createKeycloakNodePortHttpService(String namespace) {
        String keycloakName = "keycloak";
        HashMap<String, String> keycloakLabels = new HashMap<String, String>();
        keycloakLabels.put("app", keycloakName);
        keycloakLabels.put("component", keycloakName);
        return ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)KubernetesResource.getSystemtestsServiceResource(keycloakName + "-service-http", 8080, namespace, "TCP").editSpec().withType("NodePort")).withSelector(keycloakLabels)).editFirstPort().withNodePort(Integer.valueOf(32482))).endPort()).endSpec()).build();
    }

    public static Service createKeycloakNodePortService(String namespace) {
        String keycloakName = "keycloak";
        HashMap<String, String> keycloakLabels = new HashMap<String, String>();
        keycloakLabels.put("app", keycloakName);
        keycloakLabels.put("component", keycloakName);
        return ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)KubernetesResource.getSystemtestsServiceResource(keycloakName + "-service-https", 8443, namespace, "TCP").editSpec().withType("NodePort")).withSelector(keycloakLabels)).editFirstPort().withNodePort(Integer.valueOf(32481))).endPort()).endSpec()).build();
    }

    public static Service deployBridgeNodePortService(String bridgeExternalService, String namespace, String clusterName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("strimzi.io/cluster", clusterName);
        map.put("strimzi.io/kind", "KafkaBridge");
        map.put("strimzi.io/name", clusterName + "-bridge");
        return ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)KubernetesResource.getSystemtestsServiceResource(bridgeExternalService, 8080, namespace, "TCP").editSpec().withType("NodePort")).withSelector(map)).endSpec()).build();
    }

    public static void applyDefaultNetworkPolicySettings(List<String> namespaces) {
        for (String namespace : namespaces) {
            if (Environment.DEFAULT_TO_DENY_NETWORK_POLICIES) {
                KubernetesResource.applyDefaultNetworkPolicy(namespace, DefaultNetworkPolicy.DEFAULT_TO_DENY);
            } else {
                KubernetesResource.applyDefaultNetworkPolicy(namespace, DefaultNetworkPolicy.DEFAULT_TO_ALLOW);
            }
            LOGGER.info("NetworkPolicy successfully set to: {} for namespace: {}", (Object)Environment.DEFAULT_TO_DENY_NETWORK_POLICIES, (Object)namespace);
        }
    }

    public static NetworkPolicyBuilder networkPolicyBuilder(String name) {
        return (NetworkPolicyBuilder)((NetworkPolicyFluent.SpecNested)((NetworkPolicyFluent.SpecNested)KubernetesResource.networkPolicyBuilder(name, null).withNewSpec().withNewPodSelector().endPodSelector()).withPolicyTypes(new String[]{"Ingress"})).endSpec();
    }

    public static NetworkPolicyBuilder networkPolicyBuilder(String name, LabelSelector labelSelector) {
        return (NetworkPolicyBuilder)((NetworkPolicyFluent.SpecNested)((NetworkPolicyFluent.SpecNested)((NetworkPolicySpecFluent.IngressNested)((NetworkPolicyIngressRuleFluent.FromNested)((NetworkPolicyBuilder)((NetworkPolicyFluent.MetadataNested)((NetworkPolicyBuilder)((NetworkPolicyBuilder)new NetworkPolicyBuilder().withNewApiVersion("networking.k8s.io/v1")).withNewKind("NetworkPolicy")).withNewMetadata().withName(name + "-allow")).endMetadata()).withNewSpec().addNewIngress().addNewFrom().withPodSelector(labelSelector)).endFrom()).endIngress()).withPolicyTypes(new String[]{"Ingress"})).endSpec();
    }

    public static void allowNetworkPolicySettingsForClusterOperator() {
        String clusterOperatorKind = "cluster-operator";
        LabelSelector labelSelector = ((LabelSelectorBuilder)new LabelSelectorBuilder().addToMatchLabels("user-test-app", "kafka-clients")).build();
        LOGGER.info("Apply NetworkPolicy access to {} from pods with LabelSelector {}", (Object)clusterOperatorKind, (Object)labelSelector);
        NetworkPolicy networkPolicy = ((NetworkPolicyBuilder)((NetworkPolicyFluent.SpecNested)((NetworkPolicySpecFluent.PodSelectorNested)((NetworkPolicyFluent.SpecNested)((NetworkPolicySpecFluent.IngressNested)((NetworkPolicyIngressRuleFluent.PortsNested)((NetworkPolicyIngressRuleFluent.PortsNested)KubernetesResource.networkPolicyBuilder(clusterOperatorKind, labelSelector).editSpec().editFirstIngress().addNewPort().withNewPort(Integer.valueOf(8080))).withNewProtocol("TCP")).endPort()).endIngress()).withNewPodSelector().addToMatchLabels("strimzi.io/kind", clusterOperatorKind)).endPodSelector()).endSpec()).build();
        LOGGER.debug("Going to apply the following NetworkPolicy: {}", (Object)networkPolicy.toString());
        KubernetesResource.deleteLater((NetworkPolicy)((NonNamespaceOperation)KubeClusterResource.kubeClient().getClient().network().networkPolicies().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new NetworkPolicy[]{networkPolicy}));
        LOGGER.info("Network policy for LabelSelector {} successfully applied", (Object)labelSelector);
    }

    public static void allowNetworkPolicySettingsForEntityOperator(String clusterName) {
        LabelSelector labelSelector = ((LabelSelectorBuilder)new LabelSelectorBuilder().addToMatchLabels("user-test-app", "kafka-clients")).build();
        String eoDeploymentName = KafkaResources.entityOperatorDeploymentName((String)clusterName);
        LOGGER.info("Apply NetworkPolicy access to {} from pods with LabelSelector {}", (Object)eoDeploymentName, (Object)labelSelector);
        NetworkPolicy networkPolicy = ((NetworkPolicyBuilder)((NetworkPolicyFluent.SpecNested)((NetworkPolicySpecFluent.PodSelectorNested)((NetworkPolicySpecFluent.PodSelectorNested)((NetworkPolicySpecFluent.PodSelectorNested)((NetworkPolicyFluent.SpecNested)((NetworkPolicySpecFluent.IngressNested)((NetworkPolicyIngressRuleFluent.PortsNested)((NetworkPolicyIngressRuleFluent.PortsNested)((NetworkPolicySpecFluent.IngressNested)((NetworkPolicyIngressRuleFluent.PortsNested)((NetworkPolicyIngressRuleFluent.PortsNested)KubernetesResource.networkPolicyBuilder(eoDeploymentName, labelSelector).editSpec().editFirstIngress().addNewPort().withNewPort(Integer.valueOf(8080))).withNewProtocol("TCP")).endPort()).addNewPort().withNewPort(Integer.valueOf(8081))).withNewProtocol("TCP")).endPort()).endIngress()).withNewPodSelector().addToMatchLabels("strimzi.io/cluster", clusterName)).addToMatchLabels("strimzi.io/kind", "Kafka")).addToMatchLabels("strimzi.io/name", eoDeploymentName)).endPodSelector()).endSpec()).build();
        LOGGER.debug("Going to apply the following NetworkPolicy: {}", (Object)networkPolicy.toString());
        KubernetesResource.deleteLater((NetworkPolicy)((NonNamespaceOperation)KubeClusterResource.kubeClient().getClient().network().networkPolicies().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new NetworkPolicy[]{networkPolicy}));
        LOGGER.info("Network policy for LabelSelector {} successfully applied", (Object)labelSelector);
    }

    public static void allowNetworkPolicySettingsForKafkaExporter(String clusterName) {
        String kafkaExporterDeploymentName = KafkaExporterResources.deploymentName((String)clusterName);
        LabelSelector labelSelector = ((LabelSelectorBuilder)new LabelSelectorBuilder().addToMatchLabels("user-test-app", "kafka-clients")).build();
        LOGGER.info("Apply NetworkPolicy access to {} from pods with LabelSelector {}", (Object)kafkaExporterDeploymentName, (Object)labelSelector);
        NetworkPolicy networkPolicy = ((NetworkPolicyBuilder)((NetworkPolicyFluent.SpecNested)((NetworkPolicySpecFluent.PodSelectorNested)((NetworkPolicySpecFluent.PodSelectorNested)((NetworkPolicySpecFluent.PodSelectorNested)((NetworkPolicyFluent.SpecNested)((NetworkPolicySpecFluent.IngressNested)((NetworkPolicyIngressRuleFluent.PortsNested)((NetworkPolicyIngressRuleFluent.PortsNested)KubernetesResource.networkPolicyBuilder(kafkaExporterDeploymentName, labelSelector).editSpec().editFirstIngress().addNewPort().withNewPort(Integer.valueOf(9404))).withNewProtocol("TCP")).endPort()).endIngress()).withNewPodSelector().addToMatchLabels("strimzi.io/cluster", clusterName)).addToMatchLabels("strimzi.io/kind", "Kafka")).addToMatchLabels("strimzi.io/name", kafkaExporterDeploymentName)).endPodSelector()).endSpec()).build();
        LOGGER.debug("Going to apply the following NetworkPolicy: {}", (Object)networkPolicy.toString());
        KubernetesResource.deleteLater((NetworkPolicy)((NonNamespaceOperation)KubeClusterResource.kubeClient().getClient().network().networkPolicies().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new NetworkPolicy[]{networkPolicy}));
        LOGGER.info("Network policy for LabelSelector {} successfully applied", (Object)labelSelector);
    }

    public static void allowNetworkPolicySettingsForResource(HasMetadata resource, String deploymentName) {
        LabelSelector labelSelector = ((LabelSelectorBuilder)new LabelSelectorBuilder().addToMatchLabels("user-test-app", "kafka-clients")).build();
        if (KubeClusterResource.kubeClient().listPods(labelSelector).size() == 0) {
            throw new RuntimeException("You did not create the Kafka Client instance(pod) before using the " + resource.getKind());
        }
        LOGGER.info("Apply NetworkPolicy access to {} from pods with LabelSelector {}", (Object)deploymentName, (Object)labelSelector);
        NetworkPolicy networkPolicy = ((NetworkPolicyBuilder)((NetworkPolicyFluent.SpecNested)((NetworkPolicySpecFluent.PodSelectorNested)((NetworkPolicySpecFluent.PodSelectorNested)((NetworkPolicySpecFluent.PodSelectorNested)((NetworkPolicyFluent.SpecNested)((NetworkPolicySpecFluent.IngressNested)((NetworkPolicyIngressRuleFluent.PortsNested)((NetworkPolicyIngressRuleFluent.PortsNested)((NetworkPolicySpecFluent.IngressNested)((NetworkPolicyIngressRuleFluent.PortsNested)((NetworkPolicyIngressRuleFluent.PortsNested)((NetworkPolicySpecFluent.IngressNested)((NetworkPolicyIngressRuleFluent.PortsNested)((NetworkPolicyIngressRuleFluent.PortsNested)((NetworkPolicySpecFluent.IngressNested)((NetworkPolicyIngressRuleFluent.FromNested)KubernetesResource.networkPolicyBuilder(resource.getMetadata().getName(), labelSelector).editSpec().editFirstIngress().addNewFrom().withPodSelector(labelSelector)).endFrom()).addNewPort().withNewPort(Integer.valueOf(8083))).withNewProtocol("TCP")).endPort()).addNewPort().withNewPort(Integer.valueOf(9404))).withNewProtocol("TCP")).endPort()).addNewPort().withNewPort(Integer.valueOf(8080))).withNewProtocol("TCP")).endPort()).endIngress()).withNewPodSelector().addToMatchLabels("strimzi.io/cluster", resource.getMetadata().getName())).addToMatchLabels("strimzi.io/kind", resource.getKind())).addToMatchLabels("strimzi.io/name", deploymentName)).endPodSelector()).endSpec()).build();
        LOGGER.debug("Going to apply the following NetworkPolicy: {}", (Object)networkPolicy.toString());
        KubernetesResource.deleteLater((NetworkPolicy)((NonNamespaceOperation)KubeClusterResource.kubeClient().getClient().network().networkPolicies().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new NetworkPolicy[]{networkPolicy}));
        LOGGER.info("Network policy for LabelSelector {} successfully applied", (Object)labelSelector);
    }

    public static NetworkPolicy applyDefaultNetworkPolicy(String namespace, DefaultNetworkPolicy policy) {
        NetworkPolicy networkPolicy = KubernetesResource.networkPolicyBuilder("global-network-policy").build();
        if (policy.equals((Object)DefaultNetworkPolicy.DEFAULT_TO_ALLOW)) {
            networkPolicy = ((NetworkPolicyBuilder)((NetworkPolicyFluent.SpecNested)new NetworkPolicyBuilder(networkPolicy).editSpec().addNewIngress().endIngress()).endSpec()).build();
        }
        LOGGER.debug("Going to apply the following NetworkPolicy: {}", (Object)networkPolicy.toString());
        KubernetesResource.deleteLater((NetworkPolicy)((NonNamespaceOperation)KubeClusterResource.kubeClient().getClient().network().networkPolicies().inNamespace(namespace)).createOrReplace((Object[])new NetworkPolicy[]{networkPolicy}));
        LOGGER.info("Network policy successfully set to: {}", (Object)policy);
        return networkPolicy;
    }

    public static <T extends CustomResource<? extends Spec, ? extends Status>> void deployNetworkPolicyForResource(T resource, String deploymentName) {
        if (Environment.DEFAULT_TO_DENY_NETWORK_POLICIES) {
            KubernetesResource.allowNetworkPolicySettingsForResource(resource, deploymentName);
        }
    }

    public static Deployment getDeploymentFromYaml(String yamlPath) {
        return (Deployment)TestUtils.configFromYaml((String)yamlPath, Deployment.class);
    }

    private static RoleBinding getRoleBindingFromYaml(String yamlPath) {
        return (RoleBinding)TestUtils.configFromYaml((String)yamlPath, RoleBinding.class);
    }

    private static ClusterRoleBinding getClusterRoleBindingFromYaml(String yamlPath) {
        return (ClusterRoleBinding)TestUtils.configFromYaml((String)yamlPath, ClusterRoleBinding.class);
    }

    private static Deployment waitFor(Deployment deployment) {
        String deploymentName = deployment.getMetadata().getName();
        DeploymentUtils.waitForDeploymentAndPodsReady(deploymentName, deployment.getSpec().getReplicas());
        return deployment;
    }

    private static Deployment deleteLater(Deployment resource) {
        return ResourceManager.deleteLater(ResourceManager.kubeClient().getClient().apps().deployments(), resource);
    }

    private static ClusterRoleBinding deleteLater(ClusterRoleBinding resource) {
        return ResourceManager.deleteLater(ResourceManager.kubeClient().getClient().rbac().clusterRoleBindings(), resource);
    }

    private static RoleBinding deleteLater(RoleBinding resource) {
        return ResourceManager.deleteLater(ResourceManager.kubeClient().getClient().rbac().roleBindings(), resource);
    }

    private static Service deleteLater(Service resource) {
        return ResourceManager.deleteLater(ResourceManager.kubeClient().getClient().services(), resource);
    }

    public static NetworkPolicy deleteLater(NetworkPolicy resource) {
        return ResourceManager.deleteLater(ResourceManager.kubeClient().getClient().network().networkPolicies(), resource);
    }

    public static Job deleteLater(Job resource) {
        return ResourceManager.deleteLater(ResourceManager.kubeClient().getClient().batch().jobs(), resource);
    }
}

