/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources.crd;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaBridgeList;
import io.strimzi.api.kafka.model.KafkaBridge;
import io.strimzi.api.kafka.model.KafkaBridgeBuilder;
import io.strimzi.api.kafka.model.KafkaBridgeFluent;
import io.strimzi.api.kafka.model.KafkaBridgeHttpConfigFluent;
import io.strimzi.api.kafka.model.KafkaBridgeResources;
import io.strimzi.api.kafka.model.KafkaBridgeSpecFluent;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.enums.CustomResourceStatus;
import io.strimzi.systemtest.resources.KubernetesResource;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.test.TestUtils;
import java.util.function.Consumer;

public class KafkaBridgeResource {
    public static final String PATH_TO_KAFKA_BRIDGE_CONFIG = TestUtils.USER_PATH + "/../examples/bridge/kafka-bridge.yaml";
    public static final String PATH_TO_KAFKA_BRIDGE_METRICS_CONFIG = TestUtils.USER_PATH + "/../examples/metrics/kafka-bridge-metrics.yaml";

    public static MixedOperation<KafkaBridge, KafkaBridgeList, Resource<KafkaBridge>> kafkaBridgeClient() {
        return Crds.kafkaBridgeOperation((KubernetesClient)ResourceManager.kubeClient().getClient());
    }

    public static KafkaBridgeBuilder kafkaBridge(String name, String bootstrap, int kafkaBridgeReplicas) {
        return KafkaBridgeResource.kafkaBridge(name, name, bootstrap, kafkaBridgeReplicas);
    }

    public static KafkaBridgeBuilder kafkaBridge(String name, String clusterName, String bootstrap, int kafkaBridgeReplicas) {
        KafkaBridge kafkaBridge = KafkaBridgeResource.getKafkaBridgeFromYaml(PATH_TO_KAFKA_BRIDGE_CONFIG);
        return KafkaBridgeResource.defaultKafkaBridge(kafkaBridge, name, clusterName, bootstrap, kafkaBridgeReplicas);
    }

    public static KafkaBridgeBuilder kafkaBridgeWithCors(String name, String bootstrap, int kafkaBridgeReplicas, String allowedCorsOrigin, String allowedCorsMethods) {
        return KafkaBridgeResource.kafkaBridgeWithCors(name, name, bootstrap, kafkaBridgeReplicas, allowedCorsOrigin, allowedCorsMethods);
    }

    public static KafkaBridgeBuilder kafkaBridgeWithCors(String name, String clusterName, String bootstrap, int kafkaBridgeReplicas, String allowedCorsOrigin, String allowedCorsMethods) {
        return (KafkaBridgeBuilder)((KafkaBridgeFluent.SpecNested)((KafkaBridgeSpecFluent.HttpNested)((KafkaBridgeHttpConfigFluent.CorsNested)((KafkaBridgeHttpConfigFluent.CorsNested)KafkaBridgeResource.kafkaBridge(name, clusterName, bootstrap, kafkaBridgeReplicas).editSpec().editHttp().withNewCors().withAllowedOrigins(new String[]{allowedCorsOrigin})).withAllowedMethods(new String[]{allowedCorsMethods != null ? allowedCorsMethods : "GET,POST,PUT,DELETE,OPTIONS,PATCH"})).endCors()).endHttp()).endSpec();
    }

    public static KafkaBridgeBuilder kafkaBridgeWithMetrics(String name, String clusterName, String bootstrap) {
        return KafkaBridgeResource.kafkaBridgeWithMetrics(name, clusterName, bootstrap, 1);
    }

    public static KafkaBridgeBuilder kafkaBridgeWithMetrics(String name, String clusterName, String bootstrap, int kafkaBridgeReplicas) {
        KafkaBridge kafkaBridge = KafkaBridgeResource.getKafkaBridgeFromYaml(PATH_TO_KAFKA_BRIDGE_METRICS_CONFIG);
        return KafkaBridgeResource.defaultKafkaBridge(kafkaBridge, name, clusterName, bootstrap, kafkaBridgeReplicas);
    }

    private static KafkaBridgeBuilder defaultKafkaBridge(KafkaBridge kafkaBridge, String name, String kafkaClusterName, String bootstrap, int kafkaBridgeReplicas) {
        return (KafkaBridgeBuilder)((KafkaBridgeFluent.SpecNested)((KafkaBridgeSpecFluent.InlineLoggingNested)((KafkaBridgeFluent.SpecNested)((KafkaBridgeFluent.SpecNested)((KafkaBridgeBuilder)((KafkaBridgeFluent.MetadataNested)((KafkaBridgeFluent.MetadataNested)((KafkaBridgeFluent.MetadataNested)new KafkaBridgeBuilder(kafkaBridge).withNewMetadata().withName(name)).withNamespace(ResourceManager.kubeClient().getNamespace())).withClusterName(kafkaClusterName)).endMetadata()).editSpec().withBootstrapServers(bootstrap)).withReplicas(kafkaBridgeReplicas)).withNewInlineLogging().addToLoggers("bridge.root.logger", "DEBUG")).endInlineLogging()).endSpec();
    }

    public static KafkaBridge createAndWaitForReadiness(KafkaBridge kafkaBridge) {
        KubernetesResource.deployNetworkPolicyForResource(kafkaBridge, KafkaBridgeResources.deploymentName((String)kafkaBridge.getMetadata().getName()));
        TestUtils.waitFor((String)"KafkaBridge creation", (long)Constants.POLL_INTERVAL_FOR_RESOURCE_CREATION, (long)ResourceManager.CR_CREATION_TIMEOUT, () -> {
            try {
                ((NonNamespaceOperation)KafkaBridgeResource.kafkaBridgeClient().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new KafkaBridge[]{kafkaBridge});
                return true;
            }
            catch (KubernetesClientException e) {
                if (e.getMessage().contains("object is being deleted")) {
                    return false;
                }
                throw e;
            }
        });
        return KafkaBridgeResource.waitFor(KafkaBridgeResource.deleteLater(kafkaBridge));
    }

    public static KafkaBridge kafkaBridgeWithoutWait(KafkaBridge kafkaBridge) {
        ((NonNamespaceOperation)KafkaBridgeResource.kafkaBridgeClient().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new KafkaBridge[]{kafkaBridge});
        return kafkaBridge;
    }

    public static void deleteKafkaBridgeWithoutWait(String resourceName) {
        ((EditReplacePatchDeletable)((Resource)((NonNamespaceOperation)KafkaBridgeResource.kafkaBridgeClient().inNamespace(ResourceManager.kubeClient().getNamespace())).withName(resourceName)).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
    }

    private static KafkaBridge getKafkaBridgeFromYaml(String yamlPath) {
        return (KafkaBridge)TestUtils.configFromYaml((String)yamlPath, KafkaBridge.class);
    }

    private static KafkaBridge waitFor(KafkaBridge kafkaBridge) {
        return ResourceManager.waitForResourceStatus(KafkaBridgeResource.kafkaBridgeClient(), kafkaBridge, CustomResourceStatus.Ready);
    }

    private static KafkaBridge deleteLater(KafkaBridge kafkaBridge) {
        return ResourceManager.deleteLater(KafkaBridgeResource.kafkaBridgeClient(), kafkaBridge);
    }

    public static void replaceBridgeResource(String resourceName, Consumer<KafkaBridge> editor) {
        ResourceManager.replaceCrdResource(KafkaBridge.class, KafkaBridgeList.class, resourceName, editor);
    }
}

