/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources.crd;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.strimzi.api.kafka.KafkaList;
import io.strimzi.api.kafka.model.KafkaUser;
import io.strimzi.api.kafka.model.KafkaUserScramSha512ClientAuthentication;
import io.strimzi.api.kafka.model.KafkaUserTlsClientAuthentication;
import io.strimzi.systemtest.Environment;
import io.strimzi.systemtest.resources.KubernetesResource;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.resources.crd.KafkaResource;
import io.strimzi.test.TestUtils;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KafkaClientsResource {
    private static final Logger LOGGER = LogManager.getLogger(KafkaClientsResource.class);

    public static DeploymentBuilder deployKafkaClients(String kafkaClusterName) {
        return KafkaClientsResource.deployKafkaClients(false, kafkaClusterName, null);
    }

    public static DeploymentBuilder deployKafkaClients(boolean tlsListener, String kafkaClientsName, KafkaUser ... kafkaUsers) {
        return KafkaClientsResource.deployKafkaClients(tlsListener, kafkaClientsName, true, null, null, kafkaUsers);
    }

    public static DeploymentBuilder deployKafkaClients(boolean tlsListener, String kafkaClientsName, String listenerName, KafkaUser ... kafkaUsers) {
        return KafkaClientsResource.deployKafkaClients(tlsListener, kafkaClientsName, true, listenerName, null, kafkaUsers);
    }

    public static DeploymentBuilder deployKafkaClients(boolean tlsListener, String kafkaClientsName, boolean hostnameVerification, KafkaUser ... kafkaUsers) {
        return KafkaClientsResource.deployKafkaClients(tlsListener, kafkaClientsName, hostnameVerification, null, null, kafkaUsers);
    }

    public static DeploymentBuilder deployKafkaClients(boolean tlsListener, String kafkaClientsName, boolean hostnameVerification, String listenerName, String secretPrefix, KafkaUser ... kafkaUsers) {
        Map<String, String> label = Collections.singletonMap("user-test-app", "kafka-clients");
        return (DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentSpecFluent.SelectorNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(kafkaClientsName)).withLabels(label)).endMetadata()).withNewSpec().withNewSelector().addToMatchLabels("app", kafkaClientsName)).addToMatchLabels(label)).endSelector()).withReplicas(Integer.valueOf(1))).withNewTemplate().withNewMetadata().addToLabels("app", kafkaClientsName)).addToLabels(label)).endMetadata()).withSpec(KafkaClientsResource.createClientSpec(tlsListener, kafkaClientsName, hostnameVerification, listenerName, secretPrefix, kafkaUsers))).endTemplate()).endSpec();
    }

    private static PodSpec createClientSpec(boolean tlsListener, String kafkaClientsName, boolean hostnameVerification, String listenerName, String secretPrefix, KafkaUser ... kafkaUsers) {
        PodSpecBuilder podSpecBuilder = new PodSpecBuilder();
        ContainerBuilder containerBuilder = (ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(kafkaClientsName)).withImage(Environment.TEST_CLIENT_IMAGE)).withCommand(new String[]{"sleep"})).withArgs(new String[]{"infinity"})).withImagePullPolicy(Environment.COMPONENTS_IMAGE_PULL_POLICY);
        Object producerConfiguration = "acks=all\n";
        Object consumerConfiguration = "auto.offset.reset=earliest\n";
        if (kafkaUsers == null) {
            ((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)containerBuilder.addNewEnv().withName("PRODUCER_CONFIGURATION")).withValue((String)producerConfiguration)).endEnv();
            ((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)containerBuilder.addNewEnv().withName("CONSUMER_CONFIGURATION")).withValue((String)consumerConfiguration)).endEnv();
        } else {
            for (KafkaUser kafkaUser : kafkaUsers) {
                String kafkaUserName = secretPrefix == null ? kafkaUser.getMetadata().getName() : secretPrefix + kafkaUser.getMetadata().getName();
                boolean tlsUser = kafkaUser.getSpec() != null && kafkaUser.getSpec().getAuthentication() instanceof KafkaUserTlsClientAuthentication;
                boolean scramShaUser = kafkaUser.getSpec() != null && kafkaUser.getSpec().getAuthentication() instanceof KafkaUserScramSha512ClientAuthentication;
                ((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)containerBuilder.addNewEnv().withName("PRODUCER_CONFIGURATION")).withValue((String)producerConfiguration)).endEnv();
                ((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)containerBuilder.addNewEnv().withName("CONSUMER_CONFIGURATION")).withValue((String)consumerConfiguration)).endEnv();
                String envVariablesSuffix = String.format("_%s", kafkaUserName.replace("-", "_"));
                ((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)containerBuilder.addNewEnv().withName("KAFKA_USER" + envVariablesSuffix)).withValue(kafkaUserName)).endEnv();
                if (tlsListener) {
                    if (scramShaUser) {
                        producerConfiguration = (String)producerConfiguration + "security.protocol=SASL_SSL\n";
                        producerConfiguration = (String)producerConfiguration + KafkaClientsResource.saslConfigs(kafkaUser, secretPrefix);
                        consumerConfiguration = (String)consumerConfiguration + "security.protocol=SASL_SSL\n";
                        consumerConfiguration = (String)consumerConfiguration + KafkaClientsResource.saslConfigs(kafkaUser, secretPrefix);
                    } else {
                        producerConfiguration = (String)producerConfiguration + "security.protocol=SSL\n";
                        consumerConfiguration = (String)consumerConfiguration + "security.protocol=SSL\n";
                    }
                    producerConfiguration = (String)producerConfiguration + "ssl.truststore.location=/tmp/" + kafkaUserName + "-truststore.p12\nssl.truststore.type=pkcs12\n";
                    consumerConfiguration = (String)consumerConfiguration + "ssl.truststore.location=/tmp/" + kafkaUserName + "-truststore.p12\nssl.truststore.type=pkcs12\n";
                } else if (scramShaUser) {
                    producerConfiguration = (String)producerConfiguration + "security.protocol=SASL_PLAINTEXT\n";
                    producerConfiguration = (String)producerConfiguration + KafkaClientsResource.saslConfigs(kafkaUser, secretPrefix);
                    consumerConfiguration = (String)consumerConfiguration + "security.protocol=SASL_PLAINTEXT\n";
                    consumerConfiguration = (String)consumerConfiguration + KafkaClientsResource.saslConfigs(kafkaUser, secretPrefix);
                } else {
                    producerConfiguration = (String)producerConfiguration + "security.protocol=PLAINTEXT\n";
                    consumerConfiguration = (String)consumerConfiguration + "security.protocol=PLAINTEXT\n";
                }
                if (tlsUser) {
                    producerConfiguration = (String)producerConfiguration + "ssl.keystore.location=/tmp/" + kafkaUserName + "-keystore.p12\nssl.keystore.type=pkcs12\n";
                    consumerConfiguration = (String)consumerConfiguration + "ssl.keystore.location=/tmp/" + kafkaUserName + "-keystore.p12\nssl.keystore.type=pkcs12\n";
                    ((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((ContainerBuilder)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)containerBuilder.addNewEnv().withName("PRODUCER_TLS" + envVariablesSuffix)).withValue("TRUE")).endEnv()).addNewEnv().withName("CONSUMER_TLS" + envVariablesSuffix)).withValue("TRUE")).endEnv();
                    String userSecretVolumeName = "tls-cert-" + kafkaUserName;
                    String userSecretMountPoint = "/opt/kafka/user-secret-" + kafkaUserName;
                    ((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)containerBuilder.addNewVolumeMount().withName(userSecretVolumeName)).withMountPath(userSecretMountPoint)).endVolumeMount()).addNewEnv().withName("USER_LOCATION" + envVariablesSuffix)).withValue(userSecretMountPoint)).endEnv();
                    ((PodSpecFluent.VolumesNested)((VolumeFluent.SecretNested)((PodSpecFluent.VolumesNested)podSpecBuilder.addNewVolume().withName(userSecretVolumeName)).withNewSecret().withSecretName(kafkaUserName)).endSecret()).endVolume();
                }
                if (tlsListener) {
                    String clusterName = (String)kafkaUser.getMetadata().getLabels().get("strimzi.io/cluster");
                    String clusterNamespace = ((KafkaList)((FilterWatchListMultiDeletable)KafkaResource.kafkaClient().inAnyNamespace()).list()).getItems().stream().filter(kafka -> kafka.getMetadata().getName().equals(clusterName)).findFirst().get().getMetadata().getNamespace();
                    String clusterCaSecretName = KafkaResource.getKafkaTlsListenerCaCertName(clusterNamespace, clusterName, listenerName);
                    String clusterCaSecretVolumeName = "ca-cert-" + kafkaUserName;
                    String caSecretMountPoint = "/opt/kafka/cluster-ca-" + kafkaUserName;
                    ((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((ContainerBuilder)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((ContainerBuilder)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((ContainerBuilder)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)containerBuilder.addNewVolumeMount().withName(clusterCaSecretVolumeName)).withMountPath(caSecretMountPoint)).endVolumeMount()).addNewEnv().withName("PRODUCER_TLS" + envVariablesSuffix)).withValue("TRUE")).endEnv()).addNewEnv().withName("CONSUMER_TLS" + envVariablesSuffix)).withValue("TRUE")).endEnv()).addNewEnv().withName("CA_LOCATION" + envVariablesSuffix)).withValue(caSecretMountPoint)).endEnv()).addNewEnv().withName("TRUSTSTORE_LOCATION" + envVariablesSuffix)).withValue("/tmp/" + kafkaUserName + "-truststore.p12")).endEnv();
                    if (tlsUser) {
                        ((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)containerBuilder.addNewEnv().withName("KEYSTORE_LOCATION" + envVariablesSuffix)).withValue("/tmp/" + kafkaUserName + "-keystore.p12")).endEnv();
                    }
                    ((PodSpecFluent.VolumesNested)((VolumeFluent.SecretNested)((PodSpecFluent.VolumesNested)podSpecBuilder.addNewVolume().withName(clusterCaSecretVolumeName)).withNewSecret().withSecretName(clusterCaSecretName)).endSecret()).endVolume();
                }
                if (!hostnameVerification) {
                    producerConfiguration = (String)producerConfiguration + "ssl.endpoint.identification.algorithm=";
                    consumerConfiguration = (String)consumerConfiguration + "ssl.endpoint.identification.algorithm=";
                }
                ((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)containerBuilder.addNewEnv().withName("PRODUCER_CONFIGURATION" + envVariablesSuffix)).withValue((String)producerConfiguration)).endEnv();
                ((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)containerBuilder.addNewEnv().withName("CONSUMER_CONFIGURATION" + envVariablesSuffix)).withValue((String)consumerConfiguration)).endEnv();
                containerBuilder.withResources(((ResourceRequirementsBuilder)new ResourceRequirementsBuilder().addToRequests("memory", new Quantity("200M"))).build());
            }
        }
        return ((PodSpecBuilder)podSpecBuilder.withContainers(new Container[]{containerBuilder.build()})).build();
    }

    static String saslConfigs(KafkaUser kafkaUser, String secretPrefix) {
        String secretName = secretPrefix == null ? kafkaUser.getMetadata().getName() : secretPrefix + kafkaUser.getMetadata().getName();
        Secret secret = ResourceManager.kubeClient().getSecret(secretName);
        String password = new String(Base64.getDecoder().decode((String)secret.getData().get("password")), Charset.forName("UTF-8"));
        if (password.isEmpty()) {
            LOGGER.info("Secret {}:\n{}", (Object)kafkaUser.getMetadata().getName(), (Object)TestUtils.toYamlString((Object)secret));
            throw new RuntimeException("The Secret " + kafkaUser.getMetadata().getName() + " lacks the 'password' key");
        }
        return "sasl.mechanism=SCRAM-SHA-512\nsasl.jaas.config=org.apache.kafka.common.security.scram.ScramLoginModule required \\\nusername=\"" + kafkaUser.getMetadata().getName() + "\" \\\npassword=\"" + password + "\";\n";
    }

    public static Deployment createAndWaitForReadiness(Deployment deployment) {
        return KubernetesResource.deployNewDeployment(deployment);
    }
}

